// generated by ../../../../tools/tube_transfer.py
// tube: EL84
// plate current function: pentode
// mu: 21.3
// kx: 1.24
// kg1: 401.7
// kg2: 4500
// kp: 111.1
// kvb: 17.9
// Uin_min: -10
// Uin_max: 10
// Vp: 370
// Rp: 3500

table1d_imp<2001> tubetable_EL84[2] __rt_data = {
	{ // Ri = 68k
	-10,10,100,2001, {
	263.2701201203105,263.15495216609577,263.0397359214184,262.9244714230433,262.8091587077414,
	262.69379781229,262.57838877347257,262.46293162807905,262.3474264129057,262.2318731647554,
	262.1162719204377,262.00062271676865,261.88492559057096,261.76918057867465,261.65338771791613,
	261.53754704513904,261.4216585971939,261.30572241093876,261.1897385232384,261.07370697096536,
	260.9576277909991,260.8415010202269,260.7253266955434,260.60910485385085,260.49283553205936,
	260.3765187670866,260.2601545958583,260.14374305530794,260.0272841823771,259.91077801401553,
	259.7942245871811,259.6776239388398,259.56097610596635,259.4442811255436,259.32753903456296,
	259.2107498700245,259.0939136689368,258.9770304683175,258.8601003051929,258.7431232165982,
	258.6260992395777,258.5090284111849,258.3919107684822,258.27474634854156,258.1575351884441,
	258.04027732528056,257.9229727961511,257.80562163816546,257.68822388844313,257.5707795841135,
	257.45328876231576,257.3357514601989,257.2181677149221,257.10053756365494,256.9828610435768,
	256.86513819187746,256.7473690457574,256.62955364242725,256.5116920191086,256.39378421303326,
	256.275830261444,256.15783020159466,256.0397840707498,255.921691906185,255.80355374518706,
	255.6853696250539,255.5671395830949,255.44886365663072,255.3305418829935,255.212174299527,
	255.0937609435867,254.97530185253967,254.8567970637652,254.7382466146542,254.61965054260966,
	254.50100888504693,254.38232167939336,254.26358896308872,254.14481077358522,254.02598714834758,
	253.90711812485316,253.78820374059185,253.6692440330667,253.55023903979327,253.43118879830038,
	253.3120933461298,253.1929527208365,253.07376695998883,252.95453610116837,252.83526018197037,
	252.71593924000348,252.59657331289006,252.47716243826633,252.3577066537823,252.23820599710183,
	252.1186605059031,251.99907021787826,251.87943517073384,251.75975540219065,251.64003094998398,
	251.52026185186364,251.4004481455942,251.28058986895485,251.16068705973976,251.04073975575807,
	250.92074799483387,250.8007118148065,250.68063125353052,250.56050634887595,250.44033713872807,
	250.32012366098795,250.19986595357219,250.0795640544132,249.9592180014594,249.8388278326749,
	249.71839358604024,249.59791529955186,249.4773930112226,249.35682675908174,249.23621658117497,
	249.11556251556465,248.99486460032986,248.8741228735664,248.75333737338704,248.63250813792163,
	248.511635205317,248.39071861373742,248.2697584013643,248.1487546063966,248.02770726705086,
	247.9066164215612,247.78548210817954,247.66430436517575,247.54308323083742,247.42181874347065,
	247.30051094139932,247.1791598629659,247.05776554653104,246.9363280304742,246.81484735319327,
	246.6933235531048,246.57175666864444,246.4501467382666,246.3284938004449,246.20679789367193,
	246.08505905645978,245.96327732733985,245.84145274486306,245.71958534759995,245.59767517414065,
	245.47572226309546,245.3537266530943,245.23168838278735,245.10960749084495,244.98748401595748,
	244.86531799683618,244.74310947221238,244.6208584808383,244.49856506148672,244.37622925295142,
	244.25385109404704,244.13143062360942,244.00896788049536,243.88646290358324,243.76391573177273,
	243.64132640398498,243.5186949591629,243.39602143627113,243.2733058742962,243.15054831224657,
	243.02774878915292,242.90490734406802,242.7820240160671,242.65909884424784,242.5361318677304,
	242.41312312565776,242.2900726571956,242.1669805015326,242.04384669788047,241.92067128547404,
	241.79745430357147,241.67419579145428,241.55089578842754,241.42755433381984,241.3041714669838,
	241.18074722729554,241.0572816541554,240.93377478698784,240.81022666524143,240.68663732838917,
	240.56300681592856,240.43933516738153,240.31562242229484,240.19186862024011,240.0680738008138,
	239.9442380036375,239.82036126835794,239.6964436346473,239.572485142203,239.4484858307482,
	239.32444574003156,239.2003649098276,239.07624337993687,238.95208119018582,238.82787838042714,
	238.70363499053974,238.579351060429,238.45502663002682,238.3306617392918,238.20625642820917,
	238.0818107367913,237.95732470507733,237.83279837313367,237.70823178105417,237.5836249689598,
	237.45897797699917,237.33429084534862,237.2095636142122,237.08479632382173,236.95998901443733,
	236.835141726347,236.7102544998673,236.58532737534284,236.4603603931471,236.33535359368204,
	236.21030701737848,236.08522070469596,235.96009469612338,235.83492903217848,235.7097237534085,
	235.58447890039008,235.45919451372927,235.33387063406192,235.20850730205373,235.0831045584001,
	234.9576624438268,234.83218099908945,234.7066602649743,234.58110028229785,234.4555010919073,
	234.3298627346804,234.20418525152581,234.07846868338333,233.9527130712235,233.82691845604836,
	233.70108487889115,233.5752123808168,233.44930100292154,233.32335078633358,233.197361772213,
	233.0713340017518,232.9452675161741,232.81916235673637,232.69301856472745,232.5668361814687,
	232.4406152483142,232.31435580665072,232.18805789789815,232.0617215635092,231.93534684496993,
	231.80893378379966,231.68248242155124,231.55599279981098,231.42946496019923,231.30289894436967,
	231.17629479401057,231.0496525508439,230.92297225662605,230.79625395314775,230.6694976822344,
	230.54270348574588,230.41587140557698,230.2890014836574,230.16209376195187,230.03514828246037,
	229.90816508721826,229.78114421829628,229.6540857178008,229.52698962787397,229.39985599069385,
	229.27268484847443,229.14547624346594,229.01823021795477,228.8909468142639,228.76362607475278,
	228.63626804181752,228.50887275789125,228.38144026544379,228.25397060698236,228.1264638250512,
	227.99891996223204,227.87133906114417,227.74372116444445,227.6160663148276,227.48837455502627,
	227.36064592781116,227.23288047599118,227.10507824241358,226.9772392699642,226.8493636015674,
	226.72145128018636,226.59350234882308,226.46551685051872,226.33749482835367,226.20943632544737,
	226.0813413849591,225.95321005008745,225.82504236407087,225.69683837018775,225.5685981117564,
	225.44032163213527,225.3120089747232,225.18366018295941,225.0552753003239,224.92685437033714,
	224.7983974365606,224.6699045425967,224.541375732089,224.4128110487225,224.28421053622344,
	224.15557423835972,224.02690219894097,223.89819446181863,223.7694510708862,223.64067207007926,
	223.51185750337572,223.38300741479588,223.2541218484026,223.1252008483015,222.99624445864097,
	222.86725272361252,222.73822568745072,222.60916339443338,222.4800658888818,222.3509332151608,
	222.221765417679,222.09256254088876,221.96332462928646,221.83405172741266,221.7047438798522,
	221.57540113123437,221.4460235262329,221.31661110956648,221.18716392599836,221.0576820203371,
	220.92816543743606,220.79861422219426,220.6690284195559,220.53940807451087,220.40975323209463,
	220.2800639373889,220.1503402355209,220.0205821716644,219.8907897910393,219.76096313891196,
	219.6311022605954,219.50120720144938,219.37127800688037,219.24131472234214,219.1113173933355,
	218.98128606540857,218.85122078415688,218.7211215952238,218.59098854430013,218.46082167712487,
	218.330621039485,218.2003866772156,218.0701186362001,217.93981696237057,217.80948170170748,
	217.67911290024037,217.54871060404747,217.4182748592562,217.28780571204317,217.1573032086344,
	217.0267673953053,216.89619831838115,216.76559602423686,216.63496055929733,216.50429197003766,
	216.3735903029831,216.24285560470932,216.1120879218426,215.98128730105975,215.85045378908868,
	215.71958743270798,215.58868827874764,215.45775637408875,215.326791765664,215.1957945004574,
	215.06476462550495,214.93370218789437,214.80260723476553,214.67147981331019,214.5403199707728,
	214.40912775445003,214.27790321169113,214.14664638989828,214.01535733652653,213.8840360990838,
	213.7526827251315,213.62129726228417,213.4898797582099,213.35843026063048,213.2269488173215,
	213.09543547611239,212.96389028488676,212.8323132915825,212.70070454419172,212.56906409076132,
	212.43739197939263,212.30568825824196,212.17395297552056,212.04218617949485,211.91038791848652,
	211.77855824087257,211.64669719508584,211.51480482961455,211.38288119300313,211.25092633385174,
	211.11894030081692,210.98692314261146,210.85487490800463,210.72279564582223,210.590685404947,
	210.45854423431842,210.3263721829331,210.19416929984487,210.06193563416497,209.92967123506205,
	209.79737615176245,209.66505043355033,209.53269412976786,209.40030728981515,209.26788996315082,
	209.1354421992916,209.00296404781298,208.87045555834908,208.7379167805928,208.6053477642962,
	208.47274855927026,208.3401192153855,208.20745978257173,208.0747703108183,207.94205085017447,
	207.80930145074927,207.67652216271176,207.54371303629122,207.41087412177728,207.27800546951997,
	207.14510712993012,207.01217915347917,206.87922159069944,206.7462344921846,206.61321790858935,
	206.48017189062963,206.34709648908319,206.2139917547893,206.08085773864897,205.94769449162533,
	205.81450206474355,205.68128050909104,205.54802987581772,205.41475021613587,205.2814415813207,
	205.14810402271007,205.01473759170506,204.88134233976965,204.74791831843137,204.61446557928093,
	204.48098417397284,204.34747415422535,204.2139355718204,204.08036847860416,203.94677292648694,
	203.81314896744325,203.67949665351225,203.5458160367977,203.41210716946796,203.27837010375654,
	203.14460489196176,203.01081158644752,202.87699023964277,202.74314090404192,202.60926363220537,
	202.47535847675897,202.3414254903947,202.20746472587072,202.07347623601115,201.93946007370678,
	201.80541629191472,201.67134494365888,201.53724608203,201.40311976018572,201.26896603135083,
	201.1347849488174,201.00057656594487,200.8663409361603,200.73207811295842,200.59778814990176,
	200.46347110062086,200.3291270188145,200.19475595824957,200.06035797276155,199.92593311625444,
	199.79148144270084,199.65700300614242,199.52249786068973,199.38796606052242,199.2534076598896,
	199.11882271310972,198.9842112745708,198.8495733987307,198.71490914011696,198.58021855332734,
	198.44550169302974,198.31075861396212,198.1759893709333,198.0411940188223,197.9063726125791,
	197.77152520722456,197.63665185785047,197.5017526196199,197.36682754776714,197.23187669759793,
	197.09690012448962,196.96189788389145,196.8268700313242,196.69181662238108,196.55673771272717,
	196.42163335810005,196.28650361430948,196.1513485372382,196.01616818284137,195.88096260714715,
	195.74573186625676,195.61047601634442,195.47519511365778,195.33988921451802,195.2045583753197,
	195.0692026525312,194.93382210269473,194.79841678242656,194.66298674841707,194.52753205743096,
	194.39205276630724,194.25654893195968,194.12102061137662,193.98546786162115,193.8498907398316,
	193.71428930322128,193.57866360907872,193.44301371476794,193.30733967772846,193.1716415554754,
	193.03591940559988,192.90017328576883,192.76440325372536,192.6286093672887,192.49279168435461,
	192.3569502628952,192.22108516095935,192.08519643667265,191.94928414823755,191.81334835393378,
	191.677389112118,191.54140648122439,191.4054005197645,191.26937128632753,191.13331883958037,
	190.99724323826786,190.8611445412128,190.72502280731612,190.58887809555705,190.45271046499334,
	190.31651997476112,190.18030668407533,190.04407065222966,189.90781193859684,189.77153060262862,
	189.63522670385603,189.49890030188936,189.36255145641854,189.2261802272131,189.08978667412214,
	188.95337085707493,188.81693283608058,188.68047267122847,188.54399042268824,188.40748615070987,
	188.27095991562405,188.13441177784205,187.997841797856,187.861250036239,187.72463655364524,
	187.58800141081014,187.45134466855035,187.31466638776413,187.17796662943132,187.04124545461357,
	186.90450292445425,186.76773910017883,186.6309540430949,186.4941478145923,186.35732047614334,
	186.22047208930275,186.08360271570794,185.94671241707914,185.8098012552194,185.67286929201498,
	185.5359165894351,185.39894320953243,185.26194921444304,185.12493466638642,184.98789962766597,
	184.8508441606687,184.71376832786564,184.57667219181187,184.4395558151467,184.30241926059364,
	184.16526259096085,184.0280858691408,183.8908891581108,183.75367252093304,183.61643602075455,
	183.47917972080745,183.3419036844091,183.20460797496216,183.06729265595473,182.92995779096054,
	182.79260344363888,182.65522967773506,182.51783655708016,182.38042414559146,182.24299250727242,
	182.10554170621265,181.96807180658845,181.83058287266255,181.6930749687844,181.5555481593902,
	181.41800250900323,181.28043808223362,181.14285494377899,181.00525315842384,180.86763279104048,
	180.72999390658862,180.59233657011558,180.45466084675658,180.3169668017346,180.17925450036086,
	180.04152400803454,179.90377539024323,179.76600871256286,179.6282240406579,179.49042144028138,
	179.35260097727522,179.21476271757004,179.07690672718567,178.93903307223087,178.80114181890377,
	178.66323303349174,178.5253067823717,178.38736313201014,178.24940214896333,178.11142389987725,
	177.97342845148788,177.83541587062135,177.69738622419382,177.55933957921192,177.42127600277263,
	177.28319556206338,177.14509832436246,177.00698435703876,176.8688537275522,176.73070650345358,
	176.592542752385,176.45436254207954,176.31616594036203,176.1779530151485,176.0397238344466,
	175.90147846635574,175.76321697906727,175.62493944086438,175.48664592012236,175.34833648530864,
	175.21001120498303,175.0716701477977,174.9333133824975,174.7949409779197,174.65655300299454,
	174.51814952674513,174.37973061828748,174.2412963468308,174.1028467816776,173.9643819922237,
	173.82590204795832,173.68740701846443,173.5488969734187,173.4103719825915,173.2718321158473,
	173.1332774431446,172.99470803453613,172.85612396016887,172.71752529028427,172.5789120952185,
	172.44028444540206,172.30164241136058,172.16298606371447,172.02431547317929,171.88563071056575,
	171.74693184677975,171.60821895282277,171.46949209979175,171.33075135887947,171.1919968013743,
	171.05322849866084,170.91444652221952,170.77565094362714,170.63684183455686,170.49801926677821,
	170.3591833121576,170.2203340426579,170.08147153033917,169.94259584735846,169.80370706597003,
	169.6648052585255,169.52589049747408,169.38696285536264,169.24802240483595,169.10906921863673,
	168.97010336960602,168.83112493068313,168.69213397490603,168.55313057541142,168.41411480543485,
	168.27508673831116,168.13604644747454,167.9969940064587,167.85792948889716,167.71885296852346,
	167.5797645191715,167.44066421477575,167.3015521293713,167.16242833709455,167.02329291218302,
	166.8841459289763,166.7449874619156,166.60581758554463,166.46663637450982,166.32744390356078,
	166.1882402475504,166.04902548143554,165.9097996802775,165.77056291924237,165.63131527360156,
	165.49205681873227,165.35278763011814,165.21350778335005,165.0742173541263,164.9349164182537,
	164.7956050516481,164.65628333033524,164.51695133045172,164.37760912824547,164.23825680007732,
	164.09889442242147,163.95952207186687,163.82013982511847,163.68074775899822,163.5413459504466,
	163.40193447652416,163.2625134144129,163.123082841418,162.98364283496977,162.8441934726254,
	162.70473483207118,162.56526699112467,162.42579002773724,162.28630401999655,162.14680904612953,
	162.00730518450524,161.86779251363802,161.72827111219158,161.588741058982,161.44920243298253,
	161.30965531332748,161.17009977931733,161.03053591042342,160.89096378629424,160.7513834867604,
	160.61179509184197,160.47219868175495,160.33259433691873,160.1929821379644,160.05336216574352,
	159.91373450133722,159.77409922606674,159.63445642150418,159.4948061694844,159.35514855211798,
	159.2154836518049,159.0758115512495,158.93613233347673,158.7964460818492,158.65675288008663,
	158.51705281228558,158.3773459629417,158.23763241697316,158.09791225974678,157.95818557710507,
	157.8184524553966,157.67871298150783,157.53896724289828,157.3992153276384,157.25945732444947,
	157.1196933227484,156.97992341269466,156.84014768524193,156.70036623219318,156.56057914626084,
	156.42078652113125,156.28098845153468,156.14118503332088,156.00137636354034,155.86156254053284,
	155.72174366402228,155.58191983521976,155.44209115693474,155.30225773369497,155.16241967187617,
	155.02257707984268,154.88273006809803,154.74287874944952,154.6030232391842,154.46316365526025,
	154.32330011851343,154.18343275287953,154.04356168563567,153.90368704766044,153.76380897371482,
	153.62392760274605,153.48404307821588,153.3441555484548,153.20426516704526,153.06437209323525,
	152.92447649238548,152.78457853645193,152.64467840450777,152.50477628330663,152.3648723678914,
	152.22496686225168,152.085059980034,151.94515194530905,151.80524299340027,151.66533337177853,
	151.52542334102927,151.385513175896,151.24560316640793,151.10569361909734,150.9657848583146,
	150.8258772276475,150.6859710914545,150.5460668365195,150.40616487383903,150.2662656405509,
	150.12636960201652,149.98647725406866,149.8465891254368,149.7067057803651,149.56682782143716,
	149.42695589262357,149.2870906825701,149.1472329281441,149.00738341825954,148.8675429980021,
	148.72771257307616,148.58789311459907,148.44808566426806,148.308291339928,148.16851134156946,
	148.0287469577891,147.88899957274555,147.74927067364774,147.60956185881244,147.46987484633277,
	147.3302114833998,147.19057375632255,147.05096380129433,146.9113839159558,146.7718365718065,
	146.63232442752144,146.4928503432286,146.35341739580764,146.21402889527215,146.07468840229672,
	145.93539974695517,145.79616704873607,145.65699473789874,145.51788757823837,145.37885069132363,
	145.23988958226872,145.10101016709982,144.9622188017703,144.82352231287237,144.68492803008544,
	144.54644382039055,144.40807812406706,144.26983999247287,144.13173912758884,143.99378592328756,
	143.85599150825647,143.7183677904788,143.5809275031347,143.44368425174798,143.30665256235346,
	143.1698479304104,143.03328687012583,142.89698696378915,142.76096691064674,142.62524657477042,
	142.4898470312913,142.35479061028488,142.2201009375059,142.08580297108068,141.95192303317816,
	141.8184888355935,141.68552949810413,141.55307555838834,141.42115897224704,141.2898131028378,
	141.15907269762144,141.02897385174938,140.8995539566757,140.77085163287998,140.64290664573122,
	140.51575980371555,140.38945283849415,140.26402826654856,140.1395292325123,140.01599933466866,
	139.8934824335127,139.7720224447166,139.6516631182919,139.53244780618786,139.41441922099517,
	139.29761918880706,139.182088399618,139.067866158891,138.95499014408048,138.84349616995337,
	138.7334179664929,138.62478697299605,138.51763215169254,138.41197982382798,138.3078535306737,
	138.20527392138195,138.10425866900528,138.0048224153757,137.90697674491378,137.81073018683142,
	137.71608824463155,137.6230534513042,137.53162544819236,137.44180108515837,137.35357453942567,
	137.2669374503104,137.1818790669776,137.0983864063619,137.0164444184667,136.93603615638978,
	136.85714294860804,136.77974457127385,136.70381941851844,136.6293446690201,136.5562964473549,
	136.48464997891037,136.41437973739048,136.3454595841753,136.277862899013,136.21156270171608,
	136.14653176470347,136.0827427163783,136.02016813545524,135.9587806364546,135.89855294666333,
	135.83945797492706,135.78146887268622,135.72455908770107,135.66870241093278,135.61387301705727,
	135.56004549908974,135.50719489759186,135.45529672492165,135.40432698497116,135.35426218881415,
	135.3050793666686,135.2567560765504,135.20927040997404,135.162600995029,135.1167269971369,
	135.0716281177693,135.02728459138478,134.98367718081806,134.9407871713318,134.89859636355428,
	134.85708706539515,134.8162420832128,134.7760447122818,134.73647872672458,134.69752836901287,
	134.65917833913812,134.62141378353755,134.58422028385485,134.54758384560105,134.51149088677644,
	134.47592822650367,134.440883073717,134.40634301594574,134.37229600822394,134.33873036215454,
	134.30563473515053,134.2729981198728,134.24080983387913,134.20905950949933,134.17773708394307,
	134.1468327896509,134.11633714489193,134.0862409446129,134.0565352515394,134.02721138753114,
	133.99826092518995,133.9696756797189,133.9414477010305,133.91356926610067,133.88603287156397,
	133.85883122654758,133.8319572457368,133.8054040426697,133.7791649232536,133.7532333794984,
	133.7276030834621,133.70226788140127,133.6772217881213,133.6524589815213,133.6279737973263,
	133.60376072400206,133.57981439784666,133.55612959825245,133.5327012431337,133.5095243845137,
	133.4865942042604,133.4639060100015,133.44145523112005,133.41923741495523,133.39724822310257,
	133.37548342785007,133.35393890873962,133.33261064924824,133.31149473358502,133.2905873435998,
	133.2698847557994,133.24938333846723,133.22907954888294,133.20896993063798,133.18905111104397,
	133.16931979862972,133.1497727807251,133.13040692112642,133.11121915784247,133.09220650091643,
	133.0733660303225,133.05469489393278,133.03619030555325,133.0178495430256,132.99966994639243,
	132.98164891612373,132.96378391140237,132.94607244846648,132.92851209900618,132.9111004886132,
	132.89383529528124,132.8767142479557,132.8597351251296,132.8428957534856,132.82619400658197,
	132.80962780357993,132.79319510801278,132.77689392659312,132.7607223080589,132.7446783420549,
	132.72876015805065,132.71296592429096,132.69729384678007,132.68174216829698,132.66630916744126,
	132.6509931577082,132.6357924865928,132.62070553472017,132.60573071500335,132.590866471826,
	132.57611128024996,132.56146364524645,132.5469221009506,132.53248520993745,132.51815156252027,
	132.5039197760688,132.489788494348,132.47575638687596,132.46182214830029,132.44798449778682,
	132.43424217845768,132.42059395677924,132.40703862203614,132.39357498578502,132.3802018813307,
	132.3669181632175,132.35372270673454,132.34061440743523,132.32759218066985,132.31465496113088,
	132.30180170241184,132.28903137657704,132.27634297374397,132.2637355016764,132.25120798538939,
	132.238759466764,132.2263890041731,132.21409567211677,132.20187856086764,132.18973677612541,
	132.17766943868102,132.1656756840888,132.153754662348,132.14190553759238,132.13012748778766,
	132.1184197044369,132.10678139229375,132.0952117690827,132.08371006522646,132.07227552358057,
	132.06090739917457,132.04960495895946,132.03836748156218,132.02719425704524,132.01608458667326,
	132.0050377826847,131.99405316806957,131.98313007635238,131.97226785138045,131.96146584711767,
	131.9507234274426,131.94003996595225,131.92941484576997,131.9188474593584,131.90833720833632,
	131.89788350330068,131.8874857636519,131.87714341742407,131.8668559011186,131.85662265954244,
	131.8464431456488,131.8363168203834,131.82624315253233,131.81622161857507,131.80625170253964,
	131.79633289586187,131.7864646972476,131.77664661253766,131.76687815457666,131.75715884308377,
	131.74748820452743,131.73786577199715,131.72829108510388,131.71876368982964,131.70928313843586,
	131.6998489893445,131.69046080702813,131.68111816190228,131.67182063021997,131.6625677939688,
	131.6533592407705,131.64419456378153,131.63507336159728,131.625995238157,131.61695980265193,
	131.60796666943423,131.59901545792866,131.59010579254584,131.58123730259706,131.57240962221152,
	131.5636223902544,131.5548752502475,131.5461678502909,131.53749984298653,131.5288708853631,
	131.52028063880283,131.5117287689695,131.50321494573782,131.4947388431244,131.48630013922016,
	131.47789851612404,131.4695336598779,131.46120526040266,131.45291301143627,131.44465661047212,
	131.43643575869905,131.42825016094275,131.42009952560775,131.41198356462115,131.40390199337693,
	131.3958545306815,131.3878408987006,131.3798608229004,131.37191403202408,131.36400025799495,
	131.35611923590218,131.3482707039421,131.3404544033705,131.33267007845635,131.32491747643564,
	131.31719634746673,131.309506444586,131.30184752366483,131.29421934336688,131.28662166510645,
	131.2790542530078,131.27151687386447,131.26400929709752,131.25653129472965,131.2490826413901,
	131.24166311396033,131.2342724922084,131.22691055807306,131.21957709596856,131.21227189268217,
	131.2049947373402,131.19774542137424,131.19052373848822,131.18332948462617,131.17616245794028,
	131.1690224587596,131.16190928955953,131.15482275493147,131.14776266155326,131.14072881815991,
	131.1337210355151,131.12673912638277,131.1197829054998,131.11285218956095,131.10594679714836,
	131.09906654876437,131.09221126676982,131.08538077536681,131.07857490057387,131.07179347020121,
	131.06503631382662,131.05830326277186,131.051594150079,131.04490881048764,131.0382470804124,
	131.0316087979203,131.0249938027095,131.01840193608703,131.01183304094826,131.00528696175581,
	130.99876354451902,130.99226263677403,130.98578408756353,130.97932774741773,130.97289346833475,
	130.96648110376208,130.9600905085775,130.95372153907144,130.94737405292827,130.94104790920906,
	130.9347429683338,130.92845909206457,130.92219614348824,130.91595398700005,130.90973248828718,
	130.90353151431256,130.89735093329895,130.89119061471348,130.8850504292519,130.87893024882374,
	130.8728299465372,130.86674939668447,130.86068847472725,130.85464705728242,130.84862502210788,
	130.84262224808901,130.83663861522484,130.8306740046145,130.82472829844414,130.81880137997388,
	130.81289313352485,130.8070034444667,130.80113219919892,130.79527928516157,130.78944459079034,
	130.78362800552557,130.77782941979544,130.77204872500437,130.76628581352148,130.76054057866972,
	130.75481291471434,130.74910271685224,130.7434098812009,130.73773430478815,130.73207588554138,
	130.7264345222773,130.7208101146917,130.71520256334964,130.70961176967538,130.70403763594254,
	130.6984800652647,130.69293896158572,130.68741422967057,130.68190577509588,130.67641350424094,
	130.67093732427904,130.6654771431681,130.66003286964227,130.65460441320315,130.64919168411168,
	130.6437945933792,130.6384130527597,130.6330469747413,130.62769627253851,130.62236086008417,
	130.6170406520215,130.61173556369667,130.60644551115104,130.6011704111136,130.59591018099363,
	130.59066473887341,130.5854340035009,130.58021789428284,130.57501633127754,130.56982923518785,
	130.56465652735463,130.55949812974987,130.55435396496983,130.5492239562288,130.54410802735237,
	130.539006102771,130.533918107514,130.52884396720296,130.5237836080457,130.51873695683028,
	130.51370394091887,130.50868448824195,130.50367852729224,130.49868598711925,130.49370679732323,
	130.48874088804988,130.48378818998452,130.47884863434655,130.47392215288454,130.46900867787014,
	130.46410814209347,130.4592204788574,130.45434562197264,130.44948350575265,130.44463406500864,
	130.43979723504438,130.43497295165147,130.43016115110456,130.4253617701565,130.4205747460335,
	130.41580001643058,130.411037519507,130.4062871938816,130.4015489786283,130.39682281327185,
	130.3921086377831,130.387406392575,130.3827160184981,130.37803745683635,130.37337064930298,
	130.3687155380364,130.3640720655959,130.35944017495788,130.35481980951167,130.3502109130557,
	130.3456134297936,130.3410273043302,130.33645248166803,130.33188890720317,130.32733652672184,
	130.32279528639663,130.31826513278287,130.31374601281507,130.30923787380326,130.30474066342958,
	130.30025432974503,130.2957788211654,130.29131408646134,130.28686007478322,130.28241673561575,
	130.27798401880253,130.2735618745356,130.26915025335256,130.26474910613334,130.26035838409706,
	130.25597803879893,130.2516080221273,130.24724828630045,130.24289878386375,130.23855946768674,
	130.23423029096003,130.22991120719257,130.22560217020882,130.2213031341457,130.21701405345016,
	130.21273488287605,130.20846557748166,130.20420609262695,130.19995638397063,130.195716407468,
	130.1914861193679,130.1872654762104,130.18305443482413,130.17885295232378,130.17466098610745,
	130.17047849385452,130.1663054335229,130.16214176334668,130.1579874418338,130.15384242776364,
	130.14970668018475,130.14558015841237,130.14146282202628,130.13735463086843,130.13325554504084,
	130.12916552490327,130.12508453107097,130.12101252441266,130.1169494660482,130.11289531734673,
	130.10885003992414,130.1048135956415,130.10078594660249,130.09676705515184,130.09275688387294,
	130.0887553955859,130.08476255334594,130.08077832044074,130.07680266038923,130.0728355369392,
	130.06887691406556,130.0649267559685,130.06098502707152,130.05705169201968,130.05312671567776,
	130.04921006312844,130.0453016996705,130.04140159081715,130.0375097022942,130.03362600003814,
	130.0297504501949,130.02588301911786,130.02202367336594,130.01817237970243,130.0143291050931,
	130.01049381670435,130.00666648190213,130.0028470682498,129.99903554350686,129.9952318756274,
	129.9914360327584,129.98764798323816,129.98386769559505,129.98009513854566,129.9763302809937,
	129.97257309202806,129.96882354092176,129.9650815971304,129.96134723029047,129.9576204102183,
	129.95390110690855,129.95018929053242,129.94648493143703,129.9427880001433,129.9390984673452,
	129.93541630390797,129.9317414808671,129.92807396942672,129.9244137409587,129.92076076700096,
	129.9171150192564,129.91347646959173,129.9098450900359,129.90622085277926,129.9026037301719,
	129.8989936947229,129.8953907190987,129.89179477612228,129.8882058387716,129.8846238801788,
	129.8810488736287,129.87748079255792,129.87391961055366,129.87036530135248,129.8668178388393,
	129.86327719704613,129.8597433501513,129.85621627247798,129.85269593849335,129.84918232280756,
	129.8456754001724,129.8421751454806,129.83868153376454,129.83519454019535,129.83171414008177,
	129.8282403088694,129.8247730221393,129.8213122556074,129.81785798512337,129.81441018666936,
	129.8109688363595,129.8075339104388,129.80410538528193,129.80068323739263,129.7972674434027,
	129.79385798007075,129.79045482428188,129.7870579530463,129.78366734349848,129.78028297289663,
	129.77690481862132,129.77353285817486,129.7701670691806,129.76680742938169,129.7634539166405,
	129.7601065089377,129.7567651843714,129.75342992116305,129.75010069763047,129.74677749222533,
	129.74346028350752,129.74014905015008,129.73684377093886,129.73354442477142,129.73025099065643,
	129.7269634477127,129.7236817751687,129.7204059523615,129.71713595873618,129.71387177384526,
	129.71061337734733,129.70736074900725,129.70411386869455,129.70087271638317,129.69763727215079,
	129.6944075161778,129.6911834287468,129.68796499024205,129.68475218114853,129.6815449820512,
	129.67834337363462,129.67514733668207,129.67195685207494,129.66877190079202,129.66559246390884,
	129.66241852259722,129.6592500581243,129.65608705185207,129.65292948523683,129.64977733982835,
	129.64663059726945,129.64348923929518,129.64035324773232,129.63722260449887,129.6340972916032,
	129.63097729114364,129.62786258530778,129.6247531563721,129.621648986701,129.6185500587465,
	129.6154563550477,129.61236785823004,129.60928455100472,129.6062064161684,129.6031334366023,
	129.60006559527187,129.59700287522634,129.59394525959775,129.5908927316009,129.58784527453244,
	129.58480287177068,129.58176550677473,129.5787331630842,129.57570582431865,129.5726834741769,
	129.56966609643686,129.5666536749547,129.56364619366443,129.56064363657762,129.55764598778256,
	129.55465323144415,129.55166535180288,129.54868233317507,129.5457041599517,129.54273081659844,
	129.53976228765475,129.53679855773387,129.53383961152204,129.53088543377814,129.52793600933308,
	129.52499132308972,129.522051360022,129.5191161051749,129.51618554366345,129.513259660673,
	129.5103384414581,129.50742187134256,129.5045099357188,129.50160262004744,129.49869990985687,
	129.49580179074292,129.49290824836842,129.4900192684627,129.4871348368213,129.48425493930534,
	129.4813795618415,129.47850869042117,129.4756423111005,129.47278040999961,129.4699229733026,
	129.46706998725662,129.46422143817213,129.461377312422,129.45853759644137,129.4557022767272,
	129.45287133983797,129.4500447723933,129.4472225610735,129.44440469261923,129.4415911538311,
	129.4387819315696,129.43597701275428,129.43317638436366,129.430380033435,129.4275879470637,
	129.424800112403,129.42201651666372,129.419237147114,129.41646199107862,129.41369103593914,
	129.41092426913312,129.40816167815413,129.40540325055122,129.4026489739286,129.39989883594544,
	129.39715282431538,129.3944109268065,129.39167313124057,129.38893942549316,129.386209797493,
	129.38348423522194,129.38076272671435,129.37804526005715,129.37533182338925,129.37262240490136,
	129.36991699283553,129.3672155754853,129.36451814119457,129.36182467835846,129.3591351754219,
	129.35644962087997,129.35376800327765,129.35109031120908,129.34841653331765,129.34574665829575,
	129.34308067488422,129.34041857187228,129.33776033809713,129.33510596244383,129.33245543384487,
	129.32980874128003,129.32716587377604,129.32452682040625,129.32189157029052,129.31926011259492,
	129.31663243653134,129.3140085313574,129.31138838637608,129.30877199093553,129.3061593344288,
	129.30355040629354,129.30094519601184,129.29834369310993,129.29574588715795,129.29315176776964,
	129.2905613246023,129.28797454735616,129.28539142577463,129.28281194964367,129.28023610879185,
	129.27766389308982,129.27509529244324,129.27253029682012,129.26996889621,129.26741108065013,
	129.264856840219,129.26230616503574,129.2597590452604,129.25721547109325,129.25467543277483,
	129.2521389205856,129.24960592484584,129.24707643591535,129.24455044419327,129.24202794011785,
	129.23950891416627,129.2369933568543,129.23448125873645,129.2319726104052,129.2294674024914,
	129.22696562566344,129.22446727062774,129.22197232812795,129.21948078894502,129.21699264389707,
	129.214507883839,129.2120264996624,129.20954848229536,129.20707382270226,129.20460251188356,
	129.20213454087568,129.19966990075062,129.19720858261593,129.1947505776147,129.192295876925,
	129.18984447175984,129.18739635336706,129.18495151302918,129.18250994206298,129.18007163181963,
	129.17763657368428,129.17520475907597,129.17277617944745,129.17035082628502,129.16792869110827,
	129.16550976547015,129.1630940409564,129.16068150918574,129.15827216180946,129.15586599051144,
	129.15346298700786,129.15106314304708,129.14866645040942,129.14627290090712,129.14388248638403,
	129.14149519871546,129.13911102980822,129.1367299716001,129.13435201606012,129.13197715518814,
	129.1296053810146,129.12723668560065,129.12487106103777,129.12250849944766,129.12014899298217,
	129.11779253382304,129.11543911418195,129.11308872629996,129.11074136244787,129.10839701492569,
	129.10605567606265,129.10371733821705,129.10138199377607,129.0990496351557,129.09672025480046,
	129.0943938451833,129.09207039880573,129.08974990819718,129.08743236591533,129.0851177645456,
	129.08280609670132,129.08049735502334,129.07819153218009,129.07588862086732,129.07358861380794,
	129.07129150375204,129.06899728347668,129.06670594578563,129.06441748350943,129.06213188950517,
	129.05984915665633,129.05756927787277,129.05529224609035,129.05301805427126,129.05074669540323,
	129.0484781625001,129.0462124486012,129.04394954677144,129.0416894501012,129.03943215170597,
	129.03717764472663,129.03492592232897,129.0326769777037,129.03043080406644,129.02818739465735,
	129.0259467427412,129.02370884160734,129.02147368456917,129.01924126496462,129.0170115761555,
	129.0147846115276,129.01256036449067,129.0103388284782,129.00811999694727,129.0059038633785,
	129.00369042127585,129.00147966416674,128.9992715856016,128.99706617915413,128.99486343842082,
	128.99266335702112,128.9904659285972,128.9882711468139,128.98607900535856,128.98388949794096,
	128.98170261829327,128.97951836016972,128.9773367173469,128.97515768362314,128.97298125281893,
	128.97080741877642,128.96863617535942,128.96646751645346,128.96430143596555,128.9621379278241,
	128.9599769859787,128.9578186044004,128.95566277708105,128.95350949803372,128.95135876129234,
	128.9492105609116,128.94706489096697,128.94492174555447,128.94278111879075,128.94064300481276,
	128.9385073977779,128.93637429186376,128.93424368126804,128.9321155602086,128.92998992292317,
	128.92786676366944,128.92574607672475,128.92362785638633,128.92151209697076,128.91939879281435,
	128.91728793827278,128.915179527721,128.91307355555327,128.910970016183,128.90886890404255,
	128.90677021358357,128.90467393927634,128.90258007560996,128.90048861709246,128.89839955825036,
	128.89631289362873,128.89422861779124,128.89214672531267,128.89006721080708,128.88799006888644,
	128.88591529418738,128.8838428813647,128.8817728250911,128.87970512005728,128.8776397609717,
	128.8755767425606,128.8735160595679,128.871457706755,128.86940167890097,128.86734797080226,
	128.86529657727263,128.86324749314315,128.86120071326218,128.85915623249505,128.85711404572422,
	128.85507414784917,128.85303653378628,128.85100119846854,128.8489681368461,128.8469373438855,
	128.8449088145699,128.84288254389907,128.84085852688932,128.83883675857314,128.83681723399954,
	128.83479994823364,128.8327848963568,128.83077207346656,128.82876147467636,128.82675309511566,
	128.8247469299299,128.82274297428015,128.82074122334348,128.81874167231254,128.8167443163955,
	128.81474915081634,128.8127561708143,128.8107653716442,128.8087767485761,128.80679029689543,
	128.8048060119028,128.80282388891402,128.80084392326,128.7988661102866,128.7968904453548,
	128.79491692384028,128.79294554113378,128.79097629264066,128.78900917378104,128.78704417998972,
	128.78508130671605,128.78312054942398,128.78116190359188,128.7792053647124,128.7772509282927,
	128.77529858985426,128.77334834493254,128.7714001890775,128.76945411785297,128.76751012683678,
	128.76556821162094,128.7636283678113,128.76169059102756,128.75975487690314,128.7578212210855,
	128.7558896192355,128.75396006702766,128.75203256015035,128.75010709430518,128.74818366520736,
	128.7462622685854,128.7443429001814,128.74242555575054,128.74051023106128,128.73859692189532,
	128.73668562404754,128.7347763333258,128.73286904555104,128.73096375655717,128.72906046219103,
	128.72715915831228,128.72525984079346,128.7233625055199,128.7214671483895,128.7195737653129,
	128.71768235221342,128.71579290502683,128.7139054197014,128.71201989219796,128.71013631848962,
	128.70825469456187,128.7063750164126,128.7044972800518,128.70262148150175,128.7007476167968,
	128.69887568198362,128.69700567312066,128.69513758627852,128.6932714175398,128.69140716299876,
	128.68954481876182,128.68768438094708,128.68582584568438,128.6839692091153,128.68211446739318,
	128.68026161668274,128.67841065316057,128.6765615730146,128.67471437244433,128.67286904766064,
	128.67102559488583,128.66918401035352,128.6673442903087,128.6655064310075,128.66367042871744,
	128.66183627971705,128.66000398029598,128.6581735267551,128.65634491540615,128.65451814257196,
	128.65269320458626,128.6508700977938,128.64904881855,128.64722936322127,128.64541172818468,
	128.64359590982806,128.64178190454996,128.6399697087596,128.6381593188767,128.63635073133167,
	128.63454394256544
	}},
	{ // Ri = 250k
	-10,10,100,2001, {
	263.2701201203105,263.15495216609577,263.0397359214184,262.9244714230433,262.8091587077414,
	262.69379781229,262.57838877347257,262.46293162807905,262.3474264129057,262.2318731647555,
	262.1162719204377,262.00062271676865,261.884925590571,261.7691805786747,261.65338771791613,
	261.53754704513904,261.4216585971939,261.3057224109388,261.1897385232384,261.07370697096536,
	260.9576277909991,260.8415010202269,260.7253266955434,260.60910485385085,260.49283553205936,
	260.3765187670866,260.2601545958583,260.14374305530794,260.0272841823771,259.91077801401553,
	259.7942245871811,259.6776239388398,259.56097610596635,259.4442811255436,259.32753903456296,
	259.2107498700245,259.0939136689368,258.9770304683175,258.8601003051928,258.7431232165982,
	258.62609923957774,258.5090284111849,258.3919107684822,258.27474634854156,258.1575351884441,
	258.0402773252806,257.9229727961511,257.80562163816546,257.68822388844313,257.5707795841135,
	257.4532887623157,257.3357514601989,257.2181677149221,257.10053756365494,256.9828610435768,
	256.86513819187746,256.7473690457574,256.62955364242725,256.5116920191086,256.39378421303326,
	256.275830261444,256.15783020159466,256.0397840707498,255.921691906185,255.80355374518706,
	255.6853696250539,255.5671395830949,255.44886365663072,255.3305418829935,255.21217429952702,
	255.0937609435867,254.97530185253967,254.8567970637652,254.7382466146542,254.61965054260963,
	254.50100888504693,254.38232167939333,254.26358896308872,254.14481077358522,254.02598714834758,
	253.90711812485316,253.78820374059188,253.6692440330667,253.55023903979327,253.43118879830038,
	253.3120933461298,253.1929527208365,253.07376695998883,252.95453610116837,252.83526018197037,
	252.71593924000348,252.59657331289006,252.47716243826633,252.35770665378226,252.23820599710183,
	252.1186605059031,251.99907021787826,251.87943517073384,251.75975540219065,251.64003094998398,
	251.52026185186364,251.40044814559423,251.28058986895485,251.16068705973976,251.04073975575807,
	250.92074799483387,250.80071181480653,250.68063125353052,250.56050634887595,250.44033713872807,
	250.32012366098795,250.19986595357219,250.0795640544132,249.9592180014594,249.83882783267492,
	249.71839358604026,249.59791529955186,249.4773930112226,249.35682675908174,249.23621658117497,
	249.1155625155647,248.99486460032986,248.8741228735664,248.753337373387,248.63250813792163,
	248.511635205317,248.39071861373745,248.2697584013643,248.1487546063966,248.02770726705086,
	247.9066164215612,247.78548210817954,247.6643043651757,247.54308323083742,247.42181874347065,
	247.30051094139932,247.1791598629659,247.05776554653104,246.9363280304742,246.81484735319327,
	246.6933235531048,246.57175666864447,246.4501467382666,246.32849380044487,246.20679789367193,
	246.08505905645978,245.96327732733982,245.84145274486306,245.71958534759995,245.59767517414065,
	245.47572226309546,245.3537266530943,245.23168838278735,245.10960749084495,244.9874840159575,
	244.86531799683618,244.74310947221238,244.6208584808383,244.49856506148672,244.37622925295142,
	244.25385109404704,244.13143062360942,244.00896788049536,243.88646290358324,243.76391573177273,
	243.64132640398498,243.5186949591629,243.39602143627113,243.2733058742962,243.15054831224657,
	243.02774878915292,242.90490734406802,242.7820240160671,242.6590988442478,242.5361318677304,
	242.41312312565776,242.2900726571956,242.16698050153258,242.04384669788047,241.92067128547404,
	241.79745430357147,241.67419579145428,241.55089578842757,241.42755433381984,241.3041714669838,
	241.18074722729554,241.05728165415542,240.93377478698784,240.81022666524143,240.68663732838917,
	240.56300681592856,240.43933516738153,240.31562242229484,240.19186862024011,240.0680738008138,
	239.9442380036375,239.82036126835794,239.6964436346473,239.572485142203,239.4484858307482,
	239.32444574003156,239.20036490982767,239.07624337993687,238.95208119018582,238.82787838042714,
	238.70363499053974,238.579351060429,238.45502663002682,238.3306617392918,238.20625642820917,
	238.0818107367913,237.95732470507733,237.83279837313367,237.70823178105417,237.58362496895975,
	237.45897797699917,237.33429084534862,237.2095636142122,237.08479632382173,236.95998901443733,
	236.835141726347,236.7102544998673,236.58532737534284,236.4603603931471,236.33535359368204,
	236.21030701737848,236.08522070469596,235.96009469612338,235.83492903217848,235.7097237534085,
	235.58447890039008,235.45919451372927,235.33387063406192,235.20850730205373,235.0831045584001,
	234.9576624438268,234.83218099908945,234.7066602649743,234.58110028229785,234.45550109190725,
	234.3298627346804,234.20418525152581,234.07846868338333,233.9527130712235,233.82691845604836,
	233.70108487889115,233.5752123808168,233.44930100292154,233.32335078633358,233.197361772213,
	233.0713340017518,232.9452675161741,232.81916235673637,232.69301856472745,232.5668361814687,
	232.4406152483142,232.31435580665072,232.18805789789815,232.0617215635092,231.93534684496993,
	231.80893378379966,231.68248242155124,231.55599279981098,231.42946496019923,231.30289894436967,
	231.17629479401057,231.0496525508439,230.92297225662605,230.79625395314775,230.6694976822344,
	230.54270348574588,230.41587140557698,230.28900148365733,230.16209376195187,230.03514828246037,
	229.90816508721826,229.78114421829628,229.6540857178008,229.52698962787397,229.39985599069385,
	229.27268484847443,229.14547624346594,229.01823021795477,228.8909468142639,228.76362607475278,
	228.63626804181752,228.50887275789125,228.38144026544379,228.25397060698236,228.12646382505116,
	227.99891996223204,227.87133906114417,227.74372116444445,227.6160663148276,227.48837455502627,
	227.36064592781116,227.23288047599118,227.10507824241358,226.9772392699642,226.8493636015674,
	226.72145128018636,226.59350234882308,226.46551685051872,226.33749482835367,226.2094363254474,
	226.0813413849591,225.95321005008745,225.8250423640709,225.69683837018775,225.5685981117564,
	225.44032163213527,225.3120089747232,225.18366018295941,225.0552753003239,224.9268543703371,
	224.7983974365606,224.6699045425967,224.541375732089,224.4128110487225,224.28421053622344,
	224.15557423835972,224.02690219894097,223.89819446181863,223.7694510708862,223.64067207007926,
	223.51185750337572,223.38300741479588,223.2541218484026,223.1252008483015,222.99624445864097,
	222.86725272361252,222.73822568745072,222.60916339443338,222.4800658888818,222.3509332151608,
	222.221765417679,222.09256254088874,221.96332462928643,221.83405172741266,221.7047438798522,
	221.57540113123437,221.4460235262329,221.31661110956648,221.18716392599836,221.0576820203371,
	220.92816543743606,220.79861422219426,220.66902841955587,220.53940807451087,220.40975323209472,
	220.2800639373889,220.15034023552099,220.0205821716644,219.8907897910393,219.76096313891196,
	219.6311022605954,219.50120720144938,219.37127800688037,219.24131472234214,219.1113173933355,
	218.98128606540857,218.85122078415688,218.72112159522376,218.59098854430013,218.46082167712487,
	218.330621039485,218.2003866772156,218.07011863620008,217.93981696237057,217.80948170170748,
	217.67911290024037,217.54871060404747,217.4182748592562,217.28780571204317,217.1573032086344,
	217.0267673953053,216.89619831838115,216.76559602423686,216.63496055929735,216.50429197003766,
	216.3735903029831,216.24285560470932,216.11208792184257,215.98128730105978,215.85045378908868,
	215.71958743270798,215.58868827874764,215.45775637408875,215.326791765664,215.19579450045742,
	215.06476462550495,214.93370218789437,214.80260723476553,214.67147981331019,214.5403199707728,
	214.40912775445003,214.27790321169113,214.14664638989828,214.01535733652653,213.8840360990838,
	213.7526827251315,213.62129726228417,213.4898797582099,213.35843026063048,213.2269488173215,
	213.09543547611239,212.96389028488676,212.8323132915825,212.70070454419172,212.56906409076132,
	212.43739197939266,212.30568825824196,212.17395297552056,212.04218617949485,211.91038791848652,
	211.7785582408726,211.64669719508584,211.51480482961455,211.38288119300313,211.25092633385177,
	211.11894030081692,210.98692314261146,210.8548749080046,210.72279564582223,210.59068540494698,
	210.45854423431842,210.32637218293308,210.1941692998449,210.06193563416497,209.92967123506205,
	209.79737615176248,209.66505043355033,209.53269412976786,209.40030728981517,209.2678899631508,
	209.1354421992916,209.00296404781298,208.87045555834908,208.7379167805928,208.6053477642962,
	208.47274855927031,208.3401192153855,208.20745978257176,208.07477031081837,207.94205085017447,
	207.8093014507493,207.67652216271176,207.54371303629122,207.41087412177725,207.27800546952,
	207.14510712993012,207.01217915347917,206.87922159069947,206.7462344921846,206.61321790858935,
	206.48017189062963,206.34709648908319,206.2139917547893,206.08085773864897,205.94769449162533,
	205.81450206474352,205.68128050909104,205.54802987581772,205.41475021613587,205.28144158132068,
	205.1481040227101,205.01473759170506,204.88134233976965,204.74791831843137,204.6144655792809,
	204.48098417397284,204.34747415422532,204.2139355718204,204.08036847860416,203.94677292648694,
	203.81314896744325,203.67949665351225,203.5458160367977,203.41210716946796,203.27837010375652,
	203.14460489196176,203.01081158644752,202.87699023964277,202.74314090404192,202.6092636322053,
	202.47535847675897,202.3414254903947,202.20746472587072,202.07347623601115,201.93946007370678,
	201.80541629191472,201.67134494365888,201.53724608203,201.40311976018575,201.26896603135083,
	201.1347849488174,201.00057656594487,200.8663409361603,200.73207811295845,200.59778814990176,
	200.46347110062086,200.32912701881452,200.19475595824957,200.06035797276158,199.9259331162544,
	199.79148144270084,199.65700300614242,199.52249786068973,199.38796606052242,199.2534076598896,
	199.11882271310972,198.9842112745708,198.8495733987307,198.71490914011702,198.58021855332734,
	198.4455016930297,198.31075861396212,198.17598937093325,198.0411940188223,197.9063726125791,
	197.77152520722456,197.63665185785047,197.5017526196199,197.36682754776714,197.23187669759793,
	197.09690012448962,196.96189788389145,196.8268700313242,196.69181662238108,196.55673771272717,
	196.42163335810005,196.2865036143095,196.15134853723816,196.01616818284137,195.88096260714718,
	195.74573186625673,195.61047601634445,195.47519511365783,195.3398892145181,195.20455837531975,
	195.0692026525312,194.93382210269476,194.79841678242656,194.6629867484171,194.52753205743096,
	194.39205276630733,194.25654893195974,194.12102061137668,193.98546786162123,193.84989073983166,
	193.71428930322136,193.57866360907877,193.44301371476797,193.3073396777285,193.17164155547547,
	193.03591940559997,192.90017328576891,192.76440325372545,192.62860936728885,192.49279168435473,
	192.35695026289534,192.2210851609595,192.0851964366728,191.9492841482377,191.81334835393392,
	191.67738911211816,191.54140648122456,191.4054005197647,191.26937128632773,191.1333188395806,
	190.99724323826817,190.86114454121306,190.72502280731646,190.58887809555742,190.45271046499371,
	190.31651997476155,190.1803066840758,190.04407065223015,189.90781193859738,189.77153060262918,
	189.63522670385663,189.49890030189005,189.36255145641928,189.2261802272138,189.089786674123,
	188.9533708570758,188.81693283608155,188.68047267122952,188.54399042268938,188.4074861507111,
	188.2709599156254,188.13441177784347,187.99784179785755,187.86125003624068,187.72463655364706,
	187.58800141081204,187.45134466855242,187.3146663877664,187.1779666294338,187.04124545461625,
	186.90450292445712,186.76773910018198,186.63095404309826,186.49414781459598,186.35732047614732,
	186.22047208930704,186.08360271571254,185.94671241708411,185.80980125522478,185.67286929202078,
	185.53591658944137,185.3989432095392,185.26194921445034,185.12493466639438,184.9878996276745,
	184.8508441606779,184.7137683278756,184.5766721918227,184.43955581515834,184.30241926060629,
	184.16526259097446,184.02808586915552,183.89088915812673,183.7536725209502,183.61643602077314,
	183.47917972082755,183.34190368443078,183.20460797498558,183.06729265598005,182.92995779098788,
	182.79260344366847,182.65522967776704,182.51783655711475,182.38042414562884,182.24299250731278,
	182.1055417062563,181.9680718066356,181.83058287271353,181.69307496883948,181.55554815944973,
	181.41800250906755,181.28043808230316,181.1428549438541,181.0052531585051,180.86763279112827,
	180.7299939066835,180.5923365702181,180.45466084686734,180.3169668018543,180.17925450049026,
	180.0415240081744,179.90377539039443,179.76600871272623,179.6282240408344,179.49042144047215,
	179.3526009774814,179.21476271779287,179.07690672742646,178.93903307249113,178.801141819185,
	178.66323303379565,178.5253067827002,178.38736313236518,178.24940214934702,178.11142390029187,
	177.97342845193594,177.8354158711056,177.69738622471718,177.55933957977751,177.4212760033838,
	177.28319556272393,177.14509832507633,177.00698435781027,176.86885372838594,176.73070650435463,
	176.59254275335874,176.45436254313194,176.31616594149938,176.17795301637761,176.03972383577488,
	175.9014784677913,175.76321698061867,175.62493944254095,175.48664592193424,175.34833648726675,
	175.2100112070992,175.07167015008469,174.933313384969,174.79494098059072,174.6565530058811,
	174.51814952986464,174.3797306216587,174.24129635047413,174.10284678561496,173.96438199647872,
	173.8259020525568,173.68740702343402,173.5488969787893,173.41037198839553,173.27183212211966,
	173.13327744992316,172.99470804186168,172.85612396808557,172.7175252988398,172.57891210446437,
	172.44028445539405,172.3016424221589,172.16298607538414,172.02431548579068,171.8856307241947,
	171.74693186150844,171.60821896873995,171.46949211699334,171.33075137746903,171.19199682146387,
	171.05322852037136,170.9144465456819,170.7756509689826,170.63684186195817,170.49801929639045,
	170.3591833441591,170.2203340772415,170.08147156771318,169.94259588774793,169.8037071096183,
	169.66480530569544,169.5258905484498,169.38696291045122,169.24802246436914,169.1090692829731,
	168.9701034391331,168.83112500581962,168.6921340561045,168.55313066316083,168.41411490026377,
	168.27508684079064,168.13604655822175,167.99699412614058,167.85792961823444,167.71885310829506,
	167.5797646702192,167.44066437800902,167.30155230577319,167.16242852772723,167.02329311819454,
	166.8841461516071,166.74498770250625,166.60581784554387,166.46663665548314,166.32744420720002,
	166.18824057568384,166.04902583603896,165.9098000634859,165.77056333336307,165.6313157211278,
	165.49205730235855,165.35278815275626,165.2135083481466,165.07421796448156,164.9349170778423,
	164.79560576444098,164.65628410062362,164.51695216287274,164.37761002781045,164.2382577722015,
	164.098895472957,163.95952320713778,163.82014105195867,163.6807490847929,163.5413473831764,
	163.4019360248133,163.26251508758105,163.12308464953645,162.98364478892194,162.84419558417213,
	162.7047371139219,162.56526945701367,162.42579269250623,162.28630689968404,162.1468121580672,
	162.0073085474224,161.86779614777436,161.7282750394184,161.58874530293446,161.44920701920142,
	161.30966026941297,161.17010513509493,161.03054169812373,160.8909700407462,160.75139024560139,
	160.61180239574392,160.472206574669,160.33260286633956,160.19299135521604,160.0533721262879,
	159.91374526510776,159.7741108578288,159.63446899124463,159.49481975283254,159.35516323080012,
	159.2154995141362,159.07582869266474,158.9361508571042,158.79646609913118,158.65677451144896,
	158.5170761878621,158.37737122335653,158.23765971418635,158.09794175796762,157.9582174537795,
	157.81848690227378,157.67875020579302,157.53900746849817,157.39925879650696,157.2595042980423,
	157.11974408359407,156.97997826609264,156.84020696109715,156.70043028699865,156.5606483652395,
	156.4208613205506,156.28106928120746,156.14127237930734,156.00147075106787,155.8616645371504,
	155.7218538830091,155.58203893926805,155.4422198621285,155.30239681380914,155.16256996302158,
	155.02273948548412,154.8829055644764,154.74306839143912,154.6032281666211,154.46338509977937,
	154.32353941093416,154.18369133118514,154.04384110359294,153.90398898413093,153.7641352427138,
	153.62428016430755,153.484424050129,153.3445672189407,153.2047100084494,153.06485277681588,
	152.9249959042854,152.78513979494772,152.64528487863774,152.5054316129861,152.36558048563404,
	152.2257320166227,152.08588676097258,151.94604531146612,151.80620830165117,151.66637640908027,
	151.52655035880545,151.38673092714757,151.24691894576094,151.10711530601637,150.96732096372557,
	150.8275369442342,150.68776434790917,150.54800435605142,150.40825823726408,150.2685273543102,
	150.1288131714951,149.9891172626113,149.84944131948632,149.70978716117486,149.57015674384135,
	149.4305521713793,149.2909757068176,149.15142978456555,149.01191702355226,148.87244024131616,
	148.73300246910495,148.59360696804643,148.45425724645386,148.31495707832983,148.1757105231346,
	148.0365219468852,147.89739604464987,147.75833786450477,147.61935283301443,147.48044678229678,
	147.34162597872825,147.2028971533383,147.06426753393615,146.92574487899992,146.78733751334937,
	146.64905436560528,146.51090500742185,146.37289969445607,146.23504940900892,146.09736590425376,
	145.9598617499147,145.82255037923403,145.68544613701235,145.54856432845764,145.41192126851965,
	145.27553433132385,145.1394219992489,145.00360391111656,144.8681009088819,144.73293508212694,
	144.59812980957352,144.4637097967406,144.32970110878333,144.19613119746512,144.06302892113376,
	143.93042455650584,143.79834980100577,143.66683776437182,143.53592294822866,143.40564121234326,
	143.27602972633312,143.1471269056874,143.01897233109602,142.89160665026594,142.76507146163667,
	142.6394091796874,142.51466288186253,142.39087613751414,142.26809281967238,142.14635690089327,
	142.02571223488513,141.90620232606656,141.78787008964082,141.67075760516818,141.55490586695916,
	141.44035453487612,141.32714168931247,141.215303594191,141.1048744717906,140.99588629306055,
	140.88836858681867,140.78234827086467,140.67784950757806,140.57489358603593,140.4734988320961,
	140.37368054727,140.27545097658142,140.17881930499655,140.0837916814365,139.99037126886955,
	139.8985583185339,139.80835026598356,139.71974184637676,139.63272522624257,139.5472901488707,
	139.46342409045442,139.38111242417833,139.30033858956648,139.2210842645807,139.14332953817262,
	139.06705308123358,138.99223231414365,138.91884356938473,138.84686224794362,138.77626296848393,
	138.70701970850195,138.63910593690346,138.57249473763312,138.50715892416724,138.4430711448288,
	138.38020397901693,138.31853002454773,138.25802197639126,138.1986526971569,138.14039527973185,
	138.08322310251236,138.0271098776909,137.9720296930749,137.91795704791602,137.86486688322307,
	137.8127346070228,137.76153611501496,137.71124780705196,137.66184659984847,137.6133099363064,
	137.5656157918133,137.51874267784478,137.47266964321,137.42737627314955,137.3828426866541,
	137.3390495321593,137.29597798187018,137.25360972490674,137.21192695944808,137.17091238403634,
	137.13054918818452,137.09082104241583,137.05171208785112,137.01320692544363,136.9752906049536,
	136.93794861374016,136.90116686544076,136.86493168859943,136.82922981529583,136.79404836982158,
	136.75937485744265,136.72519715328212,136.69150349135145,136.65828245375397,136.62552296008133,
	136.5932142570183,136.56134590817024,136.52990778412217,136.4988900527394,136.46828316971312,
	136.43807786935713,136.4082651556566,136.37883629357026,136.34978280058536,136.32109643852468,
	136.29276920560264,136.2647933287278,136.23716125604793,136.2098656497339,136.1828993789971,
	136.1562555133357,136.12992731600514,136.10390823770587,136.07819191048455,136.05277214184127,
	136.0276429090385,136.00279835360462,135.97823277602706,135.95394063062867,135.92991652062219,
	135.9061551933366,135.88265153560937,135.85940056934047,135.8363974472012,135.81363744849313,
	135.79111597514682,135.76882854788926,135.7467708024858,135.72493848617535,135.70332745419833,
	135.6819336664525,135.6607531842653,135.6397821672792,135.61901687044448,135.5984536411175,
	135.57808891625868,135.5579192197278,135.53794115967258,135.51815142600694,135.49854678797612,
	135.47912409180472,135.4598802584257,135.44081228128587,135.42191722422666,135.4031922194357,
	135.38463446546857,135.36624122533578,135.3480098246548,135.32993764986333,135.31202214649218,
	135.29426081749514,135.27665122163413,135.25919097191752,135.2418777340896,135.22470922516933,
	135.20768321203647,135.1907975100639,135.17404998179347,135.157438535655,135.14096112472583,
	135.1246157455303,135.10840043687674,135.09231327873198,135.07635239113077,135.0605159331193,
	135.0448021017322,135.02920913100104,135.01373529099345,134.99837888688182,134.98313825804095,
	134.9680117771729,134.95299784945843,134.93809491173457,134.9233014316966,134.90861590712404,
	134.89403686513006,134.87956286143287,134.86519247964887,134.85092433060677,134.83675705168164,
	134.82268930614867,134.80871978255556,134.79484719411317,134.78107027810375,134.76738779530638,
	134.7537985294384,134.7403012866132,134.72689489481323,134.71357820337784,134.70035008250542,
	134.68720942276985,134.67415513465005,134.6611861480728,134.64830141196785,134.63549989383606,
	134.62278057932838,134.6101424718369,134.59758459209698,134.58510597779983,134.57270568321584,
	134.56038277882791,134.54813635097437,134.53596550150178,134.52386934742643,134.51184702060505,
	134.49989766741425,134.48802044843802,134.47621453816362,134.46447912468523,134.4528134094085,
	134.44121660679653,134.42968794405388,134.4182266608882,134.40683200924238,134.39550325304083,
	134.38423966794204,134.37304054109728,134.36190517091558,134.3508328668341,134.33982294909464,
	134.32887474852515,134.31798760632728,134.3071608738682,134.29639391247844,134.28568609325396,
	134.27503679686305,134.26444541335832,134.25391134199253,134.24343399103952,134.23301277761868,
	134.22264712752397,134.21233647505696,134.20208026286386,134.1918779417756,134.18172897065293,
	134.17163281623388,134.16158895298568,134.1515968629591,134.14165603564706,134.13176596784606,
	134.12192616352053,134.1121361336706,134.1023953962027,134.09270347580306,134.0830599038141,
	134.07346421811346,134.06391596299568,134.05441468905673,134.04495995308085,134.03555131792984,
	134.02618835243518,134.0168706312917,134.00759773495443,133.99836924953703,133.98918476671287,
	133.9800438836176,133.97094620275473,133.96189133190228,133.95287888402183,133.94390847716963,
	133.93497973440935,133.9260922837266,133.91724575794547,133.9084397946466,133.89967403608705,
	133.8909481291217,133.88226172512663,133.87361447992333,133.86500605370532,133.85643611096572,
	133.84790432042632,133.83941035496818,133.83095389156404,133.82253461121084,133.8141521988653,
	133.80580634337926,133.79749673743723,133.78922307749485,133.7809850637184,133.77278239992586,
	133.76461479352892,133.75648195547603,133.74838360019675,133.740319445547,133.73228921275563,
	133.72429262637152,133.7163294142123,133.70839930731364,133.70050203987947,133.6926373492335,
	133.6848049757714,133.6770046629137,133.66923615706006,133.66149920754393,133.65379356658843,
	133.64611898926253,133.63847523343878,133.63086205975105,133.62327923155368,133.6157265148808,
	133.60820367840708,133.60071049340837,133.59324673372376,133.58581217571802,133.5784065982446,
	133.5710297826097,133.5636815125363,133.5563615741298,133.54906975584308,133.54180584844352,
	133.53456964497917,133.52736094074677,133.5201795332597,133.51302522221638,133.50589780946962,
	133.49879709899622,133.49172289686732,133.48467501121894,133.47765325222332,133.47065743206068,
	133.46368736489129,133.45674286682842,133.4498237559111,133.44292985207798,133.4360609771414,
	133.42921695476176,133.42239761042228,133.4156027714048,133.40883226676496,133.4020859273087,
	133.3953635855687,133.38866507578126,133.38199023386363,133.37533889739169,133.36871090557804,
	133.3621060992502,133.35552432082963,133.34896541431058,133.34242922523975,133.33591560069578,
	133.32942438926963,133.32295544104468,133.31650860757765,133.31008374187334,133.30368069839145,
	133.2972993329892,133.2909395029297,133.28460106685725,133.27828388478025,133.27198781805347,
	133.2657127293615,133.25945848270146,133.2532249433672,133.2470119779326,133.24081945423578,
	133.23464724136346,133.2284952096354,133.2223632305891,133.21625117696493,133.21015892269136,
	133.2040863428703,133.1980333137627,133.1919997127747,133.18598541844355,133.17999031042382,
	133.17401426947418,133.16805717744387,133.16211891725968,133.15619937291302,133.15029842944742,
	133.14441597294555,133.13855189051742,133.13270607028784,133.12687840138457,133.1210687739265,
	133.11527707901217,133.10950320870788,133.10374705603692,133.0980085149681,133.0922874804047,
	133.08658384817397,133.0808975150163,133.07522837857456,133.06957633738398,133.0639412908618,
	133.05832313929716,133.0527217838413,133.04713712649772,133.0415690701123,133.03601751836428,
	133.03048237575632,133.02496354760564,133.01946094003458,133.01397445996201,133.008504015094,
	133.0030495139154,132.997610865681,132.99218798040707,132.98678076886307,132.98138914256313,
	132.9760130137582,132.97065229542767,132.96530690127156,132.95997674570265,132.95466174383893,
	132.94936181149552,132.94407686517755,132.93880682207256,132.93355160004313,132.92831111761978,
	132.92308529399358,132.9178740490094,132.91267730315883,132.90749497757315,132.90232699401685,
	132.89717327488069,132.89203374317532,132.8869083225245,132.88179693715912,132.87669951191023,
	132.8716159722033,132.86654624405185,132.86149025405132,132.85644792937305,132.85141919775845,
	132.84640398751287,132.8414022275002,132.83641384713675,132.83143877638582,132.82647694575212,
	132.82152828627608,132.8165927295287,132.81167020760594,132.8067606531235,132.80186399921158,
	132.79698017950975,132.7921091281618,132.78725077981065,132.78240506959335,132.77757193313644,
	132.77275130655067,132.76794312642647,132.76314732982928,132.7583638542944,132.75359263782303,
	132.74883361887714,132.7440867363753,132.73935192968807,132.73462913863355,132.72991830347317,
	132.72521936490736,132.72053226407115,132.71585694253014,132.71119334227626,132.70654140572378,
	132.70190107570505,132.6972722954668,132.69265500866584,132.68804915936548,132.68345469203143,
	132.67887155152806,132.67429968311475,132.66973903244198,132.66518954554763,132.66065116885358,
	132.65612384916196,132.65160753365146,132.64710216987396,132.64260770575123,132.6381240895711,
	132.6336512699844,132.62918919600136,132.62473781698856,132.62029708266536,132.61586694310085,
	132.6114473487106,132.60703825025348,132.6026395988285,132.5982513458717,132.59387344315323,
	132.58950584277412,132.5851484971635,132.58080135907534,132.57646438158588,132.57213751809036,
	132.5678207223006,132.5635139482417,132.55921715024954,132.55493028296797,132.55065330134602,
	132.54638616063517,132.5421288163867,132.53788122444914,132.53364334096543,132.52941512237047,
	132.52519652538857,132.52098750703098,132.5167880245932,132.51259803565253,132.5084174980657,
	132.50424636996655,132.5000846097634,132.49593217613662,132.4917890280367,132.4876551246814,
	132.48353042555388,132.4794148904002,132.475308479227,132.47121115229965,132.4671228701395,
	132.46304359352212,132.458973283475,132.45491190127538,132.45085940844822,132.44681576676405,
	132.44278093823687,132.4387548851222,132.434737569915,132.4307289553477,132.42672900438816,
	132.42273768023753,132.41875494632893,132.41478076632478,132.4108151041153,132.4068579238166,
	132.40290918976862,132.39896886653366,132.3950369188942,132.3911133118511,132.3871980106151,
	132.3832909806332,132.3793921875438,132.37550159720402,132.37161917568096,132.36774488924945,
	132.3638787043909,132.3600205877913,132.35617050633962,132.35232842712637,132.3484943174416,
	132.3446681447738,132.34084987680777,132.3370394814236,132.33323692669458,132.32944218088613,
	132.325655212454,132.3218759900428,132.3181044824845,132.31434065879714,132.31058448818308,
	132.30683594002775,132.30309498389803,132.29936158954112,132.29563572688284,132.29191736602647,
	132.28820647725104,132.2845030310103,132.2808069979313,132.2771183488129,132.27343705462448,
	132.26976308650484,132.26609641576053,132.2624370138649,132.2587848524566,132.25513990333843,
	132.25150213847607,132.2478715299967,132.24424805018796,132.24063167149674,132.23702236652767,
	132.2334201080424,132.2298248689579,132.22623662234577,132.22265534143065,132.21908099958935,
	132.21551357034963,132.21195302738914,132.208399344534,132.2048524957582,132.20131245518195,
	132.19777919707096,132.19425269583533,132.1907329260283,132.18721986234527,132.18371347962295,
	132.1802137528379,132.17672065710593,132.17323416768082,132.1697542599534,132.16628090945048,
	132.16281409183395,132.1593537828997,132.1558999585768,132.15245259492633,132.14901166814047,
	132.14557715454174,132.14214903058186,132.1387272728408,132.13531185802597,132.13190276297132,
	132.12849996463632,132.12510344010508,132.1217131665856,132.11832912140872,132.11495128202725,
	132.11157962601524,132.108214131067,132.10485477499626,132.10150153573537,132.09815439133436,
	132.09481331996037,132.09147829989655,132.08814930954122,132.08482632740728,132.08150933212136,
	132.07819830242283,132.07489321716335,132.07159405530558,132.0683007959231,132.06501341819896,
	132.06173190142536,132.0584562250026,132.05518636843874,132.05192231134836,132.0486640334522,
	132.04541151457622,132.04216473465095,132.03892367371088,132.03568831189358,132.03245862943902,
	132.02923460668893,132.0260162240862,132.02280346217384,132.01959630159485,132.01639472309094,
	132.01319870750237,132.010008235767,132.0068232889196,132.0036438480915,132.0004698945096,
	131.99730140949586,131.9941383744668,131.99098077093257,131.98782858049663,131.98468178485498,
	131.9815403657955,131.97840430519733,131.9752735850306,131.97214818735526,131.96902809432092,
	131.96591328816618,131.96280375121782,131.9596994658906,131.95660041468625,131.95350658019328,
	131.95041794508617,131.94733449212495,131.94425620415444,131.941183064104,131.9381150549868,
	131.93505215989916,131.93199436202025,131.9289416446114,131.92589399101567,131.9228513846572,
	131.9198138090408,131.91678124775135,131.91375368445338,131.91073110289042,131.90771348688463,
	131.90470082033622,131.90169308722287,131.89869027159966,131.89569235759782,131.892699329425,
	131.8897111713644,131.8867278677742,131.88374940308745,131.8807757618113,131.87780692852652,
	131.8748428878874,131.87188362462075,131.86892912352593,131.86597936947396,131.8630343474076,
	131.86009404234034,131.8571584393563,131.85422752360975,131.85130128032463,131.84837969479403,
	131.84546275237997,131.84255043851277,131.8396427386907,131.83673963847963,131.83384112351257,
	131.83094717948913,131.82805779217531,131.82517294740305,131.8222926310696,131.8194168291375,
	131.8165455276339,131.81367871265022,131.81081637034183,131.8079584869276,131.80510504868948,
	131.8022560419723,131.79941145318313,131.79657126879107,131.79373547532683,131.79090405938243,
	131.7880770076107,131.78525430672497,131.78243594349877,131.77962190476543,131.77681217741753,
	131.77400674840703,131.7712056047444,131.7684087334985,131.76561612179626,131.76282775682228,
	131.76004362581844,131.7572637160837,131.7544880149737,131.75171650990032,131.74894918833144,
	131.74618603779066,131.7434270458569,131.740672200164,131.73792148840073,131.73517489830985,
	131.73243241768856,131.72969403438756,131.72695973631104,131.7242295114104,131.72150334770794,
	131.7187812332599,131.71606315618112,131.71334910463827,131.71063906684947,131.70793303108445,
	131.7052309856636,131.7025329189583,131.6998388193902,131.69714867543098,131.6944624756023,
	131.69178020847534,131.68910186267053,131.68642742685722,131.6837568897535,131.68109024012605,
	131.67842746678937,131.67576855860617,131.6731135044865,131.670462293388,131.66781491431516,
	131.6651713563194,131.66253160849863,131.659895659997,131.6572635000048,131.654635117758,
	131.652010502538,131.64938964367155,131.64677253053048,131.64415915253113,131.64154949913447,
	131.63894355984576,131.63634132421416,131.63374278183264,131.63114792233768,131.62855673540895,
	131.62596921076934,131.62338533818436,131.62080510746216,131.61822850845314,131.6156555310499,
	131.61308616518681,131.61052040083993,131.6079582280267,131.60539963680569,131.6028446172765,
	131.60029315957942,131.59774525389525,131.59520089044506,131.59266005949002,131.59012275133105,
	131.58758895630885,131.58505866480343,131.5825318672341,131.58000855405908,131.5774887157753,
	131.57497234291844,131.57245942606247,131.5699499558195,131.56744392283963,131.5649413178107,
	131.56244213145803,131.55994635454442,131.5574539778697,131.55496499227078,131.55247938862118,
	131.54999715783103,131.54751829084697,131.54504277865155,131.54257061226355,131.5401017827374,
	131.53763628116312,131.53517409866623,131.53271522640745,131.5302596555825,131.52780737742208,
	131.52535838319136,131.5229126641902,131.5204702117526,131.5180310172469,131.51559507207526,
	131.5131623676736,131.51073289551152,131.50830664709204,131.5058836139513,131.5034637876588,
	131.50104715981664,131.49863372205994,131.4962234660561,131.49381638350516,131.49141246613937,
	131.4890117057229,131.48661409405202,131.48421962295447,131.48182828428992,131.47944006994925,
	131.47705497185459,131.47467298195917,131.47229409224727,131.46991829473382,131.46754558146444,
	131.46517594451524,131.46280937599252,131.46044586803288,131.45808541280286,131.45572800249892,
	131.4533736293471,131.4510222856031,131.448673963552,131.44632865550813,131.4439863538149,
	131.44164705084475,131.4393107389989,131.43697741070727,131.43464705842823,131.43231967464868,
	131.42999525188358,131.42767378267618,131.4253552595976,131.4230396752468,131.42072702225045,
	131.4184172932628,131.41611048096536,131.41380657806707,131.411505577304,131.40920747143923,
	131.40691225326267,131.40461991559104,131.40233045126755,131.400043853162,131.39776011417055,
	131.3954792272156,131.39320118524546,131.39092598123466,131.38865360818343,131.38638405911774,
	131.3841173270892,131.38185340517475,131.3795922864685,131.37733396411576,131.3750784312597,
	131.37282568107796,131.37057570677308,131.36832850157236,131.3660840587276,131.3638423715152,
	131.36160343323598,131.35936723721488,131.35713377680105,131.35490304536768,131.35267503631184,
	131.35044974305444,131.34822715904008,131.34600727773687,131.34379009263654,131.3415755972539,
	131.3393637851271,131.3371546498176,131.33494818490973,131.33274438401065,131.33054324075047,
	131.32834474878192,131.32614890178027,131.32395569344334,131.3217651174913,131.31957716766664,
	131.31739183773388,131.31520912147968,131.31302901271275,131.31085150526346,131.30867659298397,
	131.30650426974825,131.3043345294517,131.30216736601105,131.3000027733646,131.2978407454718,
	131.29568127631316,131.29352435989043,131.29136999022612,131.28921816136366,131.2870688673673,
	131.28492210232193,131.28277786033297,131.2806361355263,131.27849692204822,131.2763602140653,
	131.27422600576435,131.27209429135215,131.2699650650556,131.2678383211215,131.2657140538164,
	131.2635922574241,131.26147292625723,131.25935605463653,131.25724163690722,131.25512966743398,
	131.25302014060063,131.25091305079232,131.24880839248416,131.24670616006406,131.24460634800965,
	131.24250895079985,131.24041396293237,131.23832137892362,131.23623119330588,131.23414340063596,
	131.23205799548438,131.22997497244125,131.22789432611506,131.22581605113234,131.22374014213787,
	131.22166659379434,131.21959540078242,131.21752655780074,131.21546005956552,131.2133959008109,
	131.21133407628847,131.20927458076744,131.20721740903454,131.20516255589382,131.2031100161667,
	131.2010597846918,131.19901185632486,131.1969662259388,131.1949228884236,131.19288183868596,
	131.19084307164965,131.18880658225513,131.1867723654596,131.18474041623693,131.1827107295775,
	131.18068330048823,131.17865812399245,131.17663519512988,131.17461450895644,131.17259606054432,
	131.17057984498186,131.16856585737344,131.16655409283948,131.1645445465162,131.1625372135559,
	131.16053208912652,131.15852916841172,131.15652844661088,131.15452991893898,131.15253358062645,
	131.1505394269193,131.14854745307866,131.14655765438135,131.14457002611917,131.14258456359926,
	131.14060126214383,131.13862011709008,131.13664112379033,131.13466427761182,131.13268957393657,
	131.13071700816153,131.1287465756983,131.1267782719731,131.12481209242694,131.1228480325153,
	131.12088608771816,131.11892625350117,131.11696852537207,131.11501289884382,131.11305936944385,
	131.11110793271368,131.10915858420907,131.10721131949975,131.10526613416937,131.1033230238158,
	131.1013819840506,131.0994430104992,131.09750609880084,131.09557124460855,131.09363844358882,
	131.09170769142204,131.08977898380192,131.0878523164357,131.0859276850441,131.08400508536133,
	131.08208451313473,131.080165964125,131.07824943410603,131.07633491886494,131.07442241420196,
	131.07251191593028,131.07060341987614,131.06869692187874,131.06679241779017,131.06488990347535,
	131.062989374812,131.0610908276905,131.0591942580141,131.0572996616984,131.05540703467193,
	131.05351637287538,131.0516276722622,131.04974092879812,131.0478561384613,131.04597329724226,
	131.04409240114362,131.0422134461804,131.04033642837982,131.03846134378102,131.03658818843547,
	131.0347169584065,131.03284764976945,131.0309802586116,131.02911478103212,131.02725121314202,
	131.02538955106408,131.02352979093286,131.02167192889456,131.019815961107,131.0179618837397,
	131.01610969297369,131.01425938500148,131.01241095602705,131.0105644022658,131.00871971994445,
	131.0068769053012,131.00503595458534,131.00319686405746,131.0013596299894,130.99952424866407,
	130.99769071637553,130.99585902942883,130.99402918414015,130.9922011768365,130.9903750038559,
	130.9885506615472,130.9867281462702,130.9849074543953,130.9830885823039,130.9812715263879,
	130.97945628305007,130.9776428487035,130.97583121977218,130.97402139269053,130.97221336390348,
	130.9704071298663,130.9686026870449,130.96680003191543,130.96499916096434,130.9632000706886,
	130.96140275759518,130.95960721820148,130.95781344903486,130.95602144663297,130.95423120754364,
	130.9524427283246,130.95065600554364,130.9488710357785,130.94708781561707,130.9453063416569,
	130.94352661050553
	}}
};
table1d_imp<2001> tubetable2_EL84[2] __rt_data = {
	{ // Ri = 68k
	-10,10,100,2001, {
	2062.404728886117,2061.0456739423234,2059.6892192833716,2058.33535979238,2056.984090365678,
	2055.6354059126165,2054.2893013559396,2052.9457716311745,2051.6048116871434,2050.2664164854523,
	2048.930581000515,2047.5973002200003,2046.2665691441352,2044.938382786029,2043.6127361715794,
	2042.2896243394819,2040.969042340888,2039.6509852398892,2038.3354481128256,2037.0224260488576,
	2035.7119141495236,2034.4039075288522,2033.0984013134055,2031.795390641977,2030.4948706657337,
	2029.1968365481762,2027.9012834652174,2026.6082066046595,2025.3176011667922,2024.0294623638715,
	2022.743785420274,2021.4605655725263,2020.1797980690553,2018.901478170413,2017.6256011488072,
	2016.3521622886976,2015.0811568861438,2013.8125802492013,2012.5464276974483,2011.2826945625452,
	2010.0213761875318,2008.7624679272967,2007.5059651482334,2006.2518632285721,2005.0001575577226,
	2003.7508435367702,2002.5039165783885,2001.259372106456,2000.0172055562,1998.7774123745553,
	1997.539988019456,1996.3049279600796,1995.0722276771646,1993.8418826622233,1992.613888418179,
	1991.3882404591166,1990.1649343099975,1988.9439655070241,1987.7253295972578,1986.5090221388525,
	1985.2950387008045,1984.0833748629852,1982.874026216185,1981.6669883621153,1980.4622569129504,
	1979.2598274920967,1978.0596957330338,1976.8618572805528,1975.6663077897729,1974.4730429263584,
	1973.2820583666032,1972.0933497974127,1970.9069129160519,1969.7227434303495,1968.5408370585787,
	1967.3611895292565,1966.1837965812517,1965.0086539639506,1963.8357574367315,1962.665102769493,
	1961.4966857422298,1960.3305021449653,1959.1665477780587,1958.0048184518014,1956.8453099867834,
	1955.6880182134344,1954.5329389721219,1953.3800681134378,1952.2294014976103,1951.0809349950075,
	1949.9346644856664,1948.790585859554,1947.6486950164197,1946.5089878656947,1945.3714603265962,
	1944.2361083279127,1943.1029278084575,1941.9719147161206,1940.8430650087782,1939.7163746536905,
	1938.5918396275513,1937.4694559169454,1936.349219517358,1935.2311264340517,1934.1151726816486,
	1933.0013542840486,1931.8896672742833,1930.7801076950718,1929.6726715981358,1928.5673550444085,
	1927.464154104043,1926.363064856472,1925.2640833900346,1924.1672058023944,1923.0724281999403,
	1921.979746698476,1920.8891574225354,1919.8006565058113,1918.7142400905839,1917.6299043283857,
	1916.5476453795075,1915.4674594130402,1914.3893426067482,1913.313291147493,1912.2393012306077,
	1911.1673690601247,1910.0974908489193,1909.0296628184117,1907.9638811986613,1906.900142228179,
	1905.83844215425,1904.7787772325994,1903.721143727369,1902.6655379110666,1901.611956065009,
	1900.560394478394,1899.5108494493045,1898.4633172836839,1897.4177942960841,1896.3742768093261,
	1895.3327611542547,1894.2932436701724,1893.2557207043358,1892.2201886123369,1891.1866437578703,
	1890.155082512595,1889.1255012564304,1888.097896377042,1887.072264270432,1886.048601340273,
	1885.0269039984562,1884.0071686645745,1882.9893917661298,1881.9735697385747,1880.959699025241,
	1879.9477760768978,1878.937797352689,1877.9297593188398,1876.9236584497355,1875.9194912271323,
	1874.917254140811,1873.9169436878155,1872.9185563729477,1871.9220887086708,1870.9275372146615,
	1869.9348984183305,1868.9441688546751,1867.955345065966,1866.9684236018077,1865.983401019353,
	1865.00027388314,1864.0190387649848,1863.0396922439668,1862.062230906444,1861.086651346116,
	1860.1129501639323,1859.1411239678669,1858.171169373052,1857.2030830020644,1856.2368614841607,
	1855.2725014561286,1854.3099995613895,1853.3493524507635,1852.390556781737,1851.4336092189817,
	1850.4785064341047,1849.5252451054369,1848.5738219186167,1847.6242335655418,1846.6764767455716,
	1845.7305481643805,1844.7864445346818,1843.8441625758787,1842.903699014149,1841.965050582184,
	1841.0282140196707,1840.093186072679,1839.1599634939287,1838.2285430428537,1837.298921485377,
	1836.3710955938889,1835.4450621474468,1834.5208179316082,1833.598359738127,1832.6776843654252,
	1831.7587886182046,1830.8416693077595,1829.9263232514977,1829.0127472731922,1828.1009382031482,
	1827.1908928776068,1826.282608139258,1825.3760808369566,1824.471307825842,1823.5682859672463,
	1822.6670121282907,1821.7674831827874,1820.8696960102259,1819.9736474961692,1819.0793345324723,
	1818.1867540168807,1817.295902852974,1816.4067779506652,1815.519376225405,1814.6336945988428,
	1813.7497299982729,1812.8674793572445,1811.9869396146505,1811.108107715643,1810.2309806108497,
	1809.355555256811,1808.481828615794,1807.609797655758,1806.7394593503827,1805.8708106788954,
	1805.0038486262606,1804.1385701832287,1803.2749723456427,1802.4130521155055,1801.5528064998334,
	1800.6942325116731,1799.8373271690361,1798.982087495769,1798.1285105210045,1797.276593279446,
	1796.4263328109064,1795.57772616079,1794.7307703798288,1793.8854625240608,1793.041799654616,
	1792.1997788382319,1791.35939714678,1790.5206516570665,1789.6835394514922,1788.8480576174857,
	1788.014203247501,1787.1819734393628,1786.3513652957572,1785.5223759245494,1784.6950024387447,
	1783.8692419561878,1783.0450915999343,1782.2225484978833,1781.4016097829576,1780.5822725928817,
	1779.7645340705499,1778.9483913634936,1778.133841624253,1777.3208820100851,1776.5095096833131,
	1775.699721810735,1774.8915155640527,1774.0848881198808,1773.279836659347,1772.4763583682272,
	1771.6744504371934,1770.8741100614036,1770.0753344407767,1769.2781207797914,1768.4824662873853,
	1767.6883681771833,1766.8958236674675,1766.1048299806555,1765.3153843440293,1764.527483989207,
	1763.741126152284,1762.9563080736011,1762.1730269982259,1761.3912801753079,1760.6110648584947,
	1759.8323783057133,1759.055217779219,1758.279580545659,1757.5054638757194,1756.7328650445372,
	1755.9617813313316,1755.192210019591,1754.4241483969229,1753.6575937552354,1752.892543390343,
	1752.1289946022412,1751.3669446951471,1750.6063909771303,1749.8473307605184,1749.0897613614782,
	1748.333680100285,1747.5790843010852,1746.825971292011,1746.074338405207,1745.3241829766373,
	1744.5755023461793,1743.8282938575119,1743.0825548582316,1742.338282699825,1741.5954747373005,
	1740.8541283298325,1740.1142408399228,1739.375809634189,1738.6388320826863,1737.90330555931,
	1737.1692274414856,1736.4365951104492,1735.7054059509258,1734.975657351343,1734.2473467035447,
	1733.5204714031381,1732.7950288491375,1732.0710164441066,1731.3484315939943,1730.6272717085237,
	1729.9075342005087,1729.18921648638,1728.4723159859323,1727.7568301222825,1727.0427563221422,
	1726.3300920153529,1725.6188346349873,1724.9089816177548,1724.2005304033287,1723.493478434776,
	1722.7878231583413,1722.0835620236276,1721.3806924832734,1720.6792119930863,1719.979118012239,
	1719.2804080026813,1718.5830794297417,1717.8871297617825,1717.192556470255,1716.4993570295494,
	1715.8075289171954,1715.1170696136255,1714.4279766023137,1713.7402473698198,1713.0538794052372,
	1712.368870201143,1711.6852172526424,1711.0029180577346,1710.321970117432,1709.642370935475,
	1708.964118018412,1708.2872088756533,1707.6116410194954,1706.9374119646839,1706.264519228931,
	1705.5929603326074,1704.9227327986575,1704.2538341530214,1703.5862619239667,1702.9200136424479,
	1702.2550868422609,1701.5914790595064,1700.929187832958,1700.2682107039793,1699.6085452164891,
	1698.9501889168969,1698.2931393540487,1697.63739407915,1696.9829506462277,1696.3298066112568,
	1695.6779595331006,1695.0274069726026,1694.37814649324,1693.7301756607474,1693.0834920431275,
	1692.438093210724,1691.7939767363905,1691.1511401948292,1690.5095811633716,1689.869297221323,
	1689.2302859504164,1688.5925449343079,1687.9560717589907,1687.3208640127366,1686.6869192856254,
	1686.0542351701038,1685.4228092605579,1684.7926391535716,1684.163722447686,1683.53605674346,
	1682.9096396434668,1682.2844687523632,1681.660541676812,1681.0378560251177,1680.4164094078653,
	1679.796199437372,1679.1772237279138,1678.5594798955788,1677.9429655583835,1677.3276783361177,
	1676.7136158504013,1676.100775724672,1675.4891555840934,1674.8787530556754,1674.269565768039,
	1673.6615913516061,1673.0548274384628,1672.4492716624454,1671.844921658979,1671.2417750650807,
	1670.6398295194597,1670.0390826625285,1669.4395321359902,1668.841175583422,1668.2440106497436,
	1667.6480349815417,1667.0532462267263,1666.4596420348817,1665.867220056924,1665.2759779452547,
	1664.6859133538303,1664.0970239378184,1663.509307353833,1662.9227612600225,1662.337383315607,
	1661.7531711813353,1661.1701225192978,1660.5882349926776,1660.0075062662227,1659.4279340056316,
	1658.8495158781766,1658.272249551943,1657.6961326965682,1657.1211629828276,1656.5473380824171,
	1655.9746556683906,1655.4031134149466,1654.832708997248,1654.2634400916281,1653.6953043755116,
	1653.128299527354,1652.562423226638,1651.9976731538795,1651.4340469905908,1650.8715424191064,
	1650.3101571230277,1649.7498887866834,1649.1907350953218,1648.6326937351992,1648.0757623933112,
	1647.5199387577513,1646.9652205172315,1646.4116053614157,1645.8590909807426,1645.307675066478,
	1644.7573553105549,1644.2081294058676,1643.659995045824,1643.112949924701,1642.566991737487,
	1642.022118179688,1641.4783269477036,1640.935615738411,1640.3939822493753,1639.8534241787606,
	1639.3139392254463,1638.7755250885546,1638.2381794682717,1637.7019000648743,1637.1666845793263,
	1636.6325307132531,1636.0994361683427,1635.5673986472484,1635.0364158528262,1634.506485488322,
	1633.9776052574814,1633.4497728644205,1632.9229860136654,1632.397242410055,1631.8725397588207,
	1631.3488757655184,1630.8262481358825,1630.3046545761467,1629.7840927927273,1629.2645604922109,
	1628.7460553815663,1628.228575167883,1627.712117558483,1627.1966802609397,1626.6822609827625,
	1626.1688574319655,1625.6564673164535,1625.145088344195,1624.6347182235356,1624.1253546626326,
	1623.616995369791,1623.1096380534343,1622.6032804219235,1622.0979201836699,1621.593555047121,
	1621.0901827205125,1620.5878009123753,1620.0864073308312,1619.5859996842207,1619.086575680581,
	1618.588133027883,1618.0906694341072,1617.5941826069384,1617.098670253957,1616.6041300825907,
	1616.1105598000227,1615.6179571132786,1615.1263197290716,1614.635645354076,1614.1459316943722,
	1613.6571764561413,1613.1693773449144,1612.6825320662497,1612.1966383249664,1611.711693826042,
	1611.2276962736469,1610.7446433718494,1610.262532824177,1609.7813623338045,1609.3011296035,
	1608.8218323355359,1608.3434682317982,1607.8660349936051,1607.3895303218221,1606.9139519167995,
	1606.4392974784178,1605.9655647058903,1605.4927512979793,1605.0208549528547,1604.5498733681002,
	1604.0798042405954,1603.610645266666,1603.142394142063,1602.67504856186,1602.2086062202907,
	1601.7430648110917,1601.2784220272229,1600.8146755609264,1600.3518231037012,1599.889862346345,
	1599.4287909787822,1598.9686066902314,1598.5093071692074,1598.050890103104,1597.593353178785,
	1597.1366940821506,1596.6809104982065,1596.2260001111476,1595.771960604233,1595.3187896598351,
	1594.8664849593138,1594.4150441832342,1593.9644650110613,1593.5147451214502,1593.0658821918541,
	1592.6178738988658,1592.170717918096,1591.7244119239656,1591.278953589989,1590.8343405885598,
	1590.3905705909299,1589.9476412673837,1589.5055502869902,1589.0642953176705,1588.623874026404,
	1588.1842840787367,1587.7455231392282,1587.3075888712015,1586.8704789367416,1586.4341909967225,
	1585.9987227109493,1585.564071737675,1585.1302357341208,1584.6972123562025,1584.2649992584788,
	1583.8335940942293,1583.4029945153707,1582.9731981725763,1582.5442027151437,1582.1160057908994,
	1581.6886050464575,1581.2619981268936,1580.8361826760033,1580.4111563359904,1579.9869167477968,
	1579.5634615507859,1579.1407883828824,1578.7188948806179,1578.297778678923,1577.8774374112477,
	1577.457868709513,1577.03907020415,1576.6210395239739,1576.2037742962727,1575.7872721467143,
	1575.3715306994586,1574.9565475769168,1574.5423203999928,1574.1288467879467,1573.7161243583275,
	1573.30415072705,1572.8929235083576,1572.4824403148245,1572.0726987572823,1571.6636964447919,
	1571.2554309847576,1570.8478999829686,1570.441101043079,1570.0350317673158,1569.6296897560458,
	1569.2250726077134,1568.8211779189926,1568.4180032848749,1568.0155462983107,1567.613804550426,
	1567.2127756307282,1566.812457126463,1566.4128466232091,1566.0139417047108,1565.6157399525582,
	1565.218238946543,1564.8214362645829,1564.4253294824932,1564.0299161741364,1563.6351939114852,
	1563.2411602645238,1562.847812801004,1562.455149086952,1562.0631666861275,1561.6718631603412,
	1561.2812360693945,1560.8912829708927,1560.502001420453,1560.1133889715343,1559.7254431755323,
	1559.3381615816297,1558.9515417369942,1558.5655811866154,1558.18027747319,1557.7956281374165,
	1557.411630717732,1557.028282750428,1556.6455817694114,1556.263525306568,1555.8821108915295,
	1555.5013360515409,1555.1211983117594,1554.7416951949492,1554.3628242215868,1553.9845829100202,
	1553.606968776145,1553.2299793335085,1552.8536120934652,1552.4778645649194,1552.1027342545067,
	1551.7282186664736,1551.3543153025603,1550.9810216624135,1550.6083352429835,1550.2362535389793,
	1549.86477404265,1549.4938942438203,1549.1236116298367,1548.7539236856962,1548.3848278937792,
	1548.0163217341317,1547.6484026841483,1547.2810682189363,1546.9143158109634,1546.5481429302135,
	1546.1825470440822,1545.8175256175286,1545.4530761128406,1545.0891959898981,1544.7258827058574,
	1544.3631337153697,1544.0009464705126,1543.6393184206088,1543.2782470126065,1542.9177296906573,
	1542.5577638963202,1542.198347068524,1541.8394766434903,1541.481150054841,1541.123364733534,
	1540.7661181077633,1540.409407603049,1540.0532306422388,1539.6975846454666,1539.3424670301374,
	1538.9878752107902,1538.633806599435,1538.2802586051637,1537.927228634386,1537.5747140907297,
	1537.2227123750035,1536.87122088522,1536.5202370165764,1536.1697581615715,1535.8197817096977,
	1535.4703050477683,1535.1213255596672,1534.77284062646,1534.4248476263517,1534.077343934645,
	1533.7303269238703,1533.3837939635312,1533.0377424202636,1532.6921696579207,1532.347073037296,
	1532.0024499162691,1531.658297649916,1531.3146135901943,1530.9713950863006,1530.6286394842875,
	1530.286344127399,1529.9445063557102,1529.6031235065568,1529.2621929140748,1528.92171190945,
	1528.5816778209671,1528.2420879738,1527.9029396899675,1527.5642302887322,1527.2259570860647,
	1526.8881173950901,1526.5507085257227,1526.2137277847662,1525.877172476084,1525.5410399004668,
	1525.2053273554086,1524.8700321356162,1524.5351515323725,1524.200682834019,1523.8666233258023,
	1523.532970289606,1523.199721004456,1522.866872746078,1522.5344227870835,1522.2023683969016,
	1521.8707068418228,1521.5394353848537,1521.2085512859649,1520.8780518018834,1520.547934185972,
	1520.2181956886488,1519.8888335570189,1519.5598450348327,1519.2312273627942,1518.902977778279,
	1518.5750935154135,1518.2475718051446,1517.9204098749728,1517.5936049493641,1517.267154249398,
	1516.9410549929694,1516.6153043944676,1516.289899665178,1515.9648380131155,1515.6401166427968,
	1515.3157327556164,1514.9916835495346,1514.6679662192673,1514.3445779561077,1514.0215159480606,
	1513.69877737979,1513.376359432732,1513.0542592845763,1512.7324741101577,1512.411001080502,
	1512.0898373635755,1511.768980123826,1511.4484265223427,1511.1281737167674,1510.8082188613632,
	1510.488559107109,1510.1691916013865,1509.8501134883575,1509.5313219086074,1509.2128139994809,
	1508.894586894602,1508.5766377244572,1508.2589636159755,1507.9415616926244,1507.6244290744705,
	1507.307562878141,1506.9909602168548,1506.674618200166,1506.3585339344422,1506.0427045225053,
	1505.7271270636152,1505.4117986536467,1505.0967163851196,1504.781877346866,1504.4672786244896,
	1504.152917299976,1503.83879045189,1503.5248951553208,1503.211228481915,1502.8977874998598,
	1502.584569273992,1502.271570865553,1501.9587893323776,1501.646221728906,1501.333865106151,
	1501.0217165117256,1500.709772989743,1500.398031581018,1500.0864893229802,1499.775143249697,
	1499.4639903917096,1499.1530277765085,1498.842252428092,1498.531661367287,1498.221251611522,
	1497.9110201751676,1497.6009640693128,1497.2910803017562,1496.9813658774565,1496.6718177982186,
	1496.3624330625923,1496.0532086664186,1495.7441416025922,1495.435228861034,1495.1264674290333,
	1494.817854291122,1494.5093864292448,1494.2010608228973,1493.8928744489333,1493.584824282279,
	1493.276907295521,1492.9691204592011,1492.6614607420242,1492.353925110902,1492.0465105315363,
	1491.7392139679973,1491.4320323833833,1491.1249627400027,1490.8180019995846,1490.5111471234688,
	1490.2043950731072,1489.8977428103126,1489.591187297687,1489.284725499156,1488.9783543800947,
	1488.6720709082608,1488.365872053992,1488.0597547912462,1487.7537160977129,1487.4477529560759,
	1487.1418623546006,1486.8360412881527,1486.5302867590974,1486.2245957782636,1485.918965366599,
	1485.6133925560653,1485.3078743913786,1485.0024079314544,1484.6969902513817,1484.3916184442355,
	1484.0862896236279,1483.7810009255472,1483.4757495116514,1483.1705325718428,1482.8653473279458,
	1482.560191036936,1482.255060995495,1481.9499545441065,1481.6448690725126,1481.3398020249597,
	1481.0347509067149,1480.7297132906576,1480.424686825681,1480.119669244665,1479.8146583742653,
	1479.5096521460205,1479.2046486080976,1478.8996459388877,1478.5946424616432,1478.2896366619427,
	1477.9846272059992,1477.6796129617483,1477.374593022693,1477.0695667336547,1476.7645337210945,
	1476.4594939252281,1476.154447637449,1475.8493955412223,1475.5443387583516,1475.239278900065,
	1474.9342181245815,1474.62915920075,1474.3241055788812,1474.0190614699989,1473.7140319327864,
	1473.4090229705457,1473.104041638002,1472.7990961584208,1472.4941960533895,1472.189352283557,
	1471.8845774027977,1471.5798857258033,1471.275293508788,1470.970819144085,1470.6664833683626,
	1470.3623094844272,1470.058323594323,1469.7545548446697,1469.4510356802327,1469.1478021053565,
	1468.8448939485975,1468.542355127981,1468.2402339122605,1467.9385831725522,1467.637460619433,
	1467.3369290181606,1467.0370563751412,1466.7379160886917,1466.4395870555993,1466.142153725848,
	1465.8457060974674,1465.550339644926,1465.256155173843,1464.9632585969193,1464.6717606269872,
	1464.3817763850393,1464.0934249226036,1463.806828660823,1463.5221127496568,1463.2394043549778,
	1462.9588318810029,1462.6805241406482,1462.4046094847256,1462.1312149073985,1461.8604651396574,
	1461.5924817511454,1461.3273822732478,1461.0652793606394,1460.806280007266,1460.5504848271821,
	1460.2979874150906,1460.04887379352,1459.8032219549777,1459.561101502365,1459.3225733914505,
	1459.0876897726105,1458.8564939307228,1458.6290203188044,1458.405294677192,1458.1853342327943,
	1457.9691479675848,1457.7567369485264,1457.5480947086305,1457.343207669515,1457.1420555945012,
	1456.944612066678,1456.7508449794273,1456.560717033194,1456.3741862336683,1456.191206381927,
	1456.011727552879,1455.835696558485,1455.6630573913494,1455.4937516462983,1455.3277189165663,
	1455.1648971667962,1455.0052230783183,1454.848632368267,1454.6950600821772,1454.5444408619617,
	1454.3967091866211,1454.251799591487,1454.1096468616743,1453.970186205825,1453.833353409815,
	1453.6990849679175,1453.5673182016133,1453.437991357041,1453.311043691348,1453.1864155429103,
	1453.0640483901698,1452.9438848987459,1452.8258689596526,1452.7099457170807,1452.596061588139,
	1452.4841642763547,1452.3742027781525,1452.2661273838128,1452.1598896735688,1452.0554425098055,
	1451.95274002453,1451.8517376051975,1451.7523918763434,1451.6546606798274,1451.5585030536329,
	1451.4638792070468,1451.3707504980166,1451.2790794052326,1451.1888295040822,1451.099965437478,
	1451.0124528912993,1450.926258563667,1450.8413501394707,1450.757696263903,1450.6752665123647,
	1450.5940313649999,1450.5139621806873,1450.4350311694604,1450.3572113669854,1450.280476609267,
	1450.2048015080231,1450.1301614257764,1450.056532453164,1449.9838913839899,1449.9122156949063,
	1449.8414835219503,1449.7716736396744,1449.7027654410351,1449.634738915583,1449.5675746319002,
	1449.5012537176538,1449.4357578425945,1449.3710691982124,1449.3071704829256,1449.2440448855743,
	1449.1816760679349,1449.1200481498518,1449.0591456943755,1448.998953693658,1448.9394575547242,
	1448.8806430850614,1448.8224964810136,1448.7650043153178,1448.7081535224004,1448.6519313894357,
	1448.596325545524,1448.5413239465345,1448.4869148694543,1448.4330868997129,1448.3798289225615,
	1448.3271301103787,1448.274979919125,1448.223368074357,1448.1722845665988,1448.1217196398552,
	1448.0716637853393,1448.0221077348685,1447.9730424514933,1447.9244591231181,1447.876349156637,
	1447.828704169424,1447.7815159849354,1447.7347766250962,1447.6884783029027,1447.6426134230035,
	1447.5971745676022,1447.5521544966655,1447.507546141009,1447.463342598606,1447.4195371267185,
	1447.3761231406286,1447.3330942068308,1447.2904440398786,1447.2481664981233,1447.2062555784626,
	1447.1647054136686,1447.1235102673108,1447.0826645332538,1447.0421627259025,1447.001999484035,
	1446.9621695616484,1446.9226678279897,1446.8834892639632,1446.8446289580145,1446.8060821030563,
	1446.7678439959457,1446.7299100322093,1446.69227570407,1446.6549365990015,1446.6178883961302,
	1446.5811268629664,1446.5446478562094,1446.5084473156278,1446.4725212650696,1446.4368658073745,
	1446.4014771248196,1446.3663514765337,1446.3314851952375,1446.2968746871259,1446.2625164285628,
	1446.2284069646385,1446.1945429095588,1446.1609209412775,1446.1275378021771,1446.094390298966,
	1446.0614752958686,1446.0287897195017,1445.9963305531926,1445.9640948366732,1445.9320796670017,
	1445.9002821920267,1445.8686996147749,1445.837329189337,1445.806168218102,1445.7752140543269,
	1445.74446409926,1445.7139158005389,1445.6835666514567,1445.653414189965,1445.6234559965753,
	1445.5936896971116,1445.5641129569995,1445.5347234835112,1445.5055190223327,1445.4764973599492,
	1445.4476563194235,1445.418993761474,1445.3905075831947,1445.3621957197017,1445.3340561367343,
	1445.3060868369298,1445.278285855184,1445.2506512614505,1445.2231811526715,1445.195873662993,
	1445.1687269521003,1445.1417392126655,1445.1149086658518,1445.088233561559,1445.0617121778146,
	1445.03534281938,1445.0091238199618,1444.9830535384287,1444.9571303598589,1444.9313526934113,
	1444.9057189742414,1444.8802276621482,1444.854877239812,1444.8296662147661,1444.8045931179727,
	1444.7796564975943,1444.7548549303424,1444.7301870110941,1444.705651356623,1444.6812466047115,
	1444.6569714127938,1444.6328244582432,1444.6088044393216,1444.5849100718679,1444.561140092773,
	1444.537493254045,1444.5139683279594,1444.4905641050657,1444.4672793915859,1444.444113012861,
	1444.421063808604,1444.3981306390501,1444.3753123755232,1444.3526079082042,1444.3300161426828,
	1444.3075360000087,1444.2851664143668,1444.2629063376664,1444.2407547341918,1444.2187105822811,
	1444.1967728772509,1444.1749406237802,1444.1532128427907,1444.1315885676468,1444.1100668459935,
	1444.0886467369821,1444.0673273114487,1444.0461076544086,1444.0249868632122,1444.0039640446098,
	1443.983038320227,1443.9622088198707,1443.9414746893638,1443.9208350795252,1443.9002891572773,
	1443.8798360983744,1443.8594750894133,1443.8392053260875,1443.81902601602,1443.7989363768668,
	1443.7789356351664,1443.7590230270803,1443.73919779886,1443.7194592085045,1443.6998065177158,
	1443.680239002986,1443.6607559453055,1443.6413566388085,1443.6220403831517,1443.6028064856473,
	1443.5836542663617,1443.5645830503777,1443.5455921712296,1443.526680971127,1443.5078487979492,
	1443.489095013707,1443.4704189793342,1443.4518200704063,1443.4332976641797,1443.4148511508336,
	1443.396479924031,1443.3781833850198,1443.359960943853,1443.3418120137455,1443.3237360196574,
	1443.3057323872547,1443.287800555004,1443.26993996486,1443.2521500633418,1443.2344303051561,
	1443.2167801518349,1443.1991990706504,1443.1816865326828,1443.1642420176152,1443.1468650111676,
	1443.129555001062,1443.1123114851507,1443.0951339643614,1443.0780219457297,1443.0609749412688,
	1443.043992468233,1443.0270740510348,1443.0102192167278,1442.993427498019,1442.9766984345595,
	1442.9600315682242,1442.943426448815,1442.9268826268465,1442.910399662116,1442.8939771151881,
	1442.8776145552001,1442.861311551998,1442.8450676817263,1442.828882526387,1442.8127556689453,
	1442.7966866994161,1442.780675210753,1442.7647208027652,1442.7488230745248,1442.7329816323056,
	1442.7171960867129,1442.7014660505665,1442.6857911435939,1442.670170986449,1442.6546052038175,
	1442.639093425991,1442.6236352845506,1442.6082304191318,1442.592878465222,1442.577579070609,
	1442.5623318827388,1442.5471365507526,1442.5319927263004,1442.5169000727853,1442.501858248575,
	1442.486866917656,1442.4719257476825,1442.4570344083809,1442.442192576424,1442.427399928608,
	1442.4126561420287,1442.3979609033083,1442.3833138968196,1442.3687148130934,1442.354163343065,
	1442.3396591849835,1442.3252020329328,1442.3107915914409,1442.2964275594845,1442.2821096465702,
	1442.2678375636926,1442.253611020463,1442.2394297303115,1442.2252934127564,1442.211201786595,
	1442.1971545744311,1442.1831515009408,1442.1691922934317,1442.1552766821064,1442.1414043998182,
	1442.1275751803828,1442.1137887631492,1442.1000448858142,1442.086343288377,1442.0726837186423,
	1442.0590659224172,1442.0454896465474,1442.031954643828,1442.018460666235,1442.0050074722033,
	1441.991594815581,1441.9782224555158,1441.9648901568178,1441.9515976825467,1441.9383447962384,
	1441.925131269766,1441.9119568697906,1441.8988213699063,1441.8857245419133,1441.8726661639232,
	1441.85964601417,1441.8466638698153,1441.833719513983,1441.8208127285166,1441.807943301901,
	1441.7951110180438,1441.7823156661866,1441.7695570371855,1441.7568349252367,1441.7441491219222,
	1441.7314994240912,1441.7188856290802,1441.7063075356496,1441.6937649462504,1441.6812576621473,
	1441.668785486088,1441.6563482256188,1441.6439456886656,1441.6315776802935,1441.6192440156015,
	1441.6069445044284,1441.5946789604557,1441.582447198655,1441.5702490353929,1441.5580842894958,
	1441.5459527793519,1441.5338543242813,1441.5217887498225,1441.5097558782431,1441.497755535129,
	1441.4857875456182,1441.473851738205,1441.461947943348,1441.4500759888097,1441.438235708904,
	1441.4264269360522,1441.4146495052669,1441.4029032512215,1441.3911880120802,1441.3795036261558,
	1441.3678499314913,1441.3562267713887,1441.344633984928,1441.3330714165822,1441.3215389124641,
	1441.310036316126,1441.2985634742806,1441.2871202357953,1441.2757064509576,1441.2643219667432,
	1441.2529666374428,1441.2416403129673,1441.2303428495134,1441.2190741002591,1441.2078339192954,
	1441.1966221693015,1441.185438702937,1441.1742833795988,1441.1631560591848,1441.15205660743,
	1441.140984879946,1441.1299407447013,1441.1189240610142,1441.107934697602,1441.0969725202694,
	1441.0860373938622,1441.0751291888064,1441.0642477716003,1441.0533930152783,1441.0425647881311,
	1441.0317629613382,1441.020987409131,1441.0102380061503,1440.9995146239112,1440.9888171417067,
	1440.9781454317024,1440.9674993717274,1440.9568788413517,1440.9462837199142,1440.9357138841954,
	1440.9251692202422,1440.9146496012743,1440.904154917199,1440.8936850470566,1440.8832398753973,
	1440.8728192862409,1440.8624231672104,1440.8520514041736,1440.8417038807936,1440.8313804877278,
	1440.8210811146819,1440.810805647649,1440.8005539773721,1440.7903259982766,1440.7801215988354,
	1440.7699406707738,1440.7597831111798,1440.7496488072297,1440.739537658777,1440.7294495614292,
	1440.7193844072729,1440.7093420941296,1440.6993225233011,1440.6893255857033,1440.6793511840601,
	1440.6693992198068,1440.6594695884141,1440.6495621948504,1440.639676935084,1440.6298137171284,
	1440.6199724392284,1440.6101530075252,1440.6003553221508,1440.5905792917622,1440.5808248182695,
	1440.5710918096295,1440.561380170253,1440.551689810326,1440.5420206351416,1440.5323725515716,
	1440.522745471149,1440.5131393024906,1440.5035539550324,1440.4939893369508,1440.4844453625974,
	1440.4749219433352,1440.4654189896244,1440.4559364180036,1440.446474136745,1440.4370320626876,
	1440.4276101108255,1440.4182081925073,1440.4088262276096,1440.3994641291024,1440.390121814229,
	1440.3807992002435,1440.3714962044737,1440.3622127446852,1440.3529487424566,1440.34370411311,
	1440.3344787793717,1440.3252726549915,1440.316085670645,1440.3069177383027,1440.297768783992,
	1440.2886387300782,1440.2795274969826,1440.2704350076774,1440.2613611864665,1440.2523059573712,
	1440.2432692475866,1440.234250974891,1440.2252510695762,1440.2162694583667,1440.2073060637997,
	1440.198360816438,1440.189433640768,1440.1805244616344,1440.171633213284,1440.162759821006,
	1440.1539042116462,1440.1450663169828,1440.1362460661724,1440.1274433870528,1440.1186582122375,
	1440.10989047684,1440.1011401022004,1440.0924070282492,1440.0836911822262,1440.0749924985982,
	1440.066310912492,1440.0576463534906,1440.0489987588328,1440.0403680554475,1440.0317541865238,
	1440.0231570818123,1440.0145766763212,1440.00601290802,1439.997465711825,1439.9889350204066,
	1439.980420778619,1439.9719229169073,1439.9634413768179,1439.9549760897103,1439.9465270004202,
	1439.9380940405094,1439.9296771571082,1439.9212762816508,1439.9128913580496,1439.9045223268222,
	1439.8961691230893,1439.887831692864,1439.8795099738154,1439.871203906086,1439.8629134340442,
	1439.8546384995782,1439.8463790435624,1439.8381350063753,1439.8299063337129,1439.8216929676253,
	1439.8134948525314,1439.8053119289245,1439.7971441462744,1439.7889914416949,1439.7808537659023,
	1439.7727310617647,1439.7646232724499,1439.7565303480305,1439.7484522297184,1439.7403888665683,
	1439.7323402042541,1439.7243061887123,1439.7162867668324,1439.7082818858876,1439.7002914959228,
	1439.6923155424515,1439.684353972226,1439.676406736235,1439.6684737823716,1439.6605550585257,
	1439.652650515601,1439.6447601044053,1439.6368837689233,1439.6290214654155,1439.621173139441,
	1439.6133387452899,1439.605518230546,1439.5977115469689,1439.5899186515978,1439.5821394858385,
	1439.5743740061682,1439.5666221706063,1439.5588839215195,1439.551159216406,1439.5434480100923,
	1439.5357502534198,1439.5280658964734,1439.52039489817,1439.5127372074094,1439.5050927843456,
	1439.4974615809324,1439.4898435461766,1439.4822386408634,1439.4746468182875,1439.4670680321365,
	1439.459502240941,1439.4519493991845,1439.4444094586922,1439.4368823806772,1439.429368119192,
	1439.4218666323973,1439.4143778769596,1439.4069018086943,1439.399438378898,1439.3919875579325,
	1439.3845492960822,1439.3771235503107,1439.3697102805206,1439.3623094439902,1439.3549209996788,
	1439.3475449085824,1439.3401811218002,1439.3328296068528,1439.325490322487,1439.3181632217388,
	1439.3108482695052,1439.3035454245796,1439.2962546452736,1439.2889758973904,1439.2817091329546,
	1439.274454321612,1439.2672114185332,1439.2599803816381,1439.252761179588,1439.2455537702178,
	1439.23835811447,1439.2311741794697,1439.224001920743,1439.216841299929,1439.209692285847,
	1439.2025548357403,1439.1954289139358,1439.188314487012,1439.1812115114683,1439.1741199504231,
	1439.1670397751798,1439.1599709398618,1439.1529134144932,1439.1458671633904,1439.138832147016,
	1439.1318083326764,1439.1247956789582,1439.1177941605142,1439.1108037351341,1439.1038243670966,
	1439.0968560262768,1439.0898986714524,1439.0829522750782,1439.0760167975538,1439.069092207763,
	1439.0621784721882,1439.0552755551662,1439.0483834190766,1439.0415020374749,1439.0346313727357,
	1439.027771394392,1439.0209220661493,1439.0140833549917,1439.0072552298877,1439.0004376615454,
	1438.993630606955,1438.9868340464345,1438.980047939565,1438.973272258562,1438.9665069680548,
	1438.9597520342516,1438.9530074327267,1438.9462731270141,1438.9395490858894,1438.9328352792952,
	1438.9261316761392,1438.9194382456403,1438.9127549563475,1438.9060817797274,1438.8994186801349,
	1438.8927656343549,1438.8861226073602,1438.879489568513,1438.8728664896707,1438.8662533414786,
	1438.8596500933613,1438.8530567142936,1438.8464731777253,1438.839899452402,1438.8333355092636,
	1438.8267813235777,1438.8202368593331,1438.813702089024,1438.8071769888643,1438.8006615265829,
	1438.7941556739972,1438.7876594034822,1438.78117268922,1438.7746954992483,1438.7682278070165,
	1438.7617695816323,1438.7553208041697,1438.7488814407857,1438.7424514600448,1438.7360308450175,
	1438.7296195593938,1438.723217581115,1438.7168248826374,1438.7104414345679,1438.704067210453,
	1438.6977021916507,1438.6913463367703,1438.6849996313242,1438.6786620437965,1438.672333554299,
	1438.6660141269408,1438.6597037440508,1438.6534023750953,1438.6471099975029,1438.6408265820494,
	1438.6345521080204,1438.6282865441062,1438.6220298708438,1438.6157820626272,1438.6095430872392,
	1438.60331292924,1438.5970915572912,1438.5908789503,1438.5846750769615,1438.5784799232042,
	1438.5722934578575,1438.5661156531494,1438.5599464949912,1438.5537859523088,1438.547634001304,
	1438.5414906234325,1438.5353557859457,1438.5292294708347,1438.5231116527293,1438.517002310789,
	1438.5109014233599,1438.5048089588022,1438.4987248996865,1438.4926492219781,1438.4865818989329,
	1438.4805229153535,1438.4744722388834,1438.4684298552763,1438.462395739927,1438.4563698655231,
	1438.4503522164382,1438.4443427653634,1438.4383414878148,1438.4323483630756,1438.4263633795695,
	1438.4203864998633,1438.4144177142723,1438.4084569914874,1438.402504310943,1438.3965596589742,
	1438.3906230043583,1438.3846943316134,1438.378773615645,1438.372860841517,1438.366955979309,
	1438.3610590188237,1438.3551699214663,1438.3492886835165,1438.3434152759557,1438.3375496789097,
	1438.3316918734145,1438.325841839886,1438.319999553748,1438.3141649926906,1438.3083381393833,
	1438.3025189771229,1438.2967074838953,1438.290903636059,1438.285107412135,1438.2793187994441,
	1438.27353777109,1438.2677643126474,1438.2619984003725,1438.256240014138,1438.250489141316,
	1438.244745751925,1438.2390098326252,1438.2332813652965,1438.22756032679,1438.221846700702,
	1438.2161404614958,1438.210441600423,1438.2047500902415,1438.1990659151604,1438.1933890596326,
	1438.1877194963151,1438.18205721566,1438.1764021911108,1438.170754408363,1438.1651138474408,
	1438.1594804885722,1438.1538543212046,1438.1482353185731,1438.1426234637972,1438.1370187376153,
	1438.1314211302347,1438.1258306164457,1438.1202471753688,1438.1146707987837,1438.1091014596657,
	1438.1035391431687,1438.0979838318888,1438.0924355100042,1438.0868941550493,1438.0813597607691,
	1438.0758322941094,1438.0703117477024,1438.0647981021646,1438.0592913419207,1438.0537914454064,
	1438.0482984002444,1438.042812183801,1438.0373327816972,1438.03186018377,1438.0263943641403,
	1438.0209353049008,1438.0154829980884,1438.010037420255,1438.0045985553575,1437.9991663948852,
	1437.9937409116249,1437.9883220947897,1437.9829099221517,1437.9775043834093,1437.9721054643219,
	1437.966713140982,1437.9613274056892,1437.9559482341604,1437.9505756160636,1437.945209532591,
	1437.9398499680913,1437.9344969081353,1437.9291503398788,1437.9238102379973,1437.918476595,
	1437.9131493963403,1437.9078286180945,1437.9025142523992,1437.8972062807645,1437.8919046868507,
	1437.8866094611863,1437.881320579836,1437.8760380317422,1437.870761806506,1437.8654918767083,
	1437.8602282425666,1437.8549708770986,1437.8497197705428,1437.8444749054313,1437.8392362706572,
	1437.8340038558322,1437.8287776268494,1437.8235575894907,1437.8183437220691,1437.8131360058312,
	1437.807934434554,1437.8027389830654,1437.797549642482,1437.792366403783,1437.7871892463272,
	1437.7820181579086,1437.7768531247582,1437.7716941282038,1437.7665411554974,1437.7613941983436,
	1437.7562532387146,1437.7511182653102,1437.745989257104,1437.7408662053624,1437.7357490991487,
	1437.7306379148254,1437.7255326513782,1437.7204332843125,1437.715339806178,1437.7102522035805,
	1437.7051704609348,1437.7000945616599,1437.6950244978316,1437.6899602513386,1437.6849018144048,
	1437.679849163746,1437.6748023005991,1437.6697611980942,1437.6647258523105,1437.659696246879,
	1437.654672362599,1437.6496542002828,1437.644641733718,1437.6396349556421,1437.6346338565825,
	1437.6296384169218,1437.6246486264013,1437.6196644725435,1437.6146859383236,1437.609713021899,
	1437.604745697675,1437.5997839677634,1437.5948278052297,1437.589877206298,1437.5849321518199,
	1437.57999263576,1437.575058642442,1437.5701301609406,1437.56520718107,1437.5602896813803,
	1437.5553776562072,1437.550471098267,1437.5455699873687,1437.5406743141248,1437.5357840653235,
	1437.5308992323173,1437.5260197995865,1437.5211457546638,1437.5162770883878,1437.5114137896471,
	1437.5065558489177,1437.501703241401,1437.496855971131,1437.492014009849,1437.487177369533,
	1437.4823460167854,1437.4775199462752,1437.4726991557795,1437.4678836189396,1437.4630733317058,
	1437.4582682824418,1437.4534684609928,1437.4486738588362,1437.4438844515992,1437.4391002419466,
	1437.434321210236,1437.4295473528007,1437.4247786500437,1437.4200150952233,1437.415256674374,
	1437.410503386222,1437.405755206492,1437.4010121295933,1437.396274147944,1437.3915412439635,
	1437.386813409318,1437.3820906381604,1437.3773729149618,1437.3726602273182,1437.3679525697514,
	1437.363249926228,1437.3585522869785,1437.353859643382,1437.349171987714,1437.3444892984346,
	1437.3398115788516,1437.3351388077594,1437.330470978717,1437.3258080830522,1437.321150108184,
	1437.3164970442797,1437.3118488774028,1437.307205608088,1437.302567212765,1437.297933682329,
	1437.2933050197566,1437.2886812035943,1437.284062227361,1437.279448077429,1437.2748387468916,
	1437.2702342246437,1437.2656345007313,1437.26103956512,1437.2564494069786,1437.2518640192359,
	1437.2472833882678,1437.242707508512,1437.2381363637292,1437.2335699513872,1437.229008254368,
	1437.2244512723214,1437.2198989838037,1437.2153513862843,1437.210808473087,1437.2062702276594,
	1437.2017366426142,1437.1972077114233,1437.1926834196033,1437.1881637586657,1437.1836487243875,
	1437.1791383044256,1437.1746324803848,1437.1701312589905,1437.1656346208135,1437.1611425577498,
	1437.1566550595671,1437.1521721182487,1437.1476937278528,1437.143219872437,1437.1387505490454,
	1437.1342857451036,1437.129825453281,1437.1253696615543,1437.120918363548,1437.1164715477637,
	1437.11202920817,1437.107591331311,1437.103157916372,1437.0987289455645,1437.0943044130497,
	1437.0898843124942,1437.0854686299465,1437.0810573629526,1437.0766504974436,1437.072248026399,
	1437.0678499376252,1437.063456227179,1437.0590668888226,1437.0546819056997,1437.0503012759955,
	1437.0459249886173,1437.0415530375747,1437.0371854078783,1437.0328220920933,1437.0284630828023,
	1437.0241083775288,1437.0197579626392,1437.0154118281139,1437.0110699695572,1437.0067323725339,
	1437.0023990371565
	}},
	{ // Ri = 250k
	-10,10,100,2001, {
	2062.404728886117,2061.0456739423234,2059.689219283372,2058.3353597923924,2056.9840903656527,
	2055.6354059126165,2054.289301355876,2052.945771631175,2051.6048116871434,2050.2664164854777,
	2048.930581000515,2047.5973002200255,2046.2665691441603,2044.938382786054,2043.612736171592,
	2042.2896243394819,2040.969042340888,2039.6509852398772,2038.3354481128256,2037.0224260488576,
	2035.7119141495236,2034.40390752884,2033.098401313393,2031.795390641977,2030.4948706657337,
	2029.1968365481641,2027.9012834652174,2026.6082066046595,2025.3176011668054,2024.0294623638936,
	2022.7437854202608,2021.4605655725263,2020.1797980690553,2018.901478170413,2017.6256011488072,
	2016.3521622887445,2015.0811568861438,2013.8125802492013,2012.5464276973867,2011.2826945624972,
	2010.0213761874757,2008.7624679272967,2007.5059651482334,2006.2518632285721,2005.00015755777,
	2003.7508435367959,2002.5039165783885,2001.259372106456,2000.0172055562,1998.7774123745553,
	1997.5399880194536,1996.3049279600796,1995.0722276771646,1993.8418826622233,1992.613888418201,
	1991.38824045907,1990.1649343099975,1988.9439655070241,1987.7253295972578,1986.5090221388743,
	1985.2950387008045,1984.0833748629852,1982.874026216185,1981.6669883621153,1980.462256912952,
	1979.2598274920967,1978.0596957330126,1976.8618572805528,1975.6663077897729,1974.47304292636,
	1973.2820583666032,1972.093349797388,1970.9069129160746,1969.7227434303495,1968.5408370585994,
	1967.3611895292565,1966.1837965811822,1965.0086539639506,1963.835757436754,1962.665102769493,
	1961.4966857422298,1960.3305021449673,1959.1665477780587,1958.0048184518034,1956.8453099868057,
	1955.6880182134344,1954.5329389721685,1953.3800681134378,1952.2294014976103,1951.0809349950075,
	1949.9346644856664,1948.7905858595739,1947.6486950164197,1946.5089878657363,1945.3714603265962,
	1944.2361083279127,1943.102927808477,1941.9719147161206,1940.8430650087782,1939.7163746536905,
	1938.5918396275513,1937.469455916948,1936.349219517358,1935.2311264340517,1934.1151726816777,
	1933.001354284003,1931.8896672742428,1930.7801076950718,1929.6726715981358,1928.5673550444085,
	1927.4641541040376,1926.363064856472,1925.2640833900346,1924.1672058023971,1923.0724281999856,
	1921.9797466985212,1920.889157422575,1919.8006565058113,1918.7142400905839,1917.6299043283857,
	1916.5476453795343,1915.4674594130402,1914.389342606775,1913.31329114749,1912.2393012306077,
	1911.1673690601247,1910.0974908489225,1909.0296628184117,1907.9638811986613,1906.900142228179,
	1905.83844215425,1904.7787772326171,1903.7211437273215,1902.6655379110284,1901.611956065009,
	1900.560394478394,1899.5108494493045,1898.4633172836634,1897.4177942960841,1896.3742768093261,
	1895.3327611542547,1894.2932436701349,1893.2557207043358,1892.2201886123742,1891.1866437578262,
	1890.155082512595,1889.1255012564068,1888.097896377042,1887.072264270432,1886.048601340273,
	1885.0269039984562,1884.0071686645745,1882.9893917661298,1881.9735697385747,1880.9596990252446,
	1879.9477760768978,1878.937797352689,1877.9297593188398,1876.9236584497355,1875.9194912271323,
	1874.917254140811,1873.9169436878155,1872.9185563729477,1871.922088708615,1870.9275372146615,
	1869.9348984183305,1868.9441688546751,1867.9553450659303,1866.9684236018077,1865.983401019353,
	1865.00027388314,1864.0190387649848,1863.0396922439431,1862.0622309064402,1861.086651346116,
	1860.1129501639323,1859.1411239678434,1858.1711693730479,1857.2030830020256,1856.2368614841996,
	1855.2725014561286,1854.3099995613895,1853.3493524507674,1852.390556781737,1851.4336092189817,
	1850.4785064341047,1849.5252451054985,1848.5738219186167,1847.6242335655418,1846.6764767455716,
	1845.7305481643805,1844.7864445346734,1843.8441625758787,1842.903699014149,1841.965050582184,
	1841.0282140196707,1840.093186072679,1839.1599634939287,1838.2285430428537,1837.298921485377,
	1836.3710955938889,1835.4450621474743,1834.5208179315564,1833.598359738127,1832.6776843654252,
	1831.7587886182046,1830.8416693077595,1829.9263232515164,1829.0127472731922,1828.1009382031482,
	1827.1908928776068,1826.282608139258,1825.3760808369566,1824.471307825842,1823.5682859672186,
	1822.6670121282907,1821.7674831827874,1820.8696960102259,1819.9736474961692,1819.0793345324723,
	1818.1867540168807,1817.295902852974,1816.4067779506652,1815.519376225405,1814.6336945988428,
	1813.7497299983277,1812.8674793572445,1811.9869396146505,1811.108107715643,1810.2309806108449,
	1809.355555256811,1808.481828615794,1807.609797655758,1806.7394593503827,1805.8708106788954,
	1805.0038486262606,1804.1385701832287,1803.2749723456427,1802.4130521155055,1801.5528064998773,
	1800.6942325116731,1799.8373271690361,1798.982087495769,1798.1285105210045,1797.276593279446,
	1796.4263328109064,1795.57772616079,1794.7307703798288,1793.8854625240608,1793.041799654616,
	1792.1997788382319,1791.35939714678,1790.5206516570665,1789.6835394514922,1788.8480576174857,
	1788.014203247501,1787.1819734393628,1786.3513652957572,1785.5223759245844,1784.6950024387447,
	1783.8692419561878,1783.0450915999515,1782.2225484978833,1781.4016097829576,1780.5822725928817,
	1779.7645340705499,1778.9483913634936,1778.133841624253,1777.3208820100851,1776.5095096833131,
	1775.699721810735,1774.8915155640527,1774.0848881199047,1773.279836659347,1772.4763583682272,
	1771.6744504371934,1770.8741100614036,1770.0753344407767,1769.2781207797914,1768.4824662873853,
	1767.6883681771833,1766.8958236674675,1766.1048299806555,1765.3153843440293,1764.527483989207,
	1763.741126152284,1762.9563080736011,1762.1730269982259,1761.391280175246,1760.6110648584554,
	1759.8323783057133,1759.055217779219,1758.279580545659,1757.5054638757194,1756.7328650445652,
	1755.9617813313316,1755.192210019591,1754.4241483969674,1753.6575937552354,1752.892543390343,
	1752.1289946022412,1751.3669446950973,1750.6063909771303,1749.8473307605184,1749.0897613615002,
	1748.333680100285,1747.5790843010852,1746.825971292033,1746.074338405207,1745.3241829766373,
	1744.5755023461793,1743.8282938575119,1743.0825548582316,1742.3382826997922,1741.5954747373437,
	1740.8541283298325,1740.1142408399228,1739.375809634189,1738.6388320826863,1737.90330555931,
	1737.1692274414856,1736.4365951104594,1735.7054059509258,1734.975657351343,1734.2473467035447,
	1733.5204714031381,1732.7950288491272,1732.0710164441066,1731.3484315939943,1730.6272717085237,
	1729.9075342005087,1729.18921648638,1728.4723159859323,1727.7568301222825,1727.0427563221422,
	1726.3300920153529,1725.618834635019,1724.9089816177427,1724.2005304033287,1723.4934784347581,
	1722.7878231583413,1722.0835620236255,1721.3806924832734,1720.6792119930863,1719.979118012239,
	1719.2804080026813,1718.5830794297417,1717.8871297617923,1717.192556470255,1716.499357029552,
	1715.8075289171954,1715.1170696136282,1714.4279766023137,1713.7402473697728,1713.0538794052372,
	1712.368870201143,1711.6852172526424,1711.002918057725,1710.321970117432,1709.6423709354594,
	1708.964118018412,1708.2872088756533,1707.6116410195204,1706.9374119646839,1706.264519228931,
	1705.5929603326074,1704.9227327986575,1704.2538341530308,1703.5862619239667,1702.9200136424479,
	1702.2550868422609,1701.5914790595064,1700.9291878329489,1700.2682107039882,1699.6085452165353,
	1698.9501889168816,1698.2931393540334,1697.63739407915,1696.9829506461729,1696.329806611248,
	1695.6779595331006,1695.0274069726026,1694.3781464932335,1693.7301756607537,1693.0834920431275,
	1692.438093210724,1691.7939767363905,1691.1511401948292,1690.5095811633716,1689.8692972213444,
	1689.2302859504164,1688.5925449343079,1687.956071758997,1687.3208640127366,1686.6869192856254,
	1686.0542351701038,1685.4228092605579,1684.7926391535716,1684.163722447686,1683.53605674346,
	1682.9096396434602,1682.2844687523632,1681.660541676812,1681.0378560251177,1680.4164094078653,
	1679.7961994373702,1679.1772237278842,1678.5594798955788,1677.9429655583835,1677.3276783361111,
	1676.7136158503931,1676.100775724672,1675.4891555841,1674.8787530556754,1674.269565768011,
	1673.6615913515834,1673.0548274384694,1672.4492716624454,1671.844921658979,1671.2417750650138,
	1670.6398295194824,1670.0390826625285,1669.4395321360048,1668.84117558343,1668.244010649773,
	1667.6480349815417,1667.0532462267488,1666.4596420348448,1665.8672200569385,1665.2759779452547,
	1664.6859133538012,1664.0970239378184,1663.5093073538553,1662.9227612600157,1662.337383315615,
	1661.753171181343,1661.1701225192978,1660.5882349926776,1660.0075062662227,1659.427934005667,
	1658.8495158782046,1658.272249551943,1657.6961326966036,1657.1211629828267,1656.5473380824171,
	1655.9746556684117,1655.4031134149466,1654.832708997248,1654.2634400916356,1653.6953043755184,
	1653.128299527375,1652.562423226638,1651.9976731539005,1651.4340469905908,1650.8715424191416,
	1650.3101571230277,1649.7498887866834,1649.1907350953218,1648.6326937351992,1648.075762393332,
	1647.5199387577868,1646.9652205172101,1646.4116053614157,1645.8590909807644,1645.307675066457,
	1644.7573553105901,1644.2081294058676,1643.659995045824,1643.112949924701,1642.566991737529,
	1642.022118179688,1641.4783269476827,1640.935615738432,1640.3939822493753,1639.8534241787745,
	1639.3139392254463,1638.7755250885546,1638.2381794682717,1637.7019000648743,1637.1666845793472,
	1636.6325307132531,1636.0994361683427,1635.5673986472484,1635.0364158528055,1634.5064854883078,
	1633.9776052574814,1633.4497728644205,1632.9229860136654,1632.397242410076,1631.8725397588207,
	1631.3488757655184,1630.826248135889,1630.3046545761536,1629.7840927927207,1629.2645604922316,
	1628.7460553815663,1628.228575167883,1627.712117558483,1627.1966802608922,1626.6822609827625,
	1626.1688574319655,1625.6564673164535,1625.145088344195,1624.634718223542,1624.1253546625983,
	1623.616995369791,1623.1096380534343,1622.6032804219105,1622.0979201836699,1621.593555047121,
	1621.0901827205125,1620.5878009123753,1620.0864073308446,1619.5859996841946,1619.0865756805747,
	1618.588133027849,1618.0906694341072,1617.594182606917,1617.0986702539435,1616.6041300825907,
	1616.1105598000227,1615.6179571132714,1615.1263197290996,1614.635645354049,1614.1459316944051,
	1613.6571764561209,1613.169377344935,1612.6825320662351,1612.1966383249714,1611.7116938260408,
	1611.2276962736264,1610.7446433718494,1610.2625328241431,1609.7813623338106,1609.3011296034867,
	1608.8218323355998,1608.3434682318043,1607.8660349936183,1607.3895303218678,1606.9139519168114,
	1606.439297478396,1605.9655647059096,1605.4927512979984,1605.0208549529061,1604.5498733680784,
	1604.079804240569,1603.610645266685,1603.14239414212,1602.6750485618322,1602.208606220263,
	1601.7430648110712,1601.278422027214,1600.8146755609364,1600.351823103685,1599.8898623463433,
	1599.428790978779,1598.9686066902616,1598.509307169178,1598.0508901031412,1597.5933531787857,
	1597.1366940821715,1596.680910498203,1596.226000111148,1595.771960604213,1595.3187896597947,
	1594.8664849593251,1594.4150441831862,1593.9644650110913,1593.5147451214466,1593.0658821918432,
	1592.6178738988824,1592.1707179180773,1591.7244119239983,1591.2789535899647,1590.8343405885628,
	1590.3905705909401,1589.9476412673844,1589.5055502869704,1589.0642953177073,1588.6238740263748,
	1588.1842840787158,1587.74552313924,1587.3075888711853,1586.8704789367573,1586.434190996753,
	1585.9987227109368,1585.5640717376398,1585.1302357341322,1584.697212356209,1584.26499925845,
	1583.8335940941392,1583.4029945153118,1582.9731981725686,1582.5442027151234,1582.1160057908844,
	1581.6886050464836,1581.2619981269122,1580.8361826759528,1580.4111563359859,1579.9869167478125,
	1579.5634615507836,1579.1407883828772,1578.7188948806202,1578.2977786789068,1577.8774374112434,
	1577.4578687094954,1577.0390702041514,1576.6210395239866,1576.203774296289,1575.7872721466888,
	1575.3715306994234,1574.9565475768968,1574.54232039999,1574.1288467879583,1573.7161243582877,
	1573.3041507270534,1572.8929235083465,1572.4824403148305,1572.0726987572216,1571.663696444822,
	1571.2554309848194,1570.8478999829417,1570.4411010430892,1570.035031767362,1569.6296897560394,
	1569.2250726077102,1568.8211779190553,1568.4180032848676,1568.0155462982611,1567.6138045504458,
	1567.212775630669,1566.81245712646,1566.412846623236,1566.013941704718,1565.61573995254,
	1565.2182389465504,1564.8214362645735,1564.425329482492,1564.0299161741693,1563.6351939115368,
	1563.2411602645425,1562.8478128010106,1562.4551490869374,1562.0631666861334,1561.6718631604085,
	1561.281236069441,1560.891282970925,1560.5020014205259,1560.1133889716095,1559.725443175598,
	1559.3381615816586,1558.9515417370583,1558.56558118664,1558.1802774732844,1557.7956281374554,
	1557.4116307177978,1557.0282827504843,1556.6455817694512,1556.263525306661,1555.8821108915781,
	1555.5013360516327,1555.1211983118476,1554.7416951950386,1554.3628242217226,1553.9845829101484,
	1553.6069687762547,1553.2299793336012,1552.853612093641,1552.477864565074,1552.1027342546608,
	1551.7282186666187,1551.3543153027829,1550.9810216625976,1550.6083352432368,1550.23625353921,
	1549.8647740428894,1549.4938942441017,1549.123611630111,1548.7539236860018,1548.3848278940604,
	1548.0163217344696,1547.648402684498,1547.2810682193413,1546.9143158113918,1546.5481429306876,
	1546.1825470445715,1545.8175256180537,1545.4530761134324,1545.089195990515,1544.725882706473,
	1544.3631337161037,1544.00094647122,1543.6393184213957,1543.2782470134478,1542.91772969155,
	1542.5577638972893,1542.1983470695204,1541.8394766446336,1541.481150056071,1541.1233647348336,
	1540.766118109174,1540.4094076045708,1540.053230643862,1539.697584647189,1539.342467031981,
	1538.9878752127681,1538.6338066015542,1538.280258607445,1537.927228636881,1537.5747140933959,
	1537.222712377883,1536.8712208883119,1536.5202370199224,1536.1697581651617,1535.819781713513,
	1535.4703050518604,1535.1213255640491,1534.7728406311337,1534.4248476313849,1534.0773439400934,
	1533.7303269297229,1533.3837939697937,1533.03774242703,1532.6921696651787,1532.3470730450647,
	1532.002449924663,1531.6582976589289,1531.314613599938,1530.9713950967216,1530.628639495504,
	1530.2863441393827,1529.9445063686596,1529.6031235204307,1529.2621929289976,1528.9217119255609,
	1528.5816778382807,1528.2420879923575,1527.902939709962,1527.5642303102686,1527.225957109262,
	1526.8881174199994,1526.5507085524862,1526.2137278135858,1525.8771725071192,1525.5410399337754,
	1525.2053273913623,1524.8700321742988,1524.5351515740283,1524.200682878828,1523.86662337401,
	1523.5329703415423,1523.1997210603952,1522.866872806304,1522.5344228519339,1522.2023684667258,
	1521.8707069169902,1521.539435465852,1521.2085513732357,1520.878051895846,1520.547934287283,
	1520.218195797811,1519.888833674636,1519.5598451616313,1519.23122749951,1518.9029779256518,
	1518.5750936742913,1518.2475719763727,1517.9204100596662,1517.5936051486,1517.2671544643042,
	1516.9410552247161,1516.6153046444822,1516.2898999349768,1515.9648383042015,1515.6401169569422,
	1515.3157330946794,1514.9916839155571,1514.6679666143716,1514.344578382716,1514.0215164086892,
	1513.6987778772705,1513.3763599699346,1513.0542598648583,1512.7324747369673,1512.4110017578223,
	1512.0898380954477,1511.768980914704,1511.4484273770784,1511.1281746406867,1510.808219860228,
	1510.4885601870121,1510.1691927691534,1509.850114751217,1509.5313232744893,1509.2128154768957,
	1508.8945884929424,1508.5766394538539,1508.2589654873357,1507.9415637178774,1507.6244312666117,
	1507.30756525116,1506.9909627858915,1506.6746209818443,1506.3585369467266,1506.0427077848558,
	1505.7271305973054,1505.4118024816628,1505.096720532426,1504.7818818407427,1504.4672834943867,
	1504.1529225779927,1503.838796172949,1503.5249013573284,1503.2112352062145,1502.89779479124,
	1502.5845771811655,1502.271579441484,1501.958798634871,1501.646231820704,1501.3338760554125,
	1501.0217283927154,1500.7097858832904,1500.3980455750439,1500.0865045132018,1499.7751597401666,
	1499.4640082959113,1499.1530472178747,1498.8422735410566,1498.5316842981385,1498.2212765197655,
	1497.9110472343873,1497.600993468653,1497.2911122473893,1496.981400593858,1496.6718555300902,
	1496.362474076708,1496.0532532535974,1495.7441900797062,1495.4352815737989,1495.1265247543092,
	1494.8179166402108,1494.5094542506004,1494.2011346058457,1493.8929547276985,1493.5849116396944,
	1493.277002367896,1492.969223941439,1492.661573392926,1492.3540477595814,1492.0466440835594,
	1491.7393594131668,1491.4321908037516,1491.1251353185783,1490.818190030149,1490.5113520214297,
	1490.2046183873993,1489.897986236565,1489.5914526923414,1489.2850148957034,1488.9786700066747,
	1488.6724152072431,1488.3662477034343,1488.0601647287278,1487.7541635471734,1487.4482414567492,
	1487.142395794131,1486.836623938191,1486.5309233159378,1486.225291407719,1485.9197257535407,
	1485.6142239599549,1485.3087837082717,1485.0034027629315,1484.6980789815698,1484.392810325993,
	1484.0875948743142,1483.7824308352392,1483.4773165630572,1483.1722505751518,1482.867231571982,
	1482.5622584583434,1482.2573303683052,1481.952446692677,1481.647607109965,1481.3428116208463,
	1481.038060587351,1480.7333547760466,1480.4286954067534,1480.1240842071904,1479.81952347341,
	1479.515016137753,1479.2105658440505,1478.9061770318467,1478.601855028964,1478.2976061545962,
	1477.9934378326807,1477.6893587173813,1477.385378829435,1477.0815097068153,1476.777764567422,
	1476.4741584861536,1476.1707085857063,1475.8674342412496,1475.5643572985207,1475.2615023049175,
	1474.9588967521079,1474.6565713288562,1474.3545601814355,1474.0529011793942,1473.7516361822384,
	1473.450811304479,1473.1504771714435,1472.8506891634383,1472.551507638723,1472.2529981304538,
	1471.955231509573,1471.6582841050465,1471.3622377745091,1471.0671799171828,1470.7732034208123,
	1470.4804065373894,1470.1888926803033,1469.8987701393485,1469.6101517113375,1469.3231542441004,
	1469.037898096698,1468.7545065186384,1468.47310495401,1468.1938202799765,1467.9167799895663,
	1467.6421113303447,1467.3699404154268,1467.1003913202305,1466.8335851819566,1466.5696393185808,
	1466.3086663821312,1466.0507735621868,1465.7960618537616,1465.5446254003139,1465.296550922918,
	1465.0519172421582,1464.8107948984655,1464.5732458732243,1464.339323409489,1464.1090719330018,
	1463.882527065581,1463.6597157268138,1463.4406563174314,1463.225358973484,1463.0138258836234,
	1462.8060516597445,1462.602023750408,1462.4017228882,1462.2051235614306,1462.0121945018711,
	1461.822899179708,1461.6371963006686,1461.4550402964544,1461.276381804936,1461.1011681353943,
	1460.9293437151384,1460.7608505129556,1460.5956284412232,1460.433615731009,1460.274749281703,
	1460.1189649842972,1459.966198018611,1459.8163831235165,1459.6694548439125,1459.5253477505096,
	1459.3839966399075,1459.2453367095218,1459.109303714179,1458.9758341019458,1458.8448651328838,
	1458.716334981609,1458.5901828230994,1458.4663489069437,1458.3447746165207,1458.225402518408,
	1458.1081764012806,1457.9930413054008,1457.879943543306,1457.7688307140622,1457.6596517105925,
	1457.5523567213081,1457.4468972268714,1457.343225991945,1457.2412970548603,1457.1410657124518,
	1457.0424885013813,1456.9455231805662,1456.8501287076483,1456.7562652168963,1456.6638939939846,
	1456.5729774507251,1456.4834790981708,1456.3953635202909,1456.3085963466638,1456.223144224244,
	1456.1389747900298,1456.056056644546,1455.974359322716,1455.8938532682905,1455.814509805878,
	1455.7363011147127,1455.6592002037958,1455.5831808847108,1455.5082177476897,1455.4342861365776,
	1455.361362126048,1455.2894224969211,1455.218444714634,1455.148406906207,1455.0792878401442,
	1455.0110669035407,1454.94372408488,1454.877239952083,1454.8115956334518,1454.7467728006295,
	1454.682753650568,1454.6195208872034,1454.5570577056758,1454.4953477769184,1454.4343752298669,
	1454.3741246394598,1454.3145810082935,1454.255729756577,1454.1975567060738,1454.14004806759,
	1454.0831904283687,1454.0269707402979,1453.9713763067837,1453.9163947736076,1453.8620141161857,
	1453.8082226297568,1453.7550089188944,1453.7023618867386,1453.650270727918,1453.5987249178502,
	1453.5477142032241,1453.4972285948418,1453.4472583584406,1453.3977940066197,1453.3488262938954,
	1453.3003462045326,1453.252344948631,1453.204813955197,1453.1577448644312,1453.1111295218166,
	1453.0649599722801,1453.0192284524153,1452.9739273870882,1452.9290493836686,1452.884587222967,
	1452.8405338608925,1452.7968824158788,1452.7536261690082,1452.7107585577896,1452.6682731714336,
	1452.6261637485725,1452.5844241673656,1452.543048448974,1452.502030747546,1452.4613653506901,
	1452.4210466711133,1452.3810692486672,1452.3414277413538,1452.3021169270569,1452.2631316960044,
	1452.2244670504897,1452.1861180988722,1452.148080057849,1452.110348243805,1452.0729180735184,
	1452.0357850605317,1451.998944812593,1451.9623930291298,1451.9261254980838,1451.8901380969985,
	1451.8544267849288,1451.818987604579,1451.783816681212,1451.7489102145473,1451.7142644836629,
	1451.6798758403545,1451.645740710587,1451.6118555882551,1451.5782170382863,1451.544821692708,
	1451.5116662479456,1451.4787474649136,1451.446062167398,1451.4136072386957,1451.3813796227703,
	1451.3493763198392,1451.317594388119,1451.2860309403397,1451.2546831425684,1451.2235482141248,
	1451.1926234254836,1451.161906096412,1451.1313935962812,1451.1010833424539,1451.0709727980618,
	1451.041059472855,1451.0113409199853,1450.9818147363985,1450.9524785626033,1450.9233300792089,
	1450.8943670089036,1450.8655871124474,1450.836988190675,1450.8085680810777,1450.7803246595288,
	1450.7522558388757,1450.7243595645064,1450.6966338192774,1450.6690766188697,1450.6416860120798,
	1450.6144600815317,1450.5873969390932,1450.5604947316353,1450.533751632021,1450.5071658464333,
	1450.4807356080182,1450.4544591798826,1450.428334852895,1450.4023609463227,1450.376535801814,
	1450.350857793101,1450.3253253168828,1450.2999367957032,1450.2746906762986,1450.2495854290282,
	1450.224619548862,1450.1997915552638,1450.175099988097,1450.1505434117064,1450.1261204104442,
	1450.1018295906015,1450.0776695801765,1450.0536390285092,1450.0297366030184,1450.0059609924945,
	1449.9823109050135,1449.9587850678204,1449.9353822252,1449.9121011433663,1449.8889406020992,
	1449.8658994026555,1449.8429763616443,1449.8201703138066,1449.7974801091627,1449.7749046145998,
	1449.7524427146286,1449.7300933083675,1449.707855308733,1449.685727647328,1449.663709268728,
	1449.641799130979,1449.6199962090968,1449.5982994912656,1449.576707977932,1449.5552206856119,
	1449.5338366445988,1449.5125548941787,1449.4913744925022,1449.4702945032495,1449.4493140114116,
	1449.4284321062855,1449.407647894442,1449.3869604901215,1449.3663690232663,1449.3458726323606,
	1449.3254704684953,1449.3051616933456,1449.2849454801674,1449.264821011559,1449.2447874823124,
	1449.224844096791,1449.2049900687864,1449.1852246220058,1449.1655469917266,1449.1459564213342,
	1449.1264521652192,1449.107033484409,1449.087699651715,1449.0684499486665,1449.049283664179,
	1449.0302000979048,1449.011198555362,1448.9922783545771,1448.9734388180468,1448.9546792790964,
	1448.9359990768141,1448.917397561124,1448.898874087254,1448.8804280189627,1448.862058726356,
	1448.8437655917962,1448.8255479985828,1448.8074053422708,1448.789337021267,1448.7713424465612,
	1448.7534210284853,1448.7355721917602,1448.7177953618434,1448.7000899763416,1448.6824554742295,
	1448.6648913044983,1448.6473969190374,1448.6299717803247,1448.6126153520677,1448.5953271091655,
	1448.5781065279466,1448.5609530930872,1448.5438662940558,1448.526845628696,1448.5098905932011,
	1448.4930006975792,1448.4761754544973,1448.4594143800268,1448.44271699667,1448.4260828320664,
	1448.4095114213778,1448.3930022998798,1448.3765550127398,1448.360169108283,1448.3438441366711,
	1448.3275796569899,1448.3113752336812,1448.2952304313162,1448.2791448212583,1448.263117981451,
	1448.247149491764,1448.2312389358565,1448.215385904929,1448.1995899918318,1448.1838507940652,
	1448.1681679131364,1448.1525409558415,1448.136969533192,1448.1214532591825,1448.1059917491884,
	1448.090584627511,1448.0752315204231,1448.059932055576,1448.0446858671853,1448.0294925916678,
	1448.0143518728603,1447.999263351316,1447.9842266753124,1447.9692414967035,1447.9543074693427,
	1447.939424254417,1447.9245915102842,1447.9098089018223,1447.8950760992448,1447.8803927723418,
	1447.8657585954645,1447.8511732460436,1447.8366364061721,1447.822147759496,1447.8077069920905,
	1447.7933137937969,1447.7789678572371,1447.7646688815635,1447.7504165596251,1447.736210596279,
	1447.7220506961546,1447.707936565469,1447.6938679146815,1447.6798444554927,1447.6658659031514,
	1447.6519319757786,1447.638042393685,1447.6241968799955,1447.6103951613513,1447.5966369651137,
	1447.5829220211783,1447.5692500631587,1447.5556208263129,1447.5420340475825,1447.5284894709644,
	1447.5149868351077,1447.5015258876192,1447.4881063724165,1447.4747280426673,1447.4613906478316,
	1447.4480939436633,1447.434837682621,1447.421621626036,1447.4084455344837,1447.3953091697706,
	1447.382212295965,1447.3691546798002,1447.3561360905248,1447.3431562988649,1447.3302150757102,
	1447.3173121987832,1447.3044474422898,1447.2916205849822,1447.278831409136,1447.2660796948608,
	1447.2533652257177,1447.2406877920878,1447.2280471763554,1447.2154431705278,1447.202875566586,
	1447.190344156676,1447.177848737,1447.1653891015696,1447.152965050447,1447.1405763845107,
	1447.1282229032531,1447.115904410847,1447.1036207116347,1447.0913716155565,1447.0791569251207,
	1447.0669764533652,1447.0548300110438,1447.0427174117488,1447.0306384659375,1447.0185929938127,
	1447.0065808128277,1446.9946017364307,1446.982655590658,1446.9707421952762,1446.9588613704173,
	1446.9470129443105,1446.9351967416292,1446.9234125896096,1446.9116603180407,1446.8999397536227,
	1446.888250730215,1446.8765930805641,1446.8649666391914,1446.8533712384497,1446.841806717842,
	1446.830272914664,1446.8187696684788,1446.8072968166528,1446.7958542035335,1446.784441671158,
	1446.7730590636559,1446.7617062256413,1446.750383006381,1446.7390892486212,1446.7278248035523,
	1446.7165895210594,1446.7053832534348,1446.6942058492782,1446.683057167014,1446.671937055303,
	1446.66084537465,1446.649781978471,1446.6387467235259,1446.6277394733943,1446.6167600832941,
	1446.6058084147471,1446.5948843315268,1446.5839876913258,1446.5731183653518,1446.5622762129058,
	1446.551461102217,1446.5406728997707,1446.5299114724096,1446.5191766885907,1446.508468419839,
	1446.497786535567,1446.4871309086632,1446.4765014092795,1446.4658979139897,1446.4553202926038,
	1446.4447684256643,1446.434242184519,1446.4237414487025,1446.4132660953096,1446.4028160043583,
	1446.3923910530286,1446.3819911231847,1446.3716160973129,1446.3612658545837,1446.3509402820544,
	1446.3406392580398,1446.3303626721395,1446.3201104080647,1446.3098823499497,1446.2996783903138,
	1446.289498407512,1446.2793422990906,1446.2692099502947,1446.2591012511036,1446.249016093523,
	1446.2389543688325,1446.2289159677034,1446.2189007858358,1446.2089087148788,1446.1989396511558,
	1446.188993488543,1446.1790701224138,1446.1691694514993,1446.1592913704228,1446.1494357798383,
	1446.1396025748934,1446.1297916598808,1446.1200029314318,1446.110236288247,1446.1004916362042,
	1446.0907688762877,1446.0810679081746,1446.0713886411231,1446.061730971554,1446.0520948087847,
	1446.0424800566416,1446.0328866205316,1446.023314408699,1446.013763327586,1446.0042332817445,
	1445.9947241838163,1445.9852359400682,1445.9757684609035,1445.966321655465,1445.9568954356585,
	1445.9474897108294,1445.9381043944077,1445.9287393955874,1445.9193946316548,1445.910070013455,
	1445.9007654533405,1445.891480871136,1445.882216177723,1445.872971289366,1445.8637461208236,
	1445.85454059374,1445.8453546197431,1445.836188118112,1445.8270410049226,1445.8179132063262,
	1445.8088046342173,1445.7997152115329,1445.7906448566212,1445.7815934927091,1445.772561038212,
	1445.7635474161382,1445.7545525476478,1445.7455763586715,1445.7366187674595,1445.7276797016257,
	1445.7187590839007,1445.7098568374308,1445.7009728912672,1445.6921071641968,1445.683259585926,
	1445.6744300850894,1445.6656185836453,1445.656825013428,1445.6480493001761,1445.6392913692273,
	1445.630551151868,1445.6218285749735,1445.6131235725104,1445.6044360706212,1445.5957660011109,
	1445.5871132927746,1445.578477877468,1445.5698596840823,1445.5612586482805,1445.5526747033005,
	1445.5441077776977,1445.53555781085,1445.527024727523,1445.5185084643747,1445.510008959911,
	1445.5015261435183,1445.4930599536312,1445.4846103222094,1445.476177188003,1445.4677604858168,
	1445.4593601535503,1445.4509761270162,1445.442608343013,1445.4342567371036,1445.4259212518275,
	1445.4176018219382,1445.4092983866258,1445.4010108842922,1445.392739259589,1445.3844834429458,
	1445.376243382103,1445.3680190106647,1445.3598102739911,1445.3516171138388,1445.3434394709236,
	1445.335277283533,1445.327130498152,1445.3189990517033,1445.310882891893,1445.3027819563856,
	1445.2946961972364,1445.2866255493716,1445.2785699604833,1445.2705293737502,1445.2625037329226,
	1445.2544929829871,1445.2464970716908,1445.2385159414548,1445.230549541847,1445.2225978125625,
	1445.2146607040688,1445.2067381624959,1445.1988301365984,1445.190936570943,1445.1830574130383,
	1445.1751926134557,1445.167342114343,1445.1595058697776,1445.1516838252942,1445.1438759301498,
	1445.1360821359815,1445.1283023891688,1445.1205366376796,1445.112784837646,1445.1050469344748,
	1445.0973228808166,1445.0896126269051,1445.0819161203246,1445.074233317713,1445.0665641671897,
	1445.0589086215311,1445.0512666329337,1445.0436381551976,1445.0360231383615,1445.0284215346849,
	1445.0208332986708,1445.0132583852267,1445.0056967422413,1444.9981483305676,1444.9906131015907,
	1444.9830910066053,1444.9755820038006,1444.96808604543,1444.960603087052,1444.9531330821574,
	1444.945675992699,1444.9382317658717,1444.9308003620747,1444.9233817394977,1444.9159758478718,
	1444.9085826472672,1444.9012020950956,1444.893834149718,1444.8864787655282,1444.8791359018294,
	1444.8718055141228,1444.8644875602251,1444.8571820003106,1444.8498887917758,1444.8426078923667,
	1444.8353392596475,1444.8280828574214,1444.8208386386198,1444.8136065671445,1444.806386597978,
	1444.799178695888,1444.7919828194022,1444.7847989244826,1444.7776269741971,1444.7704669315544,
	1444.7633187542608,1444.7561824035424,1444.749057841452,1444.7419450289142,1444.7348439249786,
	1444.7277544943652,1444.7206766993352,1444.7136104999033,1444.7065558538422,1444.699512735076,
	1444.6924810961382,1444.6854609043758,1444.678452121557,1444.6714547095141,1444.6644686325988,
	1444.657493852503,1444.6505303389229,1444.6435780485576,1444.636636950628,1444.629707002554,
	1444.622788174678,1444.6158804334175,1444.6089837351597,1444.602098049612,1444.5952233457156,
	1444.5883595805403,1444.5815067242465,1444.574664740677,1444.5678335952282,1444.5610132556812,
	1444.5542036858276,1444.547404854373,1444.540616726783,1444.5338392655194,1444.5270724451445,
	1444.5203162227172,1444.5135705718824,1444.5068354587877,1444.5001108530062,1444.493396712867,
	1444.486693014936,1444.47999972336,1444.4733168074592,1444.4666442323196,1444.4599819652597,
	1444.453329980018,1444.4466882442616,1444.4400567190096,1444.4334353799693,1444.4268241962452,
	1444.4202231350441,1444.4136321619942,1444.4070512527196,1444.400480371912,1444.3939194922061,
	1444.3873685790104,1444.3808276105738,1444.3742965447968,1444.3677753615873,1444.3612640276247,
	1444.3547625113536,1444.3482707878472,1444.341788822635,1444.335316590085,1444.3288540615247,
	1444.3224012055614,1444.3159579976345,1444.3095244005995,1444.3031003892368,1444.2966859422402,
	1444.2902810220985,1444.2838856054746,1444.2774996621768,1444.2711231641706,1444.2647560884895,
	1444.2583984013293,1444.2520500743324,1444.2457110842447,1444.239381406205,1444.2330610077397,
	1444.226749859768,1444.2204479403306,1444.214155221295,1444.2078716725396,1444.2015972750162,
	1444.195331991073,1444.1890758041955,1444.182828687687,1444.1765906072635,1444.1703615421488,
	1444.1641414683666,1444.1579303558085,1444.1517281810034,1444.1455349163662,1444.1393505413537,
	1444.1331750244237,1444.127008343295,1444.1208504699084,1444.1147013834072,1444.1085610602063,
	1444.1024294706235,1444.0963065908418,1444.0901923937347,1444.0840868579612,1444.0779899602894,
	1444.071901677175,1444.0658219803627,1444.0597508454705,1444.0536882560475,1444.0476341731426,
	1444.0415885905857,1444.0355514710504,1444.0295227991703,1444.0235025457441,1444.0174906943944,
	1444.0114872157205,1444.005492083994,1443.999505282961,1443.993526786456,1443.9875565724055,
	1443.9815946119952,1443.9756408924309,1443.969695386009,1443.963758067338,1443.9578289161113,
	1443.9519079126767,1443.9459950340577,1443.940090257549,1443.93419355845,1443.9283049149174,
	1443.9224243092308,1443.9165517111821,1443.9106871108409,1443.9048304792059,1443.8989817910197,
	1443.8931410317728,1443.8873081806664,1443.881483209679,1443.8756661001323,1443.8698568352079,
	1443.8640553896112,1443.8582617426448,1443.8524758752874,1443.8466977608857,1443.8409273874295,
	1443.8351647288966,1443.8294097642954,1443.8236624731549,1443.8179228392012,1443.8121908401672,
	1443.806466452042,1443.8007496631437,1443.7950404427088,1443.78933877878,1443.783644645729,
	1443.777958027959,1443.772278901648,1443.766607252938,1443.7609430565262,1443.7552862942975,
	1443.749636951732,1443.7439950010296,1443.7383604283245,1443.732733213118,1443.7271133353977,
	1443.7215007781567,1443.7158955214816,1443.7102975440944,1443.70470683023,1443.699123361166,
	1443.6935471131053,1443.687978074666,1443.6824162224736,1443.6768615407059,1443.6713140071251,
	1443.665773609022,1443.6602403232703,1443.6547141311676,1443.649195017951,1443.6436829642614,
	1443.6381779520166,1443.6326799661497,1443.627188980499,1443.621704984628,1443.6162279570929,
	1443.6107578850938,1443.6052947451092,1443.5998385226846,1443.5943891984268,1443.5889467585396,
	1443.583511182914,1443.5780824547498,1443.5726605581551,1443.5672454724784,1443.561837180806,
	1443.556435672391,1443.5510409246988,1443.5456529196806,1443.5402716467456,1443.5348970814773,
	1443.5295292139901,1443.524168021937,1443.5188134929058,1443.513465606342,1443.508124352709,
	1443.5027897079972,1443.4974616587808,1443.492140193483,1443.486825286444,1443.481516927255,
	1443.4762150985705,1443.4709197849807,1443.465630971573,1443.4603486388846,1443.455072773408,
	1443.4498033620416,1443.4445403820218,1443.4392838284903,1443.4340336713506,1443.4287899088467,
	1443.4235525124327,1443.418321479435,1443.4130967886022,1443.4078784232693,1443.4026663676464,
	1443.397460609813,1443.3922611295866,1443.3870679201611,1443.3818809580523,1443.3767002336886,
	1443.3715257302308,1443.3663574288,1443.3611953228528,1443.3560393931652,1443.350889618034,
	1443.3457459969293,1443.3406085051688,1443.3354771291365,1443.3303518594923,1443.325232674341,
	1443.3201195638123,1443.3150125171092,1443.3099115122052,1443.3048165337661,1443.2997275757775,
	1443.2946446227586,1443.289567654819,1443.2844966616233,1443.2794316289167,1443.2743725420694,
	1443.269319388769,1443.264272149068,1443.2592308156507,1443.2541953751459,1443.249165809758,
	1443.2441421096182,1443.2391242521817,1443.2341122392124,1443.2291060440998,1443.2241056530816,
	1443.2191110657989,1443.214122254885,1443.2091392150437,1443.2041619292906,1443.1991903842168,
	1443.1942245728324,1443.1892644736736,1443.184310072275,1443.179361365037,1443.1744183307262,
	1443.1694809629746,1443.164549246171,1443.159623162957,1443.1547026991527,1443.1497878523335,
	1443.1448786051117,1443.1399749455277,1443.135076854218,1443.1301843245976,1443.1252973473436,
	1443.1204159009988,1443.115539972832,1443.1106695637714,1443.105804648579,1443.1009452198564,
	1443.0960912635824,1443.0912427640114,1443.0863997169995,1443.0815621043773,1443.0767299185923,
	1443.0719031445765,1443.0670817667165,1443.0622657788394,1443.0574551666928,1443.05264991736,
	1443.047850017715,1443.043055463766,1443.0382662327827,1443.0334823206517,1443.0287037103665,
	1443.0239303941282,1443.0191623558549,1443.0143995863966,1443.0096420769278,1443.0048898159039,
	1443.000142780625,1442.9954009754308,1442.990664379508,1442.9859329821202,1442.9812067718851,
	1442.976485741191,1442.9717698763939,1442.9670591619351,1442.9623535960584,1442.9576531534672,
	1442.9529578374827,1442.9482676305279,1442.9435825225587,1442.938902504208,1442.9342275578206,
	1442.9295576759826,1442.9248928512222,1442.920233067812,1442.915578316113,1442.9109285879342,
	1442.9062838692598,1442.901644149877,1442.8970094170472,1442.8923796687739,1442.887754883427,
	1442.8831350585672,1442.878520177599,1442.8739102277987,1442.8693052124454,1442.8647051053242,
	1442.8601099035388,1442.8555195979816,1442.850934172334,1442.8463536230292,1442.8417779345348,
	1442.8372070971564,1442.8326410998602,1442.8280799377758,1442.82352359753,1442.8189720684954,
	1442.8144253387457,1442.8098833981949,1442.805346241366,1442.8008138543842,1442.7962862274455,
	1442.791763351784,1442.7872452144256,1442.7827318124232,1442.7782231300228,1442.7737191580957,
	1442.7692198820725,1442.764725303118,1442.7602354035894,1442.7557501812594,1442.7512696159247,
	1442.7467937010033,1442.7423224323134,1442.7378557955512,1442.7333937862672,1442.728936384649,
	1442.72448358917,1442.7200353865749,1442.7155917739585,1442.7111527347288,1442.7067182607227,
	1442.7022883482323,1442.697862976302,1442.693442145575,1442.6890258447982,1442.6846140615626,
	1442.680206792807,1442.6758040232778,1442.6714057451838,1442.6670119505895,1442.6626226248632,
	1442.6582377724808,1442.6538573679545,1442.649481416941,1442.6451098957318,1442.640742809526,
	1442.6363801382222,1442.6320218795177,1442.6276680226742,1442.6233185587755,1442.6189734738125,
	1442.6146327709196,1442.6102964253923,1442.6059644432428,1442.601636810521,1442.5973135171828,
	1442.5929945517762,1442.5886799095217,1442.584369581348,1442.5800635587136,1442.5757618321825,
	1442.5714643946872,1442.5671712344363,1442.562882347078,1442.5585977221476,1442.5543173484364,
	1442.55004122682,1442.5457693362919,1442.5415016740403,1442.5372382297405,1442.532979003808,
	1442.5287239711938,1442.5244731450305,1442.520226502956,1442.5159840378024,1442.5117457434776,
	1442.5075116100481,1442.5032816335352,1442.4990557997787,1442.4948341065415,1442.4906165394805,
	1442.4864030967187,1442.4821937690433,1442.4779885437285,1442.4737874153984,1442.4695903769561,
	1442.4653974168489,1442.4612085384458,1442.4570237178245,1442.4528429580464,1442.4486662465972,
	1442.4444935807874
	}}
};
