use core::ptr;
use std::os::raw::c_char;

#[test]
fn fts_open() {
    let paths: [*const c_char; 2] = [c"/".as_ptr(), ptr::null()];
    let fts = unsafe { super::fts_open(paths.as_ptr().cast(), super::FTS_PHYSICAL, None) };
    assert_ne!(fts, ptr::null_mut());

    unsafe { super::fts_close(fts) };
}

#[test]
fn fts_read() {
    let paths: [*const c_char; 2] = [c"/".as_ptr(), ptr::null()];
    let fts = unsafe { super::fts_open(paths.as_ptr().cast(), super::FTS_PHYSICAL, None) };
    assert_ne!(fts, ptr::null_mut());

    let entry = unsafe { super::fts_read(fts) };
    assert_ne!(entry, ptr::null_mut());
    if let Some(entry) = unsafe { entry.as_ref() } {
        // The manual page defines `fts_name` as a pointer, but GNU glibc defines it as an array.
        // Other systems, e.g., FreeBSD, define the type correctly.
        #[cfg(target_env = "gnu")]
        let fts_name = entry.fts_name.as_ptr();
        #[cfg(not(target_env = "gnu"))]
        let fts_name = entry.fts_name;

        assert_ne!(fts_name, ptr::null_mut());
    }

    unsafe { super::fts_close(fts) };
}
