"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFindingsMethods = addFindingsMethods;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addFindingsMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_FINDINGS] = createAction({
    url: {
      fmt: `${_constants.API.GET_FINDINGS}`,
      params: {
        detector_id: {
          type: 'string'
        },
        sortOrder: {
          type: 'string'
        },
        size: {
          type: 'number'
        },
        detectorType: {
          type: 'string'
        },
        startIndex: {
          type: 'number'
        },
        detectionType: {
          type: 'string'
        },
        severity: {
          type: 'string'
        },
        searchString: {
          type: 'string'
        },
        findingIds: {
          type: 'string'
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_THREAT_INTEL_FINDINGS] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/findings/_search`,
      params: {
        sortOrder: {
          type: 'string'
        },
        size: {
          type: 'number'
        },
        startIndex: {
          type: 'number'
        },
        searchString: {
          type: 'string'
        },
        findingIds: {
          type: 'list'
        },
        iocIds: {
          type: 'string'
        },
        startTime: {
          type: 'number'
        },
        endTime: {
          type: 'number'
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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