/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Guadeloupe
* Equirectangular projection

* @author CCM Benchmark Group
* @source http://commons.wikimedia.org/wiki/File:Guadeloupe_department_location_map.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_01 : {
					width : 70.349319,
					height : 55.179909,
					getCoords : function (lat, lon) {
						var xfactor = 86.761658287969;
						var xoffset = 5362.7633969916;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -82.266584089643;
						var yoffset = 1358.4158276251;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-971" : "m 29.98,0.01 c -0.16,0.06 -0.15,0.43 -0.39,0.25 -0.11,-0.09 -0.16,0.03 -0.18,0.1 -0.31,-0.09 -0.35,0.34 -0.6,0.41 -0.19,0.35 -0.3,0.75 -0.67,0.99 -0.19,0.23 -0.57,0.15 -0.74,0.38 -0.04,0.16 -0.32,0.06 -0.39,0.22 -0.21,0.08 -0.54,0.1 -0.6,0.35 -0.08,0.16 -0.06,0.31 -0.18,0.45 0.02,0.29 -0.4,0.26 -0.6,0.35 -0.32,0.01 -0.57,0.18 -0.67,0.45 -0.12,0.32 -0.58,0.34 -0.77,0.57 -0.26,0.03 -0.32,0.36 -0.42,0.54 -0.08,0.41 -0.26,0.79 -0.49,1.15 -0.06,0.23 0.36,0.03 0.35,0.25 -0.04,0.42 0.35,0.75 0.35,1.15 -0.19,0.08 -0.05,0.27 0,0.38 -0.05,0.32 0.28,0.5 0.32,0.8 0.09,0.25 0.04,0.56 0.25,0.76 -0.03,0.23 0.17,0.35 0.39,0.41 0.36,0.18 0.83,0.18 1.05,0.54 0.09,0.17 0.31,0.07 0.32,-0.1 0.08,-0.24 0.39,0.22 0.53,0.32 0.14,0.19 0.42,0.43 0.39,0.67 -0.13,0.27 0.09,0.63 -0.28,0.8 -0.32,0.14 0.04,0.22 0.14,0.35 -0.02,0.1 -0.01,0.22 0.07,0.29 0.01,0.12 -0.35,0.11 -0.18,0.25 0.11,0.06 0.31,0.07 0.39,0.13 -0.31,0.06 -0.62,0.19 -0.95,0.19 -0.13,0.01 -0.17,0.12 -0.32,0.06 -0.2,0.06 0.02,0.22 0.14,0.22 0.08,0.02 0.25,0.2 0.07,0.16 -0.14,0.05 -0.03,0.35 -0.21,0.22 -0.34,-0.1 -0.76,0.01 -1.05,-0.16 -0.14,-0.25 -0.29,0.16 -0.35,0.25 -0.04,0.15 -0.23,0.15 -0.32,0.25 -8.7e-4,0.3 -0.63,0.36 -0.53,0.7 0.01,0.23 0.16,0.48 0.07,0.7 -0.14,0.13 -0.25,0.33 -0.04,0.45 -0.07,0.14 -0.1,0.36 -0.25,0.45 -0.03,0.31 -0.29,0.56 -0.56,0.73 -0.08,0.13 0.05,-0.19 -0.04,-0.22 -0.27,0.06 -0.35,0.48 -0.14,0.64 0.05,0.12 0.1,0.4 -0.14,0.32 -0.15,0.05 -0.1,0.3 -0.28,0.32 -0.12,-0.17 -0.43,0.09 -0.42,0.22 0.12,0.18 0.36,0.11 0.53,0.19 0.1,0.09 -0.03,0.28 0.11,0.35 0.06,0.22 -0.11,0.52 0.07,0.7 0.04,0.1 -0.06,0.25 0.04,0.35 -0.02,0.23 -0.02,0.47 0,0.7 0.01,0.11 0.03,0.21 0.04,0.32 -0.03,0.13 -0.31,0.08 -0.21,0.25 0.18,0.33 0.63,0.53 0.63,0.92 0.06,0.1 0.28,-0 0.18,0.16 -0.02,0.23 0.26,0.39 0.46,0.38 -0.19,0.24 0.21,0.45 0.11,0.7 0.03,0.14 0.4,0.18 0.25,0.35 -0.06,-0.09 -0.2,-0.22 -0.18,-0.03 0.05,0.14 0.18,0.23 0.18,0.38 0.12,0.05 0.28,0.02 0.39,0.13 0.16,0.12 0.4,0.27 0.56,0.06 0.19,-0.11 0.47,0.03 0.63,-0.13 0.31,-0.07 0.41,0.26 0.39,0.48 -0.11,0.38 0.37,0.3 0.63,0.35 0.53,0.09 1.15,0.01 1.62,0.29 0.2,0.13 0.49,0.03 0.7,0.16 0.15,0.08 0.3,0.2 0.49,0.13 0.18,0.01 0.3,0.32 0.49,0.13 0.16,-0.09 0.11,-0.29 0.35,-0.29 0.21,-0.11 0.38,0.11 0.6,0.03 0.29,-0.06 0.68,-0.11 0.81,-0.38 -0.03,-0.19 0.24,-0.21 0.39,-0.29 0.33,-0.05 0.67,-0.13 0.98,-0.13 0.01,0.19 0.26,0.24 0.32,0.06 0.07,0.09 0.15,0.06 0.18,-0.03 0.17,-0.04 0.32,-0.2 0.53,-0.16 0.36,0.04 0.79,-0.04 0.91,-0.38 0.17,-0.11 0.37,-0.22 0.56,-0.29 0.13,0.05 0.32,0.38 0.35,0.1 0.04,-0.39 0.58,-0.52 0.91,-0.35 0.2,0.09 0.46,0.06 0.53,-0.16 0.2,-0.16 0.51,-0.24 0.56,-0.51 0.24,-0.17 0.59,-0.23 0.88,-0.32 0.51,-0.01 0.99,-0.14 1.44,-0.35 0.15,-0.1 0.56,0.03 0.53,-0.22 0.31,0.02 0.66,0.09 0.95,0.03 0.06,0.19 0.36,0.03 0.28,-0.13 -0.03,-0.19 0.13,0.06 0.18,0.1 0.17,0.21 0.44,0.16 0.67,0.06 0.39,-0.11 0.82,-0.08 1.2,-0.22 0.25,-0.01 0.53,0.08 0.74,-0.06 0.16,-0 0.24,-0.15 0.42,-0.13 0.19,-0.02 0.26,-0.22 0.46,-0.22 0.36,-0.3 0.88,-0.02 1.3,-0.19 0.39,-0.06 0.7,-0.36 1.09,-0.38 0.52,0.07 1.07,0.08 1.58,0.19 0.32,-0.01 0.58,0.13 0.91,0.06 0.51,-0.12 1.02,0.23 1.55,0.19 0.22,0.09 0.45,0.13 0.7,0.1 0.48,-0.06 1,-0.05 1.37,0.25 0.12,0.1 0.3,0.09 0.42,0.1 0.04,0.17 0.35,0.39 0.46,0.16 -0.02,-0.12 0.33,-0.29 0.11,-0.32 -0.16,0.09 -0.26,0.01 -0.35,-0.1 -0.22,-0.04 -0.43,-0.1 -0.56,-0.29 -0.21,-0.3 -0.25,-0.14 -0.18,0.1 -0.17,0.05 -0.39,-0.2 -0.56,-0.25 -0.22,-0.02 -0.33,-0.21 -0.53,-0.25 -0.14,0.11 -0.33,0.2 -0.53,0.13 -0.49,-0.13 -1.01,-0.3 -1.34,-0.67 -0.6,-0.24 -1.37,-0.25 -1.79,-0.76 -0.12,-0.14 -0.28,-0.28 -0.42,-0.38 -0.11,-0.39 -0.34,-0.76 -0.56,-1.12 -0.16,-0.13 -0.21,-0.41 -0.46,-0.38 0.1,-0.25 -0.13,-0.42 -0.21,-0.64 -0.13,-0.21 -0.42,-0.23 -0.63,-0.16 -0.15,-0.07 0.11,-0.26 0,-0.38 -0.14,-0.2 -0.45,-0.36 -0.7,-0.32 -0.12,0.03 -0.12,-0.2 -0.25,-0.22 -0.17,-0.13 -0.4,-0.1 -0.53,-0.29 -0.14,-0.17 -0.36,-0.16 -0.56,-0.16 -0.21,-0.04 -0.39,-0.18 -0.56,-0.29 -0,-0.14 -0.13,-0.3 -0.32,-0.22 -0.14,0.05 -0.38,0.31 -0.46,0.06 -0.16,-0.27 -0.5,-0.49 -0.84,-0.35 -0.14,0.07 -0.28,0.08 -0.42,0 -0.36,-0.06 -0.71,-0.22 -1.09,-0.19 -0.3,-0.03 -0.71,-0.02 -0.77,0.32 -0.07,0.08 -0.11,-0.14 -0.18,-0.16 -0.15,-0.13 -0.3,-0.56 -0.53,-0.32 -0.25,0.31 -0.58,0.02 -0.88,-0.06 -0.21,-0.1 -0.65,-0.26 -0.7,0.06 -0.07,-0.08 0.07,-0.34 -0.18,-0.32 -0.37,-0.08 -0.79,-0.27 -0.98,-0.57 -0.24,-0.37 -0.68,-0.62 -0.88,-1.02 -0.2,-0.15 -0.18,-0.42 -0.39,-0.57 -0.26,-0.22 -0.41,-0.48 -0.56,-0.76 -0.06,-0.29 -0.11,-0.6 -0.32,-0.83 -0.14,-0.25 0.14,-0.51 0,-0.76 0.17,-0.24 0.09,-0.6 0,-0.86 -0,-0.21 0.37,-0.09 0.35,-0.32 0.05,-0.24 -0.04,-0.55 0.25,-0.7 0.11,-0.37 -0.02,-0.77 -0.07,-1.15 -0.19,-0.28 -0.05,-0.7 -0.28,-0.96 0.01,-0.15 -0.12,-0.28 -0.28,-0.29 -0.14,-0.12 0.05,-0.4 -0.18,-0.41 0.09,-0.23 -0.01,-0.54 -0.18,-0.7 8.2e-4,-0.25 0.07,-0.65 -0.25,-0.76 -0.18,0.05 -0.2,-0.26 -0.39,-0.19 -0.08,-0.13 -0.17,-0.32 -0.39,-0.29 -0.32,-0.06 -0.44,-0.36 -0.6,-0.57 -0.16,-0.07 -0.39,-0.09 -0.42,-0.29 -0.11,-0.17 -0.33,-0.25 -0.49,-0.38 -0.1,-0.11 -0.26,0.01 -0.28,0.03 -0.13,-0.27 0.02,-0.62 -0.25,-0.83 -0.24,-0.09 -0.46,0.2 -0.67,0.13 -0.12,-0.22 -0.41,-0.04 -0.56,-0.19 -0.13,0.03 -0.3,0.16 -0.32,-0.06 -0.08,-0.14 0.3,-0.22 0.07,-0.32 -0.15,0.06 -0.18,-0.18 -0.35,-0.13 0.05,-0.19 0.22,-0.41 0.14,-0.61 -0.01,-0.01 -0.02,-0.01 -0.04,0 z M 22.81,21.04 c -0.01,-0.06 -0.06,-0.11 -0.11,-0.16 0.04,-0.46 -0.01,-0.95 -0.14,-1.4 -0.09,-0.09 -0.21,-0.1 -0.32,-0.03 -0.1,0.06 -0.18,0.21 -0.14,0.32 -0.05,0.22 -0.2,-0.2 -0.32,-0.19 -0.18,0.04 -0.14,-0.25 -0.04,-0.29 0.19,-0.03 0.32,0.22 0.49,0.16 0.15,-0.31 -0.15,-0.71 -0.49,-0.73 -0.09,0.03 -0.09,0.3 -0.21,0.22 -0.01,-0.3 -0.43,-0.19 -0.6,-0.06 -0.14,0.05 -0.1,0.25 -0.28,0.22 -0.12,0.01 -0.32,0.06 -0.21,-0.13 0.01,-0.24 -0.28,-0.11 -0.39,-0.03 -0.14,-0.07 -0.27,0.11 -0.11,0.19 0.18,0.22 -0.07,0.41 -0.25,0.54 -0.17,0.09 -0.06,0.3 -0.25,0.38 -0.21,0.19 -0.47,0.3 -0.77,0.29 -0.19,0.03 -0.39,0.02 -0.42,-0.19 -0.13,-0.15 -0,-0.23 0.14,-0.29 0.17,-0.11 0.07,-0.27 -0.04,-0.38 -0.09,-0.13 0.21,-0.33 0.04,-0.41 -0.29,0.08 -0.26,0.47 -0.42,0.67 -0.08,0.15 -0.29,0.18 -0.35,0.35 -0.17,0.18 -0.59,0.23 -0.7,0 0.11,-0.22 0.45,-0.49 0.28,-0.73 -0.39,-0.11 -0.82,0.34 -1.2,0.13 -0.15,-0.19 -0.08,-0.5 0.21,-0.54 0.25,-0.09 0.52,-0.38 0.25,-0.57 -0.03,-0.17 0.12,-0.02 0.14,0.06 0.13,0.2 0.01,0.4 -0.18,0.51 0.01,0.21 0.4,0.18 0.53,0.06 0.45,-0.23 0.15,-0.84 0.6,-1.05 0.2,-0.13 0.64,-0.29 0.53,-0.57 -0.26,-0.26 -0.73,-0.09 -1.05,-0.06 -0.37,0.03 -0.84,0.34 -1.16,0.06 -0.12,-0.24 -0.53,0.01 -0.6,-0.29 -0.1,-0.09 -0.23,-0.15 -0.32,-0.25 -0.21,-0.06 -0.54,0.13 -0.56,-0.19 -0.07,-0.18 0.39,-0.2 0.21,-0.38 -0.21,-0.19 -0.56,-0.24 -0.77,-0.41 -0.3,0.03 -0.57,0.33 -0.88,0.13 -0.14,-0.08 -0.28,0.04 -0.35,0.1 -0.09,-0.07 0.06,-0.27 -0.14,-0.22 -0.14,0.09 -0.38,-0.16 -0.42,0.03 -0.17,-0.09 -0.17,-0.33 -0.39,-0.38 -0.15,-0.08 -0.36,-0.41 -0.56,-0.25 0.01,0.11 0.06,0.31 -0.14,0.29 -0.25,-0 -0.17,-0.31 -0.39,-0.38 -0.1,-0.1 -0.29,-0.05 -0.28,-0.22 -0.1,-0.21 -0.38,-0.13 -0.56,-0.16 -0.17,-0.1 -0.37,0 -0.53,-0.13 -0.28,-0.04 -0.57,-0.06 -0.84,-0.19 -0.25,-0.05 -0.36,-0.33 -0.14,-0.48 -0,-0.13 -0.26,-0.06 -0.32,-0.19 -0.05,-0.11 -0.2,-0.03 -0.25,-0.1 0.02,-0.21 -0.24,-0.3 -0.25,-0.51 -0.1,-0.09 -0.28,-0.06 -0.35,-0.19 -0.1,-0.11 -0.23,-0.02 -0.32,0 -0.17,-0.09 -0.41,-0.09 -0.56,-0.19 0.05,-0.22 -0.3,-0.15 -0.42,-0.22 -0.04,-0 -0.1,-0.01 -0.14,0 -0.25,0.03 0.01,0.36 -0.25,0.38 -0.08,0.1 -0.22,0.27 -0.39,0.19 -0.25,0.16 -0.47,-0.24 -0.74,-0.06 -0.23,0.09 -0.46,0.18 -0.63,0.35 -0.24,0.05 -0.5,0.09 -0.74,0.13 -0.01,0.17 -0.28,0.3 -0.18,0.51 -0.03,0.24 -0.36,0.4 -0.6,0.45 -0.18,0.12 -0.43,0.37 -0.28,0.57 0.26,0.26 0.07,0.73 -0.25,0.89 -0.19,0.16 -0.47,0.08 -0.63,0.25 -0.29,0.04 -0.34,0.47 -0.07,0.57 0.15,0.07 0.45,0.11 0.39,0.32 -0.12,0.02 -0.2,0.08 -0.32,0.13 -0.4,0.02 -0.33,0.49 -0.39,0.73 -0.07,0.29 0.08,0.55 0.04,0.83 -0.11,0.17 -0.15,0.37 -0.04,0.54 0.03,0.29 -0.38,0.33 -0.56,0.48 5.7e-4,0.1 0.08,0.21 0.04,0.32 0.03,0.11 0.3,-0.03 0.21,0.13 -0.05,0.19 0.14,0.34 0.04,0.54 -0.03,0.25 0.09,0.5 0.21,0.7 0.11,0.38 0.1,0.81 0.49,1.05 0.16,0.22 0.39,0.37 0.6,0.54 0.32,0.28 0.61,0.63 0.56,1.05 0.02,0.29 0.27,0.54 0.18,0.83 -0.03,0.41 -0.44,0.74 -0.35,1.15 -0.14,0.18 0.17,0.36 0.21,0.54 0.09,0.07 0.21,0.11 0.11,0.22 -0.07,0.28 -0,0.62 -0.07,0.89 0.1,0.29 0.59,0.02 0.67,0.35 -0.08,0.08 -0.06,0.2 0,0.29 0.05,0.58 0.11,1.21 0,1.78 -0.08,0.08 -0.09,0.17 -0.21,0.22 -0.06,0.1 -0.02,0.23 -0.14,0.29 0.07,0.19 0.4,0.05 0.53,0.22 0.21,0.17 0.44,0.47 0.35,0.73 -0.16,0.07 -0.37,0.14 -0.32,0.35 -0.01,0.33 -0.01,0.67 0.04,0.99 -0.21,0.12 0.11,0.31 0.04,0.48 -0.01,0.12 -0.21,0.17 -0.14,0.32 0.01,0.13 0.24,0.02 0.18,0.19 -0.06,0.11 -0.2,0.32 0.04,0.35 0.15,0 0.03,0.13 -0.04,0.16 -0.09,0.1 -0.03,0.24 0.07,0.29 0.02,0.21 0.29,0.11 0.39,0.03 0.02,0.16 -0.31,0.33 -0.11,0.45 0.11,0.09 0.02,0.28 -0.04,0.38 0.05,0.51 -0.04,1 -0.18,1.5 0.18,0.24 0.22,0.56 0.46,0.76 0.05,0.15 0.09,0.32 0.28,0.38 0.13,0.14 0.24,0.3 0.42,0.41 0.08,0.09 0.1,0.24 0.25,0.25 0.09,0.15 0.04,0.36 0.25,0.45 0.33,0.3 0.28,0.71 0.39,1.08 0.03,0.41 -0.02,0.88 0.35,1.18 0.23,0.31 0.72,0.45 0.84,0.83 0.31,0.37 0.69,0.73 1.12,0.99 0.3,0.08 0.45,0.39 0.7,0.54 0.21,0.46 0.41,0.97 0.35,1.47 -0.08,0.21 -0.08,0.46 0.07,0.64 0.06,0.11 -0.05,0.42 0.18,0.38 0.19,-0.15 0.37,0 0.53,0.1 0.3,0.14 0.49,-0.1 0.77,-0.13 0.41,-0.11 0.86,-0.11 1.23,-0.29 0.3,-0.07 0.34,-0.38 0.49,-0.57 0.22,-0.18 0.5,-0.46 0.81,-0.45 0.01,0.16 0.17,0.37 0.35,0.38 0.12,-0.22 0.26,-0.51 0.53,-0.57 0.12,-0.13 0.35,-0.3 0.46,-0.06 0.14,0.11 0.43,0.09 0.53,-0.03 0.26,-0.08 0.5,0.35 0.74,0.16 0.04,-0.1 0.28,0.02 0.28,-0.16 0.02,-0.15 0.2,-0.41 0.39,-0.25 0.18,0.02 0.41,0.02 0.56,-0.06 0.14,-0.15 0,-0.33 -0.11,-0.45 0.09,-0.2 0.5,-0.22 0.46,-0.51 -0.02,-0.29 0.02,-0.63 0.39,-0.7 0.13,0.01 0.34,-0.02 0.21,-0.13 0.32,-0.07 0.32,-0.44 0.56,-0.57 0.19,-7.5e-4 0.27,-0.13 0.35,-0.25 0.2,-0.13 0.48,-0.22 0.56,-0.45 0.12,-0.02 0.25,-0.06 0.25,-0.19 0.19,-0.04 0.37,-0.14 0.46,-0.32 0.22,-0.37 0.78,-0.43 1.02,-0.76 0.25,-0.04 0.03,-0.31 0.21,-0.41 0.23,-0.19 0.44,-0.46 0.35,-0.76 -0.07,-0.27 0.15,-0.42 0.32,-0.61 0.02,-0.23 0.42,-0.32 0.28,-0.57 0.01,-0.06 0.2,-0.04 0.14,-0.16 -0.13,-0.25 -0.44,-0.42 -0.39,-0.73 -0.07,-0.39 0.01,-0.77 0.11,-1.15 -0.17,-0.41 -0.02,-0.88 0,-1.31 -0.14,-0.14 -0.17,-0.35 -0.18,-0.54 0.01,-0.19 -0.31,-0.26 -0.14,-0.45 0.04,-0.23 -0.3,-0.11 -0.39,-0.29 -0.39,-0.39 -0.36,-1.15 0.25,-1.34 0.2,-0.14 0.45,-0.45 0.18,-0.64 -0.19,-0.22 -0.52,-0.08 -0.74,-0.25 -0.3,-0.11 -0.5,-0.37 -0.63,-0.61 0.24,-0.13 0.09,-0.44 0.25,-0.61 -0.04,-0.32 -0.55,-0.1 -0.6,-0.41 0.01,-0.18 -0.05,-0.37 -0.18,-0.51 -0.08,-0.28 -0.14,-0.68 0.21,-0.83 0.21,-0.1 0.1,-0.39 0.04,-0.54 -0.13,-0.11 -0.42,0.01 -0.42,-0.22 -0.11,-0.19 -0.31,-0.34 -0.32,-0.57 -0.12,-0.33 0.01,-0.68 0.28,-0.92 0.09,-0.13 0.42,-0.34 0.18,-0.48 -0.18,-0.11 -0.41,-0.27 -0.25,-0.48 0.11,-0.12 0.12,-0.38 -0.11,-0.38 -0.18,-0.34 0.24,-0.68 0.28,-1.02 0.05,-0.23 0.15,-0.69 0.49,-0.64 0.15,0.14 0.43,0.26 0.6,0.1 0.18,-0.02 0.46,-0.08 0.53,0.13 0.08,0.07 0.3,0.34 0.39,0.16 -0.09,-0.17 0.21,-0.36 0.28,-0.13 0.07,0.11 0.37,0.11 0.21,0.29 -0.12,0.18 0.39,0.24 0.21,0.41 -0.19,0.12 0.04,0.35 0.21,0.29 0.19,0.05 0.2,-0.1 0.14,-0.13 0.17,0.06 0.5,-0.04 0.39,-0.25 -0.18,-0.2 0.43,-0.32 0.25,-0.54 -0.12,-0.23 -0.35,-0.02 -0.53,-0.06 -0.18,-0.35 0.1,-0.83 -0.25,-1.15 -0.14,-0.13 -0.14,-0.31 0.04,-0.41 0.16,-0.11 0.33,-0.3 0.32,-0.48 z m 46.75,-7.55 c -0.21,-0.02 -0.43,0.26 -0.6,0.1 -0.23,0.05 -0.13,0.47 -0.42,0.41 -0.28,-0.1 -0.52,0.11 -0.67,0.29 -0.1,-0.03 -0.29,-0.01 -0.25,0.13 0.04,0.07 0.04,0.23 -0.07,0.1 -0.15,-0.3 -0.33,0.03 -0.53,0.1 -0.27,0.1 -0.5,0.29 -0.74,0.41 -0.1,-0.14 -0.22,-0.03 -0.21,0.1 -0.16,0.27 -0.59,0.19 -0.77,0.45 -0.12,0.08 -0.12,0.28 -0.32,0.22 -0.14,-0.03 -0.24,0.07 -0.28,0.16 -0.15,-0.01 -0.21,0.13 -0.35,0.1 -0.17,0.15 -0.22,-0.25 -0.39,-0.1 -0.11,0.1 -0.31,0.13 -0.28,0.32 -0.2,0.06 0.03,0.38 -0.25,0.32 -0.3,0.02 -0.6,0.01 -0.88,-0.03 -0.14,0.07 -0.02,0.23 -0.18,0.32 -0.14,0.22 -0.38,0.35 -0.56,0.51 0.02,0.16 0.25,0.31 0.07,0.48 -0.08,0.18 -0.11,0.54 0.14,0.61 0.2,-0.09 0.19,-0.38 0.46,-0.41 0.28,-0.1 0.69,-0.02 0.91,-0.22 -0.06,-0.13 0.15,-0.17 0.25,-0.19 0.14,-0.05 0.23,-0.28 0.39,-0.13 0.2,-0.04 0.41,-0.12 0.63,-0.13 0.41,-0.09 0.83,-0.14 1.23,-0.22 0.75,-0.26 1.21,-0.89 1.86,-1.27 0.34,-0.22 0.73,-0.37 1.12,-0.48 0.13,0.05 0.38,0.13 0.35,-0.1 -0.03,-0.12 0.18,0.18 0.25,0 0.13,0.02 0.29,-0.02 0.32,-0.16 0.1,-0.03 0.24,0.01 0.28,-0.13 0.08,-0.1 0.33,-0.04 0.25,-0.22 -0.05,-0.1 -0.22,-0.19 -0.04,-0.25 0,-0.11 -0.2,-0.02 -0.18,-0.16 -0.03,-0.06 -0.24,-0.06 -0.07,-0.1 0.1,-0.09 -0.02,-0.19 -0.11,-0.16 -0.03,-0.1 0.21,-0.27 -0.04,-0.29 -0.07,-0.01 -0.1,-0.09 -0.18,-0.06 0.07,-0.16 0.05,-0.33 -0.18,-0.29 z m -23.09,28.1 c -0.29,0.33 -0.77,0.31 -1.2,0.29 -0.2,-0.02 -0.18,0.19 -0.35,0.22 -0.39,0.27 -0.57,0.68 -0.77,1.05 -0.16,0.09 -0.45,0.14 -0.39,0.38 -0.01,0.27 -0.14,0.56 -0.49,0.54 -0.41,-0 -0.68,0.15 -0.56,0.54 -0.04,0.5 0.05,1.07 -0.21,1.53 -0.37,0.41 -0.99,0.54 -1.41,0.89 0.01,0.39 0.14,0.81 0.18,1.21 0.05,0.56 0.24,1.11 0.46,1.62 0.09,0.23 -0.07,0.42 -0.18,0.61 0.11,0.15 0.28,0.25 0.42,0.35 0.05,0.44 0.45,0.75 0.77,1.05 0.15,0.35 0.6,0.15 0.88,0.32 0.27,0.14 0.51,0.36 0.84,0.35 0.43,0.09 0.82,0.35 1.27,0.38 0.18,0.08 0.29,0.33 0.53,0.22 0.44,-0.07 0.92,-0.01 1.3,-0.25 0.54,-0.11 1.16,-0.1 1.65,-0.35 0.33,-0.06 0.54,-0.33 0.84,-0.45 0.16,-0.17 0.39,-0.24 0.56,-0.38 0.13,-0.24 0.45,-0.29 0.6,-0.51 0.06,-0.4 0.58,-0.44 0.88,-0.64 0.27,-0.11 0.71,-0.17 0.7,-0.51 0.15,-0.47 0.5,-0.87 0.53,-1.37 -0,-0.25 0.03,-0.5 0.11,-0.73 -0.16,-0.36 -0.26,-0.75 -0.42,-1.12 -0.22,-0.4 -0.62,-0.74 -1.02,-0.99 -0.15,-0.14 -0.49,0.01 -0.49,-0.25 -0.03,-0.28 -0.33,-0.33 -0.56,-0.41 -0.13,-0.09 0.25,-0.34 0,-0.35 -0.13,0.05 -0.28,0.07 -0.28,-0.1 -0.15,-0.12 -0.35,-0.31 -0.21,-0.51 0.06,-0.11 -0.07,-0.14 -0.14,-0.16 0.11,-0.12 0.16,-0.4 -0.07,-0.41 0.05,-0.11 0.06,-0.31 -0.14,-0.22 -0.13,-0.02 -0.28,-0.09 -0.42,-0.1 -0.06,-0.06 -0.07,-0.2 -0.21,-0.13 -0.07,0.05 -0.23,0.07 -0.14,-0.06 0.13,-0.14 -0.04,-0.28 -0.21,-0.22 -0.18,0.07 -0.18,-0.03 -0.18,-0.16 -0.12,-0.09 -0.18,0.21 -0.28,0.03 -0.13,-3.6e-4 -0.19,-0.04 -0.28,-0.1 -0.32,-0.07 -0.51,-0.42 -0.81,-0.51 -0.07,-0.13 -0.3,-0.1 -0.39,-0.22 -0.23,-0.01 -0.49,-0.1 -0.6,-0.29 -0.06,0.02 -0.13,0.17 -0.11,0.03 0.01,-0.04 0.12,-0.17 0,-0.13 z"
					}
				}
			}
		}
	);
})(jQuery);