/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.common.TopicPartition;

public class NoOffsetForPartitionException
extends InvalidOffsetException {
    private static final long serialVersionUID = 1L;
    private final Set<TopicPartition> partitions;

    public NoOffsetForPartitionException(TopicPartition partition) {
        super("Undefined offset with no reset policy for partition: " + String.valueOf(partition));
        this.partitions = Collections.singleton(partition);
    }

    public NoOffsetForPartitionException(Collection<TopicPartition> partitions) {
        super("Undefined offset with no reset policy for partitions: " + String.valueOf(partitions));
        this.partitions = Set.copyOf(partitions);
    }

    @Override
    public Set<TopicPartition> partitions() {
        return this.partitions;
    }
}

