/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NdtpV6ProtocolDecoder
extends BaseProtocolDecoder {
    private static final byte[] SIGNATURE = new byte[]{126, 126};
    private static final int NPL_FLAG_CRC = 2;
    private static final int NPH_RESULT_OK = 0;
    private static final int NPL_TYPE_NPH = 2;
    private static final int NPL_ADDRESS_SERVER = 0;
    private static final int NPH_RESULT = 0;
    private static final int NPH_SRV_GENERIC_CONTROLS = 0;
    private static final int NPH_SRV_NAVDATA = 1;
    private static final int NPH_SGC_RESULT = 0;
    private static final int NPH_SGC_CONN_REQUEST = 100;
    private static final int NPH_SND_RESULT = 0;
    private static final short MAIN_NAV_DATA = 0;
    private static final short ADDITIONAL_NAV_DATA = 2;

    public NdtpV6ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int serviceId, long requestId) {
        ByteBuf content = Unpooled.buffer();
        content.writeShortLE(serviceId);
        content.writeIntLE(0);
        content.writeIntLE((int)requestId);
        content.writeIntLE(0);
        ByteBuf response = Unpooled.buffer();
        response.writeBytes(SIGNATURE);
        response.writeShortLE(content.readableBytes());
        response.writeShortLE(2);
        response.writeShort(Checksum.crc16(Checksum.CRC16_MODBUS, content.nioBuffer()));
        response.writeByte(2);
        response.writeIntLE(0);
        response.writeShortLE(0);
        response.writeBytes(content);
        content.release();
        channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
    }

    private void decodeData(ByteBuf buf, Position position) {
        short itemType = buf.readUnsignedByte();
        short itemIndex = buf.readUnsignedByte();
        if (itemType == 0 && (itemIndex == 0 || itemIndex == 1)) {
            position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
            position.setLongitude((double)buf.readIntLE() / 1.0E7);
            position.setLatitude((double)buf.readIntLE() / 1.0E7);
            short flags = buf.readUnsignedByte();
            position.setValid(BitUtil.check(flags, 7));
            if (BitUtil.check(flags, 1)) {
                position.addAlarm("general");
            }
            position.set("battery", buf.readUnsignedByte() * 20);
            position.set("obdSpeed", buf.readUnsignedShortLE());
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
            position.setCourse(buf.readUnsignedShortLE());
            position.set("odometer", buf.readUnsignedShortLE());
            position.setAltitude(buf.readShortLE());
            position.set("sat", buf.readUnsignedByte());
            position.set("pdop", buf.readUnsignedByte());
        }
        itemType = buf.readUnsignedByte();
        itemIndex = buf.readUnsignedByte();
        if (itemType == 2 && itemIndex == 0) {
            position.set("batteryLevel", Math.max((buf.readUnsignedShortLE() - 3600) / 6, 100));
            position.set("adc2", buf.readUnsignedShortLE());
            position.set("adc3", buf.readUnsignedShortLE());
            position.set("adc4", buf.readUnsignedShortLE());
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            buf.readUnsignedIntLE();
            position.set("antenna", buf.readUnsignedByte());
            position.set("gps", buf.readUnsignedByte());
            position.set("acceleration", buf.readUnsignedByte());
            position.set("power", buf.readUnsignedByte() * 200);
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        buf.skipBytes(2);
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        buf.readUnsignedByte();
        buf.readUnsignedIntLE();
        buf.readUnsignedShortLE();
        int serviceId = buf.readUnsignedShortLE();
        int serviceType = buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        long requestId = buf.readUnsignedIntLE();
        if (deviceSession == null && serviceId == 0 && serviceType == 100) {
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            int deviceId = buf.readUnsignedShortLE();
            Position position = new Position(this.getProtocolName());
            deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(deviceId));
            position.setDeviceId(deviceSession.getDeviceId());
            if (channel != null) {
                this.sendResponse(channel, serviceId, requestId);
            }
            position.set("result", String.valueOf(0));
            position.setTime(new Date());
            this.getLastLocation(position, new Date());
            position.setValid(false);
            return position;
        }
        if (serviceId == 1) {
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            if (channel != null) {
                this.sendResponse(channel, serviceId, requestId);
            }
            this.decodeData(buf, position);
            return position;
        }
        return null;
    }
}

