/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Query;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public abstract class PyLineMarkerNavigator<T extends PsiElement>
implements GutterIconNavigationHandler<T> {
    private static final Key<NavigatablePsiElement[]> MARKERS = new Key("PyLineMarkerNavigatorMarkers");

    public void navigate(MouseEvent e, T elt) {
        ArrayList navElements = new ArrayList();
        Query<PsiElement> elementQuery = this.search(elt, TypeEvalContext.userInitiated((Project)elt.getProject(), (PsiFile)elt.getContainingFile()));
        if (elementQuery == null) {
            return;
        }
        elementQuery.forEach(psiElement -> {
            if (psiElement instanceof NavigatablePsiElement) {
                navElements.add((NavigatablePsiElement)psiElement);
            }
            return true;
        });
        NavigatablePsiElement[] methods = navElements.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            elt.putUserData(MARKERS, (Object)methods);
        } else if (methods.length == 1) {
            methods[0].navigate(true);
        } else {
            Project project = elt.getProject();
            JBPopup popup2 = new PsiTargetNavigator((PsiElement[])methods).createPopup(project, this.getTitle(elt));
            NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup2, (Project)project);
            popup2.show(new RelativePoint(e));
        }
    }

    @TestOnly
    public static NavigatablePsiElement @Nullable [] getNavigationTargets(@NotNull UserDataHolder holder) {
        if (holder == null) {
            PyLineMarkerNavigator.$$$reportNull$$$0(0);
        }
        return (NavigatablePsiElement[])holder.getUserData(MARKERS);
    }

    @NlsContexts.PopupTitle
    protected abstract String getTitle(T var1);

    @Nullable
    protected abstract Query<? extends PsiElement> search(T var1, @NotNull TypeEvalContext var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/codeInsight/PyLineMarkerNavigator", "getNavigationTargets"));
    }
}

