/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 & (~ ivec4(-64, 72, 88, -76))) => ivec4(12, 4, 4, 8)
 * (12 & (~ ivec4(64, 72, 88, 76))) => ivec4(12, 4, 4, 0)
 * (12 & (~ ivec4(-24, 40, -23, 64))) => ivec4(4, 4, 4, 12)
 * (12 & (~ ivec4(24, 40, 23, 64))) => ivec4(4, 4, 8, 12)
 * (-6 & (~ ivec4(-64, 72, 88, -76))) => ivec4(58, -78, -94, 74)
 * (-6 & (~ ivec4(64, 72, 88, 76))) => ivec4(-70, -78, -94, -78)
 * (-6 & (~ ivec4(-24, 40, -23, 64))) => ivec4(18, -46, 18, -70)
 * (-6 & (~ ivec4(24, 40, 23, 64))) => ivec4(-30, -46, -24, -70)
 * (76 & (~ ivec4(-64, 72, 88, -76))) => ivec4(12, 4, 4, 72)
 * (76 & (~ ivec4(64, 72, 88, 76))) => ivec4(12, 4, 4, 0)
 * (76 & (~ ivec4(-24, 40, -23, 64))) => ivec4(4, 68, 4, 12)
 * (76 & (~ ivec4(24, 40, 23, 64))) => ivec4(68, 68, 72, 12)
 * (-32 & (~ ivec4(-64, 72, 88, -76))) => ivec4(32, -96, -96, 64)
 * (-32 & (~ ivec4(64, 72, 88, 76))) => ivec4(-96, -96, -96, -96)
 * (-32 & (~ ivec4(-24, 40, -23, 64))) => ivec4(0, -64, 0, -96)
 * (-32 & (~ ivec4(24, 40, 23, 64))) => ivec4(-32, -64, -32, -96)
 * (0 & (~ ivec4(-64, 72, 88, -76))) => ivec4(0, 0, 0, 0)
 * (0 & (~ ivec4(64, 72, 88, 76))) => ivec4(0, 0, 0, 0)
 * (0 & (~ ivec4(-24, 40, -23, 64))) => ivec4(0, 0, 0, 0)
 * (0 & (~ ivec4(24, 40, 23, 64))) => ivec4(0, 0, 0, 0)
 */
#version 130

void main()
{
  float[all(equal((12 & (~ ivec4(-64, 72, 88, -76))), ivec4(12, 4, 4, 8))) ? 1 : -1] array0;
  float[all(equal((12 & (~ ivec4(64, 72, 88, 76))), ivec4(12, 4, 4, 0))) ? 1 : -1] array1;
  float[all(equal((12 & (~ ivec4(-24, 40, -23, 64))), ivec4(4, 4, 4, 12))) ? 1 : -1] array2;
  float[all(equal((12 & (~ ivec4(24, 40, 23, 64))), ivec4(4, 4, 8, 12))) ? 1 : -1] array3;
  float[all(equal((-6 & (~ ivec4(-64, 72, 88, -76))), ivec4(58, -78, -94, 74))) ? 1 : -1] array4;
  float[all(equal((-6 & (~ ivec4(64, 72, 88, 76))), ivec4(-70, -78, -94, -78))) ? 1 : -1] array5;
  float[all(equal((-6 & (~ ivec4(-24, 40, -23, 64))), ivec4(18, -46, 18, -70))) ? 1 : -1] array6;
  float[all(equal((-6 & (~ ivec4(24, 40, 23, 64))), ivec4(-30, -46, -24, -70))) ? 1 : -1] array7;
  float[all(equal((76 & (~ ivec4(-64, 72, 88, -76))), ivec4(12, 4, 4, 72))) ? 1 : -1] array8;
  float[all(equal((76 & (~ ivec4(64, 72, 88, 76))), ivec4(12, 4, 4, 0))) ? 1 : -1] array9;
  float[all(equal((76 & (~ ivec4(-24, 40, -23, 64))), ivec4(4, 68, 4, 12))) ? 1 : -1] array10;
  float[all(equal((76 & (~ ivec4(24, 40, 23, 64))), ivec4(68, 68, 72, 12))) ? 1 : -1] array11;
  float[all(equal((-32 & (~ ivec4(-64, 72, 88, -76))), ivec4(32, -96, -96, 64))) ? 1 : -1] array12;
  float[all(equal((-32 & (~ ivec4(64, 72, 88, 76))), ivec4(-96, -96, -96, -96))) ? 1 : -1] array13;
  float[all(equal((-32 & (~ ivec4(-24, 40, -23, 64))), ivec4(0, -64, 0, -96))) ? 1 : -1] array14;
  float[all(equal((-32 & (~ ivec4(24, 40, 23, 64))), ivec4(-32, -64, -32, -96))) ? 1 : -1] array15;
  float[all(equal((0 & (~ ivec4(-64, 72, 88, -76))), ivec4(0, 0, 0, 0))) ? 1 : -1] array16;
  float[all(equal((0 & (~ ivec4(64, 72, 88, 76))), ivec4(0, 0, 0, 0))) ? 1 : -1] array17;
  float[all(equal((0 & (~ ivec4(-24, 40, -23, 64))), ivec4(0, 0, 0, 0))) ? 1 : -1] array18;
  float[all(equal((0 & (~ ivec4(24, 40, 23, 64))), ivec4(0, 0, 0, 0))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
