/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;

public class MappingsTraverser {
    private static final Logger log = LogManager.getLogger(MappingsTraverser.class);
    private Map<String, Object> mappingsMap;
    private Set<String> typesToSkip = new HashSet<String>();
    private List<Pair<String, String>> propertiesToSkip = new ArrayList<Pair<String, String>>();
    Stack<Node> nodeStack = new Stack();
    private List<MappingsTraverserListener> mappingsTraverserListeners = new ArrayList<MappingsTraverserListener>();

    public MappingsTraverser(MappingMetadata mappingMetadata) {
        this.mappingsMap = mappingMetadata.getSourceAsMap();
    }

    public MappingsTraverser(Map<String, Object> mappingsMap, Set<String> typesToSkip) {
        this.mappingsMap = mappingsMap;
        for (String typeValue : typesToSkip) {
            this.propertiesToSkip.add((Pair<String, String>)Pair.of((Object)"type", (Object)typeValue));
        }
    }

    public MappingsTraverser(String mappings, Set<String> typesToSkip) throws IOException {
        for (String typeValue : typesToSkip) {
            this.propertiesToSkip.add((Pair<String, String>)Pair.of((Object)"type", (Object)typeValue));
        }
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, mappings);){
            this.mappingsMap = parser.map();
        }
    }

    public MappingsTraverser(String mappings, List<Pair<String, String>> propertiesToSkip) throws IOException {
        this.propertiesToSkip = propertiesToSkip;
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, mappings);){
            this.mappingsMap = parser.map();
        }
    }

    public void addListener(MappingsTraverserListener l) {
        this.mappingsTraverserListeners.add(l);
    }

    public List<String> extractFlatNonAliasFields() {
        final ArrayList<String> flatProperties = new ArrayList<String>();
        this.propertiesToSkip.add((Pair<String, String>)Pair.of((Object)"type", (Object)"alias"));
        this.mappingsTraverserListeners.add(new MappingsTraverserListener(){

            @Override
            public void onLeafVisited(Node node) {
                flatProperties.add(node.currentPath);
            }

            @Override
            public void onError(String error) {
                throw new IllegalArgumentException(error);
            }
        });
        this.traverse();
        return flatProperties;
    }

    public void traverse() {
        try {
            Map rootProperties = (Map)this.mappingsMap.get("properties");
            if (Objects.nonNull(rootProperties)) {
                rootProperties.forEach((k, v) -> this.nodeStack.push(new Node(Map.of(k, v), null, rootProperties, "", "")));
            }
            while (this.nodeStack.size() > 0) {
                Node node = this.nodeStack.pop();
                if (node.isLeaf()) {
                    Object fullPath;
                    Map.Entry<String, Object> elem = node.node.entrySet().iterator().next();
                    Map properties = (Map)elem.getValue();
                    if (this.shouldSkipNode(properties)) continue;
                    node.currentPath = fullPath = (String)fullPath + (((String)(fullPath = node.currentPath)).length() > 0 ? "." + elem.getKey() : elem.getKey());
                    this.notifyLeafVisited(node);
                    continue;
                }
                Map<String, Object> children = node.getChildren();
                String currentNodeName = node.getNodeName();
                children.forEach((k, v) -> {
                    String currentPath = node.currentPath.length() > 0 ? node.currentPath + "." + currentNodeName : currentNodeName;
                    this.nodeStack.push(new Node(Map.of(k, v), node, children, currentNodeName, currentPath));
                });
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error traversing mappings tree", (Throwable)e);
            this.notifyError("Error traversing mappings tree");
        }
    }

    private boolean shouldSkipNode(Map<String, Object> properties) {
        for (Pair<String, String> e : this.propertiesToSkip) {
            String k = (String)e.getKey();
            Object v = e.getValue();
            if (!properties.containsKey(k) || !properties.get(k).equals(v)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> traverseAndCopyWithFilter(final Set<String> nodePathsToCopy) {
        final LinkedHashMap<String, Object> outRoot = new LinkedHashMap<String, Object>(Map.of("properties", new LinkedHashMap()));
        this.addListener(new MappingsTraverserListener(){
            final /* synthetic */ MappingsTraverser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onLeafVisited(Node node) {
                if (!nodePathsToCopy.contains(node.currentPath)) {
                    return;
                }
                ArrayList<Node> nodes = new ArrayList<Node>();
                Node n = node;
                nodes.add(n);
                while (n.parent != null) {
                    n = n.parent;
                    nodes.add(n);
                }
                ListIterator nodesIterator = nodes.listIterator(nodes.size());
                Map outNode = outRoot;
                while (nodesIterator.hasPrevious()) {
                    Node currentNode = (Node)nodesIterator.previous();
                    this.this$0.appendNode(currentNode, outNode, !nodesIterator.hasPrevious());
                    outNode = (Map)((Map)outNode.get("properties")).get(currentNode.getNodeName());
                }
            }

            @Override
            public void onError(String error) {
                throw new IllegalArgumentException("");
            }
        });
        this.traverse();
        return outRoot;
    }

    private void appendNode(Node srcNode, Map<String, Object> dstNode, boolean isSourceLeaf) {
        Map existingProps = (Map)((Map)dstNode.get("properties")).get(srcNode.getNodeName());
        if (existingProps == null) {
            LinkedHashMap<String, LinkedHashMap> newProps;
            LinkedHashMap<String, LinkedHashMap> srcNodeProps = srcNode.getProperties();
            LinkedHashMap<String, LinkedHashMap> linkedHashMap = newProps = isSourceLeaf ? srcNodeProps : new LinkedHashMap<String, LinkedHashMap>();
            if (srcNodeProps.containsKey("type") && srcNodeProps.get("type").equals("nested")) {
                ((Map)dstNode.get("properties")).put(srcNode.getNodeName(), new LinkedHashMap<String, String>(Map.of("properties", newProps, "type", "nested")));
            } else {
                ((Map)dstNode.get("properties")).put(srcNode.getNodeName(), isSourceLeaf ? newProps : new LinkedHashMap<String, LinkedHashMap>(Map.of("properties", newProps)));
            }
        }
    }

    public Map<String, Object> traverseAndCopyAsFlat() {
        final HashMap properties = new HashMap();
        this.addListener(new MappingsTraverserListener(){

            @Override
            public void onLeafVisited(Node node) {
                properties.put(node.currentPath, node.getProperties());
            }

            @Override
            public void onError(String error) {
                throw new IllegalArgumentException("");
            }
        });
        this.traverse();
        return Map.of("properties", properties);
    }

    private void notifyError(String error) {
        this.mappingsTraverserListeners.forEach(e -> e.onError(error));
    }

    private void notifyLeafVisited(Node node) {
        this.mappingsTraverserListeners.forEach(e -> e.onLeafVisited(node));
    }

    public Map<String, Object> getMappingsMap() {
        return this.mappingsMap;
    }

    static class Node {
        Map<String, Object> node;
        Node parent;
        Map<String, Object> properties;
        Map<String, Object> parentProperties;
        String parentKey;
        String currentPath;
        String name;

        public Node(Map<String, Object> node, String currentPath) {
            this.node = node;
            this.currentPath = currentPath;
        }

        public Node(Map<String, Object> node, Node parent, Map<String, Object> parentProperties, String parentKey, String currentPath) {
            this.node = node;
            this.parent = parent;
            this.parentProperties = parentProperties;
            this.currentPath = currentPath;
        }

        public String getNodeName() {
            if (this.name == null) {
                this.name = this.node.entrySet().iterator().next().getKey();
            }
            return this.name;
        }

        public Map<String, Object> getChildren() {
            Map.Entry<String, Object> entry = this.node.entrySet().iterator().next();
            Map properties = (Map)entry.getValue();
            if (properties.containsKey("properties")) {
                return (Map)properties.get("properties");
            }
            if (properties.containsKey("nested")) {
                return (Map)properties.get("nested");
            }
            return null;
        }

        public Map<String, Object> getProperties() {
            if (this.properties == null) {
                this.properties = (Map)this.node.entrySet().iterator().next().getValue();
            }
            return this.properties;
        }

        public boolean isLeaf() {
            Map.Entry<String, Object> entry = this.node.entrySet().iterator().next();
            Map properties = (Map)entry.getValue();
            return !properties.containsKey("properties") && !properties.containsKey("nested");
        }

        public boolean isAlias() {
            if (!this.isLeaf()) {
                return false;
            }
            return this.getProperties().containsKey("type") && this.properties.get("type").equals("alias");
        }
    }

    public static interface MappingsTraverserListener {
        public void onLeafVisited(Node var1);

        public void onError(String var1);
    }
}

