/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.searchrelevance.model.ExperimentVariant;

public class QuerySourceUtil {
    public static final int NUMBER_OF_SUBQUERIES_IN_HYBRID_QUERY = 2;

    public static Map<String, Object> createDefinitionOfTemporarySearchPipeline(ExperimentVariant experimentVariant) {
        Map<String, Object> experimentVariantParameters = experimentVariant.getParameters();
        HashMap<String, Object> normalizationTechniqueConfig = new HashMap<String, Object>(Map.of("technique", experimentVariantParameters.get("normalization")));
        HashMap<String, Object> combinationTechniqueConfig = new HashMap<String, Object>(Map.of("technique", experimentVariantParameters.get("combination")));
        if (Objects.nonNull(experimentVariantParameters.get("weights"))) {
            float[] weights = (float[])experimentVariantParameters.get("weights");
            ArrayList<Double> weightsList = new ArrayList<Double>(weights.length);
            for (float weight : weights) {
                weightsList.add(Double.valueOf(weight));
            }
            combinationTechniqueConfig.put("parameters", new HashMap(Map.of("weights", weightsList)));
        }
        HashMap<String, HashMap<String, Object>> normalizationProcessorConfig = new HashMap<String, HashMap<String, Object>>(Map.of("normalization", normalizationTechniqueConfig, "combination", combinationTechniqueConfig));
        HashMap<String, HashMap<String, HashMap<String, Object>>> phaseProcessorObject = new HashMap<String, HashMap<String, HashMap<String, Object>>>(Map.of("normalization-processor", normalizationProcessorConfig));
        HashMap<String, Object> temporarySearchPipeline = new HashMap<String, Object>();
        temporarySearchPipeline.put("phase_results_processors", List.of(phaseProcessorObject));
        return temporarySearchPipeline;
    }

    public static void validateHybridQuery(Map<String, Object> fullQueryMap) throws IOException {
        if (!fullQueryMap.containsKey("query") || !(fullQueryMap.get("query") instanceof Map)) {
            throw new IllegalArgumentException("search configuration must have at least one query");
        }
        Map queryMap = (Map)fullQueryMap.get("query");
        if (!queryMap.containsKey("hybrid") || !(queryMap.get("hybrid") instanceof Map)) {
            throw new IllegalArgumentException("query in search configuration must be of type hybrid");
        }
        Map hybridMap = (Map)queryMap.get("hybrid");
        if (!hybridMap.containsKey("queries") || !(hybridMap.get("queries") instanceof List)) {
            throw new IllegalArgumentException("hybrid query in search configuration does not have sub-queries");
        }
        List queriesMap = (List)hybridMap.get("queries");
        if (queriesMap.size() != 2) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid hybrid query: expected exactly [%d] sub-queries but found [%d]", 2, queriesMap.size()));
        }
    }
}

