/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.sandbox.search.DocValuesMultiRangeQuery;
import org.apache.lucene.search.ConstantScoreScorerSupplier;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesRangeIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.PriorityQueue;

public class SortedNumericDocValuesMultiRangeQuery
extends Query {
    protected final String fieldName;
    protected final NavigableSet<DocValuesMultiRangeQuery.LongRange> sortedClauses;

    protected SortedNumericDocValuesMultiRangeQuery(String fieldName, List<DocValuesMultiRangeQuery.LongRange> clauses) {
        this.fieldName = fieldName;
        this.sortedClauses = SortedNumericDocValuesMultiRangeQuery.resolveOverlaps(clauses);
    }

    private static NavigableSet<DocValuesMultiRangeQuery.LongRange> resolveOverlaps(Collection<DocValuesMultiRangeQuery.LongRange> clauses) {
        TreeSet<DocValuesMultiRangeQuery.LongRange> sortedClauses = new TreeSet<DocValuesMultiRangeQuery.LongRange>(Comparator.comparing(r -> r.lower));
        PriorityQueue<Edge> heap = new PriorityQueue<Edge>(clauses.size() * 2){

            protected boolean lessThan(Edge a, Edge b) {
                if (a.getValue() < b.getValue()) {
                    return true;
                }
                if (a.getValue() == b.getValue()) {
                    return a.point;
                }
                return false;
            }
        };
        for (DocValuesMultiRangeQuery.LongRange r2 : clauses) {
            long cmp = r2.lower - r2.upper;
            if (cmp == 0L) {
                heap.add((Object)Edge.createPoint(r2));
                continue;
            }
            if (cmp >= 0L) continue;
            heap.add((Object)new Edge(r2, false));
            heap.add((Object)new Edge(r2, true));
        }
        int totalEdges = heap.size();
        int depth = 0;
        Edge started = null;
        for (int i = 0; i < totalEdges; ++i) {
            Edge smallest = (Edge)heap.pop();
            if (depth == 0 && smallest.point) {
                if (i < totalEdges - 1 && smallest.getValue() == ((Edge)heap.top()).getValue()) continue;
                sortedClauses.add(smallest.range);
            }
            if (smallest.point) continue;
            if (!smallest.upper) {
                if (++depth != 1) continue;
                started = smallest;
                continue;
            }
            if (--depth != 0) continue;
            DocValuesMultiRangeQuery.LongRange range = started.range == smallest.range ? smallest.range : new DocValuesMultiRangeQuery.LongRange(started.getValue(), smallest.getValue());
            boolean strictlyIncreasing = sortedClauses.add(range);
            assert (strictlyIncreasing);
            started = null;
        }
        return sortedClauses;
    }

    public String toString(String fld) {
        return (String)(Objects.equals(this.fieldName, fld) ? "" : this.fieldName + ":") + String.valueOf(this.sortedClauses);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new MultiRangeWeight(boost, scoreMode);
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SortedNumericDocValuesMultiRangeQuery that = (SortedNumericDocValuesMultiRangeQuery)((Object)o);
        return Objects.equals(this.fieldName, that.fieldName) && this.upperBoundWiseEquals(this.sortedClauses, that.sortedClauses);
    }

    private boolean upperBoundWiseEquals(NavigableSet<DocValuesMultiRangeQuery.LongRange> left, NavigableSet<DocValuesMultiRangeQuery.LongRange> right) {
        Iterator<DocValuesMultiRangeQuery.LongRange> li = left.iterator();
        Iterator<DocValuesMultiRangeQuery.LongRange> ri = right.iterator();
        while (li.hasNext() && ri.hasNext()) {
            if (li.next().equals(ri.next()) && li.hasNext() == ri.hasNext()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.sortedClauses);
    }

    private static final class Edge {
        private final DocValuesMultiRangeQuery.LongRange range;
        private final boolean point;
        private final boolean upper;

        private static Edge createPoint(DocValuesMultiRangeQuery.LongRange r) {
            return new Edge(r);
        }

        long getValue() {
            return this.upper ? this.range.upper : this.range.lower;
        }

        private Edge(DocValuesMultiRangeQuery.LongRange range, boolean upper) {
            this.range = range;
            this.upper = upper;
            this.point = false;
        }

        private Edge(DocValuesMultiRangeQuery.LongRange range) {
            this.range = range;
            this.upper = false;
            this.point = true;
        }
    }

    protected class MultiRangeWeight
    extends ConstantScoreWeight {
        final ScoreMode scoreMode;

        public MultiRangeWeight(float boost, ScoreMode scoreMode) {
            super((Query)SortedNumericDocValuesMultiRangeQuery.this, boost);
            this.scoreMode = scoreMode;
        }

        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            if (context.reader().getFieldInfos().fieldInfo(SortedNumericDocValuesMultiRangeQuery.this.fieldName) == null) {
                return null;
            }
            final long lowerValue = ((DocValuesMultiRangeQuery.LongRange)SortedNumericDocValuesMultiRangeQuery.this.sortedClauses.getFirst()).lower;
            final long upperValue = ((DocValuesMultiRangeQuery.LongRange)SortedNumericDocValuesMultiRangeQuery.this.sortedClauses.getLast()).upper;
            int maxDoc = context.reader().maxDoc();
            DocValuesSkipper skipper = context.reader().getDocValuesSkipper(SortedNumericDocValuesMultiRangeQuery.this.fieldName);
            if (skipper != null && (skipper.minValue() > upperValue || skipper.maxValue() < lowerValue)) {
                return null;
            }
            final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)SortedNumericDocValuesMultiRangeQuery.this.fieldName);
            TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)values){
                final DocValuesMultiRangeQuery.LongRange lookupVal;
                {
                    super(arg0);
                    this.lookupVal = new DocValuesMultiRangeQuery.LongRange(-9223372036854775807L, -9223372036854775807L);
                }

                public boolean matches() throws IOException {
                    NavigableSet<DocValuesMultiRangeQuery.LongRange> rangeTree = SortedNumericDocValuesMultiRangeQuery.this.sortedClauses;
                    int count = values.docValueCount();
                    for (int i = 0; i < count; ++i) {
                        long value = values.nextValue();
                        if (value < lowerValue || value > upperValue) continue;
                        this.lookupVal.lower = value;
                        this.lookupVal.upper = value;
                        DocValuesMultiRangeQuery.LongRange lessOrEq = rangeTree.floor(this.lookupVal);
                        if (lessOrEq == null) continue;
                        if (lessOrEq.upper >= value) {
                            assert (lessOrEq.lower <= value);
                            return true;
                        }
                        assert (lessOrEq.upper < value) : "always true. prev range is over before the value";
                        if (i >= count - 1) continue;
                        rangeTree = rangeTree.tailSet(lessOrEq, false);
                    }
                    return false;
                }

                public float matchCost() {
                    return SortedNumericDocValuesMultiRangeQuery.this.sortedClauses.size();
                }
            };
            if (skipper != null) {
                iterator = new DocValuesRangeIterator(iterator, skipper, lowerValue, upperValue, SortedNumericDocValuesMultiRangeQuery.this.sortedClauses.size() > 1);
            }
            return ConstantScoreScorerSupplier.fromIterator((DocIdSetIterator)TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)iterator), (float)this.score(), (ScoreMode)this.scoreMode, (int)maxDoc);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{SortedNumericDocValuesMultiRangeQuery.this.fieldName});
        }
    }
}

