/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.configuration.SecurityConfigVersionDocument;
import org.opensearch.security.configuration.SecurityConfigVersionsLoader;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.threadpool.ThreadPool;

public class ViewVersionApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(ViewVersionApiAction.class);
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/versions"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/version/{versionID}")));
    private final SecurityConfigVersionsLoader versionsLoader;

    public ViewVersionApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies, SecurityConfigVersionsLoader versionsLoader) {
        super(Endpoint.VIEW_VERSION, clusterService, threadPool, securityApiDependencies);
        this.versionsLoader = versionsLoader;
        this.requestHandlersBuilder.allMethodsNotImplemented().onJsonContentGetRequest((CheckedFunction<RestRequest, ValidationResult<ToXContent>, IOException>)((CheckedFunction)restRequest -> {
            String versionParam = restRequest.param("versionID");
            return this.handleGetRequest(versionParam);
        }));
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType<?> getConfigType() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ValidationResult<ToXContent> handleGetRequest(String versionParam) throws IOException {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            SecurityConfigVersionDocument doc = this.versionsLoader.loadFullDocument();
            if (versionParam == null) {
                ValidationResult<ToXContent> validationResult2 = this.viewAllVersions(doc);
                return validationResult2;
            }
            ValidationResult<ToXContent> validationResult = this.viewSpecificVersion(doc, versionParam);
            return validationResult;
        }
        catch (Exception e) {
            return ValidationResult.error(RestStatus.INTERNAL_SERVER_ERROR, Responses.payload(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
        }
    }

    private ValidationResult<ToXContent> viewAllVersions(SecurityConfigVersionDocument doc) throws IOException {
        return ValidationResult.success(Responses.payload(this.buildVersionsJsonBuilder(doc.getVersions())));
    }

    private ValidationResult<ToXContent> viewSpecificVersion(SecurityConfigVersionDocument doc, String versionId) throws IOException {
        Optional<SecurityConfigVersionDocument.Version> versionSpecificDoc = doc.getVersions().stream().filter(v -> versionId.equals(v.getVersion_id())).findFirst();
        if (versionSpecificDoc.isEmpty()) {
            return ValidationResult.error(RestStatus.NOT_FOUND, Responses.payload(RestStatus.NOT_FOUND, "Version " + versionId + " not found"));
        }
        return ValidationResult.success(Responses.payload(this.buildVersionsJsonBuilder(List.of(versionSpecificDoc.get()))));
    }

    private XContentBuilder buildVersionsJsonBuilder(List<SecurityConfigVersionDocument.Version<?>> versions) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
        builder.startObject();
        builder.startArray("versions");
        for (SecurityConfigVersionDocument.Version<?> ver : versions) {
            builder.startObject();
            builder.field("version_id", ver.getVersion_id());
            builder.field("timestamp", ver.getTimestamp());
            builder.field("modified_by", ver.getModified_by());
            builder.field("security_configs");
            LinkedHashMap plainConfigs = new LinkedHashMap();
            for (Map.Entry<String, SecurityConfigVersionDocument.HistoricSecurityConfig<?>> entry : ver.getSecurity_configs().entrySet()) {
                LinkedHashMap<String, Object> securityConfigMap = new LinkedHashMap<String, Object>();
                securityConfigMap.put("lastUpdated", entry.getValue().getLastUpdated());
                securityConfigMap.put("configData", entry.getValue().getConfigData());
                plainConfigs.put(entry.getKey(), securityConfigMap);
            }
            builder.map(plainConfigs);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("versionID");
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return ViewVersionApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return ViewVersionApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigLoad(SecurityConfiguration securityConfiguration) {
                return ValidationResult.success(securityConfiguration);
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigDelete(SecurityConfiguration securityConfiguration) {
                return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Delete not supported for version view"));
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigChange(SecurityConfiguration securityConfiguration) {
                return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Change not supported for version view"));
            }

            @Override
            public RequestContentValidator createRequestContentValidator(Object ... params) {
                return RequestContentValidator.NOOP_VALIDATOR;
            }
        };
    }
}

