/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ltr;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ltr.CacheStats;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeStats> {
    @Nullable
    private final CacheStats cache;
    @Nullable
    private final Integer requestErrorCount;
    @Nullable
    private final Integer requestTotalCount;
    public static final JsonpDeserializer<NodeStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeStats::setupNodeStatsDeserializer);

    private NodeStats(Builder builder) {
        this.cache = builder.cache;
        this.requestErrorCount = builder.requestErrorCount;
        this.requestTotalCount = builder.requestTotalCount;
    }

    public static NodeStats of(Function<Builder, ObjectBuilder<NodeStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final CacheStats cache() {
        return this.cache;
    }

    @Nullable
    public final Integer requestErrorCount() {
        return this.requestErrorCount;
    }

    @Nullable
    public final Integer requestTotalCount() {
        return this.requestTotalCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cache != null) {
            generator.writeKey("cache");
            this.cache.serialize(generator, mapper);
        }
        if (this.requestErrorCount != null) {
            generator.writeKey("request_error_count");
            generator.write(this.requestErrorCount.intValue());
        }
        if (this.requestTotalCount != null) {
            generator.writeKey("request_total_count");
            generator.write(this.requestTotalCount.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cache, CacheStats._DESERIALIZER, "cache");
        op.add(Builder::requestErrorCount, JsonpDeserializer.integerDeserializer(), "request_error_count");
        op.add(Builder::requestTotalCount, JsonpDeserializer.integerDeserializer(), "request_total_count");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.cache);
        result = 31 * result + Objects.hashCode(this.requestErrorCount);
        result = 31 * result + Objects.hashCode(this.requestTotalCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStats other = (NodeStats)o;
        return Objects.equals(this.cache, other.cache) && Objects.equals(this.requestErrorCount, other.requestErrorCount) && Objects.equals(this.requestTotalCount, other.requestTotalCount);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeStats> {
        @Nullable
        private CacheStats cache;
        @Nullable
        private Integer requestErrorCount;
        @Nullable
        private Integer requestTotalCount;

        public Builder() {
        }

        private Builder(NodeStats o) {
            this.cache = o.cache;
            this.requestErrorCount = o.requestErrorCount;
            this.requestTotalCount = o.requestTotalCount;
        }

        private Builder(Builder o) {
            this.cache = o.cache;
            this.requestErrorCount = o.requestErrorCount;
            this.requestTotalCount = o.requestTotalCount;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder cache(@Nullable CacheStats value) {
            this.cache = value;
            return this;
        }

        @Nonnull
        public final Builder cache(Function<CacheStats.Builder, ObjectBuilder<CacheStats>> fn) {
            return this.cache(fn.apply(new CacheStats.Builder()).build());
        }

        @Nonnull
        public final Builder requestErrorCount(@Nullable Integer value) {
            this.requestErrorCount = value;
            return this;
        }

        @Nonnull
        public final Builder requestTotalCount(@Nullable Integer value) {
            this.requestTotalCount = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeStats build() {
            this._checkSingleUse();
            return new NodeStats(this);
        }
    }
}

