/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdDictDecompress;
import java.io.IOException;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99CustomCodec;

public class ZstdCompressionMode
extends CompressionMode {
    private static final int NUM_SUB_BLOCKS = 10;
    private static final int DICT_SIZE_FACTOR = 6;
    private final int compressionLevel;

    protected ZstdCompressionMode() {
        this.compressionLevel = Lucene99CustomCodec.DEFAULT_COMPRESSION_LEVEL;
    }

    protected ZstdCompressionMode(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public Compressor newCompressor() {
        return new ZstdCompressor(this.compressionLevel);
    }

    public Decompressor newDecompressor() {
        return new ZstdDecompressor();
    }

    private static final class ZstdCompressor
    extends Compressor {
        private final int compressionLevel;
        private byte[] compressedBuffer;

        public ZstdCompressor(int compressionLevel) {
            this.compressionLevel = compressionLevel;
            this.compressedBuffer = BytesRef.EMPTY_BYTES;
        }

        private void doCompress(byte[] bytes, int offset, int length, ZstdCompressCtx cctx, DataOutput out) throws IOException {
            if (length == 0) {
                out.writeVInt(0);
                return;
            }
            int maxCompressedLength = (int)Zstd.compressBound((long)length);
            this.compressedBuffer = ArrayUtil.growNoCopy((byte[])this.compressedBuffer, (int)maxCompressedLength);
            int compressedSize = cctx.compressByteArray(this.compressedBuffer, 0, this.compressedBuffer.length, bytes, offset, length);
            out.writeVInt(compressedSize);
            out.writeBytes(this.compressedBuffer, compressedSize);
        }

        private void compress(byte[] bytes, int offset, int length, DataOutput out) throws IOException {
            assert (offset >= 0) : "offset value must be greater than 0";
            int dictLength = length / 60;
            int blockLength = (length - dictLength + 10 - 1) / 10;
            out.writeVInt(dictLength);
            out.writeVInt(blockLength);
            int end = offset + length;
            assert (end >= 0) : "buffer read size must be greater than 0";
            try (ZstdCompressCtx cctx = new ZstdCompressCtx();){
                cctx.setLevel(this.compressionLevel);
                this.doCompress(bytes, offset, dictLength, cctx, out);
                try (ZstdDictCompress dictCompress = new ZstdDictCompress(bytes, offset, dictLength, this.compressionLevel);){
                    cctx.loadDict(dictCompress);
                    for (int start = offset + dictLength; start < end; start += blockLength) {
                        int l = Math.min(blockLength, end - start);
                        this.doCompress(bytes, start, l, cctx, out);
                    }
                }
            }
        }

        public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
            int length = (int)buffersInput.length();
            byte[] bytes = new byte[length];
            buffersInput.readBytes(bytes, 0, length);
            this.compress(bytes, 0, length, out);
        }

        public void close() throws IOException {
        }
    }

    private static final class ZstdDecompressor
    extends Decompressor {
        private byte[] compressedBuffer = BytesRef.EMPTY_BYTES;

        private void doDecompress(DataInput in, ZstdDecompressCtx dctx, BytesRef bytes, int decompressedLen) throws IOException {
            int compressedLength = in.readVInt();
            if (compressedLength == 0) {
                return;
            }
            this.compressedBuffer = ArrayUtil.growNoCopy((byte[])this.compressedBuffer, (int)compressedLength);
            in.readBytes(this.compressedBuffer, 0, compressedLength);
            bytes.bytes = ArrayUtil.grow((byte[])bytes.bytes, (int)(bytes.length + decompressedLen));
            int uncompressed = dctx.decompressByteArray(bytes.bytes, bytes.length, decompressedLen, this.compressedBuffer, 0, compressedLength);
            if (decompressedLen != uncompressed) {
                throw new IllegalStateException(decompressedLen + " " + uncompressed);
            }
            bytes.length += uncompressed;
        }

        public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
            assert (offset + length <= originalLength) : "buffer read size must be within limit";
            if (length == 0) {
                bytes.length = 0;
                return;
            }
            int dictLength = in.readVInt();
            int blockLength = in.readVInt();
            bytes.bytes = ArrayUtil.growNoCopy((byte[])bytes.bytes, (int)dictLength);
            bytes.length = 0;
            bytes.offset = 0;
            try (ZstdDecompressCtx dctx = new ZstdDecompressCtx();){
                this.doDecompress(in, dctx, bytes, dictLength);
                try (ZstdDictDecompress dictDecompress = new ZstdDictDecompress(bytes.bytes, 0, dictLength);){
                    dctx.loadDict(dictDecompress);
                    int offsetInBlock = dictLength;
                    int offsetInBytesRef = offset;
                    while (offsetInBlock + blockLength < offset) {
                        int compressedLength = in.readVInt();
                        in.skipBytes((long)compressedLength);
                        offsetInBlock += blockLength;
                        offsetInBytesRef -= blockLength;
                    }
                    while (offsetInBlock < offset + length) {
                        int l = Math.min(blockLength, originalLength - offsetInBlock);
                        this.doDecompress(in, dctx, bytes, l);
                        offsetInBlock += blockLength;
                    }
                    bytes.offset = offsetInBytesRef;
                    bytes.length = length;
                    assert (bytes.isValid()) : "decompression output is corrupted";
                }
            }
        }

        public Decompressor clone() {
            return new ZstdDecompressor();
        }
    }
}

