/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentInitiator;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class JdbcServicesImpl
implements JdbcServices,
ServiceRegistryAwareService,
Configurable {
    private ServiceRegistryImplementor serviceRegistry;
    private JdbcEnvironment jdbcEnvironment;
    private SqlStatementLogger sqlStatementLogger;
    private ParameterMarkerStrategy parameterMarkerStrategy;

    public JdbcServicesImpl() {
    }

    public JdbcServicesImpl(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void configure(Map<String, Object> configValues) {
        this.jdbcEnvironment = this.serviceRegistry.requireService(JdbcEnvironment.class);
        this.sqlStatementLogger = this.serviceRegistry.getService(SqlStatementLogger.class);
        this.parameterMarkerStrategy = this.serviceRegistry.getService(ParameterMarkerStrategy.class);
    }

    @Override
    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    @Override
    public JdbcConnectionAccess getBootstrapJdbcConnectionAccess() {
        return JdbcEnvironmentInitiator.buildBootstrapJdbcConnectionAccess(this.serviceRegistry);
    }

    @Override
    public Dialect getDialect() {
        if (this.jdbcEnvironment != null) {
            return this.jdbcEnvironment.getDialect();
        }
        return null;
    }

    @Override
    public SqlStatementLogger getSqlStatementLogger() {
        return this.sqlStatementLogger;
    }

    @Override
    public ParameterMarkerStrategy getParameterMarkerStrategy() {
        return this.parameterMarkerStrategy;
    }

    @Override
    public SqlExceptionHelper getSqlExceptionHelper() {
        assert (this.jdbcEnvironment != null) : "JdbcEnvironment was not found";
        return this.jdbcEnvironment.getSqlExceptionHelper();
    }

    @Override
    public ExtractedDatabaseMetaData getExtractedMetaDataSupport() {
        assert (this.jdbcEnvironment != null) : "JdbcEnvironment was not found";
        return this.jdbcEnvironment.getExtractedDatabaseMetaData();
    }

    @Override
    public LobCreator getLobCreator(LobCreationContext lobCreationContext) {
        assert (this.jdbcEnvironment != null) : "JdbcEnvironment was not found";
        return this.jdbcEnvironment.getLobCreatorBuilder().buildLobCreator(lobCreationContext);
    }
}

