/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java2d.DemoGroup;
import java2d.DemoInstVarsAccessor;
import java2d.DemoPanel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;

public final class CloningFeature
extends JPanel
implements Runnable {
    private final DemoInstVarsAccessor demoInstVars;
    private Thread thread;
    private JTextArea ta;

    public CloningFeature(DemoInstVarsAccessor demoInstVars) {
        this.demoInstVars = demoInstVars;
        this.setLayout(new BorderLayout());
        EmptyBorder eb = new EmptyBorder(5, 5, 5, 5);
        SoftBevelBorder sbb = new SoftBevelBorder(0);
        this.setBorder(new CompoundBorder(eb, sbb));
        this.ta = new JTextArea("Cloning Demonstrated\n\nClicking once on a demo\n");
        this.ta.setMinimumSize(new Dimension(300, 500));
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.ta);
        this.ta.setFont(new Font("Dialog", 0, 14));
        this.ta.setForeground(Color.black);
        this.ta.setBackground(Color.lightGray);
        this.ta.setEditable(false);
        this.add("Center", scroller);
        this.start();
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(10);
        this.thread.setName("CloningFeature");
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    @Override
    public void run() {
        int index = this.demoInstVars.getTabbedPane().getSelectedIndex();
        if (index == 0) {
            this.demoInstVars.getTabbedPane().setSelectedIndex(1);
            try {
                Thread.sleep(3333L);
            }
            catch (Exception e) {
                return;
            }
        }
        if (!this.demoInstVars.getControls().toolBarCB.isSelected()) {
            this.demoInstVars.getControls().toolBarCB.setSelected(true);
            try {
                Thread.sleep(2222L);
            }
            catch (Exception e) {
                return;
            }
        }
        index = this.demoInstVars.getTabbedPane().getSelectedIndex() - 1;
        DemoGroup dg = this.demoInstVars.getGroup()[index];
        DemoPanel dp = (DemoPanel)dg.getPanel().getComponent(0);
        if (dp.surface == null) {
            this.ta.append("Sorry your zeroth component is not a Surface.");
            return;
        }
        dg.mouseClicked(dp.surface);
        try {
            Thread.sleep(3333L);
        }
        catch (Exception e) {
            return;
        }
        this.ta.append("Clicking the ToolBar double document button\n");
        try {
            Thread.sleep(3333L);
        }
        catch (Exception e) {
            return;
        }
        dp = (DemoPanel)dg.clonePanels[0].getComponent(0);
        if (dp.tools != null) {
            for (int i = 0; i < 3 && this.thread != null; ++i) {
                this.ta.append("   Cloning\n");
                dp.tools.cloneB.doClick();
                try {
                    Thread.sleep(3333L);
                    continue;
                }
                catch (Exception e) {
                    return;
                }
            }
        }
        this.ta.append("Changing attributes \n");
        try {
            Thread.sleep(3333L);
        }
        catch (Exception e) {
            return;
        }
        Component[] cmps = dg.clonePanels[0].getComponents();
        for (int i = 0; i < cmps.length && this.thread != null; ++i) {
            dp = (DemoPanel)cmps[i];
            if (dp.tools == null) continue;
            switch (i) {
                case 0: {
                    this.ta.append("   Changing AntiAliasing\n");
                    dp.tools.aliasB.doClick();
                    break;
                }
                case 1: {
                    this.ta.append("   Changing Composite & Texture\n");
                    dp.tools.compositeB.doClick();
                    dp.tools.textureB.doClick();
                    break;
                }
                case 2: {
                    this.ta.append("   Changing Screen\n");
                    dp.tools.screenCombo.setSelectedIndex(4);
                    break;
                }
                case 3: {
                    this.ta.append("   Removing a clone\n");
                    dp.tools.cloneB.doClick();
                }
            }
            try {
                Thread.sleep(3333L);
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
        this.ta.append("\nAll Done!");
    }
}

