/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.wrappers;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SP80038FWrapWithPaddingEngine
extends SP80038FWrapper {
    public SP80038FWrapWithPaddingEngine(BlockCipher blockCipher, boolean bl) {
        super(blockCipher, ivKWP, bl);
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KWP";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n3 = (n2 + 7) / 8;
        int n4 = n3 * 8 - n2;
        byte[] byArray2 = new byte[n2 + this.iv.length + 4 + n4];
        byte[] byArray3 = Pack.intToBigEndian(n2);
        System.arraycopy(this.iv, 0, byArray2, 0, this.iv.length);
        System.arraycopy(byArray3, 0, byArray2, this.iv.length, byArray3.length);
        System.arraycopy(byArray, n, byArray2, this.iv.length + 4, n2);
        if (n3 == 1) {
            this.engine.init(this.wrapCipherMode, this.param);
            this.engine.processBlock(byArray2, 0, byArray2, 0);
            return byArray2;
        }
        return this.W(n3, byArray2);
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2;
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n3 = n2 / 8;
        if (n3 * 8 != n2) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] byArray3 = new byte[this.iv.length + 4];
        byte[] byArray4 = new byte[n2 - byArray3.length];
        if (n3 == 2) {
            byArray2 = new byte[this.engine.getBlockSize()];
            this.engine.init(!this.wrapCipherMode, this.param);
            this.engine.processBlock(byArray, n, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            System.arraycopy(byArray2, byArray3.length, byArray4, 0, byArray4.length);
        } else {
            System.arraycopy(byArray, n, byArray3, 0, byArray3.length);
            System.arraycopy(byArray, n + byArray3.length, byArray4, 0, n2 - byArray3.length);
            this.invW(n3, byArray4, byArray3);
        }
        byArray2 = new byte[this.iv.length];
        System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        int n4 = Pack.bigEndianToInt(byArray3, 4);
        int n5 = 8 * (n3 - 1) - n4;
        if (!Arrays.constantTimeAreEqual(byArray2, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        if (n5 < 0 || n5 > 7) {
            throw new InvalidCipherTextException("unwrap data has incorrect padding length");
        }
        byte[] byArray5 = new byte[n4];
        System.arraycopy(byArray4, 0, byArray5, 0, n4);
        boolean bl = false;
        for (int i = 1; i <= n5; ++i) {
            if (byArray4[byArray4.length - i] == 0) continue;
            bl = true;
        }
        if (bl) {
            throw new InvalidCipherTextException("unwrap data has incorrect padding");
        }
        return byArray5;
    }
}

