/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.format.Formatter;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatsType;

public class StatsCollectorFormatter
implements Formatter {
    private StringBuilder metricsBuilder;
    private Map<String, Double> latencyMap = new HashMap<String, Double>();
    private String sep = "";
    long startTime;
    long endTime;

    public StatsCollectorFormatter() {
        this.metricsBuilder = new StringBuilder();
        this.latencyMap.clear();
    }

    private void format(MeasurementSet measurementSet, Statistics aggregationType, String name, Number value) {
        if (Objects.equals((Object)measurementSet.getStatsType(), (Object)StatsType.LATENCIES)) {
            this.latencyMap.put(measurementSet.getName(), value.doubleValue());
        } else {
            this.formatStat(this.metricsBuilder, measurementSet, aggregationType, name, value);
        }
    }

    private void formatStat(StringBuilder metricsBuilder, MeasurementSet measurementSet, Statistics aggregationType, String name, Number value) {
        metricsBuilder.append(this.sep);
        metricsBuilder.append(measurementSet.getName()).append("=").append(value);
        if (!measurementSet.getUnit().isEmpty()) {
            metricsBuilder.append(" ").append(measurementSet.getUnit());
        }
        metricsBuilder.append(" ").append("aggr|").append((Object)aggregationType);
        if (!name.isEmpty()) {
            metricsBuilder.append(" ").append("key|").append(name);
        }
        this.sep = ",";
    }

    @Override
    public void formatNamedAggregatedValue(MeasurementSet measurementSet, Statistics aggregationType, String name, Number value) {
        this.format(measurementSet, aggregationType, name, value);
    }

    @Override
    public void formatAggregatedValue(MeasurementSet measurementSet, Statistics aggregationType, Number value) {
        this.format(measurementSet, aggregationType, "", value);
    }

    @Override
    public void setStartAndEndTime(long start, long end) {
        this.startTime = start;
        this.endTime = end;
    }

    public List<StatsCollectorReturn> getAllMetrics() {
        ArrayList<StatsCollectorReturn> list = new ArrayList<StatsCollectorReturn>();
        StatsCollectorReturn statsCollectorReturn = new StatsCollectorReturn(this.startTime, this.endTime);
        statsCollectorReturn.statsdata.put("Metrics", this.metricsBuilder.toString());
        statsCollectorReturn.latencies = new HashMap<String, Double>(this.latencyMap);
        list.add(statsCollectorReturn);
        return list;
    }

    public static class StatsCollectorReturn {
        private Map<String, String> statsdata = new HashMap<String, String>();
        private Map<String, Double> latencies = new HashMap<String, Double>();
        private long startTimeMillis;
        private long endTimeMillis;

        public StatsCollectorReturn(long startTimeMillis, long endTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            this.endTimeMillis = endTimeMillis;
        }

        public Map<String, String> getStatsdata() {
            return this.statsdata;
        }

        public Map<String, Double> getLatencies() {
            return this.latencies;
        }

        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        public long getEndTimeMillis() {
            return this.endTimeMillis;
        }

        public boolean isEmpty() {
            return this.statsdata.isEmpty() && this.latencies.isEmpty();
        }
    }
}

