/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.parser;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class ValidationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ObjectType type;
    private final @Nullable String uid;

    public ValidationException(ObjectType type, @Nullable String uid, @Nullable String message) {
        super(message);
        this.type = type;
        this.uid = uid;
    }

    public ValidationException(ObjectType type, @Nullable String uid, @Nullable Throwable cause) {
        super(cause);
        this.type = type;
        this.uid = uid;
    }

    public ValidationException(ObjectType type, @Nullable String uid, @Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
        this.type = type;
        this.uid = uid;
    }

    public ValidationException(ObjectType type, @Nullable String uid, @Nullable String message, @Nullable Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.type = type;
        this.uid = uid;
    }

    @Override
    public @Nullable String getMessage() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case MODULE_TYPE: {
                sb.append("[Module Type");
                break;
            }
            case TEMPLATE: {
                sb.append("[Template");
                break;
            }
            case RULE: {
                sb.append("[Rule");
                break;
            }
        }
        if (this.uid != null) {
            sb.append(' ').append(this.uid);
        }
        sb.append("] ").append(super.getMessage());
        return sb.toString();
    }

    public static enum ObjectType {
        MODULE_TYPE,
        TEMPLATE,
        RULE;

    }
}

