/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.geoip;

import com.maxmind.db.CHMCache;
import com.maxmind.db.InvalidDatabaseException;
import com.maxmind.db.Network;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.model.IspResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.Event;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.filters.geoip.Database;
import org.logstash.filters.geoip.Field;

public class GeoIPFilter
implements Closeable {
    private static final Logger logger = LogManager.getLogger();
    private final String sourceField;
    private final String targetField;
    private final Set<Field> desiredFields;
    private final Database database;
    private final DatabaseReader databaseReader;
    private final Function<Field, String> fieldReferenceExtractor;

    public GeoIPFilter(String sourceField, String targetField, List<String> fields, String databasePath, int cacheSize, String ecsCompatibility) {
        this.sourceField = sourceField;
        this.targetField = targetField;
        switch (ecsCompatibility) {
            case "disabled": {
                this.fieldReferenceExtractor = Field::getFieldReferenceLegacy;
                break;
            }
            case "v1": 
            case "v8": {
                this.fieldReferenceExtractor = Field::getFieldReferenceECSv1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown ECS version " + ecsCompatibility);
            }
        }
        File databaseFile = new File(databasePath);
        try {
            this.databaseReader = new DatabaseReader.Builder(databaseFile).withCache((NodeCache)new CHMCache(cacheSize)).build();
        }
        catch (InvalidDatabaseException e) {
            throw new IllegalArgumentException("The database provided is invalid or corrupted.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The database provided was not found in the path", e);
        }
        this.database = GeoIPFilter.getDatabase(this.databaseReader);
        this.desiredFields = this.createDesiredFields(fields, !ecsCompatibility.equals("disabled"));
    }

    private static Database getDatabase(DatabaseReader reader) {
        String databaseType = reader.getMetadata().getDatabaseType();
        Database database = Database.fromDatabaseType(databaseType);
        if (database == Database.UNKNOWN) {
            logger.warn("The provided database type {} is not supported", (Object)databaseType);
        }
        return database;
    }

    public static boolean isDatabaseValid(String databasePath) {
        block10: {
            boolean bl;
            block9: {
                File database = new File(databasePath);
                DatabaseReader ignore = new DatabaseReader.Builder(database).build();
                try {
                    bl = true;
                    if (ignore == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidDatabaseException e) {
                        logger.debug("The database provided is invalid or corrupted");
                        break block10;
                    }
                    catch (IOException e) {
                        logger.debug("The database provided was not found in the path");
                    }
                }
                ignore.close();
            }
            return bl;
        }
        return false;
    }

    private Set<Field> createDesiredFields(List<String> fields, boolean ecsCompatibilityEnabled) {
        if (fields != null && !fields.isEmpty()) {
            return fields.stream().map(Field::parseField).collect(Collectors.toCollection(() -> EnumSet.noneOf(Field.class)));
        }
        if (this.database == Database.CITY) {
            return this.createCityDefaultFields(ecsCompatibilityEnabled);
        }
        return this.database.getDefaultFields();
    }

    private Set<Field> createCityDefaultFields(boolean ecsCompatibilityEnabled) {
        if (!ecsCompatibilityEnabled) {
            EnumSet<Field> ecsDisabledFields = EnumSet.copyOf(this.database.getDefaultFields());
            ecsDisabledFields.remove((Object)Field.REGION_ISO_CODE);
            ecsDisabledFields.add(Field.REGION_CODE);
            return ecsDisabledFields;
        }
        return this.database.getDefaultFields();
    }

    public boolean handleEvent(JrubyEventExtLibrary.RubyEvent rubyEvent) {
        String ip;
        Event event = rubyEvent.getEvent();
        Object input = event.getField(this.sourceField);
        if (input == null) {
            return false;
        }
        if (input instanceof List) {
            ip = (String)((List)input).get(0);
        } else if (input instanceof String) {
            ip = (String)input;
        } else {
            throw new IllegalArgumentException("Expected input field value to be String or List type");
        }
        if (ip.trim().isEmpty()) {
            return false;
        }
        Map<Field, Object> geoData = new HashMap<Field, Object>();
        try {
            InetAddress ipAddress = InetAddress.getByName(ip);
            switch (this.database) {
                case CITY: {
                    geoData = this.retrieveCityGeoData(ipAddress);
                    break;
                }
                case COUNTRY: {
                    geoData = this.retrieveCountryGeoData(ipAddress);
                    break;
                }
                case ASN: {
                    geoData = this.retrieveAsnGeoData(ipAddress);
                    break;
                }
                case ISP: {
                    geoData = this.retrieveIspGeoData(ipAddress);
                    break;
                }
                case DOMAIN: {
                    geoData = this.retrieveDomainGeoData(ipAddress);
                    break;
                }
                case ENTERPRISE: {
                    geoData = this.retrieveEnterpriseGeoData(ipAddress);
                    break;
                }
                case ANONYMOUS_IP: {
                    geoData = this.retrieveAnonymousIpGeoData(ipAddress);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported database type " + this.databaseReader.getMetadata().getDatabaseType() + "");
                }
            }
        }
        catch (UnknownHostException e) {
            logger.debug("IP Field contained invalid IP address or hostname. exception={}, field={}, event={}", (Object)e, (Object)this.sourceField, (Object)event);
        }
        catch (AddressNotFoundException e) {
            logger.debug("IP not found! exception={}, field={}, event={}", (Object)e, (Object)this.sourceField, (Object)event);
        }
        catch (GeoIp2Exception | IOException e) {
            logger.error("Error from GeoIP database. field={}, value={}", (Object)this.sourceField, (Object)ip, (Object)e);
        }
        return this.applyGeoData(geoData, event);
    }

    private boolean applyGeoData(Map<Field, Object> geoData, Event event) {
        if (geoData == null) {
            return false;
        }
        if (event.getField(this.targetField) == null) {
            event.setField(this.targetField, Collections.emptyMap());
        }
        if (geoData.isEmpty()) {
            return false;
        }
        String targetFieldReference = "[" + this.targetField + "]";
        for (Map.Entry<Field, Object> it : geoData.entrySet()) {
            Field field = it.getKey();
            String subFieldReference = this.fieldReferenceExtractor.apply(field);
            if (subFieldReference.equals("[]")) continue;
            event.setField(targetFieldReference + subFieldReference, it.getValue());
        }
        return true;
    }

    private Map<Field, Object> retrieveCityGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        CityResponse response;
        try {
            response = this.databaseReader.city(ipAddress);
        }
        catch (NullPointerException e) {
            throw new GeoIp2InvalidCustomFieldException(e);
        }
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Postal postal = response.getPostal();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        EnumMap<Field, Object> geoData = new EnumMap<Field, Object>(Field.class);
        if (location.getLatitude() == null && location.getLongitude() == null) {
            return geoData;
        }
        for (Field desiredField : this.desiredFields) {
            switch (desiredField) {
                case CITY_NAME: {
                    String cityName = city.getName();
                    if (cityName == null) break;
                    geoData.put(Field.CITY_NAME, (Object)cityName);
                    break;
                }
                case CONTINENT_CODE: {
                    String continentCode = continent.getCode();
                    if (continentCode == null) break;
                    geoData.put(Field.CONTINENT_CODE, (Object)continentCode);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put(Field.CONTINENT_NAME, (Object)continentName);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) break;
                    geoData.put(Field.COUNTRY_NAME, (Object)countryName);
                    break;
                }
                case COUNTRY_CODE2: {
                    String countryCode2 = country.getIsoCode();
                    if (countryCode2 == null) break;
                    geoData.put(Field.COUNTRY_CODE2, (Object)countryCode2);
                    break;
                }
                case COUNTRY_CODE3: {
                    String countryCode3 = country.getIsoCode();
                    if (countryCode3 == null) break;
                    geoData.put(Field.COUNTRY_CODE3, (Object)countryCode3);
                    break;
                }
                case IP: {
                    geoData.put(Field.IP, (Object)ipAddress.getHostAddress());
                    break;
                }
                case POSTAL_CODE: {
                    String postalCode = postal.getCode();
                    if (postalCode == null) break;
                    geoData.put(Field.POSTAL_CODE, (Object)postalCode);
                    break;
                }
                case DMA_CODE: {
                    Integer dmaCode = location.getMetroCode();
                    if (dmaCode == null) break;
                    geoData.put(Field.DMA_CODE, (Object)dmaCode);
                    break;
                }
                case REGION_NAME: {
                    String subdivisionName = subdivision.getName();
                    if (subdivisionName == null) break;
                    geoData.put(Field.REGION_NAME, (Object)subdivisionName);
                    break;
                }
                case REGION_CODE: {
                    String subdivisionCode = subdivision.getIsoCode();
                    if (subdivisionCode == null) break;
                    geoData.put(Field.REGION_CODE, (Object)subdivisionCode);
                    break;
                }
                case REGION_ISO_CODE: {
                    this.parseRegionIsoCodeField(country, subdivision).ifPresent(data -> geoData.put(Field.REGION_ISO_CODE, data));
                    break;
                }
                case TIMEZONE: {
                    String locationTimeZone = location.getTimeZone();
                    if (locationTimeZone == null) break;
                    geoData.put(Field.TIMEZONE, (Object)locationTimeZone);
                    break;
                }
                case LOCATION: {
                    this.parseLocationField(location).ifPresent(data -> geoData.put(Field.LOCATION, data));
                    break;
                }
                case LATITUDE: {
                    Double lat = location.getLatitude();
                    if (lat == null) break;
                    geoData.put(Field.LATITUDE, (Object)lat);
                    break;
                }
                case LONGITUDE: {
                    Double lon = location.getLongitude();
                    if (lon == null) break;
                    geoData.put(Field.LONGITUDE, (Object)lon);
                }
            }
        }
        return geoData;
    }

    private Map<Field, Object> retrieveCountryGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        CountryResponse response;
        try {
            response = this.databaseReader.country(ipAddress);
        }
        catch (NullPointerException e) {
            throw new GeoIp2InvalidCustomFieldException(e);
        }
        Country country = response.getCountry();
        Continent continent = response.getContinent();
        EnumMap<Field, Object> geoData = new EnumMap<Field, Object>(Field.class);
        for (Field desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Field.IP, (Object)ipAddress.getHostAddress());
                    break;
                }
                case COUNTRY_CODE2: {
                    String countryCode2 = country.getIsoCode();
                    if (countryCode2 == null) break;
                    geoData.put(Field.COUNTRY_CODE2, (Object)countryCode2);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) break;
                    geoData.put(Field.COUNTRY_NAME, (Object)countryName);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put(Field.CONTINENT_NAME, (Object)continentName);
                }
            }
        }
        return geoData;
    }

    private Map<Field, Object> retrieveIspGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        IspResponse response;
        try {
            response = this.databaseReader.isp(ipAddress);
        }
        catch (NullPointerException e) {
            throw new GeoIp2InvalidCustomFieldException(e);
        }
        EnumMap<Field, Object> geoData = new EnumMap<Field, Object>(Field.class);
        for (Field desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Field.IP, (Object)ipAddress.getHostAddress());
                    break;
                }
                case AUTONOMOUS_SYSTEM_NUMBER: {
                    Integer asn = response.getAutonomousSystemNumber();
                    if (asn == null) break;
                    geoData.put(desiredField, (Object)asn);
                    break;
                }
                case AUTONOMOUS_SYSTEM_ORGANIZATION: {
                    String aso = response.getAutonomousSystemOrganization();
                    if (aso == null) break;
                    geoData.put(desiredField, (Object)aso);
                    break;
                }
                case ISP: {
                    String isp = response.getIsp();
                    if (isp == null) break;
                    geoData.put(Field.ISP, (Object)isp);
                    break;
                }
                case ORGANIZATION: {
                    String org = response.getOrganization();
                    if (org == null) break;
                    geoData.put(Field.ORGANIZATION, (Object)org);
                }
            }
        }
        return geoData;
    }

    private Map<Field, Object> retrieveAsnGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        AsnResponse response;
        try {
            response = this.databaseReader.asn(ipAddress);
        }
        catch (NullPointerException e) {
            throw new GeoIp2InvalidCustomFieldException(e);
        }
        Network network = response.getNetwork();
        EnumMap<Field, Object> geoData = new EnumMap<Field, Object>(Field.class);
        for (Field desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Field.IP, (Object)ipAddress.getHostAddress());
                    break;
                }
                case AUTONOMOUS_SYSTEM_NUMBER: {
                    Integer asn = response.getAutonomousSystemNumber();
                    if (asn == null) break;
                    geoData.put(Field.AUTONOMOUS_SYSTEM_NUMBER, (Object)asn);
                    break;
                }
                case AUTONOMOUS_SYSTEM_ORGANIZATION: {
                    String aso = response.getAutonomousSystemOrganization();
                    if (aso == null) break;
                    geoData.put(Field.AUTONOMOUS_SYSTEM_ORGANIZATION, (Object)aso);
                    break;
                }
                case NETWORK: {
                    if (network == null) break;
                    geoData.put(Field.NETWORK, (Object)network.toString());
                }
            }
        }
        return geoData;
    }

    private Map<Field, Object> retrieveDomainGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        DomainResponse response;
        try {
            response = this.databaseReader.domain(ipAddress);
        }
        catch (NullPointerException e) {
            throw new GeoIp2InvalidCustomFieldException(e);
        }
        EnumMap<Field, Object> geoData = new EnumMap<Field, Object>(Field.class);
        for (Field desiredField : this.desiredFields) {
            switch (desiredField) {
                case DOMAIN: {
                    String domain = response.getDomain();
                    geoData.put(Field.DOMAIN, (Object)domain);
                }
            }
        }
        return geoData;
    }

    private Map<Field, Object> retrieveEnterpriseGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        EnterpriseResponse response;
        try {
            response = this.databaseReader.enterprise(ipAddress);
        }
        catch (NullPointerException e) {
            throw new GeoIp2InvalidCustomFieldException(e);
        }
        EnumMap<Field, Object> geoData = new EnumMap<Field, Object>(Field.class);
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        Integer asn = response.getTraits().getAutonomousSystemNumber();
        String organizationName = response.getTraits().getAutonomousSystemOrganization();
        Network network = response.getTraits().getNetwork();
        boolean isHostingProvider = response.getTraits().isHostingProvider();
        boolean isTorExitNode = response.getTraits().isTorExitNode();
        boolean isAnonymousVpn = response.getTraits().isAnonymousVpn();
        boolean isAnonymous = response.getTraits().isAnonymous();
        boolean isPublicProxy = response.getTraits().isPublicProxy();
        boolean isResidentialProxy = response.getTraits().isResidentialProxy();
        for (Field desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(Field.IP, (Object)ipAddress.getHostAddress());
                    break;
                }
                case COUNTRY_CODE2: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) break;
                    geoData.put(desiredField, (Object)countryIsoCode);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) break;
                    geoData.put(desiredField, (Object)countryName);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put(desiredField, (Object)continentName);
                    break;
                }
                case REGION_ISO_CODE: {
                    this.parseRegionIsoCodeField(country, subdivision).ifPresent(data -> geoData.put(desiredField, data));
                    break;
                }
                case REGION_NAME: {
                    String subdivisionName = subdivision.getName();
                    if (subdivisionName == null) break;
                    geoData.put(desiredField, (Object)subdivisionName);
                    break;
                }
                case CITY_NAME: {
                    String cityName = city.getName();
                    if (cityName == null) break;
                    geoData.put(desiredField, (Object)cityName);
                    break;
                }
                case TIMEZONE: {
                    String locationTimeZone = location.getTimeZone();
                    if (locationTimeZone == null) break;
                    geoData.put(desiredField, (Object)locationTimeZone);
                    break;
                }
                case LOCATION: {
                    this.parseLocationField(location).ifPresent(data -> geoData.put(desiredField, data));
                    break;
                }
                case AUTONOMOUS_SYSTEM_NUMBER: {
                    if (asn == null) break;
                    geoData.put(desiredField, (Object)asn);
                    break;
                }
                case AUTONOMOUS_SYSTEM_ORGANIZATION: {
                    if (organizationName == null) break;
                    geoData.put(desiredField, (Object)organizationName);
                    break;
                }
                case NETWORK: {
                    if (network == null) break;
                    geoData.put(desiredField, (Object)network.toString());
                    break;
                }
                case HOSTING_PROVIDER: {
                    geoData.put(desiredField, (Object)isHostingProvider);
                    break;
                }
                case TOR_EXIT_NODE: {
                    geoData.put(desiredField, (Object)isTorExitNode);
                    break;
                }
                case ANONYMOUS_VPN: {
                    geoData.put(desiredField, (Object)isAnonymousVpn);
                    break;
                }
                case ANONYMOUS: {
                    geoData.put(desiredField, (Object)isAnonymous);
                    break;
                }
                case PUBLIC_PROXY: {
                    geoData.put(desiredField, (Object)isPublicProxy);
                    break;
                }
                case RESIDENTIAL_PROXY: {
                    geoData.put(desiredField, (Object)isResidentialProxy);
                }
            }
        }
        return geoData;
    }

    private Map<Field, Object> retrieveAnonymousIpGeoData(InetAddress ipAddress) throws GeoIp2Exception, IOException {
        AnonymousIpResponse response;
        try {
            response = this.databaseReader.anonymousIp(ipAddress);
        }
        catch (NullPointerException e) {
            throw new GeoIp2InvalidCustomFieldException(e);
        }
        EnumMap<Field, Object> geoData = new EnumMap<Field, Object>(Field.class);
        boolean isHostingProvider = response.isHostingProvider();
        boolean isTorExitNode = response.isTorExitNode();
        boolean isAnonymousVpn = response.isAnonymousVpn();
        boolean isAnonymous = response.isAnonymous();
        boolean isPublicProxy = response.isPublicProxy();
        boolean isResidentialProxy = response.isResidentialProxy();
        for (Field desiredField : this.desiredFields) {
            switch (desiredField) {
                case IP: {
                    geoData.put(desiredField, (Object)ipAddress.getHostAddress());
                    break;
                }
                case HOSTING_PROVIDER: {
                    geoData.put(desiredField, (Object)isHostingProvider);
                    break;
                }
                case TOR_EXIT_NODE: {
                    geoData.put(desiredField, (Object)isTorExitNode);
                    break;
                }
                case ANONYMOUS_VPN: {
                    geoData.put(desiredField, (Object)isAnonymousVpn);
                    break;
                }
                case ANONYMOUS: {
                    geoData.put(desiredField, (Object)isAnonymous);
                    break;
                }
                case PUBLIC_PROXY: {
                    geoData.put(desiredField, (Object)isPublicProxy);
                    break;
                }
                case RESIDENTIAL_PROXY: {
                    geoData.put(desiredField, (Object)isResidentialProxy);
                }
            }
        }
        return geoData;
    }

    private Optional<Map<String, Object>> parseLocationField(Location location) {
        Double latitude = location.getLatitude();
        Double longitude = location.getLongitude();
        if (latitude != null && longitude != null) {
            HashMap<String, Double> locationObject = new HashMap<String, Double>();
            locationObject.put("lat", latitude);
            locationObject.put("lon", longitude);
            return Optional.of(locationObject);
        }
        return Optional.empty();
    }

    private Optional<String> parseRegionIsoCodeField(Country country, Subdivision subdivision) {
        String countryCodeForRegion = country.getIsoCode();
        String regionCode2 = subdivision.getIsoCode();
        if (countryCodeForRegion != null && regionCode2 != null) {
            return Optional.of(String.format("%s-%s", countryCodeForRegion, regionCode2));
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        if (this.databaseReader != null) {
            try {
                this.databaseReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class GeoIp2InvalidCustomFieldException
    extends GeoIp2Exception {
        public GeoIp2InvalidCustomFieldException(Throwable cause) {
            super("The database contains invalid custom field, which caused deserialization to fail.", cause);
        }
    }
}

