/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.auto;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReceiver;
import com.thaiopensource.validate.auto.ReparseException;
import com.thaiopensource.validate.auto.RewindableInputStream;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.auto.SchemaReceiverLoader;
import com.thaiopensource.xml.sax.Resolver;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AutoSchemaReader
extends AbstractSchemaReader {
    private final SchemaReceiverFactory srf;

    public AutoSchemaReader() {
        this(new SchemaReceiverLoader());
    }

    public AutoSchemaReader(SchemaReceiverFactory schemaReceiverFactory) {
        this.srf = schemaReceiverFactory == null ? new SchemaReceiverLoader() : schemaReceiverFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema createSchema(SAXSource sAXSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        ErrorHandler errorHandler;
        Object object;
        if (SchemaReceiverFactory.PROPERTY.get(propertyMap) != this.srf) {
            object = new PropertyMapBuilder(propertyMap);
            SchemaReceiverFactory.PROPERTY.put((PropertyMapBuilder)object, this.srf);
            propertyMap = ((PropertyMapBuilder)object).toPropertyMap();
        }
        object = ResolverFactory.createResolver(propertyMap);
        InputSource inputSource = ((Resolver)object).open(sAXSource.getInputSource());
        InputSource inputSource2 = new InputSource();
        inputSource2.setSystemId(inputSource.getSystemId());
        inputSource2.setPublicId(inputSource.getPublicId());
        inputSource2.setEncoding(inputSource.getEncoding());
        if (inputSource.getCharacterStream() != null) {
            throw new IllegalArgumentException("character stream input sources not supported for auto-detection");
        }
        Object object2 = inputSource.getByteStream();
        Object object3 = new RewindableInputStream((InputStream)object2);
        inputSource.setByteStream((InputStream)object3);
        inputSource2.setByteStream((InputStream)object3);
        RewindableInputStream rewindableInputStream = object3;
        object2 = new AutoSchemaReceiver(propertyMap, rewindableInputStream);
        object3 = sAXSource.getXMLReader();
        if (object3 == null) {
            object3 = ((Resolver)object).createXMLReader();
        }
        if ((errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap)) != null) {
            object3.setErrorHandler(errorHandler);
        }
        SchemaFuture schemaFuture = object2.installHandlers((XMLReader)object3);
        try {
            object3.parse(inputSource);
            Schema schema = schemaFuture.getSchema();
            rewindableInputStream.willNotRewind();
            return schema;
        }
        catch (ReparseException reparseException) {
            try {
                rewindableInputStream.rewind();
                rewindableInputStream.willNotRewind();
                Schema schema = reparseException.reparse(new SAXSource((XMLReader)object3, inputSource2));
                rewindableInputStream.willNotRewind();
                return schema;
            }
            catch (Throwable throwable) {
                try {
                    rewindableInputStream.willNotRewind();
                    throw throwable;
                }
                catch (SAXException sAXException) {
                    Exception exception = sAXException.getException();
                    if (exception instanceof RuntimeException) {
                        schemaFuture.unwrapException((RuntimeException)exception);
                    }
                    throw sAXException;
                }
                catch (RuntimeException runtimeException) {
                    throw schemaFuture.unwrapException(runtimeException);
                }
            }
        }
    }

    @Override
    public Option getOption(String string) {
        return this.srf.getOption(string);
    }
}

