/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.MetricType;

public class UptimeMetric
extends AbstractMetric<Long> {
    private final LongSupplier nanoTimeSupplier;
    private final long startNanos;
    private final TimeUnit timeUnit;

    public UptimeMetric() {
        this(MetricKeys.UPTIME_IN_MILLIS_KEY.asJavaString());
    }

    public UptimeMetric(String name) {
        this(name, System::nanoTime);
    }

    UptimeMetric(String name, LongSupplier nanoTimeSupplier) {
        this(name, nanoTimeSupplier, nanoTimeSupplier.getAsLong(), TimeUnit.MILLISECONDS);
    }

    private UptimeMetric(String name, LongSupplier nanoTimeSupplier, long startNanos, TimeUnit timeUnit) {
        super(Objects.requireNonNull(name, "name"));
        this.nanoTimeSupplier = Objects.requireNonNull(nanoTimeSupplier, "nanoTimeSupplier");
        this.timeUnit = Objects.requireNonNull(timeUnit, "timeUnit");
        this.startNanos = Objects.requireNonNull(Long.valueOf(startNanos), "startNanos");
    }

    @Override
    public Long getValue() {
        return this.timeUnit.convert(this.getElapsedNanos(), TimeUnit.NANOSECONDS);
    }

    long getElapsedNanos() {
        return this.nanoTimeSupplier.getAsLong() - this.startNanos;
    }

    @Override
    public MetricType getType() {
        return MetricType.COUNTER_LONG;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public UptimeMetric withTimeUnit(String name, TimeUnit timeUnit) {
        return new UptimeMetric(name, this.nanoTimeSupplier, this.startNanos, timeUnit);
    }

    public ScaledView withUnitsPrecise(String name, ScaleUnits scaleUnits) {
        return new ScaledView(name, this::getElapsedNanos, scaleUnits.nanoRelativeDecimalShift);
    }

    public ScaledView withUnitsPrecise(ScaleUnits scaleUnits) {
        String name = String.format("%s_scaled_to_%s", this.getName(), scaleUnits.name());
        return this.withUnitsPrecise(name, scaleUnits);
    }

    static class ScaledView
    implements Metric<Number> {
        private final String name;
        private final int nanoRelativeDecimalShift;
        private final LongSupplier elapsedNanosSupplier;

        ScaledView(String name, LongSupplier elapsedNanosSupplier, int nanoRelativeDecimalShift) {
            this.name = name;
            this.nanoRelativeDecimalShift = nanoRelativeDecimalShift;
            this.elapsedNanosSupplier = elapsedNanosSupplier;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public MetricType getType() {
            return MetricType.COUNTER_DECIMAL;
        }

        @Override
        public BigDecimal getValue() {
            return BigDecimal.valueOf(this.elapsedNanosSupplier.getAsLong(), this.nanoRelativeDecimalShift);
        }
    }

    public static enum ScaleUnits {
        NANOSECONDS(0),
        MICROSECONDS(3),
        MILLISECONDS(6),
        SECONDS(9);

        private final int nanoRelativeDecimalShift;

        private ScaleUnits(int nanoRelativeDecimalShift) {
            this.nanoRelativeDecimalShift = nanoRelativeDecimalShift;
        }
    }
}

