/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class DiskHashtable {
    private final long rowConglomerateId;
    private ConglomerateController rowConglomerate;
    private final long btreeConglomerateId;
    private ConglomerateController btreeConglomerate;
    private final DataValueDescriptor[] btreeRow;
    private final int[] key_column_numbers;
    private final boolean remove_duplicates;
    private final TransactionController tc;
    private final DataValueDescriptor[] row;
    private final DataValueDescriptor[] scanKey = new DataValueDescriptor[]{new SQLInteger()};
    private int size;
    private boolean keepStatistics;
    private final boolean keepAfterCommit;

    public DiskHashtable(TransactionController tc, DataValueDescriptor[] template, int[] collation_ids, int[] key_column_numbers, boolean remove_duplicates, boolean keepAfterCommit) throws StandardException {
        this.tc = tc;
        this.key_column_numbers = key_column_numbers;
        this.remove_duplicates = remove_duplicates;
        this.keepAfterCommit = keepAfterCommit;
        LanguageConnectionContext lcc = (LanguageConnectionContext)DiskHashtable.getContextOrNull("LanguageConnectionContext");
        this.keepStatistics = lcc != null && lcc.getRunTimeStatisticsMode();
        this.row = new DataValueDescriptor[template.length];
        for (int i = 0; i < this.row.length; ++i) {
            this.row[i] = template[i].getNewNull();
            SanityManager.ASSERT((this.row[i] != null ? 1 : 0) != 0, (String)"Template for the hash table must have non-null object");
        }
        int tempFlags = keepAfterCommit ? 3 : 1;
        this.rowConglomerateId = tc.createConglomerate("heap", template, null, collation_ids, null, tempFlags);
        this.rowConglomerate = tc.openConglomerate(this.rowConglomerateId, keepAfterCommit, 4, 7, 0);
        this.btreeRow = new DataValueDescriptor[]{new SQLInteger(), this.rowConglomerate.newRowLocationTemplate()};
        Properties btreeProps = new Properties();
        btreeProps.put("baseConglomerateId", String.valueOf(this.rowConglomerateId));
        btreeProps.put("rowLocationColumn", "1");
        btreeProps.put("allowDuplicates", "false");
        btreeProps.put("nKeyFields", "2");
        btreeProps.put("nUniqueColumns", "2");
        btreeProps.put("maintainParentLinks", "false");
        int[] index_collation_ids = new int[]{0, 0};
        this.btreeConglomerateId = tc.createConglomerate("BTREE", this.btreeRow, null, index_collation_ids, btreeProps, tempFlags);
        this.btreeConglomerate = tc.openConglomerate(this.btreeConglomerateId, keepAfterCommit, 4, 7, 0);
    }

    public void close() throws StandardException {
        this.btreeConglomerate.close();
        this.rowConglomerate.close();
        this.tc.dropConglomerate(this.btreeConglomerateId);
        this.tc.dropConglomerate(this.rowConglomerateId);
    }

    public boolean put(Object key, Object[] row) throws StandardException {
        boolean isDuplicate = false;
        if (this.remove_duplicates || this.keepStatistics) {
            boolean bl = isDuplicate = this.getRemove(key, false, true) != null;
            if (this.remove_duplicates && isDuplicate) {
                return false;
            }
        }
        this.rowConglomerate.insertAndFetchLocation((DataValueDescriptor[])row, (RowLocation)this.btreeRow[1]);
        this.btreeRow[0].setValue(key.hashCode());
        this.btreeConglomerate.insert(this.btreeRow);
        if (this.keepStatistics && !isDuplicate) {
            ++this.size;
        }
        return true;
    }

    public Object get(Object key) throws StandardException {
        return this.getRemove(key, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRemove(Object key, boolean remove, boolean existenceOnly) throws StandardException {
        int hashCode = key.hashCode();
        int rowCount = 0;
        DataValueDescriptor[] firstRow = null;
        ArrayList<DataValueDescriptor[]> allRows = null;
        this.scanKey[0].setValue(hashCode);
        try (ScanController scan = this.tc.openScan(this.btreeConglomerateId, false, remove ? 4 : 0, 7, 1, null, this.scanKey, 1, null, this.scanKey, -1);){
            while (scan.fetchNext(this.btreeRow)) {
                if (!this.rowConglomerate.fetch((RowLocation)this.btreeRow[1], this.row, null) || !this.rowMatches(this.row, key)) continue;
                if (existenceOnly) {
                    DiskHashtable diskHashtable = this;
                    return diskHashtable;
                }
                DataValueDescriptor[] clonedRow = BackingStoreHashtable.shallowCloneRow(this.row);
                if (++rowCount == 1) {
                    firstRow = clonedRow;
                } else {
                    if (allRows == null) {
                        allRows = new ArrayList<DataValueDescriptor[]>(2);
                        allRows.add(firstRow);
                    }
                    allRows.add(clonedRow);
                }
                if (remove) {
                    this.rowConglomerate.delete((RowLocation)this.btreeRow[1]);
                    scan.delete();
                    --this.size;
                }
                if (!this.remove_duplicates) continue;
                DataValueDescriptor[] dataValueDescriptorArray = clonedRow;
                return dataValueDescriptorArray;
            }
        }
        if (allRows == null) {
            return firstRow;
        }
        return allRows;
    }

    private boolean rowMatches(DataValueDescriptor[] row, Object key) {
        if (this.key_column_numbers.length == 1) {
            return row[this.key_column_numbers[0]].equals(key);
        }
        KeyHasher kh = (KeyHasher)key;
        for (int i = 0; i < this.key_column_numbers.length; ++i) {
            if (row[this.key_column_numbers[i]].equals(kh.getObject(i))) continue;
            return false;
        }
        return true;
    }

    public Object remove(Object key) throws StandardException {
        return this.getRemove(key, true, false);
    }

    public int size() {
        return this.size;
    }

    public Enumeration<Object> elements() throws StandardException {
        return new ElementEnum();
    }

    private static Context getContextOrNull(final String contextID) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(contextID);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(contextID);
            }
        });
    }

    private class ElementEnum
    implements Enumeration<Object> {
        private ScanController scan;
        private boolean hasMore;
        private RowLocation rowloc;

        ElementEnum() {
            block7: {
                try {
                    this.scan = DiskHashtable.this.tc.openScan(DiskHashtable.this.rowConglomerateId, DiskHashtable.this.keepAfterCommit, 0, 7, 0, null, null, 0, null, null, 0);
                    this.hasMore = this.scan.next();
                    if (!this.hasMore) {
                        this.scan.close();
                        this.scan = null;
                    } else if (DiskHashtable.this.keepAfterCommit) {
                        this.rowloc = DiskHashtable.this.rowConglomerate.newRowLocationTemplate();
                        this.scan.fetchLocation(this.rowloc);
                    }
                }
                catch (StandardException se) {
                    this.hasMore = false;
                    if (this.scan == null) break block7;
                    try {
                        this.scan.close();
                    }
                    catch (StandardException standardException) {
                        // empty catch block
                    }
                    this.scan = null;
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMore;
        }

        @Override
        public Object nextElement() {
            if (!this.hasMore) {
                throw new NoSuchElementException();
            }
            try {
                if (this.scan.isHeldAfterCommit() && !this.scan.positionAtRowLocation(this.rowloc)) {
                    throw StandardException.newException((String)"24000", (Object[])new Object[0]);
                }
                this.scan.fetch(DiskHashtable.this.row);
                DataValueDescriptor[] retValue = BackingStoreHashtable.shallowCloneRow(DiskHashtable.this.row);
                this.hasMore = this.scan.next();
                if (!this.hasMore) {
                    this.scan.close();
                    this.scan = null;
                } else if (DiskHashtable.this.keepAfterCommit) {
                    this.scan.fetchLocation(this.rowloc);
                }
                return retValue;
            }
            catch (StandardException se) {
                if (this.scan != null) {
                    try {
                        this.scan.close();
                    }
                    catch (StandardException standardException) {
                        // empty catch block
                    }
                    this.scan = null;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

