/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.expiration;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.infinispan.distribution.DistributionManager;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.expiration.BaseExpirationTask;

class DistributionAwareExpirationTask
extends BaseExpirationTask
implements Predicate<RealmModel> {
    private final DistributionManager distributionManager;

    DistributionAwareExpirationTask(KeycloakSessionFactory factory, ScheduledExecutorService scheduledExecutorService, int intervalSeconds, Consumer<Duration> onTaskExecuted, DistributionManager distributionManager) {
        super(factory, scheduledExecutorService, intervalSeconds, onTaskExecuted);
        this.distributionManager = Objects.requireNonNull(distributionManager);
    }

    @Override
    final Predicate<RealmModel> realmFilter() {
        return this;
    }

    @Override
    public final boolean test(RealmModel realm) {
        return this.distributionManager.getCacheTopology().getDistribution((Object)realm.getId()).isPrimary();
    }
}

