/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime.interceptor;

import com.arjuna.ats.jta.logging.jtaLogger;
import io.quarkus.arc.runtime.InterceptorBindings;
import io.quarkus.narayana.jta.runtime.NotifyingTransactionManager;
import io.quarkus.narayana.jta.runtime.TransactionConfiguration;
import io.quarkus.narayana.jta.runtime.interceptor.RunnableWithException;
import io.quarkus.transaction.annotations.Rollback;
import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import io.smallrye.reactive.converters.Registry;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.function.Function;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;
import org.reactivestreams.Publisher;

public abstract class TransactionalInterceptorBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TransactionalInterceptorBase.class);
    private final Map<Method, Integer> methodTransactionTimeoutDefinedByPropertyCache = new ConcurrentHashMap<Method, Integer>();
    @Inject
    TransactionManager transactionManager;
    private final boolean userTransactionAvailable;

    protected TransactionalInterceptorBase(boolean userTransactionAvailable) {
        this.userTransactionAvailable = userTransactionAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(InvocationContext ic) throws Exception {
        TransactionManager tm = this.transactionManager;
        Transaction tx = tm.getTransaction();
        boolean previousUserTransactionAvailability = this.setUserTransactionAvailable(this.userTransactionAvailable);
        try {
            Object object = this.doIntercept(tm, tx, ic);
            return object;
        }
        finally {
            this.resetUserTransactionAvailability(previousUserTransactionAvailability);
        }
    }

    protected abstract Object doIntercept(TransactionManager var1, Transaction var2, InvocationContext var3) throws Exception;

    private Transactional getTransactional(InvocationContext ic) {
        Set bindings = InterceptorBindings.getInterceptorBindings((InvocationContext)ic);
        for (Annotation i : bindings) {
            if (i.annotationType() != Transactional.class) continue;
            return (Transactional)i;
        }
        throw new RuntimeException(jtaLogger.i18NLogger.get_expected_transactional_annotation());
    }

    private TransactionConfiguration getTransactionConfiguration(InvocationContext ic) {
        TransactionConfiguration configuration = ic.getMethod().getAnnotation(TransactionConfiguration.class);
        if (configuration == null) {
            Object target = ic.getTarget();
            Class<?> clazz = target != null ? target.getClass() : ic.getMethod().getDeclaringClass();
            return clazz.getAnnotation(TransactionConfiguration.class);
        }
        return configuration;
    }

    protected Object invokeInOurTx(InvocationContext ic, TransactionManager tm) throws Exception {
        return this.invokeInOurTx(ic, tm, () -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext ic, TransactionManager tm, RunnableWithException afterEndTransaction) throws Exception {
        Transaction tx;
        int timeoutConfiguredForMethod = this.getTransactionTimeoutFromAnnotation(ic);
        int currentTmTimeout = ((NotifyingTransactionManager)this.transactionManager).getTransactionTimeout();
        if (timeoutConfiguredForMethod > 0) {
            tm.setTransactionTimeout(timeoutConfiguredForMethod);
        }
        try {
            tm.begin();
            tx = tm.getTransaction();
        }
        finally {
            if (timeoutConfiguredForMethod > 0) {
                tm.setTransactionTimeout(currentTmTimeout);
            }
        }
        boolean throwing = false;
        CompletionStage ret = null;
        try {
            ret = ic.proceed();
        }
        catch (Throwable t) {
            throwing = true;
            this.handleException(ic, t, tx);
        }
        finally {
            if (!throwing && ret != null) {
                Optional lookup;
                ReactiveTypeConverter converter = null;
                if (!this.isCompletionStage(ret) && !this.isSomePublisher(ic, ret) && (lookup = Registry.lookup(ret.getClass())).isPresent()) {
                    converter = (ReactiveTypeConverter)lookup.get();
                    ret = converter.emitAtMostOneItem() ? converter.toCompletionStage((Object)ret) : converter.toRSPublisher((Object)ret);
                }
                if (this.isCompletionStage(ret)) {
                    ret = this.handleAsync(tm, tx, ic, ret, afterEndTransaction);
                    if (converter != null) {
                        ret = converter.fromCompletionStage(ret);
                    }
                } else if (TransactionalInterceptorBase.isFlowPublisher(ret)) {
                    ret = this.handleAsync(tm, tx, ic, ret, afterEndTransaction);
                } else if (TransactionalInterceptorBase.isLegacyPublisher(ret)) {
                    ret = this.handleAsync(tm, tx, ic, ret, afterEndTransaction);
                    if (converter != null) {
                        ret = converter.fromPublisher((Publisher)ret);
                    }
                } else {
                    this.endTransaction(tm, tx, afterEndTransaction);
                }
            } else {
                this.endTransaction(tm, tx, afterEndTransaction);
            }
        }
        return ret;
    }

    private static boolean isLegacyPublisher(Object ret) {
        return ret instanceof Publisher;
    }

    private boolean isSomePublisher(InvocationContext ic, Object ret) {
        return TransactionalInterceptorBase.isLegacyPublisher(ret) || ic.getMethod().getReturnType() == Publisher.class || TransactionalInterceptorBase.isFlowPublisher(ret) || ic.getMethod().getReturnType() == Flow.Publisher.class;
    }

    private static boolean isFlowPublisher(Object ret) {
        return ret instanceof Flow.Publisher;
    }

    private boolean isCompletionStage(Object ret) {
        return ret instanceof CompletionStage;
    }

    private int getTransactionTimeoutFromAnnotation(InvocationContext ic) {
        final TransactionConfiguration configAnnotation = this.getTransactionConfiguration(ic);
        if (configAnnotation == null) {
            return -1;
        }
        int transactionTimeout = -1;
        if (!configAnnotation.timeoutFromConfigProperty().equals("<<unset>>")) {
            Integer timeoutForMethod = this.methodTransactionTimeoutDefinedByPropertyCache.get(ic.getMethod());
            transactionTimeout = timeoutForMethod != null ? timeoutForMethod.intValue() : this.methodTransactionTimeoutDefinedByPropertyCache.computeIfAbsent(ic.getMethod(), new Function<Method, Integer>(){

                @Override
                public Integer apply(Method m) {
                    return TransactionalInterceptorBase.this.getTransactionTimeoutPropertyValue(configAnnotation);
                }
            }).intValue();
        }
        if (transactionTimeout == -1 && configAnnotation.timeout() != -1) {
            transactionTimeout = configAnnotation.timeout();
        }
        return transactionTimeout;
    }

    private Integer getTransactionTimeoutPropertyValue(TransactionConfiguration configAnnotation) {
        Optional configTimeout = ConfigProvider.getConfig().getOptionalValue(configAnnotation.timeoutFromConfigProperty(), Integer.class);
        if (configTimeout.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debugf("Configuration property '%s' was not provided, so it will not affect the transaction's timeout.", (Object)configAnnotation.timeoutFromConfigProperty());
            }
            return -1;
        }
        return (Integer)configTimeout.get();
    }

    protected Object handleAsync(TransactionManager tm, Transaction tx, InvocationContext ic, Object ret, RunnableWithException afterEndTransaction) throws Exception {
        tm.suspend();
        afterEndTransaction.run();
        if (this.isCompletionStage(ret)) {
            return ((CompletionStage)ret).handle((v, t) -> {
                try {
                    this.doInTransaction(tm, tx, () -> {
                        if (t != null) {
                            this.handleExceptionNoThrow(ic, (Throwable)t, tx);
                        }
                        this.endTransaction(tm, tx, () -> {});
                    });
                }
                catch (RuntimeException e) {
                    if (t != null) {
                        e.addSuppressed((Throwable)t);
                    }
                    throw e;
                }
                catch (Exception e) {
                    CompletionException x = new CompletionException(e);
                    if (t != null) {
                        x.addSuppressed((Throwable)t);
                    }
                    throw x;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t != null) {
                    throw new CompletionException((Throwable)t);
                }
                return v;
            });
        }
        if (TransactionalInterceptorBase.isLegacyPublisher(ret) || TransactionalInterceptorBase.isFlowPublisher(ret)) {
            boolean isLegacyRS = !TransactionalInterceptorBase.isFlowPublisher(ret);
            Flow.Publisher pub = isLegacyRS ? AdaptersToFlow.publisher((Publisher)((Publisher)ret)) : (Flow.Publisher)ret;
            ret = Multi.createFrom().publisher(pub).onFailure().invoke(t -> {
                try {
                    this.doInTransaction(tm, tx, () -> this.handleExceptionNoThrow(ic, (Throwable)t, tx));
                }
                catch (RuntimeException e) {
                    e.addSuppressed((Throwable)t);
                    throw e;
                }
                catch (Exception e) {
                    RuntimeException x = new RuntimeException(e);
                    x.addSuppressed((Throwable)t);
                    throw x;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException((Throwable)t);
            }).onTermination().invoke(() -> {
                try {
                    this.doInTransaction(tm, tx, () -> this.endTransaction(tm, tx, () -> {}));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            if (isLegacyRS) {
                ret = AdaptersToReactiveStreams.publisher((Flow.Publisher)((Multi)ret));
            }
        }
        return ret;
    }

    private void doInTransaction(TransactionManager tm, Transaction tx, RunnableWithException f) throws Exception {
        Transaction currentTransaction = tm.getTransaction();
        if (currentTransaction != tx) {
            if (currentTransaction != null) {
                tm.suspend();
            }
            tm.resume(tx);
        }
        f.run();
        if (currentTransaction != tx) {
            tm.suspend();
            if (currentTransaction != null) {
                tm.resume(currentTransaction);
            }
        }
    }

    protected Object invokeInCallerTx(InvocationContext ic, Transaction tx) throws Exception {
        try {
            this.checkConfiguration(ic);
            return ic.proceed();
        }
        catch (Throwable t) {
            this.handleException(ic, t, tx);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InvocationContext ic) throws Exception {
        this.checkConfiguration(ic);
        return ic.proceed();
    }

    private void checkConfiguration(InvocationContext ic) {
        TransactionConfiguration configAnnotation = this.getTransactionConfiguration(ic);
        if (!(configAnnotation == null || configAnnotation.timeout() == -1 && "<<unset>>".equals(configAnnotation.timeoutFromConfigProperty()))) {
            throw new RuntimeException("Changing timeout via @TransactionConfiguration can only be done at the entry level of a transaction");
        }
    }

    protected void handleExceptionNoThrow(InvocationContext ic, Throwable t, Transaction tx) throws IllegalStateException, SystemException {
        Transactional transactional = this.getTransactional(ic);
        for (Class dontRollbackOnClass : transactional.dontRollbackOn()) {
            if (!dontRollbackOnClass.isAssignableFrom(t.getClass())) continue;
            return;
        }
        for (Class rollbackOnClass : transactional.rollbackOn()) {
            if (!rollbackOnClass.isAssignableFrom(t.getClass())) continue;
            tx.setRollbackOnly();
            return;
        }
        Rollback rollbackAnnotation = t.getClass().getAnnotation(Rollback.class);
        if (rollbackAnnotation != null) {
            if (rollbackAnnotation.value()) {
                tx.setRollbackOnly();
            }
            return;
        }
        if (t instanceof RuntimeException || t instanceof Error) {
            tx.setRollbackOnly();
            return;
        }
    }

    protected void handleException(InvocationContext ic, Throwable t, Transaction tx) throws Exception {
        this.handleExceptionNoThrow(ic, t, tx);
        TransactionalInterceptorBase.sneakyThrow(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction(TransactionManager tm, Transaction tx, RunnableWithException afterEndTransaction) throws Exception {
        try {
            if (tx != tm.getTransaction()) {
                throw new RuntimeException(jtaLogger.i18NLogger.get_wrong_tx_on_thread());
            }
            if (tx.getStatus() == 1) {
                tm.rollback();
            } else {
                tm.commit();
            }
        }
        finally {
            afterEndTransaction.run();
        }
    }

    protected boolean setUserTransactionAvailable(boolean available) {
        boolean previousUserTransactionAvailability = ServerVMClientUserTransaction.isAvailable();
        ServerVMClientUserTransaction.setAvailability((boolean)available);
        return previousUserTransactionAvailability;
    }

    protected void resetUserTransactionAvailability(boolean previousUserTransactionAvailability) {
        ServerVMClientUserTransaction.setAvailability((boolean)previousUserTransactionAvailability);
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

