/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.endpoints;

import jakarta.ws.rs.core.Response;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.services.ErrorResponseException;

public abstract class AbstractCibaEndpoint {
    protected final KeycloakSession session;
    protected final EventBuilder event;
    protected final RealmModel realm;

    public AbstractCibaEndpoint(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.event = event;
        this.realm = session.getContext().getRealm();
    }

    protected ClientModel authenticateClient() {
        this.checkSsl();
        this.checkRealm();
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event, null);
        ClientModel client = clientAuth.getClient();
        if (client.isBearerOnly()) {
            throw new ErrorResponseException("invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
        if (!this.realm.getCibaPolicy().isOIDCCIBAGrantEnabled(client)) {
            this.event.error("not_allowed");
            throw new ErrorResponseException("invalid_grant", "Client not allowed OIDC CIBA Grant", Response.Status.BAD_REQUEST);
        }
        this.event.client(client);
        return client;
    }

    protected void checkSsl() {
        ClientConnection clientConnection = this.session.getContext().getConnection();
        RealmModel realm = this.session.getContext().getRealm();
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && realm.getSslRequired().isRequired(clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    protected void checkRealm() {
        RealmModel realm = this.session.getContext().getRealm();
        if (!realm.isEnabled()) {
            throw new ErrorResponseException("access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }
}

