/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.model.JWTVCIssuerMetadata;
import org.keycloak.protocol.oidc.utils.JWKSServerUtils;
import org.keycloak.services.Urls;
import org.keycloak.urls.UrlType;
import org.keycloak.wellknown.WellKnownProvider;

public class JWTVCIssuerWellKnownProvider
implements WellKnownProvider {
    private final KeycloakSession session;

    public JWTVCIssuerWellKnownProvider(KeycloakSession session) {
        this.session = session;
    }

    public void close() {
    }

    @Override
    public Object getConfig() {
        KeycloakUriInfo frontendUriInfo = this.session.getContext().getUri(UrlType.FRONTEND);
        RealmModel realm = this.session.getContext().getRealm();
        JWTVCIssuerMetadata config = new JWTVCIssuerMetadata();
        config.setIssuer(Urls.realmIssuer(frontendUriInfo.getBaseUri(), realm.getName()));
        JSONWebKeySet jwks = JWKSServerUtils.getRealmJwks(this.session, realm);
        config.setJwks(jwks);
        return config;
    }
}

