/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.keycloak.client.cli.config.RealmConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.client.registration.cli.KcRegMain;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.common.util.IoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="initial-token", description={"[--server SERVER] --realm REALM [--delete | TOKEN] [ARGUMENTS]"})
public class ConfigInitialTokenCmd
extends AbstractAuthOptionsCmd {
    @CommandLine.Option(names={"-d", "--delete"}, description={"Indicates that initial access token should be removed"})
    private boolean delete;
    @CommandLine.Option(names={"-k", "--keep-domain"}, description={"Don't overwrite default server and realm"})
    private boolean keepDomain;
    @CommandLine.Parameters(arity="0..1")
    private String token;

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.token == null && !this.delete && !this.keepDomain;
    }

    @Override
    protected String[] getUnsupportedOptions() {
        return new String[]{"--client", this.clientId, "--user", this.user, "--password", this.password, "--secret", this.secret, "--keystore", this.keystore, "--storepass", this.storePass, "--keypass", this.keyPass, "--alias", this.alias, "--truststore", this.trustStore, "--trustpass", this.keyPass, "--no-config", ConfigInitialTokenCmd.booleanOptionForCheck(this.noconfig)};
    }

    @Override
    protected void process() {
        if (this.realm == null) {
            throw new IllegalArgumentException("Realm not specified");
        }
        if (this.token != null && this.token.startsWith("-")) {
            IoUtil.warnfOut("You're using what looks like an OPTION as TOKEN: %s", this.token);
        }
        if (!this.delete && this.token == null) {
            this.token = IoUtils.readPasswordFromConsole("Initial Access Token");
        }
        String initialToken = this.token;
        ConfigUtil.saveMergeConfig(config -> {
            if (!this.keepDomain && !this.delete) {
                config.setServerUrl(this.server);
                config.setRealm(this.realm);
            }
            if (this.delete) {
                RealmConfigData rdata = config.getRealmConfigData(this.server, this.realm);
                if (rdata != null) {
                    rdata.setInitialToken(null);
                }
            } else {
                RealmConfigData rdata = config.ensureRealmConfigData(this.server, this.realm);
                rdata.setInitialToken(initialToken);
            }
        });
    }

    @Override
    protected String help() {
        return ConfigInitialTokenCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcRegMain.CMD + " config initial-token --server SERVER --realm REALM [--delete | TOKEN] [ARGUMENTS]");
        out.println();
        out.println("Command to configure an initial access token to be used with '" + KcRegMain.CMD + " create' command. Even if an ");
        out.println("authenticated session exists as a result of '" + KcRegMain.CMD + " config credentials' its access token will not");
        out.println("be used - initial access token will be used instead. By default, current server, and realm will");
        out.println("be set to the new values thus subsequent commands will use these values as default.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                      Print full stack trace when exiting with error");
        out.println("    --config                Path to the config file (" + KcRegMain.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println();
        out.println("  Command specific options:");
        out.println("    --server SERVER         Server endpoint url (e.g. 'http://localhost:8080')");
        out.println("    --realm REALM           Realm name to use");
        out.println("    -k, --keep-domain       Don't overwrite default server and realm");
        out.println("    -d, --delete            Indicates that initial access token should be removed");
        out.println("    TOKEN                   Initial access token (prompted for if not specified, unless -d is used)");
        out.println();
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Specify initial access token for server, and realm. Token is passed via env variable:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " config initial-token --server http://localhost:9080 --realm master " + OsUtil.OS_ARCH.envVar("TOKEN"));
        out.println();
        out.println("Remove initial access token:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " config initial-token --server http://localhost:9080 --realm master --delete");
        out.println();
        out.println();
        out.println("Use '" + KcRegMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

