/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources;

import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.resources.XAResourceMap;
import com.arjuna.ats.jta.utils.XAHelper;
import java.util.HashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceErrorHandler {
    private XAException e;
    private XAResource xaResource;
    private Xid xid;
    private boolean committed = false;
    private static HashMap<String, XAResourceMap> _maps = new HashMap();

    public XAResourceErrorHandler(XAException e, XAResource xaResource, Xid xid) {
        this.xid = xid;
        this.xaResource = xaResource;
        this.e = e;
    }

    protected boolean notAProblem(boolean commit) {
        return XAResourceErrorHandler.notAProblem(this.xaResource, this.e, commit);
    }

    public int handleCMRRollbackError() {
        if (!this.notAProblem(false)) {
            jtaLogger.i18NLogger.warn_resources_arjunacore_rollbackerror(XAHelper.xidToString(this.xid), this.xaResource.toString(), XAHelper.printXAErrorCode(this.e), this.e);
            switch (this.e.errorCode) {
                case -3: {
                    break;
                }
                case 8: {
                    return 6;
                }
                case 7: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case -4: {
                    break;
                }
                case 6: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    break;
                }
                default: {
                    return 8;
                }
            }
        }
        return 7;
    }

    public void forget() {
    }

    public int handleCMRCommitError(boolean onePhase) {
        jtaLogger.i18NLogger.warn_resources_arjunacore_commitxaerror(XAHelper.xidToString(this.xid), this.xaResource.toString(), XAHelper.printXAErrorCode(this.e), this.e);
        if (onePhase) {
            switch (this.e.errorCode) {
                case 5: 
                case 8: {
                    return 6;
                }
                case 7: {
                    this.forget();
                    break;
                }
                case 6: {
                    this.forget();
                    return 10;
                }
                case -3: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    return 10;
                }
                case -4: {
                    return 6;
                }
                case -5: {
                    return 6;
                }
                case -6: 
                case 4: {
                    return 10;
                }
                default: {
                    this.committed = true;
                    return 8;
                }
            }
            return 7;
        }
        switch (this.e.errorCode) {
            case 8: {
                return 6;
            }
            case 7: {
                break;
            }
            case -6: 
            case -3: 
            case 6: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case -4: {
                return 6;
            }
            case -7: 
            case 4: {
                this.committed = true;
                return 8;
            }
            default: {
                return 6;
            }
        }
        return 7;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public static boolean notAProblem(XAResource res, XAException ex, boolean commit) {
        boolean isNotAProblem = false;
        XAResourceMap theMap = _maps.get(res.getClass().getName());
        if (theMap != null) {
            isNotAProblem = theMap.notAProblem(ex, commit);
        }
        return isNotAProblem;
    }

    public static void addXAResourceMap(String type, XAResourceMap map) {
        _maps.put(type, map);
    }

    static {
        for (XAResourceMap xaResourceMap : jtaPropertyManager.getJTAEnvironmentBean().getXaResourceMaps()) {
            XAResourceErrorHandler.addXAResourceMap(xaResourceMap.getXAResourceName(), xaResourceMap);
        }
    }
}

