/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.export;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.plot.PlotSvgExport;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.util.PlotSvgHelper;
import org.jetbrains.relocated.apache.batik.transcoder.ErrorHandler;
import org.jetbrains.relocated.apache.batik.transcoder.TranscoderException;
import org.jetbrains.relocated.apache.batik.transcoder.TranscoderInput;
import org.jetbrains.relocated.apache.batik.transcoder.TranscoderOutput;
import org.jetbrains.relocated.apache.batik.transcoder.image.ImageTranscoder;
import org.jetbrains.relocated.apache.batik.transcoder.image.JPEGTranscoder;
import org.jetbrains.relocated.apache.batik.transcoder.image.PNGTranscoder;
import org.jetbrains.relocated.apache.batik.transcoder.image.TIFFTranscoder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport;", "", "()V", "buildImageFromRawSpecs", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$ImageData;", "plotSpec", "", "", "format", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "scalingFactor", "", "targetDPI", "Format", "ImageData", "plot-image-export"})
@SourceDebugExtension(value={"SMAP\nPlotImageExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotImageExport.kt\norg/jetbrains/letsPlot/core/plot/export/PlotImageExport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class PlotImageExport {
    @NotNull
    public static final PlotImageExport INSTANCE = new PlotImageExport();

    private PlotImageExport() {
    }

    @NotNull
    public final ImageData buildImageFromRawSpecs(@NotNull Map<String, Object> plotSpec, @NotNull Format format2, double scalingFactor2, double targetDPI2) {
        ImageTranscoder imageTranscoder;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        if (!(scalingFactor2 >= 0.1)) {
            boolean $i$a$-require-PlotImageExport$buildImageFromRawSpecs$32 = false;
            String $i$a$-require-PlotImageExport$buildImageFromRawSpecs$32 = "scaling factor is too small: " + scalingFactor2 + ", must be in range [0.1, 10.0]";
            throw new IllegalArgumentException($i$a$-require-PlotImageExport$buildImageFromRawSpecs$32.toString());
        }
        if (!(scalingFactor2 <= 10.0)) {
            boolean $i$a$-require-PlotImageExport$buildImageFromRawSpecs$42 = false;
            String $i$a$-require-PlotImageExport$buildImageFromRawSpecs$42 = "scaling factor is too large: " + scalingFactor2 + ", must be in range [0.1, 10.0]";
            throw new IllegalArgumentException($i$a$-require-PlotImageExport$buildImageFromRawSpecs$42.toString());
        }
        Format $i$a$-require-PlotImageExport$buildImageFromRawSpecs$42 = format2;
        if ($i$a$-require-PlotImageExport$buildImageFromRawSpecs$42 instanceof Format.TIFF) {
            imageTranscoder = new TIFFTranscoder();
        } else if ($i$a$-require-PlotImageExport$buildImageFromRawSpecs$42 instanceof Format.PNG) {
            imageTranscoder = new PNGTranscoder();
        } else if ($i$a$-require-PlotImageExport$buildImageFromRawSpecs$42 instanceof Format.JPEG) {
            JPEGTranscoder jPEGTranscoder;
            JPEGTranscoder $this$buildImageFromRawSpecs_u24lambda_u242 = jPEGTranscoder = new JPEGTranscoder();
            boolean bl = false;
            $this$buildImageFromRawSpecs_u24lambda_u242.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, Float.valueOf((float)((Format.JPEG)format2).getQuality()));
            imageTranscoder = jPEGTranscoder;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ImageTranscoder transcoder = imageTranscoder;
        transcoder.setErrorHandler(new ErrorHandler(){

            public void warning(@Nullable TranscoderException ex) {
            }

            public void error(@Nullable TranscoderException ex) {
                TranscoderException transcoderException = ex;
                if (transcoderException != null) {
                    TranscoderException it = transcoderException;
                    boolean bl = false;
                    throw it;
                }
                throw new IllegalStateException("PlotImageExport: empty transcoder exception".toString());
            }

            public void fatalError(@Nullable TranscoderException ex) {
                TranscoderException transcoderException = ex;
                if (transcoderException != null) {
                    TranscoderException it = transcoderException;
                    boolean bl = false;
                    throw it;
                }
                throw new IllegalStateException("PlotImageExport: empty transcoder exception".toString());
            }
        });
        String svg = PlotSvgExport.buildSvgImageFromRawSpecs$default(PlotSvgExport.INSTANCE, plotSpec, null, false, 2, null);
        DoubleVector plotSize2 = PlotSvgHelper.INSTANCE.fetchPlotSizeFromSvg(svg);
        DoubleVector imageSize = plotSize2.mul(scalingFactor2);
        transcoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, Float.valueOf((float)imageSize.getX()));
        transcoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, Float.valueOf((float)imageSize.getY()));
        double bl = targetDPI2;
        if (!Double.isInfinite(bl) && !Double.isNaN(bl)) {
            double millimeterPerDot = 25.4 / targetDPI2;
            transcoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, Float.valueOf((float)millimeterPerDot));
        }
        transcoder.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, Color.white);
        ByteArrayOutputStream image = new ByteArrayOutputStream();
        transcoder.transcode(new TranscoderInput(new StringReader(svg)), new TranscoderOutput(image));
        byte[] byArray = image.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return new ImageData(byArray, plotSize2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "", "()V", "defFileExt", "", "getDefFileExt", "()Ljava/lang/String;", "toString", "JPEG", "PNG", "TIFF", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$JPEG;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$PNG;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$TIFF;", "plot-image-export"})
    public static abstract class Format {
        private Format() {
        }

        @NotNull
        public final String getDefFileExt() {
            String string;
            Format format2 = this;
            if (format2 instanceof PNG) {
                string = "png";
            } else if (format2 instanceof TIFF) {
                string = "tiff";
            } else if (format2 instanceof JPEG) {
                string = "jpg";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @NotNull
        public String toString() {
            String string;
            Format format2 = this;
            if (format2 instanceof PNG) {
                string = "PNG";
            } else if (format2 instanceof TIFF) {
                string = "TIFF";
            } else if (format2 instanceof JPEG) {
                string = "JPG(quality=" + ((JPEG)this).getQuality() + ')';
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        public /* synthetic */ Format(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$JPEG;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "quality", "", "(D)V", "getQuality", "()D", "plot-image-export"})
        public static final class JPEG
        extends Format {
            private final double quality;

            public JPEG(double quality) {
                super(null);
                this.quality = quality;
            }

            public /* synthetic */ JPEG(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    d = 0.8;
                }
                this(d);
            }

            public final double getQuality() {
                return this.quality;
            }

            public JPEG() {
                this(0.0, 1, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$PNG;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "()V", "plot-image-export"})
        public static final class PNG
        extends Format {
            @NotNull
            public static final PNG INSTANCE = new PNG();

            private PNG() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$TIFF;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "()V", "plot-image-export"})
        public static final class TIFF
        extends Format {
            @NotNull
            public static final TIFF INSTANCE = new TIFF();

            private TIFF() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$ImageData;", "", "bytes", "", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "([BLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "getBytes", "()[B", "getPlotSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-image-export"})
    public static final class ImageData {
        @NotNull
        private final byte[] bytes;
        @NotNull
        private final DoubleVector plotSize;

        public ImageData(@NotNull byte[] bytes, @NotNull DoubleVector plotSize2) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
            this.bytes = bytes;
            this.plotSize = plotSize2;
        }

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }

        @NotNull
        public final DoubleVector getPlotSize() {
            return this.plotSize;
        }
    }
}

