/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.repository;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Authentication;
import org.jetbrains.kotlin.org.eclipse.aether.util.repository.ChainedAuthentication;
import org.jetbrains.kotlin.org.eclipse.aether.util.repository.SecretAuthentication;
import org.jetbrains.kotlin.org.eclipse.aether.util.repository.StringAuthentication;

public final class AuthenticationBuilder {
    private final List<Authentication> authentications = new ArrayList<Authentication>();

    public Authentication build() {
        if (this.authentications.isEmpty()) {
            return null;
        }
        if (this.authentications.size() == 1) {
            return this.authentications.get(0);
        }
        return new ChainedAuthentication(this.authentications);
    }

    public AuthenticationBuilder addUsername(String username) {
        return this.addString("username", username);
    }

    public AuthenticationBuilder addPassword(String password) {
        return this.addSecret("password", password);
    }

    public AuthenticationBuilder addPrivateKey(String pathname, String passphrase) {
        if (pathname != null) {
            this.addString("privateKey.path", pathname);
            this.addSecret("privateKey.passphrase", passphrase);
        }
        return this;
    }

    public AuthenticationBuilder addString(String key, String value) {
        if (value != null) {
            this.authentications.add(new StringAuthentication(key, value));
        }
        return this;
    }

    public AuthenticationBuilder addSecret(String key, String value) {
        if (value != null) {
            this.authentications.add(new SecretAuthentication(key, value));
        }
        return this;
    }
}

