/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.JsMainFunctionDetector;
import org.jetbrains.kotlin.ir.backend.js.utils.JsMainFunctionDetectorKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t*\u00020\u0014H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/MainFunctionCallWrapperLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "mainFunctionDetector", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector;", "mainFunctionArgs", "", "", "getMainFunctionArgs", "()Ljava/util/List;", "mainFunctionArgs$delegate", "Lkotlin/Lazy;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "generateWrapperForMainFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateMainArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "hasStringArrayParameter", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nMainFunctionCallWrapperLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainFunctionCallWrapperLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/MainFunctionCallWrapperLowering\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n233#2:119\n233#2:124\n1563#3:120\n1634#3,3:121\n295#3,2:125\n*S KotlinDebug\n*F\n+ 1 MainFunctionCallWrapperLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/MainFunctionCallWrapperLowering\n*L\n97#1:119\n108#1:124\n103#1:120\n103#1:121,3\n115#1:125,2\n*E\n"})
public final class MainFunctionCallWrapperLowering
implements FileLoweringPass {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final JsMainFunctionDetector mainFunctionDetector;
    @NotNull
    private final Lazy mainFunctionArgs$delegate;

    public MainFunctionCallWrapperLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.mainFunctionDetector = new JsMainFunctionDetector(this.context);
        this.mainFunctionArgs$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> MainFunctionCallWrapperLowering.mainFunctionArgs_delegate$lambda$0(this));
    }

    private final List<String> getMainFunctionArgs() {
        Lazy lazy = this.mainFunctionArgs$delegate;
        return (List)lazy.getValue();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        if (this.context.getMainCallArguments() == null) {
            return;
        }
        IrSimpleFunction irSimpleFunction = this.mainFunctionDetector.getMainFunctionOrNull(irFile);
        if (irSimpleFunction == null) {
            return;
        }
        IrSimpleFunction mainFunction = irSimpleFunction;
        IrSimpleFunction mainFunctionWrapper = this.context.getIrFactory().getStageController().restrictTo(mainFunction, () -> MainFunctionCallWrapperLowering.lower$lambda$2(this, mainFunction));
        irFile.getDeclarations().add(mainFunctionWrapper);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateWrapperForMainFunction(IrSimpleFunction $this$generateWrapperForMainFunction) {
        void $this$generateWrapperForMainFunction_u24lambda_u245_u24lambda_u244;
        IrCall irCall;
        IrBlockBody irBlockBody;
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunctionSymbol originalFunctionSymbol = $this$generateWrapperForMainFunction.getSymbol();
        IrFactory irFactory = this.context.getIrFactory();
        IrDeclarationOrigin irDeclarationOrigin = JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION();
        Name name2 = Name.identifier("mainWrapper");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        IrSimpleFunction it = irSimpleFunction = IrFactory.createSimpleFunction$default(irFactory, -1, -1, irDeclarationOrigin, name2, $this$generateWrapperForMainFunction.getVisibility(), false, false, $this$generateWrapperForMainFunction.getReturnType(), $this$generateWrapperForMainFunction.getModality(), new IrSimpleFunctionSymbolImpl(null, null, 3, null), false, false, false, false, false, null, false, 114688, null);
        boolean bl = false;
        it.setParent($this$generateWrapperForMainFunction.getParent());
        IrBlockBody irBlockBody2 = irBlockBody = this.context.getIrFactory().createBlockBody(-1, -1);
        IrSimpleFunction irSimpleFunction2 = it;
        boolean bl2 = false;
        boolean shouldCallMainFunctionAsCoroutine = JsMainFunctionDetectorKt.isLoweredSuspendFunction($this$generateWrapperForMainFunction, this.context) && MiscKt.getCompileSuspendAsJsGenerator(this.context);
        IrSimpleFunctionSymbol functionSymbolToCall = !shouldCallMainFunctionAsCoroutine ? originalFunctionSymbol : (this.hasStringArrayParameter($this$generateWrapperForMainFunction) ? this.context.getIntrinsics().getStartCoroutineUninterceptedOrReturnGeneratorVersion2() : this.context.getIntrinsics().getStartCoroutineUninterceptedOrReturnGeneratorVersion1());
        IrCall $this$generateWrapperForMainFunction_u24lambda_u245_u24lambda_u244_u24lambda_u243 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, functionSymbolToCall, null, null, null, null, 0, 0, 126, null);
        boolean bl3 = false;
        $this$generateWrapperForMainFunction_u24lambda_u245_u24lambda_u244_u24lambda_u243.getArguments().clear();
        if (shouldCallMainFunctionAsCoroutine) {
            $this$generateWrapperForMainFunction_u24lambda_u245_u24lambda_u244_u24lambda_u243.getArguments().add(BuildersKt.IrRawFunctionReferenceImpl(-1, -1, this.context.getIrBuiltIns().getAnyType(), originalFunctionSymbol));
        }
        $this$generateWrapperForMainFunction_u24lambda_u245_u24lambda_u244_u24lambda_u243.getArguments().addAll((Collection)this.generateMainArguments($this$generateWrapperForMainFunction));
        IrCall mainFunctionCall = irCall;
        $this$generateWrapperForMainFunction_u24lambda_u245_u24lambda_u244.getStatements().add(mainFunctionCall);
        irSimpleFunction2.setBody(irBlockBody);
        return irSimpleFunction;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<IrExpression> generateMainArguments(IrSimpleFunction $this$generateMainArguments) {
        block6: {
            block5: {
                v0 = var2_2 = new IrExpression[2];
                v1 = 0;
                condition$iv = this.hasStringArrayParameter($this$generateMainArguments);
                $i$f$runIf = false;
                if (!condition$iv) break block5;
                var18_5 = v1;
                var17_6 = v0;
                $i$a$-runIf-MainFunctionCallWrapperLowering$generateMainArguments$1 = false;
                v2 = this.context.getPlatformArgumentsProviderJsExpression();
                if (v2 == null) ** GOTO lbl-1000
                it = v2;
                $i$a$-let-MainFunctionCallWrapperLowering$generateMainArguments$1$1 = false;
                $this$generateMainArguments_u24lambda_u249_u24lambda_u247_u24lambda_u246 = var8_12 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getJsCode(), null, null, null, null, 0, 0, 126, null);
                $i$a$-apply-MainFunctionCallWrapperLowering$generateMainArguments$1$1$1 = false;
                $this$generateMainArguments_u24lambda_u249_u24lambda_u247_u24lambda_u246.getArguments().set(0, IrUtilsKt.toIrConst$default(it, this.context.getIrBuiltIns().getStringType(), 0, 0, 6, null));
                v3 = var8_12;
                v2 = v3;
                if (v3 != null) {
                    v4 = (IrExpression)v2;
                } else lbl-1000:
                // 2 sources

                {
                    var11_17 = this.getMainFunctionArgs();
                    var12_18 = JsIrBuilder.INSTANCE;
                    $i$f$map = false;
                    $i$a$-let-MainFunctionCallWrapperLowering$generateMainArguments$1$1 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_20 = (String)item$iv$iv;
                        var15_21 = destination$iv$iv;
                        $i$a$-map-MainFunctionCallWrapperLowering$generateMainArguments$1$2 = false;
                        var15_21.add(IrUtilsKt.toIrConst$default(it, this.context.getIrBuiltIns().getStringType(), 0, 0, 6, null));
                    }
                    v4 = var12_18.buildArray((List)destination$iv$iv, $this$generateMainArguments.getParameters().get(0).getType(), this.context.getIrBuiltIns().getStringType());
                }
                var19_23 /* !! */  = v4;
                v0 = var17_6;
                v1 = var18_5;
                v5 /* !! */  = var19_23 /* !! */ ;
                break block6;
            }
            v5 /* !! */  = null;
        }
        v0[v1] = v5 /* !! */ ;
        v6 = var2_2;
        v7 = 1;
        condition$iv = JsMainFunctionDetectorKt.isLoweredSuspendFunction($this$generateMainArguments, this.context);
        $i$f$runIf = false;
        if (condition$iv) {
            var18_5 = v7;
            var17_6 = v6;
            $i$a$-runIf-MainFunctionCallWrapperLowering$generateMainArguments$2 = false;
            v8 = ((IrProperty)this.context.getCoroutineEmptyContinuation().getOwner()).getGetter();
            Intrinsics.checkNotNull(v8);
            var19_23 /* !! */  = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, v8.getSymbol(), null, null, null, null, 0, 0, 126, null);
            v6 = var17_6;
            v7 = var18_5;
            v9 = var19_23 /* !! */ ;
        } else {
            v9 = null;
        }
        v6[v7] = v9;
        return CollectionsKt.listOfNotNull(var2_2);
    }

    private final boolean hasStringArrayParameter(IrSimpleFunction $this$hasStringArrayParameter) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$hasStringArrayParameter.getParameters();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                if (!(it.getKind() == IrParameterKind.Regular)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        IrValueParameter irValueParameter = v0;
        return irValueParameter != null ? JsMainFunctionDetectorKt.isStringArrayParameter(irValueParameter) : false;
    }

    private static final List mainFunctionArgs_delegate$lambda$0(MainFunctionCallWrapperLowering this$0) {
        List<String> list = this$0.context.getMainCallArguments();
        if (list == null) {
            throw new IllegalStateException("Expect to have main call args at this point".toString());
        }
        return list;
    }

    private static final IrSimpleFunction lower$lambda$2(MainFunctionCallWrapperLowering this$0, IrSimpleFunction $mainFunction) {
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction it = irSimpleFunction = this$0.generateWrapperForMainFunction($mainFunction);
        boolean bl = false;
        JsIrAttributesKt.setMainFunctionWrapper($mainFunction, it);
        return irSimpleFunction;
    }
}

