/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.blockingCallsDetection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.ElementContext;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.ChangeContextFix;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.CoroutineBlockingCallInspectionUtils;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.FlowOnIoContextFix;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.WrapInWithContextFix;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingMethodChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/BlockingMethodChecker;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isMethodNonBlocking", "context", "Lcom/intellij/codeInspection/blockingCallsDetection/MethodContext;", "getQuickFixesFor", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "elementContext", "Lcom/intellij/codeInspection/blockingCallsDetection/ElementContext;", "(Lcom/intellij/codeInspection/blockingCallsDetection/ElementContext;)[Lcom/intellij/codeInspection/LocalQuickFix;", "getLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "psiElement", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nCoroutineBlockingMethodChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBlockingMethodChecker.kt\norg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingMethodChecker\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,58:1\n66#2,2:59\n*S KotlinDebug\n*F\n+ 1 CoroutineBlockingMethodChecker.kt\norg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingMethodChecker\n*L\n44#1:59,2\n*E\n"})
public final class CoroutineBlockingMethodChecker
implements BlockingMethodChecker {
    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof KtFile)) {
            return false;
        }
        LanguageVersionSettings languageVersionSettings = this.getLanguageVersionSettings((PsiElement)file);
        return languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMethodNonBlocking(@NotNull MethodContext context) {
        UElement uMethod;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        UElement uElement = uMethod = UastContextKt.toUElement((PsiElement)((PsiElement)context.getElement()));
        UElement uElement2 = uElement;
        if (uElement == null) return false;
        if ((uElement2 = uElement2.getSourcePsi()) == null) {
            return false;
        }
        UElement sourcePsi = uElement2;
        if (!(sourcePsi instanceof KtNamedFunction)) return false;
        KtModifierList ktModifierList = ((KtNamedFunction)sourcePsi).getModifierList();
        if (ktModifierList == null) return false;
        if (!PsiUtilsKt.hasSuspendModifier((KtModifierList)ktModifierList)) return false;
        return true;
    }

    @NotNull
    public LocalQuickFix[] getQuickFixesFor(@NotNull ElementContext elementContext) {
        LocalQuickFix[] localQuickFixArray;
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        PsiElement element = elementContext.getElement();
        if (!(element instanceof KtCallExpression)) {
            return new LocalQuickFix[0];
        }
        PsiElement $this$parentOfType_u24default$iv = element;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtCallExpression.class, (boolean)true);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = ktCallExpression != null ? ResolutionUtils.resolveToCall((KtElement)ktCallExpression, BodyResolveMode.PARTIAL) : null;
        PsiFile psiFile = ((KtCallExpression)element).getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        if (!this.isApplicable(psiFile) || !CoroutineBlockingCallInspectionUtils.INSTANCE.isKotlinxOnClasspath((KtElement)element)) {
            localQuickFixArray = new LocalQuickFix[]{};
        } else if (resolvedCall != null && CoroutineBlockingCallInspectionUtils.INSTANCE.isCalledInsideNonIoContext(resolvedCall) && CoroutineBlockingCallInspectionUtils.INSTANCE.isInSuspendLambdaOrFunction((KtElement)element)) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{new ChangeContextFix(), new WrapInWithContextFix()};
            localQuickFixArray = localQuickFixArray2;
        } else if (resolvedCall != null && CoroutineBlockingCallInspectionUtils.INSTANCE.isInsideFlowChain(resolvedCall)) {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[]{new FlowOnIoContextFix(), new WrapInWithContextFix()};
            localQuickFixArray = localQuickFixArray3;
        } else if (CoroutineBlockingCallInspectionUtils.INSTANCE.isInSuspendLambdaOrFunction((KtElement)element)) {
            LocalQuickFix[] localQuickFixArray4 = new LocalQuickFix[]{new WrapInWithContextFix()};
            localQuickFixArray = localQuickFixArray4;
        } else {
            localQuickFixArray = new LocalQuickFix[]{};
        }
        return localQuickFixArray;
    }

    private final LanguageVersionSettings getLanguageVersionSettings(PsiElement psiElement) {
        Module module = GenericPsiUtils.getModule(psiElement);
        if (module == null || (module = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(module)) == null) {
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            module = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(project);
        }
        return module;
    }
}

