/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifierKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J!\u0010!\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\tH\u0082\u0010R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithOperatorAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "<init>", "()V", "isApplicable", "", "element", "inspectionText", "", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "fixText", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "checkExpressionRepeat", "variableExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isCommutative", "operationToken", "Lcom/intellij/psi/tree/IElementType;", "isArithmeticOperation", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "buildOperatorAssignment", "buildOperatorAssignmentText", "tail", "kotlin.idea"})
public final class ReplaceWithOperatorAssignmentInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    public ReplaceWithOperatorAssignmentInspection() {
        super(KtBinaryExpression.class);
    }

    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!Intrinsics.areEqual((Object)element.getOperationToken(), (Object)KtTokens.EQ)) {
            return false;
        }
        KtExpression ktExpression = element.getLeft();
        if (ktExpression == null) {
            return false;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = element.getRight();
        KtBinaryExpression ktBinaryExpression = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression right = ktBinaryExpression;
        if (right.getLeft() == null || right.getRight() == null) {
            return false;
        }
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)right, BodyResolveMode.PARTIAL_WITH_CFA);
        if (!this.checkExpressionRepeat(left, right, bindingContext)) {
            return false;
        }
        KtBinaryExpression ktBinaryExpression2 = this.buildOperatorAssignment(element);
        if (ktBinaryExpression2 == null) {
            return false;
        }
        KtBinaryExpression opAssign = ktBinaryExpression2;
        KtFile ktFile2 = opAssign.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtPsiFactoryKt.setDoNotAnalyze((KtFile)ktFile2, null);
        BindingContext newBindingContext = ExtendedResolutionApiKt.analyzeAsReplacement$default((KtExpression)opAssign, (KtExpression)element, bindingContext, null, null, null, 28, null);
        Diagnostics diagnostics = newBindingContext.getDiagnostics();
        KtOperationReferenceExpression ktOperationReferenceExpression = opAssign.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
        return diagnostics.forElement((PsiElement)ktOperationReferenceExpression).isEmpty();
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"replaceable.with.operator.assignment", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"replace.with.operator.assignment", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new Object[1];
        KtExpression ktExpression = element.getRight();
        KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        objectArray[0] = (ktBinaryExpression != null && (ktBinaryExpression = ktBinaryExpression.getOperationReference()) != null && (ktBinaryExpression = ktBinaryExpression.getOperationSignTokenType()) != null ? ktBinaryExpression.getValue() : null) + "=";
        return KotlinBundle.message((String)"replace.with.0", (Object[])objectArray);
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtBinaryExpression element) {
        KtNameReferenceExpression left;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getLeft();
        KtNameReferenceExpression ktNameReferenceExpression = left = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (left != null) {
            KotlinType leftType;
            BindingContext context = ResolutionUtils.analyze((KtElement)left, BodyResolveMode.PARTIAL);
            KotlinType kotlinType = leftType = CallUtilKt.getType((KtExpression)((KtExpression)left), (BindingContext)context);
            boolean bl = kotlinType != null ? FunctionUtilsKt.isReadOnlyCollectionOrMap(kotlinType, PlatformKt.getBuiltIns((KtElement)element)) : false;
            if (bl) {
                return ProblemHighlightType.INFORMATION;
            }
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    private final boolean checkExpressionRepeat(KtExpression variableExpression, KtBinaryExpression expression, BindingContext bindingContext) {
        boolean bl;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression.getOperationReference());
        DeclarationDescriptor descriptor2 = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        boolean isPrimitiveOperation = descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isPrimitiveType((KotlinType)((KotlinType)((ClassDescriptor)descriptor2).getDefaultType()));
        IElementType iElementType = expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType operationToken = iElementType;
        KtExpression expressionLeft = expression.getLeft();
        KtExpression expressionRight = expression.getRight();
        if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expressionLeft)) {
            bl = this.isArithmeticOperation(operationToken);
        } else if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expressionRight)) {
            bl = isPrimitiveOperation && this.isCommutative(operationToken);
        } else if (expressionLeft instanceof KtBinaryExpression) {
            boolean sameCommutativeOperation;
            boolean bl2 = sameCommutativeOperation = Intrinsics.areEqual((Object)((KtBinaryExpression)expressionLeft).getOperationToken(), (Object)operationToken) && this.isCommutative(operationToken);
            bl = isPrimitiveOperation && sameCommutativeOperation && this.checkExpressionRepeat(variableExpression, (KtBinaryExpression)expressionLeft, bindingContext);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCommutative(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MUL);
    }

    private final boolean isArithmeticOperation(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MUL) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.DIV) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PERC);
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtBinaryExpression ktBinaryExpression = this.buildOperatorAssignment(element);
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression operatorAssignment = ktBinaryExpression;
        element.replace((PsiElement)operatorAssignment);
    }

    private final KtBinaryExpression buildOperatorAssignment(KtBinaryExpression element) {
        KtExpression ktExpression = element.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression variableExpression = ktExpression;
        KtExpression ktExpression2 = element.getRight();
        KtBinaryExpression ktBinaryExpression = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression assignedExpression = ktBinaryExpression;
        String replacement = this.buildOperatorAssignmentText(variableExpression, assignedExpression, "");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression ktExpression3 = new KtPsiFactory(project, false, 2, null).createExpression(replacement);
        Intrinsics.checkNotNull((Object)ktExpression3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        return (KtBinaryExpression)ktExpression3;
    }

    private final String buildOperatorAssignmentText(KtExpression variableExpression, KtBinaryExpression expression, String tail) {
        String string;
        block3: {
            ReplaceWithOperatorAssignmentInspection replaceWithOperatorAssignmentInspection = this;
            while (true) {
                String operationText = expression.getOperationReference().getText();
                String variableName = variableExpression.getText();
                if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expression.getLeft())) {
                    KtExpression ktExpression = expression.getRight();
                    Intrinsics.checkNotNull((Object)ktExpression);
                    string = ReplaceWithOperatorAssignmentInspection.buildOperatorAssignmentText$appendTail(variableName + " " + operationText + "= " + ktExpression.getText(), tail);
                    break block3;
                }
                if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expression.getRight())) {
                    KtExpression ktExpression = expression.getLeft();
                    Intrinsics.checkNotNull((Object)ktExpression);
                    string = ReplaceWithOperatorAssignmentInspection.buildOperatorAssignmentText$appendTail(variableName + " " + operationText + "= " + ktExpression.getText(), tail);
                    break block3;
                }
                if (!(expression.getLeft() instanceof KtBinaryExpression)) break;
                ReplaceWithOperatorAssignmentInspection replaceWithOperatorAssignmentInspection2 = replaceWithOperatorAssignmentInspection;
                KtExpression ktExpression = variableExpression;
                KtExpression ktExpression2 = expression.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
                KtExpression ktExpression3 = expression.getRight();
                Intrinsics.checkNotNull((Object)ktExpression3);
                String string2 = ReplaceWithOperatorAssignmentInspection.buildOperatorAssignmentText$appendTail(operationText + " " + ktExpression3.getText(), tail);
                replaceWithOperatorAssignmentInspection = replaceWithOperatorAssignmentInspection2;
                variableExpression = ktExpression;
                expression = ktBinaryExpression;
                tail = string2;
            }
            string = tail;
        }
        return string;
    }

    private static final String buildOperatorAssignmentText$appendTail(String $this$buildOperatorAssignmentText_u24appendTail, String $tail) {
        return ((CharSequence)$tail).length() == 0 ? $this$buildOperatorAssignmentText_u24appendTail : $this$buildOperatorAssignmentText_u24appendTail + " " + $tail;
    }
}

