/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.NegatedBinaryExpressionSimplificationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NullableBooleanElvisInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "ReplaceWithEqualityCheckFix", "kotlin.idea"})
public final class NullableBooleanElvisInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return VisitorWrappersKt.binaryExpressionVisitor(arg_0 -> NullableBooleanElvisInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    private static final Unit buildVisitor$lambda$0(NullableBooleanElvisInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtBinaryExpression expression) {
        if (!Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.ELVIS)) {
            return Unit.INSTANCE;
        }
        KtExpression ktExpression = expression.getLeft();
        if (ktExpression == null) {
            return Unit.INSTANCE;
        }
        KtExpression lhs = ktExpression;
        KtExpression ktExpression2 = expression.getRight();
        if (ktExpression2 == null) {
            return Unit.INSTANCE;
        }
        KtExpression rhs = ktExpression2;
        if (!KtPsiUtil.isBooleanConstant((KtExpression)rhs)) {
            return Unit.INSTANCE;
        }
        KotlinType kotlinType = ResolutionUtils.analyze((KtElement)lhs, BodyResolveMode.PARTIAL).getType(lhs);
        if (kotlinType == null) {
            return Unit.INSTANCE;
        }
        KotlinType lhsType = kotlinType;
        if (TypeUtils.isNullableType((KotlinType)lhsType) && TypeUtilsKt.isBooleanOrNullableBoolean((KotlinType)lhsType)) {
            Class[] classArray = new Class[]{KtIfExpression.class, KtWhileExpressionBase.class};
            KtExpressionImpl parentIfOrWhile = (KtExpressionImpl)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression), (Class[])classArray);
            KtExpression condition2 = parentIfOrWhile instanceof KtIfExpression ? ((KtIfExpression)parentIfOrWhile).getCondition() : (parentIfOrWhile instanceof KtWhileExpressionBase ? ((KtWhileExpressionBase)parentIfOrWhile).getCondition() : null);
            Pair pair = condition2 != null && SequencesKt.contains((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)expression)), (Object)condition2) ? TuplesKt.to((Object)ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (Object)KotlinBundle.message((String)"text.should", (Object[])new Object[0])) : TuplesKt.to((Object)ProblemHighlightType.INFORMATION, (Object)KotlinBundle.message((String)"text.can", (Object[])new Object[0]));
            ProblemHighlightType highlightType = (ProblemHighlightType)pair.component1();
            String verb = (String)pair.component2();
            Object[] objectArray = new Object[]{verb};
            String string = KotlinBundle.message((String)"equality.check.0.be.used.instead.of.elvis.for.nullable.boolean.check", (Object[])objectArray);
            objectArray = new LocalQuickFix[]{new ReplaceWithEqualityCheckFix()};
            this$0.registerProblemWithoutOfflineInformation($holder, (PsiElement)expression, string, $isOnTheFly, highlightType, (LocalQuickFix[])objectArray);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NullableBooleanElvisInspection$ReplaceWithEqualityCheckFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nNullableBooleanElvisInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NullableBooleanElvisInspection.kt\norg/jetbrains/kotlin/idea/inspections/NullableBooleanElvisInspection$ReplaceWithEqualityCheckFix\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,81:1\n29#2,7:82\n196#3:89\n*S KotlinDebug\n*F\n+ 1 NullableBooleanElvisInspection.kt\norg/jetbrains/kotlin/idea/inspections/NullableBooleanElvisInspection$ReplaceWithEqualityCheckFix\n*L\n69#1:82,7\n73#1:89\n*E\n"})
    private static final class ReplaceWithEqualityCheckFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"replace.with.equality.check.fix.text", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void $this$getParentOfType$iv;
            PsiElement psiElement;
            void $this$replaced$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtBinaryExpression ktBinaryExpression = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression element = ktBinaryExpression;
            if (!Intrinsics.areEqual((Object)element.getOperationToken(), (Object)KtTokens.ELVIS)) {
                return;
            }
            KtExpression ktExpression = element.getRight();
            KtConstantExpression ktConstantExpression = ktExpression instanceof KtConstantExpression ? (KtConstantExpression)ktExpression : null;
            if (ktConstantExpression == null) {
                return;
            }
            KtConstantExpression constPart = ktConstantExpression;
            KtExpression ktExpression2 = element.getLeft();
            if (ktExpression2 == null) {
                return;
            }
            KtExpression exprPart = ktExpression2;
            if (KtPsiUtil.isTrueConstant((KtExpression)((KtExpression)constPart))) {
                bl = true;
            } else if (KtPsiUtil.isFalseConstant((KtExpression)((KtExpression)constPart))) {
                bl = false;
            } else {
                return;
            }
            boolean constValue = bl;
            PsiElement psiElement3 = (PsiElement)element;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (boolean)false, arg_0 -> ReplaceWithEqualityCheckFix.applyFix$lambda$0(exprPart, constValue, arg_0), (int)1, null);
            boolean $i$f$replaced22 = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression3;
                }
            }
            KtExpression equalityCheckExpression = (KtExpression)psiElement;
            PsiElement $i$f$replaced22 = (PsiElement)equalityCheckExpression;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtPrefixExpression.class, (boolean)strict$iv);
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression prefixExpression = ktPrefixExpression;
            if (NegatedBinaryExpressionSimplificationUtils.INSTANCE.canBeSimplified(prefixExpression)) {
                NegatedBinaryExpressionSimplificationUtils.INSTANCE.simplify(prefixExpression);
            }
        }

        private static final Unit applyFix$lambda$0(KtExpression $exprPart, boolean $constValue, BuilderByPattern $this$buildExpression) {
            Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
            $this$buildExpression.appendExpression($exprPart);
            $this$buildExpression.appendFixedText($constValue ? " != false" : " == true");
            return Unit.INSTANCE;
        }
    }
}

