/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.mutating;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.Mutation;
import com.intellij.database.datagrid.mutating.RowMutation;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CellMutation
extends Mutation {
    private final ModelIndex<GridColumn> myColumn;
    private final Object myNewValue;

    public CellMutation(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable Object newValue) {
        if (row == null) {
            CellMutation.$$$reportNull$$$0(0);
        }
        if (column == null) {
            CellMutation.$$$reportNull$$$0(1);
        }
        super(row);
        this.myColumn = column;
        this.myNewValue = newValue;
    }

    public boolean canMergeByRowWith(@NotNull CellMutation mutation) {
        if (mutation == null) {
            CellMutation.$$$reportNull$$$0(2);
        }
        return mutation.getRow().equals(this.getRow());
    }

    @Nullable
    public Object getValue() {
        return this.myNewValue;
    }

    @NotNull
    public ModelIndex<GridColumn> getColumn() {
        ModelIndex<GridColumn> modelIndex = this.myColumn;
        if (modelIndex == null) {
            CellMutation.$$$reportNull$$$0(3);
        }
        return modelIndex;
    }

    @Nullable
    public RowMutation createRowMutation(@NotNull GridModel<GridRow, GridColumn> model) {
        if (model == null) {
            CellMutation.$$$reportNull$$$0(4);
        }
        GridColumn column = model.getColumn(this.myColumn);
        GridRow row = model.getRow(this.getRow());
        return row == null || column == null ? null : new RowMutation(row, Collections.singletonList(new ColumnQueryData(column, this.myNewValue)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/mutating/CellMutation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/mutating/CellMutation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canMergeByRowWith";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRowMutation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class Builder {
        private ModelIndex<GridRow> myRow;
        private ModelIndex<GridColumn> myColumn;
        private Object myValue;

        @NotNull
        public Builder row(@NotNull ModelIndex<GridRow> row) {
            if (row == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myRow = row;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder column(@NotNull ModelIndex<GridColumn> column) {
            if (column == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myColumn = column;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder value(@Nullable Object value) {
            this.myValue = value;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @Nullable
        public ModelIndex<GridRow> getRow() {
            return this.myRow;
        }

        @NotNull
        public CellMutation build() {
            return new CellMutation(this.myRow, this.myColumn, this.myValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/mutating/CellMutation$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/mutating/CellMutation$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "row";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "column";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "row";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "column";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

