/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.cli.metadata.KotlinMetadataCompiler;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImplBase;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.EventManagerImpl;
import org.jetbrains.kotlin.daemon.KotlinJvmReplService;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteEnumWhenTracker;
import org.jetbrains.kotlin.daemon.RemoteExpectActualTracker;
import org.jetbrains.kotlin.daemon.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.daemon.RemoteIncrementalDataProvider;
import org.jetbrains.kotlin.daemon.RemoteIncrementalResultsConsumer;
import org.jetbrains.kotlin.daemon.RemoteInlineConstTracker;
import org.jetbrains.kotlin.daemon.RemoteLookupTrackerClient;
import org.jetbrains.kotlin.daemon.RemoteReplStateFacadeServer;
import org.jetbrains.kotlin.daemon.common.BuildMetricsValue;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.JpsCompilerServicesFacade;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.ReplStateFacade;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.daemon.report.CompileServicesFacadeMessageCollector;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterKt;
import org.jetbrains.kotlin.daemon.report.GetICReporterKt;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J<\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u00020\u000e2\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001f0#\u00a2\u0006\u0002\b%H\u0082\bJ\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001fH\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020-0\u001fH\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0016J\u0018\u00100\u001a\b\u0012\u0004\u0012\u0002010\u001f2\b\u00102\u001a\u0004\u0018\u00010-H\u0016J\u0014\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-040\u001fH\u0016J\u0018\u00105\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\b\u00102\u001a\u0004\u0018\u00010-H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u0002010\u001f2\u0006\u0010!\u001a\u00020\u000eH\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\bH\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020'0\u001f2\u0006\u0010;\u001a\u000208H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u0002010\u001fH\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u0002080\u001f2\u0006\u0010>\u001a\u000208H\u0016J*\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0@0\u001f2\u0006\u0010!\u001a\u00020\u000e2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0@H\u0016JE\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\u0006\u0010!\u001a\u00020\u000e2\u000e\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u00010KH\u0016\u00a2\u0006\u0002\u0010LJ\u0016\u0010M\u001a\b\u0012\u0004\u0012\u0002010\u001f2\u0006\u0010!\u001a\u00020\u000eH\u0016J \u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002JS\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\b\u00102\u001a\u0004\u0018\u00010-2\u000e\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020B042\u0006\u0010X\u001a\u00020-H\u0016\u00a2\u0006\u0002\u0010YJ\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0\u001f2\u0006\u0010!\u001a\u00020\u000eH\u0016J&\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0\u001f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020`H\u0016J&\u0010a\u001a\b\u0012\u0004\u0012\u00020b0\u001f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020`H\u0016J\b\u0010c\u001a\u00020\u0013H\u0014J\b\u0010d\u001a\u00020\u0013H\u0014J\b\u0010e\u001a\u00020\u0013H\u0014J\b\u0010f\u001a\u00020\u0013H\u0002J\b\u0010g\u001a\u00020\u0013H\u0002J\u0010\u0010h\u001a\u0002082\u0006\u0010i\u001a\u000208H\u0002J\b\u0010j\u001a\u00020\u0013H\u0016J3\u0010k\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\b\b\u0002\u0010l\u001a\u00020m2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001f0\u0012H\u0082\bJ!\u0010n\u001a\u00020\u00132\b\b\u0002\u0010l\u001a\u00020m2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ3\u0010o\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\b\b\u0002\u0010l\u001a\u00020m2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001f0\u0012H\u0082\bJ!\u0010p\u001a\u00020\u00132\b\b\u0002\u0010l\u001a\u00020m2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010&\u001a\u00020'8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "<init>", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/daemon/CompilerSelector;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "getRegistry", "()Ljava/rmi/registry/Registry;", "getCompiler", "()Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "getDaemonJVMOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "getOnShutdown", "()Lkotlin/jvm/functions/Function0;", "withValidRepl", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "R", "sessionId", "body", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService;", "Lkotlin/ExtensionFunctionType;", "lastUsedSeconds", "", "getLastUsedSeconds", "()J", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getDaemonInfo", "", "getKotlinVersion", "getDaemonOptions", "registerClient", "", "aliveFlagPath", "getClients", "", "leaseCompileSession", "releaseCompileSession", "checkCompilerId", "", "expectedCompilerId", "getUsedMemory", "withGC", "shutdown", "scheduleShutdown", "graceful", "classesFqNamesByFiles", "", "sourceFiles", "Ljava/io/File;", "compile", "compilerArguments", "", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationResults;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "releaseReplSession", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManager", "Lorg/jetbrains/kotlin/daemon/EventManager;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "leaseReplSession", "templateClasspath", "templateClassName", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "replCreateState", "Lorg/jetbrains/kotlin/daemon/common/ReplStateFacade;", "replCheck", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "replStateId", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "replCompile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "periodicAndAfterSessionCheck", "periodicSeldomCheck", "initiateElections", "shutdownNow", "shutdownWithDelay", "gracefulShutdown", "onAnotherThread", "clearJarCache", "ifAlive", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$Aliveness;", "ifAliveUnit", "ifAliveExclusive", "ifAliveExclusiveUnit", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nCompileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n+ 2 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 6 CompilerRunnerUtils.kt\norg/jetbrains/kotlin/incremental/CompilerRunnerUtils\n+ 7 IncrementalJsCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCompilerRunnerKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1166:1\n1141#1,2:1179\n1143#1:1204\n1138#1,5:1205\n1143#1:1233\n1138#1,5:1234\n1143#1:1262\n1138#1,5:1263\n1143#1:1291\n1141#1,2:1292\n1143#1:1317\n1138#1,5:1318\n1143#1:1346\n1141#1,2:1347\n1143#1:1372\n1141#1,2:1373\n1143#1:1398\n1138#1,5:1402\n1143#1:1435\n1155#1,2:1436\n1157#1:1461\n1141#1,2:1462\n1143#1:1487\n1138#1,5:1488\n1143#1:1526\n1138#1,5:1527\n1143#1:1972\n1141#1,2:1973\n1143#1:1998\n1141#1,2:1999\n714#1:2021\n1143#1:2037\n1141#1,2:2038\n714#1:2060\n1143#1:2076\n1141#1,2:2077\n714#1:2099\n1143#1:2115\n1145#1,2:2116\n1147#1,2:2138\n1150#1:2143\n1145#1,2:2144\n1147#1,2:2166\n1150#1:2171\n1145#1,2:2172\n1147#1,2:2194\n1150#1:2199\n1145#1,2:2200\n1147#1:2222\n1148#1:2230\n1150#1:2234\n1159#1,2:2417\n1161#1,2:2439\n1164#1:2444\n694#2:1167\n574#2,2:1168\n573#2,6:1170\n696#2:1176\n580#2:1177\n697#2:1178\n542#2,7:1181\n549#2,15:1189\n542#2,7:1210\n549#2,15:1218\n542#2,7:1239\n549#2,15:1247\n542#2,7:1268\n549#2,15:1276\n542#2,7:1294\n549#2,15:1302\n542#2,7:1323\n549#2,15:1331\n542#2,7:1349\n549#2,15:1357\n542#2,7:1375\n549#2,15:1383\n542#2,7:1407\n549#2,12:1415\n561#2,3:1432\n542#2,7:1438\n549#2,15:1446\n542#2,7:1464\n549#2,15:1472\n542#2,7:1493\n549#2,12:1501\n574#2,2:1513\n573#2,8:1515\n561#2,3:1523\n542#2,7:1532\n549#2,12:1540\n331#2,25:1552\n356#2:1585\n432#2,3:1586\n574#2,2:1589\n573#2,6:1591\n435#2,6:1597\n459#2,4:1603\n441#2:1609\n357#2,6:1610\n363#2,2:1617\n365#2,3:1620\n464#2:1625\n466#2,36:1631\n443#2,5:1667\n580#2:1672\n448#2,2:1673\n368#2:1675\n372#2:1677\n432#2,3:1678\n574#2,2:1681\n573#2,6:1683\n435#2,6:1689\n459#2,4:1695\n441#2:1699\n373#2,11:1700\n464#2:1713\n466#2,36:1719\n443#2,5:1755\n580#2:1760\n448#2,2:1761\n387#2,5:1763\n392#2:1778\n432#2,3:1779\n574#2,2:1782\n573#2,6:1784\n435#2,6:1790\n459#2,4:1796\n441#2:1800\n393#2,10:1801\n464#2:1813\n466#2,36:1819\n443#2,5:1855\n580#2:1860\n448#2,2:1861\n403#2:1863\n405#2:1865\n406#2:1876\n432#2,3:1877\n574#2,2:1880\n573#2,6:1882\n435#2,6:1888\n459#2,4:1894\n441#2:1898\n407#2,10:1899\n464#2:1911\n466#2,36:1917\n443#2,5:1953\n580#2:1958\n448#2,2:1959\n417#2:1961\n419#2,6:1963\n561#2,3:1969\n542#2,7:1975\n549#2,15:1983\n542#2,7:2001\n549#2,12:2009\n694#2:2022\n574#2,2:2023\n573#2,6:2025\n696#2:2031\n580#2:2032\n697#2:2033\n561#2,3:2034\n542#2,7:2040\n549#2,12:2048\n694#2:2061\n574#2,2:2062\n573#2,6:2064\n696#2:2070\n580#2:2071\n697#2:2072\n561#2,3:2073\n542#2,7:2079\n549#2,12:2087\n694#2:2100\n574#2,2:2101\n573#2,6:2103\n696#2:2109\n580#2:2110\n697#2:2111\n561#2,3:2112\n542#2,7:2118\n549#2,12:2126\n561#2,3:2140\n542#2,7:2146\n549#2,12:2154\n561#2,3:2168\n542#2,7:2174\n549#2,12:2182\n561#2,3:2196\n542#2,7:2202\n549#2,12:2210\n561#2,3:2231\n542#2,7:2237\n549#2,15:2245\n542#2,22:2260\n542#2,7:2282\n549#2,15:2290\n542#2,22:2305\n542#2,7:2327\n549#2,15:2335\n542#2,22:2350\n542#2,7:2372\n549#2,15:2380\n542#2,22:2395\n542#2,7:2419\n549#2,12:2427\n561#2,3:2441\n1#3:1188\n1#3:1217\n1#3:1246\n1#3:1275\n1#3:1301\n1#3:1330\n1#3:1356\n1#3:1382\n1#3:1414\n1#3:1445\n1#3:1471\n1#3:1500\n1#3:1539\n1#3:1982\n1#3:2008\n1#3:2047\n1#3:2086\n1#3:2125\n1#3:2153\n1#3:2181\n1#3:2209\n1#3:2224\n1#3:2244\n1#3:2289\n1#3:2334\n1#3:2379\n1#3:2426\n1740#4,3:1399\n1869#4:1616\n1870#4:1619\n1869#4:2223\n1869#4,2:2225\n1870#4:2227\n1869#4,2:2228\n90#5,5:1427\n44#5,2:1607\n46#5,2:1623\n90#5,5:1626\n46#5,2:1711\n90#5,5:1714\n46#5,2:1811\n90#5,5:1814\n46#5,2:1909\n90#5,5:1912\n107#6,8:1577\n116#6:1676\n105#6,10:1768\n116#6:1864\n59#7,10:1866\n70#7:1962\n13472#8,2:2235\n*S KotlinDebug\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n*L\n724#1:1179,2\n724#1:1204\n728#1:1205,5\n728#1:1233\n736#1:1234,5\n736#1:1262\n740#1:1263,5\n740#1:1291\n746#1:1292,2\n746#1:1317\n752#1:1318,5\n752#1:1346\n757#1:1347,2\n757#1:1372\n765#1:1373,2\n765#1:1398\n778#1:1402,5\n778#1:1435\n780#1:1436,2\n780#1:1461\n785#1:1462,2\n785#1:1487\n799#1:1488,5\n799#1:1526\n811#1:1527,5\n811#1:1972\n874#1:1973,2\n874#1:1998\n891#1:1999,2\n892#1:2021\n891#1:2037\n898#1:2038,2\n899#1:2060\n898#1:2076\n907#1:2077,2\n908#1:2099\n907#1:2115\n921#1:2116,2\n921#1:2138,2\n921#1:2143\n943#1:2144,2\n943#1:2166,2\n943#1:2171\n961#1:2172,2\n961#1:2194,2\n961#1:2199\n975#1:2200,2\n975#1:2222\n975#1:2230\n975#1:2234\n1082#1:2417,2\n1082#1:2439,2\n1082#1:2444\n714#1:1167\n714#1:1168,2\n714#1:1170,6\n714#1:1176\n714#1:1177\n714#1:1178\n724#1:1181,7\n724#1:1189,15\n728#1:1210,7\n728#1:1218,15\n736#1:1239,7\n736#1:1247,15\n740#1:1268,7\n740#1:1276,15\n746#1:1294,7\n746#1:1302,15\n752#1:1323,7\n752#1:1331,15\n757#1:1349,7\n757#1:1357,15\n765#1:1375,7\n765#1:1383,15\n778#1:1407,7\n778#1:1415,12\n778#1:1432,3\n780#1:1438,7\n780#1:1446,15\n785#1:1464,7\n785#1:1472,15\n799#1:1493,7\n799#1:1501,12\n800#1:1513,2\n800#1:1515,8\n799#1:1523,3\n811#1:1532,7\n811#1:1540,12\n812#1:1552,25\n812#1:1585\n812#1:1586,3\n812#1:1589,2\n812#1:1591,6\n812#1:1597,6\n812#1:1603,4\n812#1:1609\n812#1:1610,6\n812#1:1617,2\n812#1:1620,3\n812#1:1625\n812#1:1631,36\n812#1:1667,5\n812#1:1672\n812#1:1673,2\n812#1:1675\n812#1:1677\n812#1:1678,3\n812#1:1681,2\n812#1:1683,6\n812#1:1689,6\n812#1:1695,4\n812#1:1699\n812#1:1700,11\n812#1:1713\n812#1:1719,36\n812#1:1755,5\n812#1:1760\n812#1:1761,2\n812#1:1763,5\n812#1:1778\n812#1:1779,3\n812#1:1782,2\n812#1:1784,6\n812#1:1790,6\n812#1:1796,4\n812#1:1800\n812#1:1801,10\n812#1:1813\n812#1:1819,36\n812#1:1855,5\n812#1:1860\n812#1:1861,2\n812#1:1863\n812#1:1865\n812#1:1876\n812#1:1877,3\n812#1:1880,2\n812#1:1882,6\n812#1:1888,6\n812#1:1894,4\n812#1:1898\n812#1:1899,10\n812#1:1911\n812#1:1917,36\n812#1:1953,5\n812#1:1958\n812#1:1959,2\n812#1:1961\n812#1:1963,6\n811#1:1969,3\n874#1:1975,7\n874#1:1983,15\n891#1:2001,7\n891#1:2009,12\n892#1:2022\n892#1:2023,2\n892#1:2025,6\n892#1:2031\n892#1:2032\n892#1:2033\n891#1:2034,3\n898#1:2040,7\n898#1:2048,12\n899#1:2061\n899#1:2062,2\n899#1:2064,6\n899#1:2070\n899#1:2071\n899#1:2072\n898#1:2073,3\n907#1:2079,7\n907#1:2087,12\n908#1:2100\n908#1:2101,2\n908#1:2103,6\n908#1:2109\n908#1:2110\n908#1:2111\n907#1:2112,3\n921#1:2118,7\n921#1:2126,12\n921#1:2140,3\n943#1:2146,7\n943#1:2154,12\n943#1:2168,3\n961#1:2174,7\n961#1:2182,12\n961#1:2196,3\n975#1:2202,7\n975#1:2210,12\n975#1:2231,3\n1142#1:2237,7\n1142#1:2245,15\n1142#1:2260,22\n1146#1:2282,7\n1146#1:2290,15\n1146#1:2305,22\n1156#1:2327,7\n1156#1:2335,15\n1156#1:2350,22\n1160#1:2372,7\n1160#1:2380,15\n1160#1:2395,22\n1082#1:2419,7\n1082#1:2427,12\n1082#1:2441,3\n724#1:1188\n728#1:1217\n736#1:1246\n740#1:1275\n746#1:1301\n752#1:1330\n757#1:1356\n765#1:1382\n778#1:1414\n780#1:1445\n785#1:1471\n799#1:1500\n811#1:1539\n874#1:1982\n891#1:2008\n898#1:2047\n907#1:2086\n921#1:2125\n943#1:2153\n961#1:2181\n975#1:2209\n1142#1:2244\n1146#1:2289\n1156#1:2334\n1160#1:2379\n1082#1:2426\n774#1:1399,3\n812#1:1616\n812#1:1619\n996#1:2223\n999#1:2225,2\n996#1:2227\n1030#1:2228,2\n778#1:1427,5\n812#1:1607,2\n812#1:1623,2\n812#1:1626,5\n812#1:1711,2\n812#1:1714,5\n812#1:1811,2\n812#1:1814,5\n812#1:1909,2\n812#1:1912,5\n812#1:1577,8\n812#1:1676\n812#1:1768,10\n812#1:1864\n812#1:1866,10\n812#1:1962\n1055#1:2235,2\n*E\n"})
public final class CompileServiceImpl
extends CompileServiceImplBase
implements CompileService {
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final DaemonJVMOptions daemonJVMOptions;
    @NotNull
    private final Function0<Unit> onShutdown;
    @NotNull
    private final ReentrantReadWriteLock rwlock;

    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions, @NotNull DaemonJVMOptions daemonJVMOptions, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        Intrinsics.checkNotNullParameter(onShutdown, (String)"onShutdown");
        super(daemonOptions, compilerId, port, timer);
        this.registry = registry;
        this.compiler = compiler;
        this.daemonJVMOptions = daemonJVMOptions;
        this.onShutdown = onShutdown;
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        Intrinsics.checkNotNull((Object)remote, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompileService");
        CompileService stub = (CompileService)remote;
        this.registry.rebind("KotlinJvmCompilerService", stub);
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final DaemonJVMOptions getDaemonJVMOptions() {
        return this.daemonJVMOptions;
    }

    @NotNull
    public final Function0<Unit> getOnShutdown() {
        return this.onShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <R> CompileService.CallResult<R> withValidRepl(int sessionId, Function1<? super KotlinJvmReplService, ? extends CompileService.CallResult<? extends R>> body) {
        Object object;
        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
        boolean $i$f$withValidRepl = false;
        CompileServiceImplBase this_$iv = this;
        boolean $i$f$withValidReplImpl = false;
        CompileServiceImplBase this_$iv$iv = this_$iv;
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId == 0) {
            clientOrSessionProxy = null;
        } else {
            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv).getSessions().get(sessionId);
            if (clientOrSessionProxy == null) {
                object = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                return object;
            }
        }
        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = clientOrSessionProxy;
        try {
            Object object2;
            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv).incrementAndGet();
            CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv = session$iv$iv;
            boolean bl = false;
            CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv;
            Object object3 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
            if (object3 == null) {
                object3 = object2 = null;
            }
            if (object3 == null || (object2 = (CompileService.CallResult)body.invoke(object2)) == null) {
                object2 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
            }
            Object object4 = object2;
            object = object4;
            return object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv, CompileServiceImplKt.nowSeconds());
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Override
    protected long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this.get_lastUsedSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getDaemonInfo() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Dying;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    callResult3 = new CompileService.CallResult.Good<String>("Kotlin daemon on port " + this.getPort());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getKotlinVersion() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            this_$iv$iv = this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    CompileService.CallResult callResult4;
                    boolean bl = false;
                    try {
                        callResult4 = new CompileService.CallResult.Good<String>(KotlinCompilerVersion.VERSION);
                    }
                    catch (Exception e) {
                        callResult4 = new CompileService.CallResult.Error("Unknown Kotlin version");
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonOptions> getDaemonOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            this_$iv$iv = this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    callResult3 = new CompileService.CallResult.Good<DaemonOptions>(this.getDaemonOptions());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonJVMOptions> getDaemonJVMOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            this_$iv$iv = this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    this.getLog().info("getDaemonJVMOptions: " + this.daemonJVMOptions);
                    callResult3 = new CompileService.CallResult.Good<DaemonJVMOptions>(this.daemonJVMOptions);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult registerClient(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    this.getState().addClient(aliveFlagPath);
                    this.getLog().info("Registered a client alive file: " + aliveFlagPath);
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<List<String>> getClients() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            this_$iv$iv = this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    callResult3 = new CompileService.CallResult.Good<List<String>>(this.getState().getClientsFlagPaths());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseCompileSession(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    Integer n = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy(aliveFlagPath, null, null, 6, null));
                    int $this$leaseCompileSession_u24lambda_u247_u24lambda_u246 = ((Number)n).intValue();
                    boolean bl3 = false;
                    this.getLog().info("leased a new session " + $this$leaseCompileSession_u24lambda_u247_u24lambda_u246 + ", session alive file: " + aliveFlagPath);
                    Integer n2 = n;
                    callResult3 = new CompileService.CallResult.Good<Integer>(n2);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult releaseCompileSession(int sessionId) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    this.getState().getSessions().remove(sessionId);
                    this.getLog().info("cleaning after session " + sessionId);
                    this.clearJarCache();
                    callResult3 = this.postReleaseCompileSession();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCompilerId(@NotNull CompilerId expectedCompilerId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expectedCompilerId, (String)"expectedCompilerId");
        if (!(((CharSequence)this.getCompilerId().getCompilerVersion()).length() == 0)) {
            if (!Intrinsics.areEqual((Object)this.getCompilerId().getCompilerVersion(), (Object)expectedCompilerId.getCompilerVersion())) return false;
        }
        Iterable $this$all$iv = this.getCompilerId().getCompilerClasspath();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (expectedCompilerId.getCompilerClasspath().contains(it)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (this.getClasspathWatcher().isChanged()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<Long> getUsedMemory(boolean withGC) {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            this_$iv$iv = this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    boolean $i$f$usedMemory = false;
                    if (withGC) {
                        System.gc();
                    }
                    Runtime rt$iv = Runtime.getRuntime();
                    callResult3 = new CompileService.CallResult.Good<Long>(rt$iv.totalMemory() - rt$iv.freeMemory());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult shutdown() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    this.shutdownWithDelay();
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Boolean> scheduleShutdown(boolean graceful) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block14: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block11: {
                    Object object;
                    int curState$iv$iv;
                    block13: {
                        block12: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block11;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block12;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block13;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block14;
                }
                try {
                    boolean bl;
                    boolean bl3 = false;
                    if (graceful) {
                        bl = this.gracefulShutdown(true);
                    } else {
                        this.shutdownWithDelay();
                        bl = true;
                    }
                    boolean res = bl;
                    callResult3 = new CompileService.CallResult.Good<Boolean>(res);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Set<String>> classesFqNamesByFiles(int sessionId, @NotNull Set<? extends File> sourceFiles) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this).readLock();
        var5_5.lock();
        try {
            block19: {
                block16: {
                    block18: {
                        block17: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            this_$iv$iv = this;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block16;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block17;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block18;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block19;
                }
                try {
                    block20: {
                        $i$a$-ifAlive$default-CompileServiceImpl$classesFqNamesByFiles$1 = false;
                        this_$iv = this;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != 0) break block20;
                        v4 = null;
                        ** GOTO lbl-1000
                    }
                    v4 = CompileServiceImplBase.access$getState(this_$iv).getSessions().get(sessionId);
                    if (v4 == null) {
                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv = v4;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv).incrementAndGet();
                            it = session$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImpl$classesFqNamesByFiles$1$1 = false;
                            var19_23 = new CompileService.CallResult.Good<Set>(ParseFileUtilsKt.classesFqNames(sourceFiles));
                            v5 = var19_23;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var10_13 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var10_13 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var10_13;
            }
            var6_7 = v3;
        }
        finally {
            var5_5.unlock();
        }
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> compile(int sessionId, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @Nullable CompilationResults compilationResults) {
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var8_8 = CompileServiceImpl.access$getRwlock$p(this).readLock();
        var8_8.lock();
        try {
            block100: {
                block97: {
                    block99: {
                        block98: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            this_$iv$iv = this;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block97;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block98;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block99;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block100;
                }
                try {
                    block102: {
                        block101: {
                            $i$a$-ifAlive$default-CompileServiceImpl$compile$1 = false;
                            this_$iv = this;
                            $i$f$compileImpl = false;
                            $i$a$-run-CompileServiceImplBase$compileImpl$1$iv = false;
                            var22_26 = compilationOptions;
                            p0 /* !! */  = servicesFacade;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$2 = false;
                            messageCollector$iv = new CompileServicesFacadeMessageCollector(p0 /* !! */ , p1);
                            p1 = compilationOptions;
                            p0 /* !! */  = servicesFacade;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = false;
                            daemonReporter$iv = DaemonMessageReporterKt.DaemonMessageReporter(p0 /* !! */ , p1);
                            targetPlatform$iv = compilationOptions.getTargetPlatform();
                            CompileServiceImplBase.access$getLog(this_$iv).info("Starting compilation with args: " + ArraysKt.joinToString$default((Object[])compilerArguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                            switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[targetPlatform$iv.ordinal()]) {
                                case 1: {
                                    v4 = (CLICompiler)new K2JVMCompiler();
                                    break;
                                }
                                case 2: {
                                    v4 = (CLICompiler)new K2JSCompiler();
                                    break;
                                }
                                case 3: {
                                    v4 = (CLICompiler)new KotlinMetadataCompiler();
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            compiler$iv = v4;
                            k2PlatformArgs$iv = compiler$iv.createArguments();
                            ParseCommandLineArgumentsKt.parseCommandLineArguments$default((List)ArraysKt.asList((Object[])compilerArguments), (CommonToolArguments)((CommonToolArguments)k2PlatformArgs$iv), (boolean)false, (int)4, null);
                            argumentParseError$iv = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)k2PlatformArgs$iv.getErrors());
                            if (argumentParseError$iv == null) break block101;
                            MessageCollector.report$default((MessageCollector)messageCollector$iv, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)argumentParseError$iv, null, (int)4, null);
                            v5 = new CompileService.CallResult.Good<Integer>(ExitCode.COMPILATION_ERROR.getCode());
                            break block102;
                        }
                        block22 : switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$1[compilationOptions.getCompilerMode().ordinal()]) {
                            case 1: {
                                (Object)servicesFacade;
                                p0 /* !! */  = (JpsCompilerServicesFacade)servicesFacade;
                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = false;
                                enabled$iv$iv = p0 /* !! */ .hasIncrementalCaches();
                                $i$f$withIncrementalCompilation = false;
                                isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                try {
                                    if (k2PlatformArgs$iv.getIncrementalCompilation() == null) {
                                        k2PlatformArgs$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                    }
                                    $i$a$-withIncrementalCompilation-CompileServiceImplBase$compileImpl$1$1$iv = false;
                                    var35_50 = this_$iv;
                                    tracer$iv$iv = null;
                                    $i$f$doCompile = false;
                                    $this$doCompile_u24lambda_u2418$iv$iv = this_$iv$iv;
                                    $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("alive!");
                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                    $i$f$withValidClientOrSessionProxy = false;
                                    if (sessionId != 0) ** GOTO lbl101
                                    v6 = null;
                                    ** GOTO lbl105
lbl101:
                                    // 1 sources

                                    v6 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                    if (v6 != null) ** GOTO lbl105
                                    v7 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                    ** GOTO lbl219
lbl105:
                                    // 2 sources

                                    session$iv$iv$iv = v6;
                                    try {
                                        CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                        it$iv$iv = session$iv$iv$iv;
                                        $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                        rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                        eventManager$iv$iv = new EventManagerImpl();
                                        try {
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("trying get exitCode");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                            $i$f$checkedCompile = false;
                                            try {
                                                var50_115 = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                obj$iv$iv$iv$iv = null;
                                                $i$f$withMeasure = false;
                                                startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                var55_138 = rpcProfiler$iv$iv;
                                                eventManger$iv = eventManager$iv$iv;
                                                $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1$iv = false;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = profiler$iv;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = eventManger$iv;
                                                p0 /* !! */  = (CompilerCallbackServicesFacade)servicesFacade;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$4 = false;
                                                services$iv = this.createCompileServices((CompilerCallbackServicesFacade)p0 /* !! */ , (EventManager)p1, (Profiler)p2);
                                                exitCode$iv = compiler$iv.exec(messageCollector$iv, services$iv, k2PlatformArgs$iv);
                                                it$iv = var61_166 = compilationResults;
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1$iv = false;
                                                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                                compilationResult$iv = it$iv;
                                                $this$forEach$iv$iv = CompileServiceImplBase.access$getPerformanceMetrics(this_$iv, compiler$iv);
                                                $i$f$forEach = false;
                                                for (T element$iv$iv : $this$forEach$iv$iv) {
                                                    it$iv = (BuildMetricsValue)element$iv$iv;
                                                    $i$a$-forEach-CompileServiceImplBase$compileImpl$1$1$1$1$1$iv = false;
                                                    compilationResult$iv.add(CompilationResultCategory.BUILD_METRICS.getCode(), it$iv);
                                                }
                                                res$iv$iv$iv$iv = exitCode$iv.getCode();
                                                $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                res$iv$iv$iv = res$iv$iv$iv$iv;
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    withGC$iv$iv$iv$iv = false;
                                                    $i$f$usedMemory = false;
                                                    rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                    v8 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                } else {
                                                    v8 = 0L;
                                                }
                                                endMem$iv$iv$iv = v8;
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                    rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                    v9 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                    var71_209 = "%+d";
                                                    var75_219 = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                    v10 = String.format(var71_209, Arrays.copyOf(var75_219, ((Object[])var75_219).length));
                                                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"format(...)");
                                                    it$iv$iv$iv = v9.append(v10).append(" kb)").toString();
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    for (Object var75_219 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                        obj$iv$iv$iv = var75_219.getKey();
                                                        counters$iv$iv$iv = (PerfCounters)var75_219.getValue();
                                                        it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                        $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                        daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    }
                                                }
                                                v11 = res$iv$iv$iv;
                                            }
                                            catch (Throwable e$iv$iv$iv) {
                                                v12 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                v13 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                v14 = e$iv$iv$iv.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getStackTrace(...)");
                                                v15 = v13.append(ArraysKt.joinToString$default((Object[])v14, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                    v16 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                    v17 = e$iv$iv$iv.getCause();
                                                    Intrinsics.checkNotNull((Object)v17);
                                                    v18 = v17.getStackTrace();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"getStackTrace(...)");
                                                    v19 = v16.append(ArraysKt.joinToString$default((Object[])v18, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                } else {
                                                    v19 = "";
                                                }
                                                v12.log(Level.SEVERE, v15.append(v19).toString());
                                                throw e$iv$iv$iv;
                                            }
                                            exitCode$iv$iv = ((Number)v11).intValue();
                                            var80_226 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                        }
                                        finally {
                                            eventManager$iv$iv.fireCompilationFinished();
                                        }
                                        var23_30 = var80_226;
                                        v7 = var23_30;
                                    }
                                    finally {
                                        CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                    }
lbl219:
                                    // 2 sources

                                    var24_33 = v7;
                                    v5 = var24_33;
                                    break;
                                }
                                finally {
                                    IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                }
                            }
                            case 2: {
                                enabled$iv$iv = this_$iv;
                                tracer$iv$iv = null;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u2418$iv$iv = this_$iv$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("alive!");
                                this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId == 0) {
                                    v20 = null;
                                } else {
                                    v20 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                    if (v20 == null) {
                                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                        break;
                                    }
                                }
                                session$iv$iv$iv = v20;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    it$iv$iv = session$iv$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                    rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("trying get exitCode");
                                        this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            eventManager$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                            (EventManager)eventManager$iv$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$2$iv = false;
                                            exitCode$iv = compiler$iv.exec(messageCollector$iv, Services.EMPTY, k2PlatformArgs$iv);
                                            perfString$iv = compiler$iv.getDefaultPerformanceManager().renderCompilerPerformance();
                                            v21 = compilationResults;
                                            if (v21 != null) {
                                                it$iv = eventManger$iv = v21;
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$2$1$iv = false;
                                                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                                exitCode$iv = new String[]{perfString$iv};
                                                it$iv.add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), CollectionsKt.arrayListOf((Object[])exitCode$iv));
                                                v22 = eventManger$iv;
                                            } else {
                                                v22 = null;
                                            }
                                            res$iv$iv$iv$iv = exitCode$iv.getCode();
                                            $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                            res$iv$iv$iv = res$iv$iv$iv$iv;
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                v23 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                            } else {
                                                v23 = 0L;
                                            }
                                            endMem$iv$iv$iv = v23;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v24 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                rt$iv$iv$iv$iv = "%+d";
                                                $this$forEach$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                v25 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf($this$forEach$iv$iv, $this$forEach$iv$iv.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"format(...)");
                                                it$iv$iv$iv = v24.append(v25).append(" kb)").toString();
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                for (Object it$iv$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                    counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                    it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                }
                                            }
                                            v26 = res$iv$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            v27 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                            v28 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                            v29 = e$iv$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)v29, (String)"getStackTrace(...)");
                                            v30 = v28.append(ArraysKt.joinToString$default((Object[])v29, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                v31 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                v32 = e$iv$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)v32);
                                                v33 = v32.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v33, (String)"getStackTrace(...)");
                                                v34 = v31.append(ArraysKt.joinToString$default((Object[])v33, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v34 = "";
                                            }
                                            v27.log(Level.SEVERE, v30.append(v34).toString());
                                            throw e$iv$iv$iv;
                                        }
                                        exitCode$iv$iv = ((Number)v26).intValue();
                                        exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                    }
                                    finally {
                                        eventManager$iv$iv.fireCompilationFinished();
                                    }
                                    var71_210 = exitCode$iv$iv;
                                    v5 = var71_210;
                                    break;
                                }
                                finally {
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                }
                            }
                            case 3: {
                                gradleIncrementalArgs$iv = (IncrementalCompilationOptions)compilationOptions;
                                gradleIncrementalServicesFacade$iv = servicesFacade;
                                switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[targetPlatform$iv.ordinal()]) {
                                    case 1: {
                                        enabled$iv$iv = true;
                                        $i$f$withIncrementalCompilation = false;
                                        isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                        IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                        try {
                                            if (k2PlatformArgs$iv.getIncrementalCompilation() == null) {
                                                k2PlatformArgs$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withIncrementalCompilation$default-CompileServiceImplBase$compileImpl$1$3$iv = false;
                                            it$iv$iv = this_$iv;
                                            tracer$iv$iv = null;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u2418$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("alive!");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId != 0) ** GOTO lbl374
                                            v35 = null;
                                            ** GOTO lbl378
lbl374:
                                            // 1 sources

                                            v35 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                            if (v35 != null) ** GOTO lbl378
                                            v36 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                            ** GOTO lbl488
lbl378:
                                            // 2 sources

                                            session$iv$iv$iv = v35;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                                it$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("trying get exitCode");
                                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        exitCode$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$3$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments");
                                                        v37 = (K2JVMCompilerArguments)k2PlatformArgs$iv;
                                                        v38 = compilationResults;
                                                        Intrinsics.checkNotNull((Object)v38);
                                                        var83_230 = gradleIncrementalArgs$iv;
                                                        var84_232 = v38;
                                                        var85_235 = gradleIncrementalServicesFacade$iv;
                                                        var86_237 = messageCollector$iv;
                                                        var87_239 = gradleIncrementalArgs$iv;
                                                        var88_241 = v37;
                                                        var89_243 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v39 = b;
                                                        Intrinsics.checkNotNull((Object)v39);
                                                        var91_247 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v39, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execIncrementalCompiler(var89_243, var88_241, var87_239, var86_237, var91_247).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v40 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v40 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v40;
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                            v41 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            rt$iv$iv$iv$iv = "%+d";
                                                            it$iv$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v42 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(it$iv$iv$iv, ((Object[])it$iv$iv$iv).length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v42, (String)"format(...)");
                                                            it$iv$iv$iv = v41.append(v42).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                            for (Object it$iv$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v43 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v44 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                        v45 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v46 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v46, (String)"getStackTrace(...)");
                                                        v47 = v45.append(ArraysKt.joinToString$default((Object[])v46, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v48 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v49 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v49);
                                                            v50 = v49.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v50, (String)"getStackTrace(...)");
                                                            v51 = v48.append(ArraysKt.joinToString$default((Object[])v50, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v51 = "";
                                                        }
                                                        v44.log(Level.SEVERE, v47.append(v51).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v43).intValue();
                                                    exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                }
                                                finally {
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                }
                                                var71_211 = exitCode$iv$iv;
                                                v36 = var71_211;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl488:
                                            // 2 sources

                                            var85_235 = v36;
                                            v5 = var85_235;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                        }
                                    }
                                    case 2: {
                                        enabled$iv$iv = true;
                                        $i$f$withJsIC = false;
                                        isJsEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJs();
                                        IncrementalCompilation.setIsEnabledForJs((boolean)true);
                                        try {
                                            if (k2PlatformArgs$iv.getIncrementalCompilation() == null) {
                                                k2PlatformArgs$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withJsIC$default-CompileServiceImplBase$compileImpl$1$4$iv = false;
                                            this_$iv$iv = this_$iv;
                                            tracer$iv$iv = null;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u2418$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u2418$iv$iv).fine("alive!");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId != 0) ** GOTO lbl516
                                            v52 = null;
                                            ** GOTO lbl520
lbl516:
                                            // 1 sources

                                            v52 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                                            if (v52 != null) ** GOTO lbl520
                                            v53 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                            ** GOTO lbl630
lbl520:
                                            // 2 sources

                                            session$iv$iv$iv = v52;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                                                it$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u2418$iv$iv).fine("trying get exitCode");
                                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        $this$withMeasure$iv$iv$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$4$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments");
                                                        v54 = (K2JSCompilerArguments)k2PlatformArgs$iv;
                                                        v55 = compilationResults;
                                                        Intrinsics.checkNotNull((Object)v55);
                                                        var92_249 = gradleIncrementalArgs$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = v55;
                                                        c = gradleIncrementalServicesFacade$iv;
                                                        var86_238 = messageCollector$iv;
                                                        var87_240 = gradleIncrementalArgs$iv;
                                                        var88_242 = v54;
                                                        var89_244 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v56 = b;
                                                        Intrinsics.checkNotNull((Object)v56);
                                                        var91_248 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v56, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execJsIncrementalCompiler(var89_244, var88_242, var87_240, var86_238, var91_248).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v57 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v57 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v57;
                                                        CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                            v58 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            var61_169 = "%+d";
                                                            it$iv$iv$iv /* !! */  = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v59 = String.format(var61_169, Arrays.copyOf(it$iv$iv$iv /* !! */ , it$iv$iv$iv /* !! */ .length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v59, (String)"format(...)");
                                                            it$iv$iv$iv /* !! */  = v58.append(v59).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv /* !! */ );
                                                            CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info((String)it$iv$iv$iv /* !! */ );
                                                            for (Map.Entry var65_182 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = var65_182.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)var65_182.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v60 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v61 = CompileServiceImplBase.access$getLog(this_$iv$iv$iv);
                                                        v62 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v63 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v63, (String)"getStackTrace(...)");
                                                        v64 = v62.append(ArraysKt.joinToString$default((Object[])v63, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v65 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v66 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v66);
                                                            v67 = v66.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v67, (String)"getStackTrace(...)");
                                                            v68 = v65.append(ArraysKt.joinToString$default((Object[])v67, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v68 = "";
                                                        }
                                                        v61.log(Level.SEVERE, v64.append(v68).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v60).intValue();
                                                    var70_208 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                }
                                                finally {
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                }
                                                var71_212 = var70_208;
                                                v53 = var71_212;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl630:
                                            // 2 sources

                                            var85_236 = v53;
                                            v5 = var85_236;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJs((boolean)isJsEnabledBackup$iv$iv);
                                        }
                                    }
                                }
                                throw new IllegalStateException("Incremental compilation is not supported for target platform: " + targetPlatform$iv);
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    var13_16 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var13_16 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var13_16;
            }
            var9_10 = v3;
        }
        finally {
            var8_8.unlock();
        }
        return var9_10;
    }

    @Override
    @NotNull
    public CompileService.CallResult releaseReplSession(int sessionId) {
        return this.releaseCompileSession(sessionId);
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, EventManager eventManager, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches()) {
            builder.register(IncrementalCompilationComponents.class, (Object)new RemoteIncrementalCompilationComponentsClient(facade, rpcProfiler));
        }
        if (facade.hasLookupTracker()) {
            builder.register(LookupTracker.class, (Object)new RemoteLookupTrackerClient(facade, eventManager, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, (Object)new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        if (facade.hasExpectActualTracker()) {
            builder.register(ExpectActualTracker.class, (Object)new RemoteExpectActualTracker(facade, rpcProfiler));
        }
        if (facade.hasInlineConstTracker()) {
            builder.register(InlineConstTracker.class, (Object)new RemoteInlineConstTracker(facade, rpcProfiler));
        }
        if (facade.hasEnumWhenTracker()) {
            builder.register(EnumWhenTracker.class, (Object)new RemoteEnumWhenTracker(facade, rpcProfiler));
        }
        if (facade.hasIncrementalResultsConsumer()) {
            builder.register(IncrementalResultsConsumer.class, (Object)new RemoteIncrementalResultsConsumer(facade, rpcProfiler));
        }
        if (facade.hasIncrementalDataProvider()) {
            builder.register(IncrementalDataProvider.class, (Object)new RemoteIncrementalDataProvider(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseReplSession(@Nullable String aliveFlagPath, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block14: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block11: {
                    Object object;
                    int curState$iv$iv;
                    block13: {
                        block12: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block11;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block12;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block13;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block14;
                }
                try {
                    CompileService.CallResult callResult4;
                    boolean bl = false;
                    if (compilationOptions.getTargetPlatform() != CompileService.TargetPlatform.JVM) {
                        callResult4 = new CompileService.CallResult.Error("Sorry, only JVM target platform is supported now");
                    } else {
                        Disposable disposable = Disposer.newDisposable((String)("Disposable for " + Reflection.getOrCreateKotlinClass(CompileServiceImpl.class).getSimpleName() + ".leaseReplSession"));
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                        Disposable disposable2 = disposable;
                        CompileServicesFacadeMessageCollector messageCollector = new CompileServicesFacadeMessageCollector(servicesFacade, compilationOptions);
                        KotlinJvmReplService repl = new KotlinJvmReplService(disposable2, this.getPort(), this.getCompilerId(), templateClasspath, templateClassName, messageCollector, null);
                        int sessionId = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<KotlinJvmReplService>(aliveFlagPath, repl, disposable2));
                        callResult4 = new CompileService.CallResult.Good<Integer>(sessionId);
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplStateFacade> replCreateState(int sessionId) {
        var2_2 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv).readLock();
        var5_5.lock();
        try {
            block22: {
                block19: {
                    block21: {
                        block20: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block19;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block20;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block21;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block22;
                }
                try {
                    block23: {
                        $i$a$-ifAlive-CompileServiceImpl$replCreateState$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != 0) break block23;
                        v4 = null;
                        ** GOTO lbl-1000
                    }
                    v4 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (v4 == null) {
                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv$iv$iv = v4;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            v6 = session$iv$iv;
                            v7 = v6 != null ? v6.getData() : null;
                            if (v7 == null) {
                                v7 = null;
                            }
                            if (v7 != null) {
                                $this$replCreateState_u24lambda_u2422_u24lambda_u2421 = (KotlinJvmReplService)v7;
                                $i$a$-withValidRepl-CompileServiceImpl$replCreateState$1$1 = false;
                                v8 = new CompileService.CallResult.Good<RemoteReplStateFacadeServer>($this$replCreateState_u24lambda_u2422_u24lambda_u2421.createRemoteState(this.getPort()));
                            } else {
                                v8 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
                            }
                            var27_32 = v8;
                            v5 = var27_32;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var10_13 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var10_13 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var10_13;
            }
            var6_7 = v3;
        }
        finally {
            var5_5.unlock();
        }
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCheckResult> replCheck(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block20: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block17: {
                    Object object;
                    int curState$iv$iv;
                    block19: {
                        block18: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block17;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block18;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block19;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block20;
                }
                try {
                    CompileService.CallResult callResult4;
                    block15: {
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        CompileServiceImplBase this_$iv$iv$iv;
                        block22: {
                            block21: {
                                boolean bl = false;
                                CompileServiceImpl this_$iv2 = this;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase this_$iv$iv2 = this_$iv2;
                                boolean $i$f$withValidReplImpl = false;
                                this_$iv$iv$iv = this_$iv$iv2;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != 0) break block21;
                                clientOrSessionProxy = null;
                                break block22;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                            if (clientOrSessionProxy != null) break block22;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                            break block15;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block24: {
                                block23: {
                                    CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block23;
                                    KotlinJvmReplService $this$replCheck_u24lambda_u2425_u24lambda_u2424 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl3 = false;
                                    CompileService.CallResult callResult7 = $this$replCheck_u24lambda_u2425_u24lambda_u2424.withValidReplState(replStateId, arg_0 -> CompileServiceImpl.replCheck$lambda$25$lambda$24$lambda$23($this$replCheck_u24lambda_u2425_u24lambda_u2424, codeLine, arg_0));
                                    callResult5 = callResult7;
                                    if (callResult7 != null) break block24;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
                            }
                            CompileService.CallResult callResult8 = callResult5;
                            callResult4 = callResult8;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCompileResult> replCompile(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block20: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block17: {
                    Object object;
                    int curState$iv$iv;
                    block19: {
                        block18: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block17;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block18;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block19;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block20;
                }
                try {
                    CompileService.CallResult callResult4;
                    block15: {
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        CompileServiceImplBase this_$iv$iv$iv;
                        block22: {
                            block21: {
                                boolean bl = false;
                                CompileServiceImpl this_$iv2 = this;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase this_$iv$iv2 = this_$iv2;
                                boolean $i$f$withValidReplImpl = false;
                                this_$iv$iv$iv = this_$iv$iv2;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != 0) break block21;
                                clientOrSessionProxy = null;
                                break block22;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                            if (clientOrSessionProxy != null) break block22;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                            break block15;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block24: {
                                block23: {
                                    CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block23;
                                    KotlinJvmReplService $this$replCompile_u24lambda_u2428_u24lambda_u2427 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl3 = false;
                                    CompileService.CallResult callResult7 = $this$replCompile_u24lambda_u2428_u24lambda_u2427.withValidReplState(replStateId, arg_0 -> CompileServiceImpl.replCompile$lambda$28$lambda$27$lambda$26($this$replCompile_u24lambda_u2428_u24lambda_u2427, codeLine, arg_0));
                                    callResult5 = callResult7;
                                    if (callResult7 != null) break block24;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
                            }
                            CompileService.CallResult callResult8 = callResult5;
                            callResult4 = callResult8;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void periodicAndAfterSessionCheck() {
        block28: {
            block27: {
                block26: {
                    block31: {
                        block33: {
                            block32: {
                                if (this.getState().getDelayedShutdownQueued().get()) {
                                    return;
                                }
                                anyDead = this.getState().getSessions().cleanDead() != false || this.getState().cleanDeadClients() != false;
                                var2_2 = this;
                                minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                                $i$f$ifAliveUnit = false;
                                var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
                                var5_5.lock();
                                $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                                this_$iv$iv = this_$iv;
                                $i$f$ifAliveChecksImpl = false;
                                curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                                if (curState$iv$iv >= minAliveness$iv.ordinal()) break block31;
                                stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                                rmiBusinessCallDepth$iv$iv = 1;
                                Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                                v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                                if (v0 == null) break block32;
                                it$iv$iv = v0;
                                $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                                v1 = " Operation: " + it$iv$iv;
                                v0 = v1;
                                if (v1 != null) break block33;
                            }
                            v2 = Thread.currentThread().getStackTrace();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                            v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                        }
                        callSource$iv$iv = v0;
                        CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                        (CompileService.CallResult)new CompileService.CallResult.Dying();
                        ** GOTO lbl78
                    }
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 = false;
                    if (this.getState().getAlive().get() != CompileServiceImplBase.Aliveness.LastSession.ordinal() || !this.getState().getSessions().isEmpty()) break block26;
                    this.getLog().info("All sessions finished");
                    this.shutdownWithDelay();
                    var5_5.unlock();
                    return;
                }
                if (this.getState().getAliveClientsCount() != 0) break block27;
                this.getLog().info("No more clients left");
                this.shutdownWithDelay();
                var5_5.unlock();
                return;
            }
            if (this.getRunFile().exists()) break block28;
            this.getLog().info("Run file removed");
            this.shutdownWithDelay();
            var5_5.unlock();
            return;
        }
        try {
            stackTrace$iv$iv = new CompileService.CallResult.Ok();
            {
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    stackTrace$iv$iv = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
lbl78:
            // 3 sources

            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = Unit.INSTANCE;
        }
        catch (Throwable this_$iv$iv) {
            throw this_$iv$iv;
        }
        finally {
            var5_5.unlock();
        }
        this_$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAliveUnit = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
        var5_5.lock();
        try {
            block37: {
                block34: {
                    block36: {
                        block35: {
                            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                            this_$iv$iv = this_$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block34;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v3 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v3 == null) break block35;
                            it$iv$iv = v3;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v4 = " Operation: " + it$iv$iv;
                            v3 = v4;
                            if (v4 != null) break block36;
                        }
                        v5 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getStackTrace(...)");
                        v3 = ArraysKt.joinToString$default((Object[])v5, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v3;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    (CompileService.CallResult)new CompileService.CallResult.Dying();
                    break block37;
                }
                try {
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$2 = false;
                    if (this.getDaemonOptions().getAutoshutdownUnusedSeconds() != 0 && this.getCompilationsCounter().get() == 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownUnusedSeconds()) {
                        this.getLog().info("Unused timeout exceeded " + this.getDaemonOptions().getAutoshutdownUnusedSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (this.getDaemonOptions().getAutoshutdownIdleSeconds() != 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownIdleSeconds()) {
                        this.getLog().info("Idle timeout exceeded " + this.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (anyDead) {
                        this.clearJarCache();
                    }
                    var10_15 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var10_15 = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            var6_9 = Unit.INSTANCE;
        }
        finally {
            var5_5.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void periodicSeldomCheck() {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            block13: {
                CompileServiceImplBase this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    boolean bl3 = false;
                    if (this.getClasspathWatcher().isChanged()) {
                        this.getLog().info("Compiler changed.");
                        this.gracefulShutdown(false);
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void initiateElections() {
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAliveUnit = false;
        var3_3 = CompileServiceImpl.access$getRwlock$p(this).readLock();
        var3_3.lock();
        try {
            block21: {
                block18: {
                    block20: {
                        block19: {
                            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                            this_$iv$iv = this;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block18;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block19;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block20;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    (CompileService.CallResult)new CompileService.CallResult.Dying();
                    break block21;
                }
                try {
                    block22: {
                        block23: {
                            $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                            $i$a$-ifAliveUnit$default-CompileServiceImpl$initiateElections$1 = false;
                            this.getLog().info("initiate elections");
                            aliveWithOpts = SequencesKt.toList(ClientUtilsKt.walkDaemons(new File(DaemonParamsKt.getRunFilesPathOrDefault(this.getDaemonOptions())), this.getCompilerId(), this.getRunFile(), (Function2<? super File, ? super Integer, Boolean>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, initiateElections$lambda$44$lambda$32(org.jetbrains.kotlin.daemon.CompileServiceImpl java.io.File int ), (Ljava/io/File;Ljava/lang/Integer;)Ljava/lang/Boolean;)((CompileServiceImpl)this), (Function2<? super DaemonReportCategory, ? super String, Unit>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, initiateElections$lambda$44$lambda$33(org.jetbrains.kotlin.daemon.CompileServiceImpl org.jetbrains.kotlin.daemon.common.DaemonReportCategory java.lang.String ), (Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;Ljava/lang/String;)Lkotlin/Unit;)((CompileServiceImpl)this)));
                            var16_21 = new DaemonJVMOptionsMemoryComparator();
                            var16_21 = new Comparator(var16_21){
                                final /* synthetic */ Comparator $comparator;
                                {
                                    this.$comparator = $comparator;
                                }

                                public final int compare(T a, T b) {
                                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)b;
                                    Comparator comparator = this.$comparator;
                                    boolean bl = false;
                                    DaemonWithMetadata it = (DaemonWithMetadata)a;
                                    DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                                    bl = false;
                                    DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                                    return comparator.compare(daemonJVMOptions, daemonJVMOptions2);
                                }
                            };
                            var17_22 = new FileAgeComparator();
                            comparator = new Comparator(var16_21, var17_22){
                                final /* synthetic */ Comparator $this_thenBy;
                                final /* synthetic */ Comparator $comparator;
                                {
                                    this.$this_thenBy = $receiver;
                                    this.$comparator = $comparator;
                                }

                                public final int compare(T a, T b) {
                                    int n;
                                    int previousCompare = this.$this_thenBy.compare(a, b);
                                    if (previousCompare != 0) {
                                        n = previousCompare;
                                    } else {
                                        DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                                        Comparator comparator = this.$comparator;
                                        boolean bl = false;
                                        DaemonWithMetadata it = (DaemonWithMetadata)b;
                                        File file = it.getRunFile();
                                        bl = false;
                                        File file2 = it.getRunFile();
                                        n = comparator.compare(file, file2);
                                    }
                                    return n;
                                }
                            };
                            v3 = (DaemonWithMetadata)CollectionsKt.maxWithOrNull((Iterable)aliveWithOpts, (Comparator)comparator);
                            if (v3 == null) break block22;
                            bestDaemonWithMetadata = v3;
                            $i$a$-let-CompileServiceImpl$initiateElections$1$1 = false;
                            fattestOpts = bestDaemonWithMetadata.getJvmOptions();
                            if (!DaemonParamsKt.memorywiseFitsInto(fattestOpts, this.daemonJVMOptions)) break block23;
                            if (new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) >= 0) break block23;
                            this.getLog().info("Assuming other daemons have lower prio, taking clients from them and schedule them to shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            $this$forEach$iv = aliveWithOpts;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                var26_34 = (DaemonWithMetadata)element$iv;
                                $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$1 = false;
                                daemon = var26_34.component1();
                                runFile = var26_34.component2();
                                try {
                                    it = var30_42 = daemon.getClients();
                                    $i$a$-takeIf-CompileServiceImpl$initiateElections$1$1$1$1 = false;
                                    v4 = it.isGood() != false ? var30_42 : null;
                                    if (v4 != null) {
                                        it = v4;
                                        $i$a$-let-CompileServiceImpl$initiateElections$1$1$1$2 = false;
                                        $this$forEach$iv = it.get();
                                        $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            clientAliveFile = (String)element$iv;
                                            $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$1$2$1 = false;
                                            this.registerClient(clientAliveFile);
                                        }
                                    }
                                    daemon.scheduleShutdown(true);
                                }
                                catch (Throwable e) {
                                    this.getLog().info("Cannot connect to a daemon, assuming dying ('" + FilesKt.normalize((File)runFile).getAbsolutePath() + "'): " + e.getMessage());
                                }
                            }
                            break block22;
                        }
                        if (!DaemonParamsKt.memorywiseFitsInto(this.daemonJVMOptions, fattestOpts)) ** GOTO lbl-1000
                        if (new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) > 0) {
                            this.getLog().info("Assuming other daemons have higher prio, handover clients to it and schedule shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            it = var23_29 = this.getClients();
                            $i$a$-takeIf-CompileServiceImpl$initiateElections$1$1$2 = false;
                            v5 = it.isGood() != false ? var23_29 : null;
                            if (v5 != null) {
                                it = v5;
                                $i$a$-let-CompileServiceImpl$initiateElections$1$1$3 = false;
                                $this$forEach$iv = it.get();
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (String)element$iv;
                                    $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$3$1 = false;
                                    bestDaemonWithMetadata.getDaemon().registerClient(it);
                                }
                            }
                            this.scheduleShutdown(true);
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.getLog().info("Assuming other daemons have equal prio, continue: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                        }
                    }
                    var8_11 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var8_12 = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            var4_5 = Unit.INSTANCE;
        }
        finally {
            var3_3.unlock();
        }
    }

    private final void shutdownNow() {
        this.getLog().info("Shutdown started");
        Runtime $this$shutdownNow_u24lambda_u2445 = Runtime.getRuntime();
        boolean bl = false;
        this.getLog().info("Memory stats: total: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2445.totalMemory()) + "mb, free: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2445.freeMemory()) + "mb, max: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2445.maxMemory()) + "mb");
        this.getState().getAlive().set(CompileServiceImplBase.Aliveness.Dying.ordinal());
        UnicastRemoteObject.unexportObject(this, true);
        this.getLog().info("Shutdown complete");
        this.onShutdown.invoke();
        Handler[] handlerArray = this.getLog().getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"getHandlers(...)");
        Object[] $this$forEach$iv = handlerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Handler it = (Handler)element$iv;
            boolean bl2 = false;
            it.flush();
        }
    }

    private final void shutdownWithDelay() {
        this.getState().getDelayedShutdownQueued().set(true);
        int currentClientsCount = this.getState().getClientsCounter();
        int currentSessionId = this.getState().getSessions().getLastSessionId();
        int currentCompilationsCount = this.getCompilationsCounter().get();
        this.getLog().info("Delayed shutdown in " + this.getDaemonOptions().getShutdownDelayMilliseconds() + "ms");
        Timer timer = this.getTimer();
        long l = this.getDaemonOptions().getShutdownDelayMilliseconds();
        TimerTask timerTask = new TimerTask(this, currentClientsCount, currentCompilationsCount, currentSessionId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $currentClientsCount$inlined;
            final /* synthetic */ int $currentCompilationsCount$inlined;
            final /* synthetic */ int $currentSessionId$inlined;
            {
                this.this$0 = compileServiceImpl;
                this.$currentClientsCount$inlined = n;
                this.$currentCompilationsCount$inlined = n2;
                this.$currentSessionId$inlined = n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                block9: {
                    void this_$iv;
                    TimerTask $this$shutdownWithDelay_u24lambda_u2448 = this;
                    boolean bl = false;
                    this.this$0.getState().getDelayedShutdownQueued().set(false);
                    if (this.$currentClientsCount$inlined != this.this$0.getState().getClientsCounter() || this.$currentCompilationsCount$inlined != this.this$0.getCompilationsCounter().get() || this.$currentSessionId$inlined != this.this$0.getState().getSessions().getLastSessionId()) break block9;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        block13: {
                            CompileService.CallResult callResult;
                            CompileServiceImplBase this_$iv$iv;
                            block10: {
                                Object object;
                                int curState$iv$iv;
                                block12: {
                                    block11: {
                                        boolean bl2 = false;
                                        this_$iv$iv = (CompileServiceImplBase)this_$iv;
                                        boolean $i$f$ifAliveChecksImpl = false;
                                        curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                                        if (curState$iv$iv >= minAliveness$iv.ordinal()) break block10;
                                        Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                                        int rmiBusinessCallDepth$iv$iv = 1;
                                        Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                                        object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                                        if (object == null) break block11;
                                        StackTraceElement it$iv$iv = object;
                                        boolean bl3 = false;
                                        String string = " Operation: " + it$iv$iv;
                                        object = string;
                                        if (string != null) break block12;
                                    }
                                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                                    object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                                }
                                Object callSource$iv$iv = object;
                                CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                                CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                                break block13;
                            }
                            try {
                                boolean bl4 = false;
                                boolean bl5 = false;
                                this.this$0.getLog().fine("Execute delayed shutdown");
                                CompileServiceImpl.access$shutdownNow(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                callResult = new CompileService.CallResult.Error(e$iv$iv);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
                this.this$0.getLog().info("Cancel delayed shutdown due to a new activity");
            }
        };
        timer.schedule(timerTask, l);
    }

    private final boolean gracefulShutdown(boolean onAnotherThread) {
        if (!this.getState().getAlive().compareAndSet(CompileServiceImplBase.Aliveness.Alive.ordinal(), CompileServiceImplBase.Aliveness.LastSession.ordinal())) {
            this.getLog().info("Invalid state for graceful shutdown: " + this.toAlivenessName(this.getState().getAlive().get()));
            return false;
        }
        this.getLog().info("Graceful shutdown signalled");
        if (!onAnotherThread) {
            CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this);
        } else {
            Timer timer = this.getTimer();
            long l = 1L;
            TimerTask timerTask = new TimerTask(this){
                final /* synthetic */ CompileServiceImpl this$0;
                {
                    this.this$0 = compileServiceImpl;
                }

                public void run() {
                    TimerTask $this$gracefulShutdown_u24lambda_u2450 = this;
                    boolean bl = false;
                    CompileServiceImpl.access$gracefulShutdown$shutdownIfIdle(this.this$0);
                }
            };
            timer.schedule(timerTask, l);
        }
        return true;
    }

    @Override
    public void clearJarCache() {
        block2: {
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment;
            ZipHandler.clearFileAccessorCache();
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment2 = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
            if (kotlinCoreApplicationEnvironment2 == null) break block2;
            KotlinCoreApplicationEnvironment $this$clearJarCache_u24lambda_u2451 = kotlinCoreApplicationEnvironment = kotlinCoreApplicationEnvironment2;
            boolean bl = false;
            VirtualFileSystem virtualFileSystem = $this$clearJarCache_u24lambda_u2451.getJarFileSystem();
            CoreJarFileSystem coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
            if (coreJarFileSystem != null) {
                coreJarFileSystem.clearHandlersCache();
            }
            virtualFileSystem = $this$clearJarCache_u24lambda_u2451.getJrtFileSystem();
            CoreJrtFileSystem coreJrtFileSystem = virtualFileSystem instanceof CoreJrtFileSystem ? (CoreJrtFileSystem)virtualFileSystem : null;
            if (coreJrtFileSystem != null) {
                coreJrtFileSystem.clearRoots();
            }
            $this$clearJarCache_u24lambda_u2451.idleCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAlive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv;
                block8: {
                    Object object;
                    int curState$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            this_$iv = this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness.ordinal()) break block8;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAlive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv;
                block10: {
                    Object object2;
                    int curState$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            this_$iv = $this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block11;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog(this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            block11: {
                CompileServiceImplBase this_$iv;
                block8: {
                    Object object;
                    int curState$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            this_$iv = this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness.ordinal()) break block8;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            block13: {
                CompileServiceImplBase this_$iv;
                block10: {
                    Object object2;
                    int curState$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            this_$iv = $this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block11;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog(this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv;
                block10: {
                    Object object;
                    int curState$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            this_$iv = this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAliveExclusive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusive = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            block15: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv;
                block12: {
                    Object object2;
                    int curState$iv;
                    block14: {
                        block13: {
                            boolean bl = false;
                            this_$iv = $this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness.ordinal()) break block12;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block13;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block14;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog(this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveExclusiveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            block13: {
                CompileService.CallResult callResult;
                CompileServiceImplBase this_$iv;
                block10: {
                    Object object;
                    int curState$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            this_$iv = this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveExclusiveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusiveUnit = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            block15: {
                CompileService.CallResult callResult;
                CompileServiceImplBase this_$iv;
                block12: {
                    Object object2;
                    int curState$iv;
                    block14: {
                        block13: {
                            boolean bl = false;
                            this_$iv = $this;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness.ordinal()) break block12;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block13;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block14;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog(this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final ReplCheckResult replCheck$lambda$25$lambda$24$lambda$23(KotlinJvmReplService $this_withValidRepl, ReplCodeLine $codeLine, IReplStageState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $this_withValidRepl.check(state, $codeLine);
    }

    private static final ReplCompileResult replCompile$lambda$28$lambda$27$lambda$26(KotlinJvmReplService $this_withValidRepl, ReplCodeLine $codeLine, IReplStageState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $this_withValidRepl.compile(state, $codeLine);
    }

    private static final boolean initiateElections$lambda$44$lambda$32(CompileServiceImpl this$0, File file, int p) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<unused var>");
        return p != this$0.getPort();
    }

    private static final Unit initiateElections$lambda$44$lambda$33(CompileServiceImpl this$0, DaemonReportCategory daemonReportCategory, String msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)daemonReportCategory), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.getLog().info(msg);
        return Unit.INSTANCE;
    }

    private static final long shutdownNow$mb(long $this$shutdownNow_u24mb) {
        return $this$shutdownNow_u24mb / (long)0x100000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this$0;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            block16: {
                CompileService.CallResult callResult;
                CompileServiceImplBase this_$iv$iv;
                block13: {
                    Object object;
                    int curState$iv$iv;
                    block15: {
                        block14: {
                            boolean bl = false;
                            this_$iv$iv = (CompileServiceImplBase)this_$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv.ordinal()) break block13;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block14;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block15;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    boolean bl = false;
                    boolean bl3 = false;
                    if (this$0.getState().getSessions().isEmpty()) {
                        this$0.shutdownWithDelay();
                    } else {
                        this$0.getDaemonOptions().setAutoshutdownIdleSeconds((int)TimeUnit.MILLISECONDS.toSeconds(this$0.getDaemonOptions().getForceShutdownTimeoutMilliseconds()));
                        this$0.getDaemonOptions().setAutoshutdownUnusedSeconds(this$0.getDaemonOptions().getAutoshutdownIdleSeconds());
                        this$0.getLog().info("Some sessions are active, waiting for them to finish");
                        this$0.getLog().info("Unused/idle timeouts are set to " + this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() + '/' + this$0.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                    }
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public static final /* synthetic */ void access$shutdownNow(CompileServiceImpl $this) {
        $this.shutdownNow();
    }

    public static final /* synthetic */ void access$gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this$0);
    }
}

