/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Checksum;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.IoActions;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.LimitedDescription;

@Deprecated
public class GFileUtils {
    private static void logDeprecation() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateType(GFileUtils.class).willBeRemovedInGradle9().withUpgradeGuideSection(7, "org_gradle_util_reports_deprecations")).nagUser();
    }

    public GFileUtils() {
        GFileUtils.logDeprecation();
    }

    public static FileInputStream openInputStream(File file) {
        GFileUtils.logDeprecation();
        try {
            return FileUtils.openInputStream((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Problems opening file input stream for file: " + file, e);
        }
    }

    public static void touch(File file) {
        GFileUtils.logDeprecation();
        try {
            if (!file.createNewFile()) {
                GFileUtils.touchExistingInternal(file);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void touchExisting(File file) {
        GFileUtils.logDeprecation();
        GFileUtils.touchExistingInternal(file);
    }

    private static void touchExistingInternal(File file) {
        try {
            Files.setLastModifiedTime(file.toPath(), FileTime.fromMillis(System.currentTimeMillis()));
        }
        catch (IOException e) {
            if (file.isFile() && file.length() == 0L) {
                GFileUtils.touchFileByWritingEmptyByteArray(file);
            }
            throw new UncheckedIOException("Could not update timestamp for " + file, (Throwable)e);
        }
    }

    private static void touchFileByWritingEmptyByteArray(File file) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(ArrayUtils.EMPTY_BYTE_ARRAY);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException("Could not update timestamp for " + file, (Throwable)e);
            }
            catch (Throwable throwable) {
                IoActions.closeQuietly(out);
                throw throwable;
            }
        }
        IoActions.closeQuietly((Closeable)out);
    }

    public static void moveFile(File source, File destination) {
        GFileUtils.logDeprecation();
        GFileUtils.moveFileInternal(source, destination);
    }

    private static void moveFileInternal(File source, File destination) {
        try {
            FileUtils.moveFile((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void moveExistingFile(File source, File destination) {
        GFileUtils.logDeprecation();
        boolean rename = source.renameTo(destination);
        if (!rename) {
            GFileUtils.moveFileInternal(source, destination);
        }
    }

    public static void copyFile(File source, File destination) {
        GFileUtils.logDeprecation();
        try {
            FileUtils.copyFile((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void copyDirectory(File source, File destination) {
        GFileUtils.logDeprecation();
        try {
            FileUtils.copyDirectory((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void moveDirectory(File source, File destination) {
        GFileUtils.logDeprecation();
        GFileUtils.moveDirectoryInternal(source, destination);
    }

    private static void moveDirectoryInternal(File source, File destination) {
        try {
            FileUtils.moveDirectory((File)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void moveExistingDirectory(File source, File destination) {
        GFileUtils.logDeprecation();
        boolean rename = source.renameTo(destination);
        if (!rename) {
            GFileUtils.moveDirectory(source, destination);
        }
    }

    public static String readFile(File file) {
        return GFileUtils.readFile(file, Charset.defaultCharset().name());
    }

    public static String readFile(File file, String encoding) {
        GFileUtils.logDeprecation();
        try {
            return FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static String readFileQuietly(File file) {
        try {
            return GFileUtils.readFile(file);
        }
        catch (Exception e) {
            return "Unable to read file '" + file + "' due to: " + e.toString();
        }
    }

    public static void writeFile(String content, File destination) {
        GFileUtils.writeFile(content, destination, Charset.defaultCharset().name());
    }

    public static void writeFile(String content, File destination, String encoding) {
        GFileUtils.logDeprecation();
        try {
            FileUtils.writeStringToFile((File)destination, (String)content, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static Collection<File> listFiles(File directory, String[] extensions, boolean recursive) {
        GFileUtils.logDeprecation();
        return FileUtils.listFiles((File)directory, (String[])extensions, (boolean)recursive);
    }

    public static List<String> toPaths(Collection<File> files) {
        GFileUtils.logDeprecation();
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        return paths;
    }

    public static void copyURLToFile(URL source, File destination) {
        GFileUtils.logDeprecation();
        try {
            FileUtils.copyURLToFile((URL)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void deleteDirectory(File directory) {
        GFileUtils.logDeprecation();
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static boolean deleteQuietly(@Nullable File file) {
        GFileUtils.logDeprecation();
        return FileUtils.deleteQuietly((File)file);
    }

    public static String tail(File file, int maxLines) throws TailReadingException {
        String string;
        GFileUtils.logDeprecation();
        BufferedReader reader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            LimitedDescription description = new LimitedDescription(maxLines);
            String line = reader.readLine();
            while (line != null) {
                description.append(line);
                line = reader.readLine();
            }
            string = description.toString();
        }
        catch (Exception e) {
            try {
                throw new TailReadingException(e, false);
            }
            catch (Throwable throwable) {
                IoActions.closeQuietly(fileReader);
                IoActions.closeQuietly(reader);
                throw throwable;
            }
        }
        IoActions.closeQuietly((Closeable)fileReader);
        IoActions.closeQuietly((Closeable)reader);
        return string;
    }

    public static void forceDelete(File file) {
        GFileUtils.logDeprecation();
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static Checksum checksum(File file, Checksum checksum) {
        GFileUtils.logDeprecation();
        try {
            return FileUtils.checksum((File)file, (Checksum)checksum);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static File parentMkdirs(File child) {
        File parent = child.getParentFile();
        GFileUtils.mkdirs(parent);
        return parent;
    }

    public static void mkdirs(File dir) {
        GFileUtils.logDeprecation();
        dir = dir.getAbsoluteFile();
        if (dir.isDirectory()) {
            return;
        }
        if (dir.exists() && !dir.isDirectory()) {
            throw new UncheckedIOException(String.format("Cannot create directory '%s' as it already exists, but is not a directory", dir));
        }
        LinkedList<File> toCreate = new LinkedList<File>();
        File parent = dir.getParentFile();
        while (!parent.exists()) {
            toCreate.add(parent);
            parent = parent.getParentFile();
        }
        Collections.reverse(toCreate);
        for (File parentDirToCreate : toCreate) {
            if (parentDirToCreate.isDirectory()) continue;
            File parentDirToCreateParent = parentDirToCreate.getParentFile();
            if (!parentDirToCreateParent.isDirectory()) {
                throw new UncheckedIOException(String.format("Cannot create parent directory '%s' when creating directory '%s' as '%s' is not a directory", parentDirToCreate, dir, parentDirToCreateParent));
            }
            if (parentDirToCreate.mkdir() || parentDirToCreate.isDirectory()) continue;
            throw new UncheckedIOException(String.format("Failed to create parent directory '%s' when creating directory '%s'", parentDirToCreate, dir));
        }
        if (!dir.mkdir() && !dir.isDirectory()) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", dir));
        }
    }

    public static String relativePathOf(File target, File base) {
        int prefixLen;
        GFileUtils.logDeprecation();
        String separatorChars = "/" + File.separator;
        List<String> basePath = GFileUtils.splitAbsolutePathOf(base, separatorChars);
        List<String> targetPath = new ArrayList<String>(GFileUtils.splitAbsolutePathOf(target, separatorChars));
        int maxDepth = Math.min(basePath.size(), targetPath.size());
        for (prefixLen = 0; prefixLen < maxDepth && basePath.get(prefixLen).equals(targetPath.get(prefixLen)); ++prefixLen) {
        }
        basePath = basePath.subList(prefixLen, basePath.size());
        targetPath = targetPath.subList(prefixLen, targetPath.size());
        for (int i = 0; i < basePath.size(); ++i) {
            targetPath.add(0, "..");
        }
        if (targetPath.isEmpty()) {
            return ".";
        }
        return CollectionUtils.join((String)File.separator, targetPath);
    }

    private static List<String> splitAbsolutePathOf(File baseDir, String separatorChars) {
        return Arrays.asList(StringUtils.split((String)baseDir.getAbsolutePath(), (String)separatorChars));
    }

    @Deprecated
    public static class TailReadingException
    extends RuntimeException {
        public TailReadingException(Throwable throwable) {
            this(throwable, true);
        }

        private TailReadingException(Throwable throwable, boolean logDeprecation) {
            super(throwable);
            if (logDeprecation) {
                GFileUtils.logDeprecation();
            }
        }
    }
}

