"""Generated client library for dataform version v1beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.dataform.v1beta1 import dataform_v1beta1_messages as messages


class DataformV1beta1(base_api.BaseApiClient):
  """Generated client library for service dataform version v1beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://dataform.googleapis.com/'
  MTLS_BASE_URL = 'https://dataform.mtls.googleapis.com/'

  _PACKAGE = 'dataform'
  _SCOPES = ['https://www.googleapis.com/auth/bigquery', 'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1beta1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'DataformV1beta1'
  _URL_VERSION = 'v1beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new dataform handle."""
    url = url or self.BASE_URL
    super(DataformV1beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_folders = self.ProjectsLocationsFoldersService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_repositories_compilationResults = self.ProjectsLocationsRepositoriesCompilationResultsService(self)
    self.projects_locations_repositories_releaseConfigs = self.ProjectsLocationsRepositoriesReleaseConfigsService(self)
    self.projects_locations_repositories_workflowConfigs = self.ProjectsLocationsRepositoriesWorkflowConfigsService(self)
    self.projects_locations_repositories_workflowInvocations = self.ProjectsLocationsRepositoriesWorkflowInvocationsService(self)
    self.projects_locations_repositories_workspaces = self.ProjectsLocationsRepositoriesWorkspacesService(self)
    self.projects_locations_repositories = self.ProjectsLocationsRepositoriesService(self)
    self.projects_locations_teamFolders = self.ProjectsLocationsTeamFoldersService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsFoldersService(base_api.BaseApiService):
    """Service class for the projects_locations_folders resource."""

    _NAME = 'projects_locations_folders'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsFoldersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Folder in a given project and location.

      Args:
        request: (DataformProjectsLocationsFoldersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/folders',
        http_method='POST',
        method_id='dataform.projects.locations.folders.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['folderId'],
        relative_path='v1beta1/{+parent}/folders',
        request_field='folder',
        request_type_name='DataformProjectsLocationsFoldersCreateRequest',
        response_type_name='Folder',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Folder.

      Args:
        request: (DataformProjectsLocationsFoldersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/folders/{foldersId}',
        http_method='DELETE',
        method_id='dataform.projects.locations.folders.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsFoldersDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Fetches a single Folder.

      Args:
        request: (DataformProjectsLocationsFoldersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/folders/{foldersId}',
        http_method='GET',
        method_id='dataform.projects.locations.folders.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsFoldersGetRequest',
        response_type_name='Folder',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (DataformProjectsLocationsFoldersGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/folders/{foldersId}:getIamPolicy',
        http_method='GET',
        method_id='dataform.projects.locations.folders.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='DataformProjectsLocationsFoldersGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves a Folder to a new Folder, TeamFolder, or the root location.

      Args:
        request: (DataformProjectsLocationsFoldersMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/folders/{foldersId}:move',
        http_method='POST',
        method_id='dataform.projects.locations.folders.move',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:move',
        request_field='moveFolderRequest',
        request_type_name='DataformProjectsLocationsFoldersMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a single Folder.

      Args:
        request: (DataformProjectsLocationsFoldersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/folders/{foldersId}',
        http_method='PATCH',
        method_id='dataform.projects.locations.folders.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='folder',
        request_type_name='DataformProjectsLocationsFoldersPatchRequest',
        response_type_name='Folder',
        supports_download=False,
    )

    def QueryFolderContents(self, request, global_params=None):
      r"""Returns the contents of a given Folder.

      Args:
        request: (DataformProjectsLocationsFoldersQueryFolderContentsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryFolderContentsResponse) The response message.
      """
      config = self.GetMethodConfig('QueryFolderContents')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryFolderContents.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/folders/{foldersId}:queryFolderContents',
        http_method='GET',
        method_id='dataform.projects.locations.folders.queryFolderContents',
        ordered_params=['folder'],
        path_params=['folder'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+folder}:queryFolderContents',
        request_field='',
        request_type_name='DataformProjectsLocationsFoldersQueryFolderContentsRequest',
        response_type_name='QueryFolderContentsResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (DataformProjectsLocationsFoldersSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/folders/{foldersId}:setIamPolicy',
        http_method='POST',
        method_id='dataform.projects.locations.folders.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DataformProjectsLocationsFoldersSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (DataformProjectsLocationsFoldersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/folders/{foldersId}:testIamPermissions',
        http_method='POST',
        method_id='dataform.projects.locations.folders.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DataformProjectsLocationsFoldersTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (DataformProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='dataform.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='DataformProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (DataformProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='dataform.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (DataformProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='dataform.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (DataformProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='dataform.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1beta1/{+name}/operations',
        request_field='',
        request_type_name='DataformProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRepositoriesCompilationResultsService(base_api.BaseApiService):
    """Service class for the projects_locations_repositories_compilationResults resource."""

    _NAME = 'projects_locations_repositories_compilationResults'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsRepositoriesCompilationResultsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new CompilationResult in a given project and location.

      Args:
        request: (DataformProjectsLocationsRepositoriesCompilationResultsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CompilationResult) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/compilationResults',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.compilationResults.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1beta1/{+parent}/compilationResults',
        request_field='compilationResult',
        request_type_name='DataformProjectsLocationsRepositoriesCompilationResultsCreateRequest',
        response_type_name='CompilationResult',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Fetches a single CompilationResult.

      Args:
        request: (DataformProjectsLocationsRepositoriesCompilationResultsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CompilationResult) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/compilationResults/{compilationResultsId}',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.compilationResults.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesCompilationResultsGetRequest',
        response_type_name='CompilationResult',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists CompilationResults in a given Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesCompilationResultsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCompilationResultsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/compilationResults',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.compilationResults.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/compilationResults',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesCompilationResultsListRequest',
        response_type_name='ListCompilationResultsResponse',
        supports_download=False,
    )

    def Query(self, request, global_params=None):
      r"""Returns CompilationResultActions in a given CompilationResult.

      Args:
        request: (DataformProjectsLocationsRepositoriesCompilationResultsQueryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryCompilationResultActionsResponse) The response message.
      """
      config = self.GetMethodConfig('Query')
      return self._RunMethod(
          config, request, global_params=global_params)

    Query.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/compilationResults/{compilationResultsId}:query',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.compilationResults.query',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+name}:query',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesCompilationResultsQueryRequest',
        response_type_name='QueryCompilationResultActionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRepositoriesReleaseConfigsService(base_api.BaseApiService):
    """Service class for the projects_locations_repositories_releaseConfigs resource."""

    _NAME = 'projects_locations_repositories_releaseConfigs'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsRepositoriesReleaseConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new ReleaseConfig in a given Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesReleaseConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReleaseConfig) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/releaseConfigs',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.releaseConfigs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['releaseConfigId'],
        relative_path='v1beta1/{+parent}/releaseConfigs',
        request_field='releaseConfig',
        request_type_name='DataformProjectsLocationsRepositoriesReleaseConfigsCreateRequest',
        response_type_name='ReleaseConfig',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single ReleaseConfig.

      Args:
        request: (DataformProjectsLocationsRepositoriesReleaseConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/releaseConfigs/{releaseConfigsId}',
        http_method='DELETE',
        method_id='dataform.projects.locations.repositories.releaseConfigs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesReleaseConfigsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Fetches a single ReleaseConfig.

      Args:
        request: (DataformProjectsLocationsRepositoriesReleaseConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReleaseConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/releaseConfigs/{releaseConfigsId}',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.releaseConfigs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesReleaseConfigsGetRequest',
        response_type_name='ReleaseConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ReleaseConfigs in a given Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesReleaseConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListReleaseConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/releaseConfigs',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.releaseConfigs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/releaseConfigs',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesReleaseConfigsListRequest',
        response_type_name='ListReleaseConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a single ReleaseConfig. **Note:** *This method does not fully implement [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated as a bad request, and when the `field_mask` is omitted, the request is treated as a full update on all modifiable fields.*.

      Args:
        request: (DataformProjectsLocationsRepositoriesReleaseConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReleaseConfig) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/releaseConfigs/{releaseConfigsId}',
        http_method='PATCH',
        method_id='dataform.projects.locations.repositories.releaseConfigs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='releaseConfig',
        request_type_name='DataformProjectsLocationsRepositoriesReleaseConfigsPatchRequest',
        response_type_name='ReleaseConfig',
        supports_download=False,
    )

  class ProjectsLocationsRepositoriesWorkflowConfigsService(base_api.BaseApiService):
    """Service class for the projects_locations_repositories_workflowConfigs resource."""

    _NAME = 'projects_locations_repositories_workflowConfigs'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsRepositoriesWorkflowConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new WorkflowConfig in a given Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WorkflowConfig) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowConfigs',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workflowConfigs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['workflowConfigId'],
        relative_path='v1beta1/{+parent}/workflowConfigs',
        request_field='workflowConfig',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowConfigsCreateRequest',
        response_type_name='WorkflowConfig',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single WorkflowConfig.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowConfigs/{workflowConfigsId}',
        http_method='DELETE',
        method_id='dataform.projects.locations.repositories.workflowConfigs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowConfigsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Fetches a single WorkflowConfig.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WorkflowConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowConfigs/{workflowConfigsId}',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workflowConfigs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowConfigsGetRequest',
        response_type_name='WorkflowConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists WorkflowConfigs in a given Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWorkflowConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowConfigs',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workflowConfigs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/workflowConfigs',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowConfigsListRequest',
        response_type_name='ListWorkflowConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a single WorkflowConfig. **Note:** *This method does not fully implement [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated as a bad request, and when the `field_mask` is omitted, the request is treated as a full update on all modifiable fields.*.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WorkflowConfig) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowConfigs/{workflowConfigsId}',
        http_method='PATCH',
        method_id='dataform.projects.locations.repositories.workflowConfigs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='workflowConfig',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowConfigsPatchRequest',
        response_type_name='WorkflowConfig',
        supports_download=False,
    )

  class ProjectsLocationsRepositoriesWorkflowInvocationsService(base_api.BaseApiService):
    """Service class for the projects_locations_repositories_workflowInvocations resource."""

    _NAME = 'projects_locations_repositories_workflowInvocations'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsRepositoriesWorkflowInvocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Requests cancellation of a running WorkflowInvocation.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowInvocationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CancelWorkflowInvocationResponse) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowInvocations/{workflowInvocationsId}:cancel',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workflowInvocations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:cancel',
        request_field='cancelWorkflowInvocationRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowInvocationsCancelRequest',
        response_type_name='CancelWorkflowInvocationResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new WorkflowInvocation in a given Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowInvocationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WorkflowInvocation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowInvocations',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workflowInvocations.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1beta1/{+parent}/workflowInvocations',
        request_field='workflowInvocation',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowInvocationsCreateRequest',
        response_type_name='WorkflowInvocation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single WorkflowInvocation.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowInvocationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowInvocations/{workflowInvocationsId}',
        http_method='DELETE',
        method_id='dataform.projects.locations.repositories.workflowInvocations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowInvocationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Fetches a single WorkflowInvocation.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowInvocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WorkflowInvocation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowInvocations/{workflowInvocationsId}',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workflowInvocations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowInvocationsGetRequest',
        response_type_name='WorkflowInvocation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists WorkflowInvocations in a given Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowInvocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWorkflowInvocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowInvocations',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workflowInvocations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/workflowInvocations',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowInvocationsListRequest',
        response_type_name='ListWorkflowInvocationsResponse',
        supports_download=False,
    )

    def Query(self, request, global_params=None):
      r"""Returns WorkflowInvocationActions in a given WorkflowInvocation.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkflowInvocationsQueryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryWorkflowInvocationActionsResponse) The response message.
      """
      config = self.GetMethodConfig('Query')
      return self._RunMethod(
          config, request, global_params=global_params)

    Query.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workflowInvocations/{workflowInvocationsId}:query',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workflowInvocations.query',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+name}:query',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkflowInvocationsQueryRequest',
        response_type_name='QueryWorkflowInvocationActionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRepositoriesWorkspacesService(base_api.BaseApiService):
    """Service class for the projects_locations_repositories_workspaces resource."""

    _NAME = 'projects_locations_repositories_workspaces'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsRepositoriesWorkspacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Commit(self, request, global_params=None):
      r"""Applies a Git commit for uncommitted files in a Workspace.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesCommitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitWorkspaceChangesResponse) The response message.
      """
      config = self.GetMethodConfig('Commit')
      return self._RunMethod(
          config, request, global_params=global_params)

    Commit.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:commit',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.commit',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:commit',
        request_field='commitWorkspaceChangesRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesCommitRequest',
        response_type_name='CommitWorkspaceChangesResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new Workspace in a given Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['workspaceId'],
        relative_path='v1beta1/{+parent}/workspaces',
        request_field='workspace',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesCreateRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Workspace.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}',
        http_method='DELETE',
        method_id='dataform.projects.locations.repositories.workspaces.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def FetchFileDiff(self, request, global_params=None):
      r"""Fetches Git diff for an uncommitted file in a Workspace.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesFetchFileDiffRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchFileDiffResponse) The response message.
      """
      config = self.GetMethodConfig('FetchFileDiff')
      return self._RunMethod(
          config, request, global_params=global_params)

    FetchFileDiff.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:fetchFileDiff',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workspaces.fetchFileDiff',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=['path'],
        relative_path='v1beta1/{+workspace}:fetchFileDiff',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesFetchFileDiffRequest',
        response_type_name='FetchFileDiffResponse',
        supports_download=False,
    )

    def FetchFileGitStatuses(self, request, global_params=None):
      r"""Fetches Git statuses for the files in a Workspace.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesFetchFileGitStatusesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchFileGitStatusesResponse) The response message.
      """
      config = self.GetMethodConfig('FetchFileGitStatuses')
      return self._RunMethod(
          config, request, global_params=global_params)

    FetchFileGitStatuses.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:fetchFileGitStatuses',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workspaces.fetchFileGitStatuses',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:fetchFileGitStatuses',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesFetchFileGitStatusesRequest',
        response_type_name='FetchFileGitStatusesResponse',
        supports_download=False,
    )

    def FetchGitAheadBehind(self, request, global_params=None):
      r"""Fetches Git ahead/behind against a remote branch.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesFetchGitAheadBehindRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchGitAheadBehindResponse) The response message.
      """
      config = self.GetMethodConfig('FetchGitAheadBehind')
      return self._RunMethod(
          config, request, global_params=global_params)

    FetchGitAheadBehind.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:fetchGitAheadBehind',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workspaces.fetchGitAheadBehind',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['remoteBranch'],
        relative_path='v1beta1/{+name}:fetchGitAheadBehind',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesFetchGitAheadBehindRequest',
        response_type_name='FetchGitAheadBehindResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Fetches a single Workspace.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workspaces.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesGetRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:getIamPolicy',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workspaces.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def InstallNpmPackages(self, request, global_params=None):
      r"""Installs dependency NPM packages (inside a Workspace).

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesInstallNpmPackagesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstallNpmPackagesResponse) The response message.
      """
      config = self.GetMethodConfig('InstallNpmPackages')
      return self._RunMethod(
          config, request, global_params=global_params)

    InstallNpmPackages.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:installNpmPackages',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.installNpmPackages',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=[],
        relative_path='v1beta1/{+workspace}:installNpmPackages',
        request_field='installNpmPackagesRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesInstallNpmPackagesRequest',
        response_type_name='InstallNpmPackagesResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Workspaces in a given Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWorkspacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workspaces.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/workspaces',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesListRequest',
        response_type_name='ListWorkspacesResponse',
        supports_download=False,
    )

    def MakeDirectory(self, request, global_params=None):
      r"""Creates a directory inside a Workspace.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesMakeDirectoryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MakeDirectoryResponse) The response message.
      """
      config = self.GetMethodConfig('MakeDirectory')
      return self._RunMethod(
          config, request, global_params=global_params)

    MakeDirectory.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:makeDirectory',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.makeDirectory',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=[],
        relative_path='v1beta1/{+workspace}:makeDirectory',
        request_field='makeDirectoryRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesMakeDirectoryRequest',
        response_type_name='MakeDirectoryResponse',
        supports_download=False,
    )

    def MoveDirectory(self, request, global_params=None):
      r"""Moves a directory (inside a Workspace), and all of its contents, to a new location.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesMoveDirectoryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MoveDirectoryResponse) The response message.
      """
      config = self.GetMethodConfig('MoveDirectory')
      return self._RunMethod(
          config, request, global_params=global_params)

    MoveDirectory.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:moveDirectory',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.moveDirectory',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=[],
        relative_path='v1beta1/{+workspace}:moveDirectory',
        request_field='moveDirectoryRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesMoveDirectoryRequest',
        response_type_name='MoveDirectoryResponse',
        supports_download=False,
    )

    def MoveFile(self, request, global_params=None):
      r"""Moves a file (inside a Workspace) to a new location.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesMoveFileRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MoveFileResponse) The response message.
      """
      config = self.GetMethodConfig('MoveFile')
      return self._RunMethod(
          config, request, global_params=global_params)

    MoveFile.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:moveFile',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.moveFile',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=[],
        relative_path='v1beta1/{+workspace}:moveFile',
        request_field='moveFileRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesMoveFileRequest',
        response_type_name='MoveFileResponse',
        supports_download=False,
    )

    def Pull(self, request, global_params=None):
      r"""Pulls Git commits from the Repository's remote into a Workspace.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesPullRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PullGitCommitsResponse) The response message.
      """
      config = self.GetMethodConfig('Pull')
      return self._RunMethod(
          config, request, global_params=global_params)

    Pull.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:pull',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.pull',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:pull',
        request_field='pullGitCommitsRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesPullRequest',
        response_type_name='PullGitCommitsResponse',
        supports_download=False,
    )

    def Push(self, request, global_params=None):
      r"""Pushes Git commits from a Workspace to the Repository's remote.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesPushRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PushGitCommitsResponse) The response message.
      """
      config = self.GetMethodConfig('Push')
      return self._RunMethod(
          config, request, global_params=global_params)

    Push.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:push',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.push',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:push',
        request_field='pushGitCommitsRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesPushRequest',
        response_type_name='PushGitCommitsResponse',
        supports_download=False,
    )

    def QueryDirectoryContents(self, request, global_params=None):
      r"""Returns the contents of a given Workspace directory.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesQueryDirectoryContentsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryDirectoryContentsResponse) The response message.
      """
      config = self.GetMethodConfig('QueryDirectoryContents')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryDirectoryContents.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:queryDirectoryContents',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workspaces.queryDirectoryContents',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=['pageSize', 'pageToken', 'path'],
        relative_path='v1beta1/{+workspace}:queryDirectoryContents',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesQueryDirectoryContentsRequest',
        response_type_name='QueryDirectoryContentsResponse',
        supports_download=False,
    )

    def ReadFile(self, request, global_params=None):
      r"""Returns the contents of a file (inside a Workspace).

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesReadFileRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadFileResponse) The response message.
      """
      config = self.GetMethodConfig('ReadFile')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReadFile.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:readFile',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workspaces.readFile',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=['path', 'revision'],
        relative_path='v1beta1/{+workspace}:readFile',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesReadFileRequest',
        response_type_name='ReadFileResponse',
        supports_download=False,
    )

    def RemoveDirectory(self, request, global_params=None):
      r"""Deletes a directory (inside a Workspace) and all of its contents.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesRemoveDirectoryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RemoveDirectoryResponse) The response message.
      """
      config = self.GetMethodConfig('RemoveDirectory')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveDirectory.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:removeDirectory',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.removeDirectory',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=[],
        relative_path='v1beta1/{+workspace}:removeDirectory',
        request_field='removeDirectoryRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesRemoveDirectoryRequest',
        response_type_name='RemoveDirectoryResponse',
        supports_download=False,
    )

    def RemoveFile(self, request, global_params=None):
      r"""Deletes a file (inside a Workspace).

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesRemoveFileRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RemoveFileResponse) The response message.
      """
      config = self.GetMethodConfig('RemoveFile')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveFile.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:removeFile',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.removeFile',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=[],
        relative_path='v1beta1/{+workspace}:removeFile',
        request_field='removeFileRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesRemoveFileRequest',
        response_type_name='RemoveFileResponse',
        supports_download=False,
    )

    def Reset(self, request, global_params=None):
      r"""Performs a Git reset for uncommitted files in a Workspace.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesResetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResetWorkspaceChangesResponse) The response message.
      """
      config = self.GetMethodConfig('Reset')
      return self._RunMethod(
          config, request, global_params=global_params)

    Reset.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:reset',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.reset',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:reset',
        request_field='resetWorkspaceChangesRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesResetRequest',
        response_type_name='ResetWorkspaceChangesResponse',
        supports_download=False,
    )

    def SearchFiles(self, request, global_params=None):
      r"""Finds the contents of a given Workspace directory by filter.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesSearchFilesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchFilesResponse) The response message.
      """
      config = self.GetMethodConfig('SearchFiles')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchFiles.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:searchFiles',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.workspaces.searchFiles',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+workspace}:searchFiles',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesSearchFilesRequest',
        response_type_name='SearchFilesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:setIamPolicy',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:testIamPermissions',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def WriteFile(self, request, global_params=None):
      r"""Writes to a file (inside a Workspace).

      Args:
        request: (DataformProjectsLocationsRepositoriesWorkspacesWriteFileRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WriteFileResponse) The response message.
      """
      config = self.GetMethodConfig('WriteFile')
      return self._RunMethod(
          config, request, global_params=global_params)

    WriteFile.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}/workspaces/{workspacesId}:writeFile',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.workspaces.writeFile',
        ordered_params=['workspace'],
        path_params=['workspace'],
        query_params=[],
        relative_path='v1beta1/{+workspace}:writeFile',
        request_field='writeFileRequest',
        request_type_name='DataformProjectsLocationsRepositoriesWorkspacesWriteFileRequest',
        response_type_name='WriteFileResponse',
        supports_download=False,
    )

  class ProjectsLocationsRepositoriesService(base_api.BaseApiService):
    """Service class for the projects_locations_repositories resource."""

    _NAME = 'projects_locations_repositories'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsRepositoriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Commit(self, request, global_params=None):
      r"""Applies a Git commit to a Repository. The Repository must not have a value for `git_remote_settings.url`.

      Args:
        request: (DataformProjectsLocationsRepositoriesCommitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitRepositoryChangesResponse) The response message.
      """
      config = self.GetMethodConfig('Commit')
      return self._RunMethod(
          config, request, global_params=global_params)

    Commit.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:commit',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.commit',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:commit',
        request_field='commitRepositoryChangesRequest',
        request_type_name='DataformProjectsLocationsRepositoriesCommitRequest',
        response_type_name='CommitRepositoryChangesResponse',
        supports_download=False,
    )

    def ComputeAccessTokenStatus(self, request, global_params=None):
      r"""Computes a Repository's Git access token status.

      Args:
        request: (DataformProjectsLocationsRepositoriesComputeAccessTokenStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeRepositoryAccessTokenStatusResponse) The response message.
      """
      config = self.GetMethodConfig('ComputeAccessTokenStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    ComputeAccessTokenStatus.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:computeAccessTokenStatus',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.computeAccessTokenStatus',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:computeAccessTokenStatus',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesComputeAccessTokenStatusRequest',
        response_type_name='ComputeRepositoryAccessTokenStatusResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new Repository in a given project and location.

      Args:
        request: (DataformProjectsLocationsRepositoriesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Repository) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['repositoryId'],
        relative_path='v1beta1/{+parent}/repositories',
        request_field='repository',
        request_type_name='DataformProjectsLocationsRepositoriesCreateRequest',
        response_type_name='Repository',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}',
        http_method='DELETE',
        method_id='dataform.projects.locations.repositories.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def FetchHistory(self, request, global_params=None):
      r"""Fetches a Repository's history of commits. The Repository must not have a value for `git_remote_settings.url`.

      Args:
        request: (DataformProjectsLocationsRepositoriesFetchHistoryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchRepositoryHistoryResponse) The response message.
      """
      config = self.GetMethodConfig('FetchHistory')
      return self._RunMethod(
          config, request, global_params=global_params)

    FetchHistory.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:fetchHistory',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.fetchHistory',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+name}:fetchHistory',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesFetchHistoryRequest',
        response_type_name='FetchRepositoryHistoryResponse',
        supports_download=False,
    )

    def FetchRemoteBranches(self, request, global_params=None):
      r"""Fetches a Repository's remote branches.

      Args:
        request: (DataformProjectsLocationsRepositoriesFetchRemoteBranchesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchRemoteBranchesResponse) The response message.
      """
      config = self.GetMethodConfig('FetchRemoteBranches')
      return self._RunMethod(
          config, request, global_params=global_params)

    FetchRemoteBranches.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:fetchRemoteBranches',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.fetchRemoteBranches',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:fetchRemoteBranches',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesFetchRemoteBranchesRequest',
        response_type_name='FetchRemoteBranchesResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Fetches a single Repository.

      Args:
        request: (DataformProjectsLocationsRepositoriesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Repository) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesGetRequest',
        response_type_name='Repository',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (DataformProjectsLocationsRepositoriesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:getIamPolicy',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Repositories in a given project and location. **Note:** *This method can return repositories not shown in the [Dataform UI](https://console.cloud.google.com/bigquery/dataform)*.

      Args:
        request: (DataformProjectsLocationsRepositoriesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRepositoriesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/repositories',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesListRequest',
        response_type_name='ListRepositoriesResponse',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves a Repository to a new location.

      Args:
        request: (DataformProjectsLocationsRepositoriesMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:move',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.move',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:move',
        request_field='moveRepositoryRequest',
        request_type_name='DataformProjectsLocationsRepositoriesMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a single Repository. **Note:** *This method does not fully implement [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated as a bad request, and when the `field_mask` is omitted, the request is treated as a full update on all modifiable fields.*.

      Args:
        request: (DataformProjectsLocationsRepositoriesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Repository) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}',
        http_method='PATCH',
        method_id='dataform.projects.locations.repositories.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='repository',
        request_type_name='DataformProjectsLocationsRepositoriesPatchRequest',
        response_type_name='Repository',
        supports_download=False,
    )

    def QueryDirectoryContents(self, request, global_params=None):
      r"""Returns the contents of a given Repository directory. The Repository must not have a value for `git_remote_settings.url`.

      Args:
        request: (DataformProjectsLocationsRepositoriesQueryDirectoryContentsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryRepositoryDirectoryContentsResponse) The response message.
      """
      config = self.GetMethodConfig('QueryDirectoryContents')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryDirectoryContents.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:queryDirectoryContents',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.queryDirectoryContents',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['commitSha', 'pageSize', 'pageToken', 'path'],
        relative_path='v1beta1/{+name}:queryDirectoryContents',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesQueryDirectoryContentsRequest',
        response_type_name='QueryRepositoryDirectoryContentsResponse',
        supports_download=False,
    )

    def ReadFile(self, request, global_params=None):
      r"""Returns the contents of a file (inside a Repository). The Repository must not have a value for `git_remote_settings.url`.

      Args:
        request: (DataformProjectsLocationsRepositoriesReadFileRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadRepositoryFileResponse) The response message.
      """
      config = self.GetMethodConfig('ReadFile')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReadFile.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:readFile',
        http_method='GET',
        method_id='dataform.projects.locations.repositories.readFile',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['commitSha', 'path'],
        relative_path='v1beta1/{+name}:readFile',
        request_field='',
        request_type_name='DataformProjectsLocationsRepositoriesReadFileRequest',
        response_type_name='ReadRepositoryFileResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (DataformProjectsLocationsRepositoriesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:setIamPolicy',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DataformProjectsLocationsRepositoriesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (DataformProjectsLocationsRepositoriesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/repositories/{repositoriesId}:testIamPermissions',
        http_method='POST',
        method_id='dataform.projects.locations.repositories.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DataformProjectsLocationsRepositoriesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTeamFoldersService(base_api.BaseApiService):
    """Service class for the projects_locations_teamFolders resource."""

    _NAME = 'projects_locations_teamFolders'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsTeamFoldersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new TeamFolder in a given project and location.

      Args:
        request: (DataformProjectsLocationsTeamFoldersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TeamFolder) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/teamFolders',
        http_method='POST',
        method_id='dataform.projects.locations.teamFolders.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['teamFolderId'],
        relative_path='v1beta1/{+parent}/teamFolders',
        request_field='teamFolder',
        request_type_name='DataformProjectsLocationsTeamFoldersCreateRequest',
        response_type_name='TeamFolder',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single TeamFolder.

      Args:
        request: (DataformProjectsLocationsTeamFoldersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/teamFolders/{teamFoldersId}',
        http_method='DELETE',
        method_id='dataform.projects.locations.teamFolders.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsTeamFoldersDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Fetches a single TeamFolder.

      Args:
        request: (DataformProjectsLocationsTeamFoldersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TeamFolder) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/teamFolders/{teamFoldersId}',
        http_method='GET',
        method_id='dataform.projects.locations.teamFolders.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsTeamFoldersGetRequest',
        response_type_name='TeamFolder',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (DataformProjectsLocationsTeamFoldersGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/teamFolders/{teamFoldersId}:getIamPolicy',
        http_method='GET',
        method_id='dataform.projects.locations.teamFolders.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='DataformProjectsLocationsTeamFoldersGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a single TeamFolder.

      Args:
        request: (DataformProjectsLocationsTeamFoldersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TeamFolder) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/teamFolders/{teamFoldersId}',
        http_method='PATCH',
        method_id='dataform.projects.locations.teamFolders.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='teamFolder',
        request_type_name='DataformProjectsLocationsTeamFoldersPatchRequest',
        response_type_name='TeamFolder',
        supports_download=False,
    )

    def QueryContents(self, request, global_params=None):
      r"""Returns the contents of a given TeamFolder.

      Args:
        request: (DataformProjectsLocationsTeamFoldersQueryContentsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryTeamFolderContentsResponse) The response message.
      """
      config = self.GetMethodConfig('QueryContents')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryContents.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/teamFolders/{teamFoldersId}:queryContents',
        http_method='GET',
        method_id='dataform.projects.locations.teamFolders.queryContents',
        ordered_params=['teamFolder'],
        path_params=['teamFolder'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+teamFolder}:queryContents',
        request_field='',
        request_type_name='DataformProjectsLocationsTeamFoldersQueryContentsRequest',
        response_type_name='QueryTeamFolderContentsResponse',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Returns all TeamFolders in a given location that the caller has access to and match the provided filter.

      Args:
        request: (DataformProjectsLocationsTeamFoldersSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchTeamFoldersResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/teamFolders:search',
        http_method='GET',
        method_id='dataform.projects.locations.teamFolders.search',
        ordered_params=['location'],
        path_params=['location'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+location}/teamFolders:search',
        request_field='',
        request_type_name='DataformProjectsLocationsTeamFoldersSearchRequest',
        response_type_name='SearchTeamFoldersResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (DataformProjectsLocationsTeamFoldersSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/teamFolders/{teamFoldersId}:setIamPolicy',
        http_method='POST',
        method_id='dataform.projects.locations.teamFolders.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='DataformProjectsLocationsTeamFoldersSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (DataformProjectsLocationsTeamFoldersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/teamFolders/{teamFoldersId}:testIamPermissions',
        http_method='POST',
        method_id='dataform.projects.locations.teamFolders.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='DataformProjectsLocationsTeamFoldersTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (DataformProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='dataform.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def GetConfig(self, request, global_params=None):
      r"""Get default config for a given project and location.

      Args:
        request: (DataformProjectsLocationsGetConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Config) The response message.
      """
      config = self.GetMethodConfig('GetConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetConfig.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/config',
        http_method='GET',
        method_id='dataform.projects.locations.getConfig',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='DataformProjectsLocationsGetConfigRequest',
        response_type_name='Config',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service. This method can be called in two ways: * **List all public locations:** Use the path `GET /v1/locations`. * **List project-visible locations:** Use the path `GET /v1/projects/{project_id}/locations`. This may include public locations as well as private or other locations specifically visible to the project.

      Args:
        request: (DataformProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='dataform.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+name}/locations',
        request_field='',
        request_type_name='DataformProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

    def QueryUserRootContents(self, request, global_params=None):
      r"""Returns the contents of a caller's root folder in a given location. The root folder contains all resources that are created by the user and not contained in any other folder.

      Args:
        request: (DataformProjectsLocationsQueryUserRootContentsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryUserRootContentsResponse) The response message.
      """
      config = self.GetMethodConfig('QueryUserRootContents')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryUserRootContents.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}:queryUserRootContents',
        http_method='GET',
        method_id='dataform.projects.locations.queryUserRootContents',
        ordered_params=['location'],
        path_params=['location'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+location}:queryUserRootContents',
        request_field='',
        request_type_name='DataformProjectsLocationsQueryUserRootContentsRequest',
        response_type_name='QueryUserRootContentsResponse',
        supports_download=False,
    )

    def UpdateConfig(self, request, global_params=None):
      r"""Update default config for a given project and location. **Note:** *This method does not fully implement [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated as a bad request, and when the `field_mask` is omitted, the request is treated as a full update on all modifiable fields.*.

      Args:
        request: (DataformProjectsLocationsUpdateConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Config) The response message.
      """
      config = self.GetMethodConfig('UpdateConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateConfig.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/config',
        http_method='PATCH',
        method_id='dataform.projects.locations.updateConfig',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='config',
        request_type_name='DataformProjectsLocationsUpdateConfigRequest',
        response_type_name='Config',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(DataformV1beta1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
