/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public class HistoryEvent
extends StringTemplate {
    public static final String TAG = "historyEvent";
    private Turn turn;
    private HistoryEventType eventType;
    private String playerId;
    private int score;
    private static final String EVENT_TYPE_TAG = "eventType";
    private static final String PLAYER_ID_TAG = "playerId";
    private static final String SCORE_TAG = "score";
    private static final String TURN_TAG = "turn";

    public HistoryEvent() {
    }

    public HistoryEvent(Turn turn, HistoryEventType eventType, Player player) {
        super(eventType.getDescriptionKey(), null, StringTemplate.TemplateType.TEMPLATE);
        this.turn = turn;
        this.eventType = eventType;
        this.playerId = player == null ? null : player.getId();
        this.score = 0;
    }

    public HistoryEvent(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final Turn getTurn() {
        return this.turn;
    }

    public final HistoryEventType getEventType() {
        return this.eventType;
    }

    public static final HistoryEventType getEventTypeFromStance(Stance stance) {
        switch (stance) {
            case WAR: {
                return HistoryEventType.DECLARE_WAR;
            }
            case CEASE_FIRE: {
                return HistoryEventType.CEASE_FIRE;
            }
            case PEACE: {
                return HistoryEventType.MAKE_PEACE;
            }
            case ALLIANCE: {
                return HistoryEventType.FORM_ALLIANCE;
            }
        }
        return null;
    }

    public final String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public final int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        HistoryEvent o = this.copyInCast(other, HistoryEvent.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.turn = o.getTurn();
        this.eventType = o.getEventType();
        this.playerId = o.getPlayerId();
        this.score = o.getScore();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TURN_TAG, this.turn.getNumber());
        xw.writeAttribute(EVENT_TYPE_TAG, this.eventType);
        if (this.playerId != null) {
            xw.writeAttribute(PLAYER_ID_TAG, this.playerId);
        }
        xw.writeAttribute(SCORE_TAG, this.score);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.turn = new Turn(xr.getAttribute(TURN_TAG, 0));
        this.eventType = xr.getAttribute(EVENT_TYPE_TAG, HistoryEventType.class, null);
        this.playerId = xr.getAttribute(PLAYER_ID_TAG, null);
        this.score = xr.getAttribute(SCORE_TAG, 0);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HistoryEvent) {
            HistoryEvent other = (HistoryEvent)o;
            return this.turn == other.turn && this.eventType == other.eventType && this.score == other.score && Utils.equals(this.playerId, other.playerId) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.turn.hashCode();
        hash = 31 * hash + this.eventType.ordinal();
        if (this.playerId != null) {
            hash = 31 * hash + this.playerId.hashCode();
        }
        hash = 31 * hash + this.score;
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append('[').append(this.getId()).append(' ').append(this.eventType).append(" (").append(this.turn.getYear()).append(')');
        if (this.playerId != null) {
            sb.append(" playerId=").append(this.playerId).append(" score=").append(this.score);
        }
        sb.append(' ').append(super.toString()).append(']');
        return sb.toString();
    }

    public static enum HistoryEventType implements Named
    {
        DISCOVER_NEW_WORLD,
        DISCOVER_REGION,
        MEET_NATION,
        CITY_OF_GOLD,
        FOUND_COLONY,
        ABANDON_COLONY,
        CONQUER_COLONY,
        COLONY_DESTROYED,
        COLONY_CONQUERED,
        DESTROY_SETTLEMENT,
        DESTROY_NATION,
        FOUNDING_FATHER,
        DECLARE_INDEPENDENCE,
        INDEPENDENCE,
        SPANISH_SUCCESSION,
        DECLARE_WAR,
        CEASE_FIRE,
        MAKE_PEACE,
        FORM_ALLIANCE,
        NATION_DESTROYED;


        private String getKey() {
            return "historyEventType." + StringUtils.getEnumKey(this);
        }

        public String getDescriptionKey() {
            return Messages.descriptionKey("model." + this.getKey());
        }

        @Override
        public String getNameKey() {
            return Messages.nameKey("model." + this.getKey());
        }
    }
}

