/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.sqlobject.SQLObject;
import java.util.Collections;
import java.util.List;

public class DDLStatement
extends AbstractSPObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();
    private String targetCatalog;
    private String targetSchema;
    private SQLObject object;
    private StatementType type;
    private String sqlText;
    private String sqlTerminator;

    @Constructor
    public DDLStatement(@ConstructorParameter(propertyName="object") SQLObject object, @ConstructorParameter(propertyName="type") StatementType type, @ConstructorParameter(propertyName="SQLText") String sqlText, @ConstructorParameter(propertyName="sqlTerminator") String sqlTerminator, @ConstructorParameter(propertyName="targetCatalog") String targetCatalog, @ConstructorParameter(propertyName="targetSchema") String targetSchema) {
        this.object = object;
        this.type = type;
        this.sqlText = sqlText;
        this.sqlTerminator = sqlTerminator;
        this.targetCatalog = targetCatalog;
        this.targetSchema = targetSchema;
    }

    @Accessor
    public SQLObject getObject() {
        return this.object;
    }

    @Mutator
    public void setObject(SQLObject argObject) {
        SQLObject oldObj = this.object;
        this.object = argObject;
        this.firePropertyChange("object", oldObj, argObject);
    }

    @Accessor
    public StatementType getType() {
        return this.type;
    }

    @Mutator
    public void setType(StatementType argType) {
        StatementType oldType = this.type;
        this.type = argType;
        this.firePropertyChange("type", oldType, this.type);
    }

    @Accessor
    public String getSQLText() {
        return this.sqlText;
    }

    @Mutator
    public void setSQLText(String v) {
        String oldText = this.sqlText;
        this.sqlText = v;
        this.firePropertyChange("SQLText", oldText, v);
    }

    @Mutator
    public void setSqlTerminator(String sqlTerminator) {
        String oldTerminator = this.sqlTerminator;
        this.sqlTerminator = sqlTerminator;
        this.firePropertyChange("sqlTerminator", oldTerminator, sqlTerminator);
    }

    @Accessor
    public String getSqlTerminator() {
        return this.sqlTerminator;
    }

    @Accessor
    public String getTargetCatalog() {
        return this.targetCatalog;
    }

    @Mutator
    public void setTargetCatalog(String targetCatalog) {
        String oldCatalog = this.targetCatalog;
        this.targetCatalog = targetCatalog;
        this.firePropertyChange("targetCatalog", oldCatalog, targetCatalog);
    }

    @Accessor
    public String getTargetSchema() {
        return this.targetSchema;
    }

    @Mutator
    public void setTargetSchema(String targetSchema) {
        String oldSchema = this.targetSchema;
        this.targetSchema = targetSchema;
        this.firePropertyChange("targetSchema", oldSchema, targetSchema);
    }

    public String toString() {
        return this.getType() + " " + DDLUtils.toQualifiedName(this.getTargetCatalog(), this.getTargetSchema(), this.object.getName());
    }

    protected boolean removeChildImpl(SPObject child) {
        return false;
    }

    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    public List<? extends SPObject> getChildren() {
        return Collections.emptyList();
    }

    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
    }

    public static class StatementType {
        public static final StatementType CREATE = new StatementType("CREATE");
        public static final StatementType DROP = new StatementType("DROP");
        public static final StatementType ALTER = new StatementType("ALTER");
        public static final StatementType ADD_PK = new StatementType("ADD_PK");
        public static final StatementType ADD_FK = new StatementType("ADD_FK");
        public static final StatementType MODIFY = new StatementType("MODIFY");
        public static final StatementType COMMENT = new StatementType("COMMENT");
        public static final StatementType SELECT = new StatementType("SELECT");
        public static final StatementType XMLTAG = new StatementType("XMLTAG");
        private String type;

        private StatementType(String type) {
            this.type = type;
        }

        public boolean equals(Object other) {
            if (!(other instanceof StatementType)) {
                return false;
            }
            return this.type.equals(((StatementType)other).type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.type;
        }
    }
}

