/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.text.DateFormatUtil;
import java.util.Comparator;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeListColumn<T extends ChangeList> {
    public static final ChangeListColumn<CommittedChangeList> DATE = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsBundle.message("column.name.revision.list.date", new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                1.$$$reportNull$$$0(1);
            }
            String string = DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate());
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator<CommittedChangeList> comparator2 = Comparator.comparing(CommittedChangeList::getCommitDate);
            if (comparator2 == null) {
                1.$$$reportNull$$$0(3);
            }
            return comparator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ChangeListColumn$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ChangeListColumn$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    };
    public static final ChangeListColumn<CommittedChangeList> NAME = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsBundle.message("column.name.revision.list.committer", new Object[0]);
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                2.$$$reportNull$$$0(1);
            }
            return changeList.getCommitterName();
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator comparator2 = (changeList1, changeList2) -> Comparing.compare((Comparable)((Object)changeList1.getCommitterName()), (Comparable)((Object)changeList2.getCommitterName()));
            if (comparator2 == null) {
                2.$$$reportNull$$$0(2);
            }
            return comparator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ChangeListColumn$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ChangeListColumn$2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    };
    public static final ChangeListColumn<CommittedChangeList> NUMBER = new ChangeListNumberColumn(VcsBundle.message("column.name.revision.list.number", new Object[0]));
    public static final ChangeListColumn<CommittedChangeList> DESCRIPTION = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsBundle.message("column.name.revision.list.description", new Object[0]);
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                3.$$$reportNull$$$0(1);
            }
            String string = changeList.getName();
            if (string == null) {
                3.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator<CommittedChangeList> comparator2 = Comparator.comparing(list -> list.getName(), String::compareToIgnoreCase);
            if (comparator2 == null) {
                3.$$$reportNull$$$0(3);
            }
            return comparator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ChangeListColumn$3";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ChangeListColumn$3";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    };

    @NlsContexts.ColumnName
    public abstract String getTitle();

    public abstract Object getValue(T var1);

    @Nullable
    public Comparator<T> getComparator() {
        return null;
    }

    public static boolean isCustom(@NotNull ChangeListColumn column) {
        if (column == null) {
            ChangeListColumn.$$$reportNull$$$0(0);
        }
        return column != DATE && column != DESCRIPTION && column != NAME && !(column instanceof ChangeListNumberColumn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/openapi/vcs/ChangeListColumn", "isCustom"));
    }

    public static class ChangeListNumberColumn
    extends ChangeListColumn<CommittedChangeList> {
        private final @NlsContexts.ColumnName String myTitle;

        public ChangeListNumberColumn(@NlsContexts.ColumnName String title) {
            this.myTitle = title;
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                ChangeListNumberColumn.$$$reportNull$$$0(0);
            }
            Long l = changeList.getNumber();
            if (l == null) {
                ChangeListNumberColumn.$$$reportNull$$$0(1);
            }
            return l;
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator<CommittedChangeList> comparator2 = Comparator.comparingLong(CommittedChangeList::getNumber);
            if (comparator2 == null) {
                ChangeListNumberColumn.$$$reportNull$$$0(2);
            }
            return comparator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ChangeListColumn$ChangeListNumberColumn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ChangeListColumn$ChangeListNumberColumn";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

