/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.InvalidMarkException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.modbus.ModbusBitUtilities;
import org.openhab.core.io.transport.modbus.ModbusRegisterArray;

@NonNullByDefault
public class ValueBuffer {
    private final byte[] bytes;
    private final AtomicInteger byteIndex = new AtomicInteger();
    private volatile AtomicReference<@Nullable AtomicInteger> mark = new AtomicReference();

    public static ValueBuffer wrap(ModbusRegisterArray array) {
        return new ValueBuffer(array.getBytes());
    }

    public static ValueBuffer wrap(byte[] array) {
        return new ValueBuffer(array);
    }

    private ValueBuffer(byte[] bytes) {
        this.bytes = bytes;
    }

    public int position() {
        return this.byteIndex.get();
    }

    public ValueBuffer position(int byteIndex) {
        this.mark.getAndUpdate(curMark -> {
            if (curMark == null) {
                return null;
            }
            if (curMark.get() > byteIndex) {
                return null;
            }
            return curMark;
        });
        this.byteIndex.set(byteIndex);
        return this;
    }

    public ValueBuffer mark() {
        this.mark = new AtomicReference<AtomicInteger>(new AtomicInteger(this.byteIndex.get()));
        return this;
    }

    public ValueBuffer reset() throws InvalidMarkException {
        int mark = Optional.ofNullable(this.mark.get()).map(AtomicInteger::get).orElse(-1);
        if (mark < 0) {
            throw new InvalidMarkException();
        }
        this.byteIndex.set(mark);
        return this;
    }

    public int remaining() {
        return this.bytes.length - this.byteIndex.get();
    }

    public byte[] array() {
        return this.bytes;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public ValueBuffer get(byte[] dst) {
        int start = this.byteIndex.getAndAdd(dst.length);
        try {
            System.arraycopy(this.bytes, start, dst, 0, dst.length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new BufferOverflowException();
        }
        return this;
    }

    public byte getSInt8() {
        return ModbusBitUtilities.extractSInt8(this.bytes, this.byteIndex.getAndAdd(1));
    }

    public short getUInt8() {
        return ModbusBitUtilities.extractUInt8(this.bytes, this.byteIndex.getAndAdd(1));
    }

    public short getSInt16() {
        return ModbusBitUtilities.extractSInt16(this.bytes, this.byteIndex.getAndAdd(2));
    }

    public int getUInt16() {
        return ModbusBitUtilities.extractUInt16(this.bytes, this.byteIndex.getAndAdd(2));
    }

    public int getSInt32() {
        return ModbusBitUtilities.extractSInt32(this.bytes, this.byteIndex.getAndAdd(4));
    }

    public long getUInt32() {
        return ModbusBitUtilities.extractUInt32(this.bytes, this.byteIndex.getAndAdd(4));
    }

    public int getSInt32Swap() {
        return ModbusBitUtilities.extractSInt32Swap(this.bytes, this.byteIndex.getAndAdd(4));
    }

    public long getUInt32Swap() {
        return ModbusBitUtilities.extractUInt32Swap(this.bytes, this.byteIndex.getAndAdd(4));
    }

    public long getSInt64() {
        return ModbusBitUtilities.extractSInt64(this.bytes, this.byteIndex.getAndAdd(8));
    }

    public BigInteger getUInt64() {
        return ModbusBitUtilities.extractUInt64(this.bytes, this.byteIndex.getAndAdd(8));
    }

    public long getSInt64Swap() {
        return ModbusBitUtilities.extractSInt64Swap(this.bytes, this.byteIndex.getAndAdd(8));
    }

    public BigInteger getUInt64Swap() {
        return ModbusBitUtilities.extractUInt64Swap(this.bytes, this.byteIndex.getAndAdd(8));
    }

    public float getFloat32() {
        return ModbusBitUtilities.extractFloat32(this.bytes, this.byteIndex.getAndAdd(4));
    }

    public float getFloat32Swap() {
        return ModbusBitUtilities.extractFloat32Swap(this.bytes, this.byteIndex.getAndAdd(4));
    }
}

