/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.PortMapper;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;

public class HostCheckHandler
extends GzipHandler {
    private final I2PAppContext _context;
    private final PortMapper _portMapper;
    private final Set<String> _listenHosts;
    private static final String PROP_REDIRECT = "routerconsole.redirectToHTTPS";
    private static final String PROP_GZIP = "routerconsole.enableCompression";

    public HostCheckHandler(I2PAppContext ctx) {
        this._context = ctx;
        this._portMapper = ctx.portMapper();
        this._listenHosts = new HashSet<String>(8);
        this.setMinGzipSize(32768);
        if (this._context.getBooleanPropertyDefaultTrue(PROP_GZIP)) {
            this.addIncludedMimeTypes(new String[]{"application/javascript", "application/x-javascript", "application/xhtml+xml", "application/xml", "image/svg+xml", "text/css", "text/html", "text/plain"});
        } else {
            this.addIncludedMimeTypes(new String[]{"xyzzy"});
        }
    }

    public void setListenHosts(Set<String> hosts) {
        this._listenHosts.clear();
        this._listenHosts.addAll(hosts);
    }

    public void handle(String pathInContext, Request baseRequest, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        String redir;
        int httpsPort;
        String host = httpRequest.getHeader("Host");
        if (!this.allowHost(host)) {
            Log log = this._context.logManager().getLog(HostCheckHandler.class);
            host = DataHelper.stripHTML(HostCheckHandler.getHost(host));
            String s = "Console request denied.\n    To allow access using the hostname \"" + host + "\",\n    add the line \"" + "routerconsole.allowedHosts" + '=' + host + "\"\n    to advanced configuration and restart.";
            log.logAlways(30, s);
            httpResponse.sendError(403, s);
            baseRequest.setHandled(true);
            return;
        }
        if (!httpRequest.isSecure() && (httpsPort = this._portMapper.getPort("https_console")) > 0 && httpRequest.getLocalPort() != httpsPort && (Boolean.parseBoolean(redir = this._context.getProperty(PROP_REDIRECT)) || redir == null && "1".equals(httpRequest.getHeader("Upgrade-Insecure-Requests")))) {
            HostCheckHandler.sendRedirect(httpsPort, httpRequest, httpResponse);
            baseRequest.setHandled(true);
            return;
        }
        super.handle(pathInContext, baseRequest, httpRequest, httpResponse);
    }

    private boolean allowHost(String host) {
        if (host == null) {
            return true;
        }
        if (host.equals("127.0.0.1:7657") || host.equals("localhost:7657") || host.equals("[::1]:7657") || host.equals("127.0.0.1:7667") || host.equals("localhost:7667") || host.equals("[::1]:7667")) {
            return true;
        }
        if (this._listenHosts.isEmpty()) {
            return true;
        }
        if (this._listenHosts.contains(host = HostCheckHandler.getHost(host))) {
            return true;
        }
        return Addresses.isIPAddress(host);
    }

    private static String getHost(String host) {
        if (host.startsWith("[")) {
            int brack = (host = host.substring(1)).indexOf(93);
            if (brack >= 0) {
                host = host.substring(0, brack);
            }
        } else {
            int colon = host.indexOf(58);
            if (colon >= 0) {
                host = host.substring(0, colon);
            }
        }
        return host;
    }

    private static void sendRedirect(int httpsPort, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        boolean ipv6;
        StringBuilder buf = new StringBuilder(64);
        buf.append("https://");
        String name = httpRequest.getServerName();
        boolean bl = ipv6 = name.indexOf(58) >= 0 && !name.startsWith("[");
        if (ipv6) {
            buf.append('[');
        }
        buf.append(name);
        if (ipv6) {
            buf.append(']');
        }
        buf.append(':').append(httpsPort).append(httpRequest.getRequestURI());
        String q = httpRequest.getQueryString();
        if (q != null) {
            buf.append('?').append(q);
        }
        httpResponse.setHeader("Location", buf.toString());
        httpResponse.setHeader("Vary", "Upgrade-Insecure-Requests");
        httpResponse.setStatus(307);
        httpResponse.getOutputStream().close();
    }
}

