/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class DevServicesDatasourceConfigurationHandlerBuildItem
extends MultiBuildItem {
    private final String dbKind;
    private final BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>> configProviderFunction;
    private final Predicate<String> checkConfiguredFunction;

    public DevServicesDatasourceConfigurationHandlerBuildItem(String dbKind, BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>> configProviderFunction, Predicate<String> checkConfiguredFunction) {
        this.dbKind = dbKind;
        this.configProviderFunction = configProviderFunction;
        this.checkConfiguredFunction = checkConfiguredFunction;
    }

    public BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>> getConfigProviderFunction() {
        return this.configProviderFunction;
    }

    public String getDbKind() {
        return this.dbKind;
    }

    public Predicate<String> getCheckConfiguredFunction() {
        return this.checkConfiguredFunction;
    }

    public static DevServicesDatasourceConfigurationHandlerBuildItem jdbc(String dbKind) {
        return new DevServicesDatasourceConfigurationHandlerBuildItem(dbKind, new BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>>(){

            @Override
            public Map<String, String> apply(String dsName, DevServicesDatasourceProvider.RunningDevServicesDatasource runningDevDb) {
                String jdbcUrl = runningDevDb.getJdbcUrl();
                return DevServicesDatasourceConfigurationHandlerBuildItem.datasourceURLPropNames(dsName).stream().collect(Collectors.toMap(Function.identity(), ignored -> jdbcUrl));
            }
        }, new Predicate<String>(){

            @Override
            public boolean test(String dsName) {
                return ConfigUtils.isAnyPropertyPresent(DevServicesDatasourceConfigurationHandlerBuildItem.datasourceURLPropNames(dsName));
            }
        });
    }

    private static List<String> datasourceURLPropNames(String dsName) {
        return DataSourceUtil.dataSourcePropertyKeys((String)dsName, (String)"jdbc.url");
    }

    public static DevServicesDatasourceConfigurationHandlerBuildItem reactive(String dbKind) {
        return new DevServicesDatasourceConfigurationHandlerBuildItem(dbKind, new BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>>(){

            @Override
            public Map<String, String> apply(String dsName, DevServicesDatasourceProvider.RunningDevServicesDatasource runningDevDb) {
                String reactiveUrl = runningDevDb.getReactiveUrl();
                return DevServicesDatasourceConfigurationHandlerBuildItem.datasourceReactiveURLPropNames(dsName).stream().collect(Collectors.toMap(Function.identity(), ignored -> reactiveUrl));
            }
        }, new Predicate<String>(){

            @Override
            public boolean test(String dsName) {
                return ConfigUtils.isAnyPropertyPresent(DevServicesDatasourceConfigurationHandlerBuildItem.datasourceReactiveURLPropNames(dsName));
            }
        });
    }

    private static List<String> datasourceReactiveURLPropNames(String dsName) {
        return DataSourceUtil.dataSourcePropertyKeys((String)dsName, (String)"reactive.url");
    }
}

