/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticatorFactory;
import org.keycloak.authentication.authenticators.conditional.ConditionalClientScopeAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class ConditionalClientScopeAuthenticatorFactory
implements ConditionalAuthenticatorFactory {
    public static final String PROVIDER_ID = "conditional-client-scope";
    public static final String CLIENT_SCOPE = "client_scope";
    public static final String CONF_NEGATE = "negate";

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Condition - client scope";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Condition to evaluate if a configured client scope is present as a client scope of the client requesting authentication";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name(CLIENT_SCOPE).type("String").label("Client scope name").helpText("The name of the client scope, which should be present as a client scope of the client, which is requesting authentication. If requested client scope is default client scope of the client requesting login, the condition will be evaluated to true. If requested client scope is optional client scope of the client requesting login, condition will be evaluated to true if client scope is sent by the client in the login request (EG. by the 'scope' parameter in case of OIDC/OAuth2 client login)").required(true).add().property().name(CONF_NEGATE).type("boolean").label("Negate output").helpText("Apply a NOT to the check result. When this is true, then the condition will evaluate to true just if configured client scope is not present").required(true).add().build();
    }

    @Override
    public ConditionalAuthenticator getSingleton() {
        return ConditionalClientScopeAuthenticator.SINGLETON;
    }
}

