/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.util.Util;
import org.infinispan.interceptors.distribution.ConcurrentChangeException;
import org.infinispan.interceptors.impl.ContainerFullException;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.marshall.core.Ids;
import org.infinispan.notifications.IncorrectListenerException;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.remoting.CacheUnreachableException;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.topology.CacheJoinException;
import org.infinispan.topology.MissingMembersException;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.util.UserRaisedFunctionalException;
import org.infinispan.util.concurrent.locks.DeadlockDetectedException;

public class ThrowableExternalizer
implements AdvancedExternalizer<Throwable> {
    public static final ThrowableExternalizer INSTANCE = new ThrowableExternalizer();
    private static final short UNKNOWN = -1;
    private static final short ALL_OWNERS_LOST = 0;
    private static final short AVAILABILITY = 1;
    private static final short CACHE_CONFIGURATION = 2;
    private static final short CACHE_EXCEPTION = 3;
    private static final short CACHE_LISTENER = 4;
    private static final short CACHE_UNREACHABLE = 5;
    private static final short CACHE_JOIN = 6;
    private static final short CONCURRENT_CHANGE = 7;
    private static final short CONTAINER_FULL = 8;
    private static final short DEADLOCK_DETECTED = 9;
    private static final short EMBEDDED_CACHEMANAGER_STARTUP = 10;
    private static final short ENCODING = 11;
    private static final short INCORRECT_LISTENER = 12;
    private static final short ILLEGAL_LIFECYLE = 13;
    private static final short INVALID_CACHE_USAGE = 14;
    private static final short INVALID_TX = 15;
    private static final short MARSHALLING = 16;
    private static final short NOT_SERIALIZABLE = 17;
    private static final short OUTDATED_TOPOLOGY = 18;
    private static final short PERSISTENCE = 19;
    private static final short REMOTE = 20;
    private static final short RPC = 21;
    private static final short SUSPECT = 22;
    private static final short TIMEOUT = 23;
    private static final short USER_RAISED_FUNCTIONAL = 24;
    private static final short WRITE_SKEW = 25;
    private static final short MISSING_MEMBERS = 26;
    private final Map<Class<?>, Short> numbers = new HashMap(24);

    public ThrowableExternalizer() {
        this.numbers.put(AllOwnersLostException.class, (short)0);
        this.numbers.put(AvailabilityException.class, (short)1);
        this.numbers.put(CacheConfigurationException.class, (short)2);
        this.numbers.put(CacheException.class, (short)3);
        this.numbers.put(CacheListenerException.class, (short)4);
        this.numbers.put(CacheUnreachableException.class, (short)5);
        this.numbers.put(CacheJoinException.class, (short)6);
        this.numbers.put(ConcurrentChangeException.class, (short)7);
        this.numbers.put(ContainerFullException.class, (short)8);
        this.numbers.put(DeadlockDetectedException.class, (short)9);
        this.numbers.put(EmbeddedCacheManagerStartupException.class, (short)10);
        this.numbers.put(EncodingException.class, (short)11);
        this.numbers.put(IncorrectListenerException.class, (short)12);
        this.numbers.put(IllegalLifecycleStateException.class, (short)13);
        this.numbers.put(InvalidCacheUsageException.class, (short)14);
        this.numbers.put(InvalidTransactionException.class, (short)15);
        this.numbers.put(MarshallingException.class, (short)16);
        this.numbers.put(PersistenceException.class, (short)19);
        this.numbers.put(RemoteException.class, (short)20);
        this.numbers.put(RpcException.class, (short)21);
        this.numbers.put(SuspectException.class, (short)22);
        this.numbers.put(TimeoutException.class, (short)23);
        this.numbers.put(UserRaisedFunctionalException.class, (short)24);
        this.numbers.put(WriteSkewException.class, (short)25);
        this.numbers.put(OutdatedTopologyException.class, (short)18);
        this.numbers.put(MissingMembersException.class, (short)26);
    }

    public Set<Class<? extends Throwable>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{Throwable.class});
    }

    public Integer getId() {
        return Ids.EXCEPTIONS;
    }

    public void writeObject(ObjectOutput out, Throwable t) throws IOException {
        short id = this.numbers.getOrDefault(t.getClass(), (short)-1);
        out.writeShort(id);
        switch (id) {
            case 0: 
            case 7: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                ThrowableExternalizer.writeMessageAndCause(out, t);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 23: 
            case 26: {
                MarshallUtil.marshallString((String)t.getMessage(), (ObjectOutput)out);
                break;
            }
            case 18: {
                OutdatedTopologyException ote = (OutdatedTopologyException)((Object)t);
                out.writeBoolean(ote.topologyIdDelta == 0);
                break;
            }
            case 24: {
                out.writeObject(t.getCause());
                break;
            }
            case 25: {
                WriteSkewException wse = (WriteSkewException)((Object)t);
                ThrowableExternalizer.writeMessageAndCause(out, (Throwable)((Object)wse));
                out.writeObject(wse.getKey());
            }
            default: {
                ThrowableExternalizer.writeGenericThrowable(out, t);
            }
        }
    }

    public Throwable readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        short id = in.readShort();
        switch (id) {
            case 0: {
                return AllOwnersLostException.INSTANCE;
            }
            case 1: {
                return new AvailabilityException();
            }
            case 2: {
                return ThrowableExternalizer.readMessageAndCause(in, CacheConfigurationException::new);
            }
            case 3: {
                return ThrowableExternalizer.readMessageAndCause(in, CacheException::new);
            }
            case 4: {
                return ThrowableExternalizer.readMessageAndCause(in, CacheListenerException::new);
            }
            case 6: {
                return ThrowableExternalizer.readMessageAndCause(in, CacheJoinException::new);
            }
            case 5: {
                String msg = MarshallUtil.unmarshallString((ObjectInput)in);
                return new CacheUnreachableException(msg);
            }
            case 7: {
                return new ConcurrentChangeException();
            }
            case 8: {
                String msg = MarshallUtil.unmarshallString((ObjectInput)in);
                return new ContainerFullException(msg);
            }
            case 9: {
                String msg = MarshallUtil.unmarshallString((ObjectInput)in);
                return new DeadlockDetectedException(msg);
            }
            case 10: {
                return ThrowableExternalizer.readMessageAndCause(in, EmbeddedCacheManagerStartupException::new);
            }
            case 11: {
                return ThrowableExternalizer.readMessageAndCause(in, EncodingException::new);
            }
            case 12: {
                String msg = MarshallUtil.unmarshallString((ObjectInput)in);
                return new IncorrectListenerException(msg);
            }
            case 13: {
                return ThrowableExternalizer.readMessageAndCause(in, IllegalLifecycleStateException::new);
            }
            case 14: {
                return ThrowableExternalizer.readMessageAndCause(in, InvalidCacheUsageException::new);
            }
            case 15: {
                return ThrowableExternalizer.readMessageAndCause(in, InvalidTransactionException::new);
            }
            case 16: {
                return ThrowableExternalizer.readMessageAndCause(in, MarshallingException::new);
            }
            case 18: {
                return in.readBoolean() ? OutdatedTopologyException.RETRY_SAME_TOPOLOGY : OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
            }
            case 19: {
                return ThrowableExternalizer.readMessageAndCause(in, PersistenceException::new);
            }
            case 20: {
                return ThrowableExternalizer.readMessageAndCause(in, RemoteException::new);
            }
            case 21: {
                return ThrowableExternalizer.readMessageAndCause(in, RpcException::new);
            }
            case 22: {
                return ThrowableExternalizer.readMessageAndCause(in, SuspectException::new);
            }
            case 23: {
                String msg = MarshallUtil.unmarshallString((ObjectInput)in);
                return new TimeoutException(msg);
            }
            case 24: {
                Throwable t = (Throwable)in.readObject();
                return new UserRaisedFunctionalException(t);
            }
            case 25: {
                String msg = MarshallUtil.unmarshallString((ObjectInput)in);
                Throwable t = (Throwable)in.readObject();
                Throwable[] suppressed = (Throwable[])MarshallUtil.unmarshallArray((ObjectInput)in, Util::throwableArray);
                Object key = in.readObject();
                return ThrowableExternalizer.addSuppressed((Throwable)((Object)new WriteSkewException(msg, t, key)), suppressed);
            }
            case 26: {
                String msg = MarshallUtil.unmarshallString((ObjectInput)in);
                return new MissingMembersException(msg);
            }
        }
        return ThrowableExternalizer.readGenericThrowable(in);
    }

    private static void writeMessageAndCause(ObjectOutput out, Throwable t) throws IOException {
        MarshallUtil.marshallString((String)t.getMessage(), (ObjectOutput)out);
        out.writeObject(t.getCause());
        MarshallUtil.marshallArray((Object[])t.getSuppressed(), (ObjectOutput)out);
    }

    private static void writeGenericThrowable(ObjectOutput out, Throwable t) throws IOException {
        out.writeUTF(t.getClass().getName());
        ThrowableExternalizer.writeMessageAndCause(out, t);
    }

    private static Throwable readMessageAndCause(ObjectInput in, BiFunction<String, Throwable, Throwable> throwableBuilder) throws ClassNotFoundException, IOException {
        String msg = MarshallUtil.unmarshallString((ObjectInput)in);
        Throwable cause = (Throwable)in.readObject();
        return ThrowableExternalizer.readSuppressed(in, throwableBuilder.apply(msg, cause));
    }

    private static Throwable readGenericThrowable(ObjectInput in) throws IOException, ClassNotFoundException {
        String impl = in.readUTF();
        String msg = MarshallUtil.unmarshallString((ObjectInput)in);
        Throwable cause = (Throwable)in.readObject();
        Throwable throwable = ThrowableExternalizer.newThrowableInstance(impl, msg, cause);
        return ThrowableExternalizer.readSuppressed(in, throwable);
    }

    private static Throwable readSuppressed(ObjectInput in, Throwable t) throws ClassNotFoundException, IOException {
        return ThrowableExternalizer.addSuppressed(t, (Throwable[])MarshallUtil.unmarshallArray((ObjectInput)in, Util::throwableArray));
    }

    private static Throwable addSuppressed(Throwable t, Throwable[] suppressed) {
        if (suppressed != null) {
            for (Throwable s : suppressed) {
                t.addSuppressed(s);
            }
        }
        return t;
    }

    private static Throwable newThrowableInstance(String impl, String msg, Throwable t) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(impl);
            if (t == null && msg == null) {
                return (Throwable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (t == null) {
                return (Throwable)clazz.getConstructor(String.class).newInstance(msg);
            }
            if (msg == null) {
                return (Throwable)clazz.getConstructor(Throwable.class).newInstance(t);
            }
            return (Throwable)clazz.getConstructor(String.class, Throwable.class).newInstance(msg, t);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MarshallingException((Throwable)e);
        }
    }
}

