/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Objects;
import org.keycloak.component.ComponentModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.StorageProviderRealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.UserStorageProviderModel;

public class MigrateTo1_8_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.8.0");

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateRealm);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(realm);
    }

    protected void migrateRealm(RealmModel realm) {
        ((StorageProviderRealmModel)realm).getUserStorageProvidersStream().filter(fedProvider -> Objects.equals(fedProvider.getProviderId(), "ldap")).filter(this::isActiveDirectory).filter(fedProvider -> Objects.isNull(MigrateTo1_8_0.getMapperByName(realm, (ComponentModel)fedProvider, "MSAD account controls"))).map(fedProvider -> KeycloakModelUtils.createComponentModel((String)"MSAD account controls", (String)fedProvider.getId(), (String)"msad-user-account-control-mapper", (String)"org.keycloak.storage.ldap.mappers.LDAPStorageMapper", (String[])new String[0])).forEachOrdered(arg_0 -> ((RealmModel)realm).addComponentModel(arg_0));
    }

    public static ComponentModel getMapperByName(RealmModel realm, ComponentModel providerModel, String name) {
        return realm.getComponentsStream(providerModel.getId(), "org.keycloak.storage.ldap.mappers.LDAPStorageMapper").filter(component -> Objects.equals(component.getName(), name)).findFirst().orElse(null);
    }

    private boolean isActiveDirectory(UserStorageProviderModel provider) {
        String vendor = (String)provider.getConfig().getFirst((Object)"vendor");
        return vendor != null && vendor.equals("ad");
    }
}

