/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AuthenticatorDataDeserializer
extends StdDeserializer<AuthenticatorData<? extends ExtensionAuthenticatorOutput>> {
    private final ObjectConverter objectConverter;

    public AuthenticatorDataDeserializer(ObjectConverter objectConverter) {
        super(AuthenticatorData.class);
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.objectConverter = objectConverter;
    }

    public @NonNull AuthenticatorData<? extends ExtensionAuthenticatorOutput> deserialize(@NonNull JsonParser p, @NonNull DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        return new AuthenticatorDataConverter(this.objectConverter).convert(value);
    }
}

