/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.spi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class DdlTypeRegistry
implements Serializable {
    private static final Logger log = Logger.getLogger(DdlTypeRegistry.class);
    private final Map<Integer, DdlType> ddlTypes = new HashMap<Integer, DdlType>();
    private final Map<String, Integer> sqlTypes = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);

    public DdlTypeRegistry(TypeConfiguration typeConfiguration) {
    }

    public void addDescriptor(DdlType ddlType) {
        this.addDescriptor(ddlType.getSqlTypeCode(), ddlType);
    }

    public void addDescriptor(int sqlTypeCode, DdlType ddlType) {
        DdlType previous = this.ddlTypes.put(sqlTypeCode, ddlType);
        if (previous != null && previous != ddlType) {
            for (String rawTypeName : previous.getRawTypeNames()) {
                this.sqlTypes.remove(rawTypeName);
            }
            log.debugf("addDescriptor(%d, %s) replaced previous registration(%s)", sqlTypeCode, (Object)ddlType, (Object)previous);
        }
        this.addSqlType(ddlType, sqlTypeCode);
    }

    public void addDescriptorIfAbsent(DdlType ddlType) {
        this.addDescriptorIfAbsent(ddlType.getSqlTypeCode(), ddlType);
    }

    public void addDescriptorIfAbsent(int sqlTypeCode, DdlType ddlType) {
        if (this.ddlTypes.putIfAbsent(sqlTypeCode, ddlType) == null) {
            this.addSqlType(ddlType, sqlTypeCode);
        }
    }

    private void addSqlType(DdlType ddlType, int sqlTypeCode) {
        for (String rawTypeName : ddlType.getRawTypeNames()) {
            Integer previousSqlTypeCode = this.sqlTypes.put(rawTypeName, sqlTypeCode);
            if (previousSqlTypeCode == null || !JdbcTypeNameMapper.isStandardTypeCode(previousSqlTypeCode)) continue;
            this.sqlTypes.put(rawTypeName, previousSqlTypeCode);
        }
    }

    public Integer getSqlTypeCode(String rawTypeName) {
        return this.sqlTypes.get(rawTypeName);
    }

    public DdlType getDescriptor(int sqlTypeCode) {
        DdlType ddlType = this.ddlTypes.get(sqlTypeCode);
        if (ddlType == null) {
            switch (sqlTypeCode) {
                case -1: {
                    return this.ddlTypes.get(12);
                }
                case -16: {
                    return this.ddlTypes.get(-9);
                }
                case -4: {
                    return this.ddlTypes.get(-3);
                }
            }
        }
        return ddlType;
    }

    public String getTypeName(int typeCode, Dialect dialect) {
        switch (typeCode) {
            case -15: 
            case -9: 
            case -3: 
            case 1: 
            case 12: {
                return this.getTypeName(typeCode, Size.length(255L));
            }
            case 2: 
            case 3: {
                return this.getTypeName(typeCode, Size.precision(dialect.getDefaultDecimalPrecision()));
            }
            case 6: 
            case 7: {
                return this.getTypeName(typeCode, Size.precision(dialect.getFloatPrecision()));
            }
            case 8: {
                return this.getTypeName(typeCode, Size.precision(dialect.getDoublePrecision()));
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: 
            case 3003: 
            case 3007: {
                return this.getTypeName(typeCode, Size.precision(dialect.getDefaultTimestampPrecision()));
            }
        }
        return this.getTypeName(typeCode, Size.nil());
    }

    @Deprecated(since="6.3")
    public String getTypeName(int typeCode, Size size) {
        return this.getTypeName(typeCode, size.getLength(), size.getPrecision(), size.getScale());
    }

    public String getTypeName(int typeCode, Size columnSize, Type type) {
        DdlType descriptor = this.getDescriptor(typeCode);
        if (descriptor == null) {
            throw new HibernateException(String.format("No type mapping for org.hibernate.type.SqlTypes code: %s (%s)", typeCode, JdbcTypeNameMapper.getTypeName(typeCode)));
        }
        return descriptor.getTypeName(columnSize, type, this);
    }

    @Deprecated(since="6.3")
    public String getTypeName(int typeCode, Long size, Integer precision, Integer scale) {
        DdlType descriptor = this.getDescriptor(typeCode);
        if (descriptor == null) {
            throw new HibernateException(String.format("No type mapping for org.hibernate.type.SqlTypes code: %s (%s)", typeCode, JdbcTypeNameMapper.getTypeName(typeCode)));
        }
        return descriptor.getTypeName(size, precision, scale);
    }

    public boolean isTypeNameRegistered(String typeName) {
        for (DdlType value : this.ddlTypes.values()) {
            if (!value.getRawTypeName().equals(typeName)) continue;
            return true;
        }
        return false;
    }
}

